/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.util.ArrayList;
import java.util.Set;

public class ZPEOrderedAssociativeArray
extends ZPEMap {
    private static final long serialVersionUID = 9107496415773122898L;
    private final ArrayList<Object> keys = new ArrayList();

    public ZPEOrderedAssociativeArray() {
    }

    public ZPEOrderedAssociativeArray(ZPEOrderedAssociativeArray c) {
        for (Object key : c.keys()) {
            ZPEType value = c.get(key);
            if (key instanceof Number) {
                key = new ZPENumber((Number)key);
            }
            if (key instanceof String) {
                key = new ZPEString((String)key);
            }
            this.put((ZPEType)key, value);
        }
    }

    @Override
    public ZPEType put(ZPEType key, ZPEType value) {
        if (key != null) {
            this.keys.add(key);
            return this.values.put(key, value);
        }
        this.keys.add(null);
        return this.values.put(null, value);
    }

    @Override
    public void putAll(ZPEMap x) {
        for (ZPEType key : x.keySet()) {
            this.keys.add(key);
            this.put(key, x.get(key));
        }
    }

    public Object[] keys() {
        return this.keys.toArray();
    }

    @Override
    public Set<ZPEType> keySet() {
        return super.keySet();
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder("[");
        int i = 0;
        int count = this.values.keySet().size();
        if (count > 0) {
            for (Object x : this.keys) {
                if (i == count - 1) {
                    out.append(x).append("=>").append(this.values.get(x));
                } else {
                    out.append(x).append("=>").append(this.values.get(x)).append(", ");
                }
                ++i;
            }
        } else {
            out.append("=>");
        }
        return String.valueOf(out) + "]";
    }

    @Override
    public ZPEType remove(Object key) {
        this.keys.remove(key);
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values().clear();
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEOrderedAssociativeArray(this);
    }
}

