/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectArrayDataType;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPENumber;
import java.util.HashMap;
import java.util.Map;

public class ZPEArray
extends ZPEList {
    private static final long serialVersionUID = -2557413559037569547L;
    private static final Map<String, ZPEMemberType.ZPEStaticRefMethod> methods = new HashMap<String, ZPEMemberType.ZPEStaticRefMethod>();
    private byte dataType = (byte)-1;

    public ZPEArray(ZPEList l) {
        this.dataType = ZPEHelperFunctions.getDataType(l.get(0));
        for (ZPEType o : l.items) {
            this.add(o);
        }
    }

    public ZPEArray(ZPEType default_value, long size) {
        this.dataType = ZPEHelperFunctions.getDataType(default_value);
        for (long i = 0L; i < size; ++i) {
            this.items.add(default_value);
        }
    }

    @Override
    protected ZPEMemberType runNative(IAST node, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        if (node.type == 3) {
            ZPEMemberType.ZPEStaticRefMethod fn = methods.get(node.id);
            if (fn != null) {
                this.returnValue = fn.call(this, arguments);
            } else {
                ZPECore.printWarning("The reference function call to `" + node.id + "` led to an undefined path because it is disabled by the system properties.");
                this.returnValue = ZPECore.UNDEFINED;
            }
        }
        return this;
    }

    @Override
    public ZPEType set(int index, ZPEType element) {
        byte t = ZPEHelperFunctions.getDataType(element);
        if (this.dataType == -1) {
            this.dataType = t;
        } else if (this.dataType != t) {
            throw new IncorrectArrayDataType(t, this.dataType);
        }
        return this.items.set(index, element);
    }

    @Override
    public Object set(ZPENumber index, ZPEType element) {
        return this.set(index.intValue(), element);
    }

    public ZPEList toList() {
        ZPEList l = new ZPEList();
        l.items.addAll(this.items);
        return l;
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEArray(this);
    }

    static {
        methods.put("resize", resize_Command::MainMethod);
        methods.put("to_string", ZPEMemberType::toString_Command);
    }

    static class resize_Command
    implements ZPEReferenceMethod {
        resize_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int newSize = HelperFunctions.stringToInteger(arguments[0].toString());
            if (newSize > ((ZPEArray)owner).items.size()) {
                for (int index = ((ZPEArray)owner).items.size(); index < newSize; ++index) {
                    ((ZPEArray)owner).items.add(null);
                }
            } else if (((ZPEArray)owner).items.size() > newSize) {
                ((ZPEArray)owner).items.subList(newSize, ((ZPEArray)owner).items.size()).clear();
            }
            return owner;
        }
    }
}

