/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ImageEffects;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Base64;
import javax.imageio.ImageIO;

public class ImageObject
extends ZPEStructure {
    private static final long serialVersionUID = -3166986266726386568L;
    BufferedImage image = new BufferedImage(100, 100, 2);

    public ImageObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper p) throws ZPERuntimeException {
        super(z, p, "ImageObject");
        this.addNativeMethod("new_image", new new_image_Command());
        this.addNativeMethod("open", new open_Command());
        this.addNativeMethod("save", new save_Command());
        this.addNativeMethod("transform_greyscale", new transform_greyscale_Command());
        this.addNativeMethod("transform_sepia", new transform_sepia_Command());
        this.addNativeMethod("transform_invert_color", new transform_invert_color_Command());
        this.addNativeMethod("transform_resize", new transform_resize_Command());
        this.addNativeMethod("transform_rotate", new transform_rotate_Command());
        this.addNativeMethod("get_width", new get_width_Command());
        this.addNativeMethod("get_height", new get_height_Command());
        this.addNativeMethod("get_pixel", new get_pixel_Command());
        this.addNativeMethod("set_pixel", new set_pixel_Command());
        this.addNativeMethod("base64_encode", new base64_encode_Command());
        this.addNativeMethod("darken", new darken_Command());
        this.addNativeMethod("from_screen_grab", new from_screen_grab_Command());
    }

    class from_screen_grab_Command
    implements ZPEObjectNativeMethod {
        from_screen_grab_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            Rectangle screenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            BufferedImage capture = ImageObject.this.image;
            try {
                capture = new Robot().createScreenCapture(screenRect);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
            ImageObject.this.image = capture;
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "from_screen_grab";
        }
    }

    class base64_encode_Command
    implements ZPEObjectNativeMethod {
        base64_encode_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)ImageObject.this.image, "png", os);
                return new ZPEString(Base64.getEncoder().encodeToString(os.toByteArray()));
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "base64_encode";
        }
    }

    class darken_Command
    implements ZPEObjectNativeMethod {
        darken_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ImageEffects.darkenImage(ImageObject.this.image);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "darken";
        }
    }

    class set_pixel_Command
    implements ZPEObjectNativeMethod {
        set_pixel_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"x_coordinate", "y_coordinate", "color"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "number", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws IncorrectDataTypeException {
            if (!(parameters.get("color") instanceof ZPEList)) {
                throw new IncorrectDataTypeException("list", "set_pixel", "1");
            }
            int x = 0;
            x = HelperFunctions.stringToInteger(parameters.get("x_coordinate").toString());
            int y = 0;
            y = HelperFunctions.stringToInteger(parameters.get("y_coordinate").toString());
            if (x >= ImageObject.this.image.getWidth() || x < 0 || y >= ImageObject.this.image.getHeight() || y < 0) {
                throw new IndexOutOfBoundsException();
            }
            ZPEList list = (ZPEList)parameters.get("color");
            int r = HelperFunctions.stringToInteger(list.get(0).toString());
            int g = HelperFunctions.stringToInteger(list.get(1).toString());
            int b = HelperFunctions.stringToInteger(list.get(2).toString());
            Color c = new Color(r, g, b);
            if (list.size() == 4) {
                int a = HelperFunctions.stringToInteger(list.get(3).toString());
                c = new Color(r, g, b, a);
            }
            int rgb = c.getRGB();
            ImageObject.this.image.setRGB(x, y, rgb);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_pixel";
        }
    }

    class get_pixel_Command
    implements ZPEObjectNativeMethod {
        get_pixel_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"x_coordinate", "y_coordinate", "associative"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "number", "boolean"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            int x = 0;
            x = HelperFunctions.stringToInteger(parameters.get("x_coordinate").toString());
            int y = 0;
            y = HelperFunctions.stringToInteger(parameters.get("y_coordinate").toString());
            int rgb = ImageObject.this.image.getRGB(x, y);
            Color c = new Color(rgb, true);
            if (parameters.containsKey("associative")) {
                ZPEMap i = new ZPEMap();
                i.put(new ZPEString("red"), new ZPENumber(c.getRed()));
                i.put(new ZPEString("green"), new ZPENumber(c.getGreen()));
                i.put(new ZPEString("blue"), new ZPENumber(c.getBlue()));
                i.put(new ZPEString("alpha"), new ZPENumber(c.getAlpha()));
                return i;
            }
            ZPEList i = new ZPEList();
            i.add(new ZPENumber(c.getRed()));
            i.add(new ZPENumber(c.getGreen()));
            i.add(new ZPENumber(c.getBlue()));
            i.add(new ZPENumber(c.getAlpha()));
            return i;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "get_pixel";
        }
    }

    class get_height_Command
    implements ZPEObjectNativeMethod {
        get_height_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ImageObject.this.image.getHeight());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "get_height";
        }
    }

    class get_width_Command
    implements ZPEObjectNativeMethod {
        get_width_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ImageObject.this.image.getWidth());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "get_width";
        }
    }

    class transform_rotate_Command
    implements ZPEObjectNativeMethod {
        transform_rotate_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"degrees"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            int r = (int)HelperFunctions.stringToDouble(parameters.get("degrees").toString());
            ImageObject.this.image = ImageEffects.rotateImage(ImageObject.this.image, r);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "transform_rotate";
        }
    }

    class transform_resize_Command
    implements ZPEObjectNativeMethod {
        transform_resize_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"width", "height"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            int w = (int)HelperFunctions.stringToDouble(parameters.get("width").toString());
            int h = (int)HelperFunctions.stringToDouble(parameters.get("height").toString());
            ImageObject.this.image = ImageEffects.resizeImage(ImageObject.this.image, w, h);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "transform_resize";
        }
    }

    class transform_invert_color_Command
    implements ZPEObjectNativeMethod {
        transform_invert_color_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ImageEffects.invertImageColour(ImageObject.this.image);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "transform_invert_color";
        }
    }

    class transform_sepia_Command
    implements ZPEObjectNativeMethod {
        transform_sepia_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ImageEffects.generateSepiaImage(ImageObject.this.image);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "transform_sepia";
        }
    }

    class transform_greyscale_Command
    implements ZPEObjectNativeMethod {
        transform_greyscale_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ImageEffects.generateGreyscaleImage(ImageObject.this.image);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "transform_greyscale";
        }
    }

    class save_Command
    implements ZPEObjectNativeMethod {
        save_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"path"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                String p = parameters.get("path").toString();
                BufferedImage bi = ImageObject.this.image;
                File outputfile = new File(p);
                String type = "jpg";
                if (p.endsWith(".png")) {
                    type = "png";
                } else if (p.endsWith(".gif")) {
                    type = "gif";
                }
                if (ImageIO.write((RenderedImage)bi, type, outputfile)) {
                    return new ZPEBoolean(true);
                }
                return new ZPEBoolean(false);
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "save";
        }
    }

    class open_Command
    implements ZPEObjectNativeMethod {
        open_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"filename"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws ZPERuntimeException {
            Object img = false;
            try {
                img = ImageIO.read(new File(parameters.get("filename").toString()));
            }
            catch (Exception e) {
                ZPECore.printWarning("File " + parameters.get("filename").toString() + " not found.");
                return new ZPEBoolean(false);
            }
            if (img == null) {
                img = false;
            }
            assert (img instanceof BufferedImage);
            ImageObject.this.image = (BufferedImage)img;
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "open";
        }
    }

    class new_image_Command
    implements ZPEObjectNativeMethod {
        new_image_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"width", "height"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            int width = HelperFunctions.stringToInteger(parameters.get("width").toString());
            int height = HelperFunctions.stringToInteger(parameters.get("height").toString());
            ImageObject.this.image = new BufferedImage(width, height, 2);
            return parent;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "new_image";
        }
    }
}

