/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.daemon;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPEKit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;

public class ZPERuntimeDaemon {
    private int port = 9342;
    private final int permission_level;

    public ZPERuntimeDaemon(int permission_level) {
        this.permission_level = permission_level;
    }

    public ZPERuntimeDaemon(int permission_level, int port) {
        this.permission_level = permission_level;
        this.port = port;
    }

    private void executeCommand(String path) throws UnsupportedEncodingException {
        String command = "";
        if (path.startsWith("/command=")) {
            command = path.substring("/command=".length());
            command = URLDecoder.decode(command, "UTF-8");
            try {
                ZPEKit.interpret(command, this.permission_level);
            }
            catch (Exception ex) {
                System.out.println("ZPE Error: " + ex.getMessage());
            }
        } else if (path.startsWith("/file=")) {
            command = path.substring("/file=".length());
            command = URLDecoder.decode(command, "UTF-8");
            try {
                ZPEKit.interpret(FileHelperFunctions.readFileAsString(command), this.permission_level);
            }
            catch (Exception ex) {
                System.out.println("ZPE Error: " + ex.getMessage());
            }
        } else {
            System.out.println("ZPE Lite Daemon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(Socket clientSocket) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
             PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);){
            String line = in.readLine();
            ZenithJSONParser p = new ZenithJSONParser();
            if (line.startsWith("GET ") || line.startsWith("POST ")) {
                PrintWriter writer = new PrintWriter(clientSocket.getOutputStream(), true);
                writer.println("HTTP/1.1 200 OK");
                writer.println("Content-Type: text/plain; charset=utf-8");
                writer.println("Connection: close");
                writer.println();
                System.setOut(new PrintStream(clientSocket.getOutputStream()));
                System.setErr(new PrintStream(clientSocket.getOutputStream()));
                String commandLine = line;
                int contentLength = 0;
                while ((line = in.readLine()) != null && !line.isEmpty()) {
                    if (!line.toLowerCase().startsWith("content-length:")) continue;
                    contentLength = Integer.parseInt(line.split(":")[1].trim());
                }
                String requestBody = "";
                if (contentLength > 0) {
                    char[] bodyChars = new char[contentLength];
                    int read = in.read(bodyChars);
                    requestBody = new String(bodyChars, 0, read);
                }
                String path = commandLine.split(" ")[1];
                if (!requestBody.isEmpty()) {
                    this.executeCommand(requestBody);
                } else {
                    this.executeCommand(path);
                }
                writer.flush();
            } else {
                FlushingPrintStream str = new FlushingPrintStream(clientSocket.getOutputStream());
                System.setOut(str);
                System.setErr(str);
                System.out.println();
                this.executeCommand(line);
                System.out.println();
            }
        }
        catch (Exception ex) {
            System.err.println("Error handling client: " + ex.getMessage());
        }
        finally {
            try {
                System.setOut(System.out);
                System.setErr(System.err);
                clientSocket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void start() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.port);
        while (true) {
            try {
                while (true) {
                    Socket clientSocket = serverSocket.accept();
                    this.handleClient(clientSocket);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZPELiteRunning(String host, int port, int timeoutMillis) {
        try (Socket socket = new Socket();){
            String line;
            socket.connect(new InetSocketAddress(host, port), timeoutMillis);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println("GET / HTTP/1.1");
            out.println("Host: " + host);
            out.println("Connection: close");
            out.println();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            do {
                if ((line = in.readLine()) == null) return false;
            } while (!line.contains("ZPE Lite Daemon"));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public class FlushingPrintStream
    extends PrintStream {
        public FlushingPrintStream(OutputStream out) {
            super(out, true);
        }

        @Override
        public void println(String x) {
            super.println(x);
            super.flush();
        }

        @Override
        public void print(String s) {
            super.print(s);
            super.flush();
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
        }
    }
}

