/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.types.ZPEList;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class ZPESerialisedPropertyFile
implements Serializable {
    private static final long serialVersionUID = -9167608254655483283L;
    Map<String, Object> values = new HashMap<String, Object>();

    ZPESerialisedPropertyFile() {
    }

    public void put(String name, Object value) {
        if (value instanceof ZPEObject) {
            ZPEObject o = (ZPEObject)value;
            o.setRuntime(null);
            for (String prop : o.getProperties()) {
                if (!(o.getProperty(prop.toString()) instanceof ZPEFunction)) continue;
                ZPEFunction f = (ZPEFunction)o.getProperty(prop.toString());
                f.setParent(null);
            }
        }
        this.values.put(name, value);
    }

    public Object get(String name) {
        return this.values.get(name);
    }

    public static ZPESerialisedPropertyFile openMap(String file) {
        ObjectInputStream reader = null;
        try {
            FileInputStream door = new FileInputStream(file);
            reader = new ObjectInputStream(door);
            ZPESerialisedPropertyFile k = (ZPESerialisedPropertyFile)reader.readObject();
            reader.close();
            return k;
        }
        catch (Exception e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                ZPECore.log("Map file could not be opened. " + e.getMessage());
            }
            return new ZPESerialisedPropertyFile();
        }
    }

    public static void saveMap(String file, ZPESerialisedPropertyFile m) throws ZPERuntimeException {
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fileOut);
            oos.writeObject(m);
            oos.close();
        }
        catch (Exception e) {
            ZPECore.printWarning(e.getMessage());
        }
    }

    public static ZPEList getKeys(String file) {
        ZPEList l = new ZPEList();
        l.addAll(ZPESerialisedPropertyFile.openMap((String)file).values.keySet());
        return l;
    }
}

