/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.exceptions.CompileException;
import java.util.ArrayList;

class YASSUnfold {
    private boolean asHtml = false;

    YASSUnfold() {
    }

    ArrayList<String> explain(String code) throws CompileException {
        return this.explain(code, false);
    }

    ArrayList<String> explain(String code, boolean html) throws CompileException {
        YASSCompiler c = new YASSCompiler();
        IAST result = c.compile(code);
        this.asHtml = html;
        ArrayList<String> results = this.traverse(result.next);
        if (this.asHtml) {
            results.replaceAll(s -> s.replace(System.lineSeparator(), "<br>"));
        }
        return results;
    }

    ArrayList<String> explain(IAST node) {
        return this.traverse(node);
    }

    private ArrayList<String> traverse(IAST node) {
        ArrayList<String> output = new ArrayList<String>();
        IAST current = node;
        while (current != null) {
            if (current.type == 30) {
                output.add(this.explain_while(current));
            } else if (current.type == 21) {
                output.add(this.explain_if(current));
            } else if (current.type == 3) {
                output.add("calls the function " + this.explain_function_call(current));
            } else if (current.type == 16) {
                output.add(this.explain_assignment(current));
            } else if (current.type == 12) {
                output.add(this.explain_function(current));
            } else if (current.type == 32) {
                output.add(this.explain_for(current));
            } else if (current.type == 33) {
                output.add(this.explain_for_to(current));
            } else if (current.type == -17) {
                output.add(this.explain_module(current));
            }
            current = current.next;
        }
        return output;
    }

    private String arrListToString(ArrayList<String> arr) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < arr.size(); ++i) {
            String str = arr.get(i);
            if (arr.size() > 1) {
                if (i + 1 >= arr.size()) {
                    output.append("The program then ");
                    output.append(str);
                    continue;
                }
                output.append(str);
                if (i + 2 >= arr.size()) {
                    output.append(". ");
                    continue;
                }
                output.append(", ");
                continue;
            }
            output.append(str);
        }
        return output.toString();
    }

    private String explain_expression(IAST node) {
        if (node == null) {
            return "";
        }
        if (node.type == -9) {
            node = (IAST)node.value;
        }
        if (node.type == 42) {
            return this.explain_expression(node.left) + " and " + this.explain_expression(node.next);
        }
        if (node.type == 37) {
            return this.explain_expression(node.left) + " is less than " + this.explain_expression(node.middle);
        }
        if (node.type == 36) {
            return this.explain_expression(node.left) + " is greater than " + this.explain_expression(node.middle);
        }
        if (node.type == 39) {
            return this.explain_expression(node.left) + " is less than or equal to " + this.explain_expression(node.middle);
        }
        if (node.type == 38) {
            return this.explain_expression(node.left) + " is greater than or equal to " + this.explain_expression(node.middle);
        }
        if (node.type == 4) {
            if (this.asHtml) {
                return "<em>" + node.id + "</em>";
            }
            return node.id;
        }
        if (node.type == 8) {
            return "'" + node.value.toString() + "'";
        }
        if (node.type == 5) {
            return node.value.toString();
        }
        if (node.type == 6) {
            return node.value.toString();
        }
        if (node.type == 7) {
            return node.value.toString();
        }
        if (node.type == 10) {
            return "[" + this.explain_parameters((IAST)node.value, null) + "]";
        }
        if (node.type == 3) {
            return "the result of the call to the " + this.explain_function_call(node) + " function";
        }
        if (node.type == 77) {
            return this.explain_concatenation(node);
        }
        if (node.type == 55) {
            return this.explain_expression(node.left) + " + " + this.explain_expression(node.next);
        }
        if (node.type == 57) {
            return this.explain_expression(node.left) + " - " + this.explain_expression(node.next);
        }
        if (node.type == 56) {
            return this.explain_expression(node.left) + " \u00d7 " + this.explain_expression(node.next);
        }
        if (node.type == 18) {
            return "(" + this.explain_expression((IAST)node.value) + ")";
        }
        if (node.type == 58) {
            return this.explain_expression(node.left) + " \u00f7 " + this.explain_expression(node.next);
        }
        return "";
    }

    private String explain_typed_parameter(IAST node) {
        return node.left.id;
    }

    private String explain_parameters(IAST node, String paramType) {
        int count = 0;
        StringBuilder output = new StringBuilder();
        if (node != null && (node.type == -5 || node.type == -6)) {
            node = node.next;
        }
        IAST cur = node;
        while (cur != null) {
            ++count;
            if (cur.type == -13) {
                output.append(this.explain_typed_parameter(cur));
            } else {
                output.append(this.explain_expression((IAST)cur.value));
            }
            if (cur.next != null) {
                if (cur.next.next == null) {
                    output.append(" and ");
                } else {
                    output.append(", ");
                }
            }
            cur = cur.next;
        }
        if (paramType != null && count > 0) {
            if (paramType.equals("actual")) {
                return " with the actual parameters being passed in as [" + String.valueOf(output) + "]";
            }
            return " that defines formal parameters to it as [" + String.valueOf(output) + "]";
        }
        return output.toString();
    }

    private String explain_for(IAST node) {
        Object output = "";
        IAST value = (IAST)((IAST)node.value).value;
        String times = this.explain_expression(value.middle);
        output = (String)output + "loops incrementing " + value.left.id + " on each pass of the loop, the program then " + this.arrListToString(this.traverse(node.left.next)) + ", repeating this " + times + " times";
        return output;
    }

    private String explain_for_to(IAST node) {
        Object output = "the program loops until the local for loop variable, ";
        output = (String)output + this.explain_expression(node.middle.left.middle) + ", which is initially set to ";
        output = (String)output + this.explain_expression((IAST)node.middle.left.value);
        output = (String)output + ", becomes " + this.explain_expression((IAST)((IAST)node.value).value) + " repeating the following code: ";
        output = (String)output + this.arrListToString(this.traverse(node.left));
        output = (String)output + ". ";
        return output;
    }

    private String explain_assignment(IAST node) {
        Object var = node.middle.id;
        if (this.asHtml) {
            var = "<em>" + (String)var + "</em>";
        }
        return "assigns " + this.explain_expression((IAST)node.value) + " to the " + (String)var + " variable";
    }

    private String explain_function_call(IAST node) {
        return "'" + node.id + "'" + this.explain_parameters((IAST)node.value, "actual");
    }

    private String explain_concatenation(IAST node) {
        return "the result of concatenation between " + this.explain_expression(node.left) + " and " + this.explain_expression(node.next);
    }

    private String explain_while(IAST node) {
        return "while " + this.explain_expression((IAST)node.value) + " the program " + this.arrListToString(this.traverse(node.left)) + " and then repeats this until the original condition is met.";
    }

    private String explain_if(IAST node) {
        return "checks if " + this.explain_expression((IAST)node.value) + " and if it is the program " + this.arrListToString(this.traverse(node.left));
    }

    private String explain_function(IAST node) {
        return "defines a new function called '" + node.id + "'" + this.explain_parameters(((IAST)node.value).next, "formal") + " that when called it: " + this.arrListToString(this.traverse(node.left)) + ". ";
    }

    private String explain_module(IAST node) {
        return "defines a new module called '" + node.id + "' which contains the following: " + this.arrListToString(this.traverse((IAST)node.value)) + ". ";
    }
}

