/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.YASSPredefinedFunctions;
import jamiebalfour.zpe.core.YASSUnfold;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEInternalFunction;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEString;

class FunctionReference
extends ZPEStructure {
    ZPEFunction fun = null;
    Class<? extends ZPEInternalFunction> internalFun = null;
    String functionName = "";

    public FunctionReference(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent) throws ZPERuntimeException {
        super(z, parent, "FunctionReference");
        this.addMethods();
    }

    public void setRef(String name, ZPEFunction f) {
        this.functionName = name;
        this.fun = f;
        this.internalFun = null;
    }

    public void setRef(String name, Class<? extends ZPEInternalFunction> s) {
        this.functionName = name;
        this.internalFun = s;
        this.fun = null;
    }

    public ZPEType execute(IAST parameters) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (this.fun != null) {
            return this.ownerRuntime.runFunction(this.fun, this.ownerRuntime.generateArguments(parameters));
        }
        if (this.internalFun != null) {
            return YASSPredefinedFunctions.mainMethod(this.internalFun, this.ownerRuntime.generateArguments(parameters), this.ownerRuntime);
        }
        return ZPECore.UNDEFINED;
    }

    private void addMethods() throws ZPERuntimeException {
        this.addNativeMethod("get_description", new get_description_Command());
        this.addNativeMethod("describe_code", new describe_code_Command());
    }

    class describe_code_Command
    implements ZPEObjectNativeMethod {
        describe_code_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            if (FunctionReference.this.internalFun != null) {
                return new ZPEString("{native code}");
            }
            if (FunctionReference.this.fun != null) {
                try {
                    YASSUnfold u = new YASSUnfold();
                    ZPEList l = new ZPEList();
                    l.addAll(u.explain(FunctionReference.this.fun.code));
                    return l;
                }
                catch (Exception e) {
                    return new ZPEString("");
                }
            }
            return new ZPEString("");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "describe_code";
        }
    }

    class get_description_Command
    implements ZPEObjectNativeMethod {
        get_description_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            if (FunctionReference.this.internalFun != null) {
                return new ZPEString(FunctionReference.this.functionName + " : " + YASSPredefinedFunctions.getManualEntry(FunctionReference.this.internalFun));
            }
            if (FunctionReference.this.fun != null) {
                return new ZPEString(FunctionReference.this.functionName + " : " + String.valueOf(FunctionReference.this.fun.documentation));
            }
            return new ZPEString("");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "get_description";
        }
    }
}

