/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BalfFooter
extends JPanel {
    private final JLabel label;
    private Color backgroundColour;
    private Color foregroundColour;
    private final Color orgBackgroundColour;
    private final Color orgForegroundColour;
    private boolean darkMode = false;
    private String statusText = "";
    private int rounding;
    private final JFrame _frame;
    boolean hasFocus = true;
    private BufferedImage cachedBackground;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private int lastRounding = -1;
    private boolean lastDarkMode = false;
    private Color lastBackground = null;

    public BalfFooter(String text, Color background, Color foreground, int rounding, JFrame frame) {
        this.rounding = rounding;
        this.backgroundColour = background;
        this.foregroundColour = foreground;
        this.orgBackgroundColour = background;
        this.orgForegroundColour = foreground;
        this._frame = frame;
        if (this._frame != null) {
            this._frame.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    BalfFooter.this.hasFocus = true;
                    BalfFooter.this.cachedBackground = null;
                    BalfFooter.this._frame.repaint();
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    BalfFooter.this.hasFocus = false;
                    BalfFooter.this.cachedBackground = null;
                    BalfFooter.this._frame.repaint();
                }
            });
        }
        this.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.label = new JLabel(text, 0);
        this.label.setForeground(foreground);
        this.label.setOpaque(false);
        this.label.setBackground(new Color(255, 255, 255, 0));
        this.label.setFont(BalfLafManager.getBalfLafFont().deriveFont(0, 12.0f));
        this.add((Component)this.label, "Center");
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            this.darkMode = enabled;
            this.repaint();
        });
        BalfLafManager.getInstance().addThemeChangeListener(() -> {
            if (BalfLafManager.getInstance().getTheme() == null) {
                this.backgroundColour = this.orgBackgroundColour;
                this.foregroundColour = this.orgForegroundColour;
            } else {
                this.backgroundColour = BalfLafManager.getInstance().getTheme().getBackground();
                this.foregroundColour = BalfLafManager.getInstance().getTheme().getForeground();
            }
            this.label.setForeground(this.foregroundColour);
            this.repaint();
        });
    }

    public void setRounding(int rounding) {
        this.rounding = rounding;
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void setStatusText(String text) {
        this.statusText = text;
        this.repaint();
    }

    @Override
    public void setBackground(Color background) {
        this.backgroundColour = background;
        this.cachedBackground = null;
        if (this.label != null) {
            // empty if block
        }
        this.repaint();
    }

    @Override
    public void setForeground(Color foreground) {
        this.foregroundColour = foreground;
        if (this.label != null) {
            // empty if block
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean needsRepaint;
        int w = this.getWidth();
        int h = this.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        int r = (int)Math.min((double)(this.rounding - 10), (double)h / 2.0);
        Color fill = this.darkMode ? BalfLafManager.getInstance().getDarkColorBackground() : this.backgroundColour;
        boolean bl = needsRepaint = this.cachedBackground == null || w != this.lastWidth || h != this.lastHeight || r != this.lastRounding || this.darkMode != this.lastDarkMode || this.lastBackground != null && !fill.equals(this.lastBackground);
        if (needsRepaint) {
            this.cachedBackground = new BufferedImage(w, h, 2);
            Graphics2D g2 = this.cachedBackground.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (!this.hasFocus && this._frame != null) {
                fill = UIUtils.transformToGrayscaleColour(fill);
            }
            g2.setColor(fill);
            g2.fillRect(0, h / 2, w / 2, h / 2 - r);
            Path2D.Double path = new Path2D.Double();
            path.moveTo(0.0, 0.0);
            path.lineTo(w, 0.0);
            path.lineTo(w, h - r);
            path.quadTo(w, h, w - r, h);
            path.lineTo(r, h);
            path.quadTo(0.0, h, 0.0, h - r);
            path.closePath();
            g2.fill(path);
            g2.dispose();
            this.lastWidth = w;
            this.lastHeight = h;
            this.lastRounding = r;
            this.lastDarkMode = this.darkMode;
            this.lastBackground = fill;
        }
        g.drawImage(this.cachedBackground, 0, 0, null);
        if (this.statusText != null && !this.statusText.isEmpty()) {
            Graphics2D g3 = (Graphics2D)g.create();
            g3.setFont(new Font("Monospaced", 0, 10));
            g3.setColor(this.foregroundColour);
            FontMetrics fm = g3.getFontMetrics();
            int textWidth = fm.stringWidth(this.statusText);
            int x = w - textWidth - 10;
            int y = (h + fm.getAscent() - fm.getDescent()) / 2;
            g3.drawString(this.statusText, x, y);
            g3.dispose();
        }
    }
}

