/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.generic;

import jamiebalfour.generic.JBHashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinarySearchTree<K extends Comparable<K>, V> {
    int size = 0;
    private Node root;

    public void put(K key, V value) {
        this.root = this.put(this.root, key, value);
    }

    private Node put(Node node, K key, V value) {
        if (node == null) {
            return new Node(this, key, value);
        }
        int cmp = key.compareTo(node.key);
        if (cmp < 0) {
            node.left = this.put(node.left, key, value);
        } else if (cmp > 0) {
            node.right = this.put(node.right, key, value);
        } else {
            node.value = value;
        }
        ++this.size;
        return node;
    }

    public V get(K key) {
        Node node = this.get(this.root, key);
        return node == null ? null : (V)node.value;
    }

    private Node get(Node node, K key) {
        if (node == null) {
            return null;
        }
        int cmp = key.compareTo(node.key);
        if (cmp < 0) {
            return this.get(node.left, key);
        }
        if (cmp > 0) {
            return this.get(node.right, key);
        }
        return node;
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public void remove(K key) {
        this.root = this.delete(this.root, key);
    }

    private Node delete(Node node, K key) {
        if (node == null) {
            return null;
        }
        int cmp = key.compareTo(node.key);
        if (cmp < 0) {
            node.left = this.delete(node.left, key);
        } else if (cmp > 0) {
            node.right = this.delete(node.right, key);
        } else {
            if (node.left == null) {
                return node.right;
            }
            if (node.right == null) {
                return node.left;
            }
            Node minNode = this.getMin(node.right);
            minNode.right = this.deleteMin(node.right);
            minNode.left = node.left;
            return minNode;
        }
        return node;
    }

    private Node getMin(Node node) {
        while (node.left != null) {
            node = node.left;
        }
        return node;
    }

    private Node deleteMin(Node node) {
        if (node.left == null) {
            return node.right;
        }
        node.left = this.deleteMin(node.left);
        return node;
    }

    public Set<K> keySet() {
        HashSet keys2 = new HashSet();
        this.keySet(this.root, keys2);
        return keys2;
    }

    private void keySet(Node node, Set<K> keys2) {
        if (node == null) {
            return;
        }
        this.keySet(node.left, keys2);
        keys2.add(node.key);
        this.keySet(node.right, keys2);
    }

    private void inOrder(Node node, List<K> keys2) {
        if (node == null) {
            return;
        }
        this.inOrder(node.left, keys2);
        keys2.add(node.key);
        this.inOrder(node.right, keys2);
    }

    public List<V> values() {
        ArrayList result = new ArrayList();
        this.inOrderTraversal(this.root, result);
        return result;
    }

    private void inOrderTraversal(Node root, List<V> result) {
        if (root != null) {
            this.inOrderTraversal(root.left, result);
            result.add(root.value);
            this.inOrderTraversal(root.right, result);
        }
    }

    public void clear() {
        this.root = null;
    }

    public JBHashMap<K, V> toHashMap() {
        JBHashMap map = new JBHashMap();
        this.toHashMap(this.root, map);
        return map;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        this.entrySet(this.root, entries);
        return entries;
    }

    private void entrySet(Node node, Set<Map.Entry<K, V>> entries) {
        if (node == null) {
            return;
        }
        this.entrySet(node.left, entries);
        entries.add(new AbstractMap.SimpleEntry(node.key, node.value));
        this.entrySet(node.right, entries);
    }

    private void toHashMap(Node node, JBHashMap<K, V> map) {
        if (node == null) {
            return;
        }
        this.toHashMap(node.left, map);
        map.put(node.key, node.value);
        this.toHashMap(node.right, map);
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public BinarySearchTree<K, V> clone() {
        BinarySearchTree<K, V> clonedTree = new BinarySearchTree<K, V>();
        clonedTree.root = this.cloneSubtree(this.root);
        return clonedTree;
    }

    private Node cloneSubtree(Node node) {
        if (node == null) {
            return null;
        }
        Node newNode = new Node(this, node.key, node.value);
        newNode.left = this.cloneSubtree(node.left);
        newNode.right = this.cloneSubtree(node.right);
        return newNode;
    }

    public int size() {
        return this.size;
    }

    private static class Node {
        K key;
        V value;
        Node left;
        Node right;
        final /* synthetic */ BinarySearchTree this$0;

        Node(K key, V value) {
            this.this$0 = var1_1;
            this.key = key;
            this.value = value;
        }
    }
}

