/*
 * Decompiled with CFR 0.152.
 */
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.velocity.VelocityHandlerData;
import jamiebalfour.velocity.VelocityRequestHandler;
import jamiebalfour.velocity.VelocityServerResponse;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.zen.ZENWebParser;
import java.util.HashMap;

public class VelocityWebServerModule
implements VelocityRequestHandler {
    private static ZPEMap queryToAssoc(String str) {
        String[] arguments;
        ZPEMap result = new ZPEMap();
        if (str.isEmpty()) {
            return result;
        }
        for (String arg : arguments = str.split("&")) {
            int nameLen = 0;
            for (int i = 0; i < arg.length(); ++i) {
                if (arg.charAt(i) != '=') continue;
                nameLen = i;
                break;
            }
            result.put(new ZPEString(arg.substring(0, nameLen)), new ZPEString(arg.substring(nameLen + 1)));
        }
        return result;
    }

    @Override
    public VelocityHandlerData handle(VelocityServerResponse response, String documentRoot, Object data) {
        try {
            VelocityHandlerData result = new VelocityHandlerData();
            String content = FileHelperFunctions.readFileAsString(response.getFile(), "utf-8");
            ZENWebParser zenWebParser = new ZENWebParser(5);
            HashMap<String, ZPEType> variables = new HashMap<String, ZPEType>();
            ZPEMap $_SERVER = new ZPEMap();
            $_SERVER.put(new ZPEString("REMOTE_ADDRESS"), new ZPEString(response.getRemoteAddress()));
            $_SERVER.put(new ZPEString("SCRIPT"), new ZPEString(response.getFile()));
            $_SERVER.put(new ZPEString("VELOCITY_MAJOR_VERSION"), new ZPENumber(response.getServerMajorVersion()));
            $_SERVER.put(new ZPEString("VELOCITY_MINOR_VERSION"), new ZPENumber(response.getServerMinorVersion()));
            $_SERVER.put(new ZPEString("DOCUMENT_ROOT"), new ZPEString(documentRoot));
            variables.put("$_SERVER", $_SERVER);
            ZPEMap $_HEADERS = new ZPEMap();
            $_HEADERS.putAll(response.getHeaders());
            variables.put("$_HEADERS", $_HEADERS);
            ZPEMap $_GET = VelocityWebServerModule.queryToAssoc(response.getQueryString());
            variables.put("$_GET", $_GET);
            ZPEMap $_POST = VelocityWebServerModule.queryToAssoc(response.getPOSTString());
            variables.put("$_POST", $_POST);
            String output = zenWebParser.parse(content, variables);
            HashMap<String, String> headers = zenWebParser.getHeaders();
            headers.put("X-Powered-By", "ZPE/YASS 1.13.11");
            String http_header = "200";
            result.setStatus(HelperFunctions.stringToInteger(http_header));
            result.setHeaders(headers);
            result.setContent(output);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getExtension() {
        return ".ywp";
    }
}

