/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MessageSupport;

public class PUBLISH
extends MessageSupport.HeaderBase
implements MessageSupport.Acked,
MessageSupport.Message {
    public static final byte TYPE = 3;
    private UTF8Buffer topicName;
    private short messageId;
    private Buffer payload;

    public PUBLISH() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    public byte messageType() {
        return 3;
    }

    public PUBLISH decode(MQTTFrame frame) throws ProtocolException {
        assert (frame.buffers.length == 1);
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.topicName = MessageSupport.readUTF(is);
        QoS qos = this.qos();
        if (qos != QoS.AT_MOST_ONCE) {
            this.messageId = is.readShort();
        }
        this.payload = is.readBuffer(is.available());
        if (this.payload == null) {
            this.payload = new Buffer(0);
        }
        return this;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream variableHeader = new DataByteArrayOutputStream();
            MessageSupport.writeUTF(variableHeader, this.topicName);
            QoS qos = this.qos();
            if (qos != QoS.AT_MOST_ONCE) {
                variableHeader.writeShort(this.messageId);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(3);
            if (this.payload == null || this.payload.length == 0) {
                frame.buffer(variableHeader.toBuffer());
            } else {
                frame.buffers(variableHeader.toBuffer(), this.payload);
            }
            return frame;
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public boolean dup() {
        return super.dup();
    }

    public PUBLISH dup(boolean dup) {
        return (PUBLISH)super.dup(dup);
    }

    public QoS qos() {
        return super.qos();
    }

    public PUBLISH qos(QoS qos) {
        return (PUBLISH)super.qos(qos);
    }

    public boolean retain() {
        return super.retain();
    }

    public PUBLISH retain(boolean retain) {
        return (PUBLISH)super.retain(retain);
    }

    public short messageId() {
        return this.messageId;
    }

    public PUBLISH messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public Buffer payload() {
        return this.payload;
    }

    public PUBLISH payload(Buffer payload) {
        this.payload = payload;
        return this;
    }

    public UTF8Buffer topicName() {
        return this.topicName;
    }

    public PUBLISH topicName(UTF8Buffer topicName) {
        this.topicName = topicName;
        return this;
    }

    public String toString() {
        return "PUBLISH{dup=" + this.dup() + ", qos=" + (Object)((Object)this.qos()) + ", retain=" + this.retain() + ", messageId=" + this.messageId + ", topicName=" + this.topicName + ", payload=" + this.payload + '}';
    }
}

