/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import org.fusesource.hawtdispatch.internal.HawtDispatcher;

public class DispatcherConfig {
    private static HawtDispatcher defaultDispatcher;
    private String label = "hawtdispatch";
    private int threads = Integer.getInteger("hawtdispatch.threads", Runtime.getRuntime().availableProcessors());
    private boolean profile = Boolean.getBoolean("hawtdispatch.profile");
    private int drains = Integer.getInteger("hawtdispatch.drains", 1000);
    private boolean jmx = "true".equals(System.getProperty("hawtdispatch.jmx", "true").toLowerCase());

    public static synchronized HawtDispatcher getDefaultDispatcher() {
        if (defaultDispatcher == null) {
            defaultDispatcher = new DispatcherConfig().createDispatcher();
        }
        return defaultDispatcher;
    }

    public HawtDispatcher createDispatcher() {
        return new HawtDispatcher(this);
    }

    public String getLabel() {
        return this.label;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public int getDrains() {
        return this.drains;
    }

    public boolean isJmx() {
        return this.jmx;
    }
}

