/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketObject
extends ZPEStructure {
    Socket _clientSocket;
    BufferedReader _in;
    PrintWriter _out;
    ServerSocket _serverSocket;
    boolean _running = false;
    private static final long serialVersionUID = -5810570296221694219L;

    public SocketObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent) throws ZPERuntimeException {
        super(z, parent, "Socket");
        this.addNativeMethod("connect", new connect_Command());
        this.addNativeMethod("open", new open_Command());
        this.addNativeMethod("write", new write_Command());
    }

    class write_Command
    implements ZPEObjectNativeMethod {
        write_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"message"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            String s = parameters.get("message").toString();
            SocketObject.this._out.write(s + "\n");
            SocketObject.this._out.flush();
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "write";
        }
    }

    class open_Command
    implements ZPEObjectNativeMethod {
        open_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"port", "function"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) throws IncorrectDataTypeException {
            SocketObject.this._running = true;
            ZPEFunction f = (ZPEFunction)parameters.get("function");
            String name = f.getParameterNames().get(0);
            try {
                f.addParameter(name, (byte)118);
            }
            catch (ZPERuntimeException e) {
                ZPECore.log(e.getMessage());
            }
            int port_number = HelperFunctions.stringToInteger(parameters.get("port").toString());
            try {
                SocketObject.this._serverSocket = new ServerSocket(port_number);
                SocketObject.this._clientSocket = SocketObject.this._serverSocket.accept();
                SocketObject.this._out = new PrintWriter(SocketObject.this._clientSocket.getOutputStream());
                SocketObject.this._in = new BufferedReader(new InputStreamReader(SocketObject.this._clientSocket.getInputStream()));
                String line = "";
                while ((line = SocketObject.this._in.readLine()) != null) {
                    f.setParameter(name, new ZPEString(line));
                    f.run();
                }
                SocketObject.this._clientSocket.close();
                return new ZPEBoolean(true);
            }
            catch (ZPERuntimeException | IOException e) {
                return new ZPEBoolean(false);
            }
            catch (ExitHalt e) {
                throw new RuntimeException(e);
            }
            catch (BreakPointHalt e) {
                return new ZPEBoolean(true);
            }
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "open";
        }
    }

    class connect_Command
    implements ZPEObjectNativeMethod {
        connect_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"hostname", "port"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string", "number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            String hostname = parameters.get("hostname").toString();
            int port_number = HelperFunctions.stringToInteger(parameters.get("port").toString());
            try {
                SocketObject.this._clientSocket = new Socket(hostname, port_number);
                SocketObject.this._out = new PrintWriter(SocketObject.this._clientSocket.getOutputStream(), true);
                SocketObject.this._in = new BufferedReader(new InputStreamReader(SocketObject.this._clientSocket.getInputStream()));
                SocketObject.this._clientSocket.setKeepAlive(true);
            }
            catch (Exception e) {
                ZPECore.log(e.getMessage());
                ZPECore.log("Port " + port_number + " could not be opened.");
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 4;
        }

        @Override
        public String getName() {
            return "connect";
        }
    }
}

