/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.Tokeniser;
import jamiebalfour.zpe.parser.ZPEComment;
import jamiebalfour.zpe.parser.v5.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.io.IOException;
import java.util.ArrayList;

public class ParserObject
extends ZPEStructure {
    private static final long serialVersionUID = 1194414315008940360L;
    ZenithParsingEngine parser = null;
    ZPEMap tokenMap = null;
    ZPERuntimeEnvironment runtime;

    public ParserObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper p) throws ZPERuntimeException {
        super(z, p, "ParserObject");
        this.runtime = z;
        this.addNativeMethod("set_tokens", new set_tokens_Command());
        this.addNativeMethod("load", new load_Command());
        this.addNativeMethod("read", new read_Command());
        this.addNativeMethod("parse", new parse_Command());
        this.addNativeMethod("has_next", new has_next_Command());
    }

    public static class ParseValueObject
    extends ZPEStructure {
        private static final long serialVersionUID = 1194414315008940360L;
        ZPENumber byteCode;
        ZPEString text;

        protected ParseValueObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent) {
            super(z, parent, "ParseValueObject");
            this.addNativeMethod("bytecode", new bytecode_Command());
            this.addNativeMethod("text", new text_Command());
        }

        @Override
        public String toString() {
            return "{bytecode : " + String.valueOf(this.byteCode) + ", text : " + String.valueOf(this.text) + "}";
        }

        class text_Command
        implements ZPEObjectNativeMethod {
            text_Command() {
            }

            @Override
            public String[] getParameterNames() {
                return new String[0];
            }

            @Override
            public String[] getParameterTypes() {
                return new String[0];
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                return ParseValueObject.this.text;
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "text";
            }
        }

        class bytecode_Command
        implements ZPEObjectNativeMethod {
            bytecode_Command() {
            }

            @Override
            public String[] getParameterNames() {
                return new String[0];
            }

            @Override
            public String[] getParameterTypes() {
                return new String[0];
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                return ParseValueObject.this.byteCode;
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "bytecode";
            }
        }
    }

    public class SimpleTokeniser
    implements Tokeniser {
        @Override
        public byte stringToByteCode(String w) {
            if (ParserObject.this.tokenMap.containsKey(new ZPEString(w))) {
                return (byte)((ZPENumber)ParserObject.this.tokenMap.get(new ZPEString(w))).intValue();
            }
            return -1;
        }

        @Override
        public String symbolToString(int i) {
            return "";
        }

        @Override
        public String delimiterCharacters() {
            return " \r\n";
        }

        @Override
        public String[] listOfSubsequentCharacters() {
            return new String[0];
        }

        @Override
        public String quoteTypes() {
            return null;
        }

        @Override
        public String[] listOfBoundWords() {
            return new String[0];
        }

        @Override
        public String[] listOfWhitespaces() {
            return new String[]{" ", "\n", "\r", "\r\n", "\t", "\u00a0", System.lineSeparator()};
        }

        @Override
        public ArrayList<ZPEComment> listOfComments() {
            return new ArrayList<ZPEComment>();
        }
    }

    class has_next_Command
    implements ZPEObjectNativeMethod {
        has_next_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPEBoolean(ParserObject.this.parser.hasNext());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "has_next";
        }
    }

    class parse_Command
    implements ZPEObjectNativeMethod {
        parse_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ParseValueObject p = new ParseValueObject(ParserObject.this.runtime, parent);
            p.byteCode = new ZPENumber(ParserObject.this.parser.getNextSymbol());
            p.text = new ZPEString(ParserObject.this.parser.getCurrentWord());
            return p;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "parse";
        }
    }

    class read_Command
    implements ZPEObjectNativeMethod {
        read_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"text"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ZPEString text = (ZPEString)parameters.get("text");
            ParserObject.this.parser = new ZenithParsingEngine(text.toString(), false, new SimpleTokeniser());
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "read";
        }
    }

    class load_Command
    implements ZPEObjectNativeMethod {
        load_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"filename"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ZPEString filename = (ZPEString)parameters.get("filename");
            try {
                ParserObject.this.parser = new ZenithParsingEngine(FileHelperFunctions.readFileAsString(filename.toString(), "utf-8"), false, new SimpleTokeniser());
            }
            catch (IOException e) {
                ZPECore.printWarning("File could not be loaded into ZenithParser.");
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "load";
        }
    }

    class set_tokens_Command
    implements ZPEObjectNativeMethod {
        set_tokens_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"token_map"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"list"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ParserObject.this.tokenMap = (ZPEMap)parameters.get("token_map");
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_tokens";
        }
    }
}

