/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPENumber;

public class ConverterObject
extends ZPEStructure {
    private static final double KILOMETRES_TO_MILE = 1.60934;
    private static final double YARDS_TO_METRE = 1.093613;
    private static final double YARDS_TO_MILE = 1760.0;
    private static final double FEET_TO_METRE = 3.28084;
    private static final double FEET_TO_YARD = 3.0;
    private static final long serialVersionUID = -6254945662973500054L;
    double _value = 0.0;
    String _type = "";
    ConverterObject _this = this;

    public ConverterObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent) throws ZPERuntimeException {
        super(z, parent, "Converter");
        this.addNativeMethod("set_value", new set_value_Command());
        this.addNativeMethod("to_kilometres", new to_kilometres_Command());
        this.addNativeMethod("to_metres", new to_metres_Command());
        this.addNativeMethod("to_miles", new to_miles_Command());
        this.addNativeMethod("to_yards", new to_yards_Command());
        this.addNativeMethod("to_feet", new to_feet_Command());
    }

    private static double toMetres(String type, double value) {
        if (type.equals("mi")) {
            return value * 1.60934 * 1000.0;
        }
        if (type.equals("yr")) {
            return value * 1.093613;
        }
        if (type.equals("km")) {
            return value * 1000.0;
        }
        if (type.equals("m")) {
            return value;
        }
        if (type.equals("cm")) {
            return value / 100.0;
        }
        if (type.equals("mm")) {
            return value / 1000.0;
        }
        if (type.equals("um")) {
            return value / 1002.0;
        }
        if (type.equals("nm")) {
            return value / 1003.0;
        }
        if (type.equals("pm")) {
            return value / 1004.0;
        }
        return 0.0;
    }

    private static double toMiles(String type, double value) {
        if (type.equals("mi")) {
            return value;
        }
        if (type.equals("yr")) {
            return value / 1760.0;
        }
        if (type.equals("km")) {
            return value / 1.60934;
        }
        if (type.equals("m")) {
            return value / 1609.34;
        }
        if (type.equals("cm")) {
            return value / 1612.55868;
        }
        if (type.equals("um")) {
            return value / 1614.16802;
        }
        if (type.equals("nm")) {
            return value / 1615.77736;
        }
        if (type.equals("pm")) {
            return value / 1617.3867;
        }
        return 0.0;
    }

    private static double toYards(String type, double value) {
        if (type.equals("yr")) {
            return value;
        }
        if (type.equals("mi")) {
            return value * 1760.0;
        }
        if (type.equals("km")) {
            return value * 1.093613 * 1000.0;
        }
        if (type.equals("m")) {
            return value * 1.093613;
        }
        if (type.equals("cm")) {
            return value * 0.010936129999999999;
        }
        if (type.equals("mm")) {
            return value * 0.001093613;
        }
        if (type.equals("um")) {
            return value * 0.001091430139720559;
        }
        if (type.equals("nm")) {
            return value * 0.0010903419740777667;
        }
        if (type.equals("pm")) {
            return value * 0.0010892559760956174;
        }
        return 0.0;
    }

    private static double toFeet(String type, double value) {
        if (type.equals("km")) {
            return value * 3.28084 * 1000.0;
        }
        if (type.equals("m")) {
            return value * 3.28084;
        }
        if (type.equals("cm")) {
            return value * 0.0328084;
        }
        if (type.equals("mm")) {
            return value * 0.00328084;
        }
        if (type.equals("um")) {
            return value * 0.0032742914171656687;
        }
        if (type.equals("nm")) {
            return value * 0.0032710269192422732;
        }
        if (type.equals("pm")) {
            return value * 0.0032677689243027887;
        }
        if (type.equals("yr")) {
            return value * 3.0;
        }
        if (type.equals("mi")) {
            return value * 3.0 * 1760.0;
        }
        return 0.0;
    }

    private static String getType(String p) {
        if ((p = p.toLowerCase()).equals("yards") || p.equals("yr")) {
            return "yr";
        }
        if (p.equals("miles") || p.equals("mi")) {
            return "mi";
        }
        if (p.equals("kilometers") || p.equals("kilometres") || p.equals("km")) {
            return "km";
        }
        if (p.equals("meters") || p.equals("metres") || p.equals("m")) {
            return "m";
        }
        if (p.equals("centimeters") || p.equals("centimetres") || p.equals("cm")) {
            return "cm";
        }
        if (p.equals("micrometers") || p.equals("micrometres") || p.equals("um")) {
            return "um";
        }
        if (p.equals("nanometers") || p.equals("nanometres") || p.equals("nm")) {
            return "nm";
        }
        if (p.equals("picometers") || p.equals("picometres") || p.equals("pm")) {
            return "nm";
        }
        return "";
    }

    class to_feet_Command
    implements ZPEObjectNativeMethod {
        to_feet_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ConverterObject.toFeet(ConverterObject.this._type, ConverterObject.this._value));
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "to_feet";
        }
    }

    class to_yards_Command
    implements ZPEObjectNativeMethod {
        to_yards_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ConverterObject.toYards(ConverterObject.this._type, ConverterObject.this._value));
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "to_yards";
        }
    }

    class to_miles_Command
    implements ZPEObjectNativeMethod {
        to_miles_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ConverterObject.toMiles(ConverterObject.this._type, ConverterObject.this._value));
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "to_miles";
        }
    }

    class to_metres_Command
    implements ZPEObjectNativeMethod {
        to_metres_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ConverterObject.toMetres(ConverterObject.this._type, ConverterObject.this._value));
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "to_metres";
        }
    }

    class to_kilometres_Command
    implements ZPEObjectNativeMethod {
        to_kilometres_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            return new ZPENumber(ConverterObject.toMetres(ConverterObject.this._type, ConverterObject.this._value) / 1000.0);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "to_kilometres";
        }
    }

    class set_value_Command
    implements ZPEObjectNativeMethod {
        set_value_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"value", "type"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            ConverterObject.this._value = HelperFunctions.stringToDouble(parameters.get("value").toString());
            ConverterObject.this._type = ConverterObject.getType(parameters.get("type").toString());
            return ConverterObject.this._this;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "set_value";
        }
    }
}

