/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.components.BalfButton;
import jamiebalfour.ui.dialogs.BalfAboutDialog;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.editor.CodeEditorView;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.gui.ZPEMacroInterfaceObjectViewer;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.SimpleAttributeSet;

public class ZPEMacroInterface
extends JFrame {
    private static final long serialVersionUID = 4508802298090684343L;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("YASS files (*.yas)", "yas");
    private final ZPEMacroInterface _this = this;
    private final JTextArea outputBox;
    private final JEditorPane mainEditor;
    private final PrintStream originalOut;
    private final PrintStream originalErr;
    CodeEditorView mainSyntax;
    ZPERuntimeEnvironment environment;
    String currentMacro = null;
    final String initialText;
    JMenuItem addAsNewMacroButton = new JMenuItem("Use as new Macro");
    JMenuItem saveCurrentMacroItem = new JMenuItem("Save current macro");
    private final List<AddAsMacroButtonClickedListener> addMacroButtonClickedListeners = new ArrayList<AddAsMacroButtonClickedListener>();
    private final List<SaveMacroButtonClickedListener> saveMacroButtonClickedListeners = new ArrayList<SaveMacroButtonClickedListener>();

    public ZPEMacroInterface(ZPERuntimeEnvironment z, ZPEObject[] linkedObjects, HashMap<String, String> currentMacros) {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outputBox = new JTextArea(4, 40);
        ZPECore.IGNORE_STARTUP = true;
        JTextAreaOutputStream outStream = new JTextAreaOutputStream(this.outputBox);
        System.setOut(new PrintStream(outStream));
        System.setErr(new PrintStream(outStream));
        int modifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.setOut(ZPEMacroInterface.this.originalOut);
                System.setErr(ZPEMacroInterface.this.originalErr);
                e.getWindow().dispose();
            }
        });
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.environment = z;
        JPanel mainPanel = new JPanel();
        this.getContentPane().add(mainPanel);
        mainPanel.setLayout(new BorderLayout(0, 0));
        final JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.white);
        scrollPane.setEnabled(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        HashMap<String, SimpleAttributeSet> YASSKeywords = ZPEKit.getKeywordSet();
        StringBuilder editorComment = new StringBuilder();
        if (linkedObjects.length > 0) {
            editorComment.append("// Available predefined objects: ");
        }
        int c = 0;
        for (ZPEObject o : linkedObjects) {
            YASSKeywords.put(o.getId(), CodeEditorView.DEFAULT_KEYWORD);
            editorComment.append(o.getId());
            if (c != linkedObjects.length - 1) {
                editorComment.append(", ");
            }
            ++c;
        }
        editorComment.append("\n");
        this.initialText = editorComment.toString();
        this.mainSyntax = new CodeEditorView(YASSKeywords, "\"'", "$");
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.black);
        this.mainEditor = (JEditorPane)this.mainSyntax.getEditPane();
        this.mainEditor.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        scrollPane.setViewportView(this.mainEditor);
        if (HelperFunctions.isMac()) {
            this.mainEditor.setFont(new Font("Consolas", 0, 14));
        } else {
            this.mainEditor.setFont(new Font("Courier New", 0, 14));
        }
        scrollPane.setRowHeaderView(this.mainSyntax.getEditor());
        this.mainSyntax.setFontSize(14);
        this.mainSyntax.repaint();
        this.mainEditor.setText("// ZPE Macro Scripting Interface\n" + String.valueOf(editorComment));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem newMenuItem = new JMenuItem("New");
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, modifierKey));
        newMenuItem.addActionListener(e -> {
            this.mainEditor.setText(this.initialText);
            this.currentMacro = null;
            this.addAsNewMacroButton.setVisible(true);
            this.saveCurrentMacroItem.setVisible(false);
        });
        fileMenu.add(newMenuItem);
        JMenuItem saveAsMenuItem = new JMenuItem("Save As");
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, modifierKey));
        saveAsMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter1);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String extension = "yas";
                try {
                    FileHelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, this.mainEditor.getText(), false);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.mainEditor, "The file could not be saved.", "Error", 0);
                }
            }
        });
        fileMenu.add(saveAsMenuItem);
        fileMenu.add(new JSeparator());
        JMenuItem openMenuItem = new JMenuItem("Open");
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, modifierKey));
        openMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter1);
            int returnVal = fc.showOpenDialog(this.getContentPane());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    this.mainEditor.setText(FileHelperFunctions.readFileAsString(file.getAbsolutePath()));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ZPEMacroInterface.this.mainEditor.setCaretPosition(0);
                            scrollPane.getVerticalScrollBar().setValue(0);
                        }
                    });
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "The file could not be opened.", "Error", 0);
                }
            }
        });
        fileMenu.add(openMenuItem);
        JMenu editMenu = new JMenu("Edit");
        menuBar.add(editMenu);
        JMenuItem cutMenuItem = new JMenuItem("Cut");
        cutMenuItem.addActionListener(e -> this.mainEditor.cut());
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, modifierKey));
        editMenu.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy");
        copyMenuItem.addActionListener(e -> this.mainEditor.copy());
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, modifierKey));
        editMenu.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste");
        pasteMenuItem.addActionListener(e -> this.mainEditor.paste());
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, modifierKey));
        editMenu.add(pasteMenuItem);
        InputMap im = this.mainEditor.getInputMap(1);
        ActionMap am = this.mainEditor.getActionMap();
        im.put(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Cut");
        am.put("Cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEMacroInterface.this.mainEditor.cut();
            }
        });
        im.put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Copy");
        am.put("Copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEMacroInterface.this.mainEditor.copy();
            }
        });
        im.put(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Paste");
        am.put("Paste", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEMacroInterface.this.mainEditor.paste();
            }
        });
        if (linkedObjects.length > 0) {
            JMenu objectsMenu = new JMenu("Objects");
            menuBar.add(objectsMenu);
            for (ZPEObject o : linkedObjects) {
                JMenuItem menuItem = new JMenuItem(o.getId());
                menuItem.addActionListener(e -> {
                    ZPEMacroInterfaceObjectViewer viewer = new ZPEMacroInterfaceObjectViewer(o);
                    viewer.setVisible(true);
                });
                objectsMenu.add(menuItem);
            }
        }
        if (currentMacros != null) {
            JMenu macroMenu = new JMenu("Macros");
            macroMenu.add(this.addAsNewMacroButton);
            this.addAsNewMacroButton.addActionListener(e -> {
                for (AddAsMacroButtonClickedListener listener : this.addMacroButtonClickedListeners) {
                    listener.onAddAsMacroButtonClicked(this.mainEditor.getText());
                }
            });
            this.saveCurrentMacroItem = new JMenuItem("Save macro");
            macroMenu.add(this.saveCurrentMacroItem);
            this.saveCurrentMacroItem.setVisible(false);
            this.saveCurrentMacroItem.addActionListener(e -> {
                for (SaveMacroButtonClickedListener listener : this.saveMacroButtonClickedListeners) {
                    listener.onSaveMacroButtonClicked(this.currentMacro, this.mainEditor.getText());
                }
            });
            if (!currentMacros.isEmpty()) {
                macroMenu.addSeparator();
                for (String macro : currentMacros.keySet()) {
                    JMenuItem menuItem = new JMenuItem(macro);
                    menuItem.addActionListener(e -> {
                        this.saveCurrentMacroItem.setVisible(true);
                        this.addAsNewMacroButton.setVisible(false);
                        this.currentMacro = macro;
                        this.mainEditor.setText((String)currentMacros.get(macro));
                    });
                    macroMenu.add(menuItem);
                }
            }
            menuBar.add(macroMenu);
        }
        JMenu scriptMenu = new JMenu("Script");
        menuBar.add(scriptMenu);
        JMenuItem executeMenuItem = new JMenuItem("Execute");
        scriptMenu.add(executeMenuItem);
        executeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, modifierKey));
        executeMenuItem.addActionListener(e -> this.executeCode(linkedObjects));
        scriptMenu.add(new JSeparator());
        JMenuItem validateScriptMenuItem = new JMenuItem("Validate Script");
        scriptMenu.add(validateScriptMenuItem);
        validateScriptMenuItem.addActionListener(e -> {
            try {
                if (ZPEKit.validateCode(this.mainEditor.getText())) {
                    JOptionPane.showMessageDialog(this._this, "Your code is valid", "ZPE Code Validation", 1);
                } else {
                    JOptionPane.showMessageDialog(this._this, "Your code is invalid", "ZPE Code Validation", 0);
                }
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this._this, "Your code is invalid", "ZPE Code Validation", 0);
            }
        });
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        JMenuItem aboutMenuItem = new JMenuItem("About ZPE");
        helpMenu.add(aboutMenuItem);
        aboutMenuItem.addActionListener(e -> {
            Object msg = "";
            msg = (String)msg + "ZPE version 1.13.9." + ZPECore.getBuildVersion() + " [Gillygate]\n";
            msg = (String)msg + "Built on: " + ZPECore.getBuildDate() + " at " + ZPECore.getBuildTime() + "\n";
            msg = (String)msg + "Copyright Jamie B Balfour 2011 - 2025";
            msg = (String)msg + "\n\n";
            msg = (String)msg + "Powered by Zenith Parsing Engine version 1.5";
            msg = (String)msg + "\n\nFor more information visit\nhttps://www.jamiebalfour.scot/projects/zpe/";
            BalfButton btnVisitWebsiteButton = new BalfButton("More", 15);
            btnVisitWebsiteButton.addActionListener(event -> {
                try {
                    HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Could not open the ZPE website", "Failure", 0);
                }
            });
            URL imagePath = this.getClass().getResource("/files/ZPELogoLighter.png");
            assert (imagePath != null);
            ImageIcon lighterLogoFull = new ImageIcon(imagePath);
            Image newimg = lighterLogoFull.getImage().getScaledInstance(60, 60, 4);
            ImageIcon lighterLogo = new ImageIcon(newimg);
            try {
                this.setIconImage(lighterLogo.getImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane op = new JOptionPane(new BalfAboutDialog("ZPE & YASS", (String)msg, btnVisitWebsiteButton).getContentPane(), -1, -1, lighterLogo, new String[0]);
            JDialog dlg = op.createDialog(this._this, "About ZPE");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
        });
        helpMenu.add(new JSeparator());
        JMenuItem websiteItem = new JMenuItem("Visit the ZPE website");
        helpMenu.add(websiteItem);
        websiteItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this._this, "Could not load the website.", "Failure", 0);
            }
        });
        this.add((Component)menuBar, "North");
        this.setSize(new Dimension(700, 500));
        BalfButton executeBtn = new BalfButton("Run", 15);
        executeBtn.setFont(new Font(executeBtn.getFont().getName(), 0, 10));
        int width1 = 40;
        int height1 = 20;
        executeBtn.setPreferredSize(new Dimension(width1, height1));
        executeBtn.setMaximumSize(new Dimension(width1, height1));
        executeBtn.setMinimumSize(new Dimension(width1, height1));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.outputBox.setEditable(false);
        this.outputBox.setLineWrap(true);
        this.outputBox.setWrapStyleWord(true);
        if (HelperFunctions.isMac()) {
            this.outputBox.setFont(new Font("Consolas", 0, 13));
        } else {
            this.outputBox.setFont(new Font("Courier New", 0, 13));
        }
        this.outputBox.setBorder(BorderFactory.createTitledBorder("Immediate Output"));
        JScrollPane outputScroll = new JScrollPane(this.outputBox);
        outputScroll.setVerticalScrollBarPolicy(22);
        JPanel bottomButtons = new JPanel();
        JPanel executeButtonPanel = new JPanel();
        executeButtonPanel.setLayout(new BorderLayout());
        executeButtonPanel.add((Component)executeBtn, "Center");
        executeButtonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        menuBar.add(Box.createHorizontalGlue());
        int width2 = 60;
        int height2 = 25;
        executeButtonPanel.setPreferredSize(new Dimension(width2, height2));
        executeButtonPanel.setMaximumSize(new Dimension(width2, height2));
        executeButtonPanel.setMinimumSize(new Dimension(width2, height2));
        executeButtonPanel.setOpaque(false);
        menuBar.add((Component)executeButtonPanel, Float.valueOf(1.0f));
        bottomPanel.add((Component)bottomButtons, "North");
        bottomPanel.add((Component)outputScroll, "Center");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(scrollPane);
        splitPane.setBottomComponent(bottomPanel);
        splitPane.setDividerLocation(200);
        splitPane.setResizeWeight(0.85);
        splitPane.setContinuousLayout(false);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mainPanel.add((Component)splitPane, "Center");
        JLabel footerLabel = new JLabel("<html><body><p>&copy; Jamie B Balfour 2015 - 2025</p></body></html>", 0);
        footerLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        footerLabel.setBackground(Color.white);
        footerLabel.setFont(new Font(HelperFunctions.getBestAvailableFont(true), 1, 12));
        mainPanel.add((Component)footerLabel, "South");
        executeBtn.addActionListener(e -> this.executeCode(linkedObjects));
        executeBtn.disableDarkMode();
        this.setTitle("ZPE Macro Interface Editor");
    }

    private void executeCode(ZPEObject[] modifiableObjects) {
        this.outputBox.setText("");
        HashMap<String, ZPEType> vars = new HashMap<String, ZPEType>();
        for (ZPEObject o : modifiableObjects) {
            vars.put(o.getId(), o);
        }
        try {
            ZPEKit.interpret(this.environment, this.mainEditor.getText(), new ZPEType[0], false, vars, false);
        }
        catch (BreakPointHalt | CompileException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (ExitHalt ex) {
            JOptionPane.showMessageDialog(this, "Exit Halt: " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    public void addAddNewMacroButtonListener(AddAsMacroButtonClickedListener listener) {
        this.addMacroButtonClickedListeners.add(listener);
    }

    public void addSaveMacroButtonListener(SaveMacroButtonClickedListener listener) {
        this.saveMacroButtonClickedListeners.add(listener);
    }

    public void setTraverseAction(Runnable action) {
        this.environment.setTraverseAction(action);
    }

    public static interface SaveMacroButtonClickedListener {
        public void onSaveMacroButtonClicked(String var1, String var2);
    }

    public static interface AddAsMacroButtonClickedListener {
        public void onAddAsMacroButtonClicked(String var1);
    }

    static class JTextAreaOutputStream
    extends OutputStream {
        private final JTextArea textArea;

        public JTextAreaOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void write(int b) {
            SwingUtilities.invokeLater(() -> {
                this.textArea.append(String.valueOf((char)b));
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            });
        }

        @Override
        public void write(byte[] b, int off, int len) {
            String text = new String(b, off, len);
            SwingUtilities.invokeLater(() -> {
                this.textArea.append(text);
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            });
        }
    }
}

