/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZULEPackageManager;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.io.FileOutputStream;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;

public class ZPEUpdater {
    private static ZPEUpdater instance;
    private boolean updateAvailable = false;
    private String updateVersionNumber = "";
    private String updateVersionNumberMajor = "";
    private String updateVersionNumberMinor = "";
    private String updateVersionNumberBuild = "";
    private String updateVersionName = "";

    private ZPEUpdater() {
    }

    public static synchronized ZPEUpdater getInstance() {
        if (instance == null) {
            instance = new ZPEUpdater();
        }
        return instance;
    }

    public void checkForUpdate(boolean nightly) {
        try {
            ZPEType out = nightly ? ZPEHelperFunctions.urlToJson(ZPEInstance.UPDATE_PATH + "&nightly=true") : ZPEHelperFunctions.urlToJson(ZPEInstance.UPDATE_PATH);
            if (out instanceof ZPEMap) {
                if (((ZPEMap)out).containsKey(new ZPEString("number"))) {
                    ZPEMap results = (ZPEMap)out;
                    this.updateVersionNumber = results.get(new ZPEString("number")).toString();
                    this.updateVersionNumberMajor = results.get(new ZPEString("major_version")).toString();
                    this.updateVersionNumberMinor = results.get(new ZPEString("minor_version")).toString();
                    this.updateVersionNumberBuild = results.get(new ZPEString("build_version")).toString();
                    this.updateVersionName = results.get(new ZPEString("name")).toString();
                }
            } else {
                this.updateAvailable = false;
            }
            double newMajorVersion = HelperFunctions.stringToDouble(this.updateVersionNumberMajor);
            int newMinorVersion = HelperFunctions.stringToInteger(this.updateVersionNumberMinor);
            int newBuildVersion = HelperFunctions.stringToInteger(this.updateVersionNumberBuild);
            double currentMajorVersion = HelperFunctions.stringToDouble("1.13");
            int currentMinorVersion = HelperFunctions.stringToInteger("9");
            int currentBuildVersion = ZPECore.getBuildVersion();
            if (newMajorVersion > currentMajorVersion || newMajorVersion == currentMajorVersion && newMinorVersion > currentMinorVersion || newMajorVersion == currentMajorVersion && newMinorVersion == currentMinorVersion && newBuildVersion > currentBuildVersion) {
                this.updateAvailable = true;
            }
        }
        catch (Exception e) {
            this.updateAvailable = false;
        }
    }

    public boolean runUpdate(boolean nightly) throws Exception {
        String pack = nightly ? "zpe_nightly.jar" : "zpe_latest.jar";
        String path = URLDecoder.decode(ZPEInstance.EXECUTABLE_PATH + "/zpe.jar", "UTF-8");
        ReadableByteChannel rbc = ZULEPackageManager.zuleFetch(pack);
        FileOutputStream fos = new FileOutputStream(path);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        ZPECore.print("Update moved to " + path);
        return true;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getUpdateVersionName() {
        return this.updateVersionName;
    }

    public String getUpdateVersionNumber() {
        return this.updateVersionNumber;
    }
}

