/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPESettingsFile;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class ZPEStartup {
    ZPEStartup() {
    }

    static Properties loadProperties() {
        block12: {
            File lockdownFile = ZPEHelperFunctions.getPlatformSpecificLockdownFile();
            if (lockdownFile.exists()) {
                try {
                    Properties props = HelperFunctions.readProperties(lockdownFile.getAbsolutePath());
                    if (props.containsKey("lockdown")) {
                        ZPEInstance.LOCKDOWN = props.getProperty("lockdown").equals("true");
                        break block12;
                    }
                    ZPEInstance.LOCKDOWN = false;
                }
                catch (IOException e) {
                    ZPEInstance.LOCKDOWN = false;
                }
            } else {
                ZPEInstance.LOCKDOWN = false;
            }
        }
        if (ZPEInstance.MAIN_PROPERTIES != null) {
            return ZPEInstance.MAIN_PROPERTIES;
        }
        String filename = ZPEInstance.CONFIGURATION_PATH;
        try {
            ZPEInstance.MAIN_PROPERTIES = HelperFunctions.readProperties(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ZPEInstance.INTERNAL_ALIASES = HelperFunctions.readProperties(ZPEInstance.INSTALL_PATH + "/aliases.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ZPEInstance.CONSTANTS = ZPEStartup.readConstants();
        }
        catch (ZPERuntimeException zPERuntimeException) {
            // empty catch block
        }
        return ZPEInstance.MAIN_PROPERTIES;
    }

    static Map<String, YASSCompiler.CompilerConstant> readConstants() throws ZPERuntimeException {
        ZenithJSONParser j = new ZenithJSONParser();
        HashMap<String, YASSCompiler.CompilerConstant> constants = new HashMap<String, YASSCompiler.CompilerConstant>();
        try {
            if (new File(ZPEInstance.INSTALL_PATH + "/constants.json").exists()) {
                ZPEMap readFile = (ZPEMap)j.jsonDecode(FileHelperFunctions.readFileAsString(ZPEInstance.INSTALL_PATH + "/constants.json"), false);
                for (ZPEType s : readFile.keySet()) {
                    ZPEMap value = (ZPEMap)readFile.get(s);
                    constants.put(s.toString(), new YASSCompiler.CompilerConstant(value.get(new ZPEString("value")).toString(), (byte)HelperFunctions.stringToInteger(value.get(new ZPEString("type")).toString())));
                }
            }
        }
        catch (IOException e) {
            ZPECore.log(e.getMessage());
        }
        catch (MalformedJSONException e) {
            ZPECore.log(e.getMessage());
            ZPECore.printError(e.getMessage());
        }
        constants.put("ZPE_VERSION_MAJOR", new YASSCompiler.CompilerConstant("1.13", 8));
        constants.put("ZPE_VERSION_MINOR", new YASSCompiler.CompilerConstant("9", 8));
        constants.put("ZPE_VERSION_BUILD", new YASSCompiler.CompilerConstant("" + ZPECore.getBuildVersion(), 8));
        constants.put("ZPE_CLI_VERSION", new YASSCompiler.CompilerConstant("1.8.1", 8));
        return constants;
    }

    static void createDefaultSettingsFile() {
        ZPESettingsFile f = new ZPESettingsFile();
        f.serialID = ZPEHelperFunctions.generateRandomWord(256);
        f.uniqueID = ZPEHelperFunctions.generateRandomWord(256);
        try {
            FileOutputStream fileOutput = new FileOutputStream(ZPEInstance.BASE_SETTINGS_PATH);
            ObjectOutputStream oos = new ObjectOutputStream(fileOutput);
            oos.writeObject(f);
            oos.close();
        }
        catch (IOException e) {
            ZPECore.log(e.getMessage());
        }
    }

    private static ZPEMap createConst(ZPEType value, byte type) {
        ZPEMap output = new ZPEMap();
        output.put(new ZPEString("value"), value);
        output.put(new ZPEString("type"), new ZPENumber(type));
        return output;
    }

    static void writeDefaultConstants() {
        ZPEMap constants_list = new ZPEMap();
        constants_list.put(new ZPEString("EPSILON"), ZPEStartup.createConst(new ZPEString("2.220446049250313E-16"), (byte)6));
        constants_list.put(new ZPEString("PI"), ZPEStartup.createConst(new ZPEString("3.141592653589793"), (byte)6));
        constants_list.put(new ZPEString("PLANCK"), ZPEStartup.createConst(new ZPEString("6.62606957E34"), (byte)6));
        constants_list.put(new ZPEString("LIGHT_SPEED"), ZPEStartup.createConst(new ZPEString("2.99792458E8"), (byte)6));
        constants_list.put(new ZPEString("COULOMB_CONSTANT"), ZPEStartup.createConst(new ZPEString("8.987551787E9"), (byte)6));
        constants_list.put(new ZPEString("EULER_NUMBER"), ZPEStartup.createConst(new ZPEString("2.7182818285"), (byte)6));
        constants_list.put(new ZPEString("GRAVITATIONAL_CONSTANT"), ZPEStartup.createConst(new ZPEString("6.67408E-11"), (byte)6));
        constants_list.put(new ZPEString("ATOMIC_MASS"), ZPEStartup.createConst(new ZPEString("1.6605390666E-27"), (byte)6));
        constants_list.put(new ZPEString("GOLDEN_RATIO"), ZPEStartup.createConst(new ZPEString("1.618033988749895"), (byte)6));
        constants_list.put(new ZPEString("INFINITY"), ZPEStartup.createConst(new ZPEString("2147483647"), (byte)5));
        ZenithJSONParser j = new ZenithJSONParser();
        String content = j.jsonEncode(constants_list);
        try {
            FileHelperFunctions.writeFile(ZPEInstance.INSTALL_PATH + "/constants.json", content, false);
        }
        catch (IOException e) {
            System.err.println("Could not write default constants.");
        }
    }

    static void writeDefaultAliases() {
        Properties aliases = new Properties();
        aliases.put("bye_bye", "exit");
        aliases.put("new_line", "std_new_line");
        aliases.put("print_error", "std_err");
        aliases.put("echo", "std_out");
        aliases.put("get_input", "std_in");
        aliases.put("input", "std_in");
        aliases.put("get_type", "type");
        aliases.put("deserialize", "deserialise");
        aliases.put("sin", "sine");
        aliases.put("cos", "cosine");
        aliases.put("tan", "tangent");
        aliases.put("abs", "absolute_value");
        aliases.put("sqrt", "square_root");
        aliases.put("cbrt", "cube_root");
        aliases.put("flr", "floor");
        aliases.put("pessimistic", "floor");
        aliases.put("ceil", "ceiling");
        aliases.put("optimistic", "ceiling");
        aliases.put("int", "value");
        aliases.put("int_to_char", "integer_to_character");
        aliases.put("char_to_int", "character_to_integer");
        aliases.put("get_char_at", "string_get_character_at");
        aliases.put("char_at", "string_get_character_at");
        aliases.put("str_len", "string_get_length");
        aliases.put("str_count_occurrences", "string_count_occurrences");
        aliases.put("str_contains", "string_contains");
        aliases.put("str_split", "string_split");
        aliases.put("str_splice", "string_splice");
        aliases.put("str_divide", "string_divide");
        aliases.put("str_find", "string_find_occurrences");
        aliases.put("str_substring", "string_substring");
        aliases.put("str_lcase", "string_to_lowercase");
        aliases.put("str_ucase", "string_to_uppercase");
        aliases.put("str_replace", "string_replace");
        aliases.put("str_starts_with", "string_starts_with");
        aliases.put("str_ends_with", "string_ends_with");
        aliases.put("str_cut", "string_cut");
        aliases.put("str_trim", "string_trim");
        aliases.put("str_trim_start", "string_trim_start");
        aliases.put("str_trim_end", "string_trim_end");
        aliases.put("str_matches", "string_matches");
        aliases.put("str_to_date", "string_to_date");
        aliases.put("str_is_numeric", "string_is_numeric");
        aliases.put("is_numeric", "string_is_numeric");
        aliases.put("str_concatenate", "string_concatenate");
        aliases.put("str_is_lcase", "string_is_lowercase");
        aliases.put("str_is_ucase", "string_is_uppercase");
        aliases.put("str_text_compare", "string_text_compare");
        aliases.put("say", "speak");
        aliases.put("direxists", "directory_exists");
        aliases.put("dir_list", "directory_list_files");
        aliases.put("mkdir", "directory_create");
        aliases.put("fexists", "file_exists");
        aliases.put("fsize", "file_size");
        aliases.put("fname", "file_get_name");
        aliases.put("fopen", "file_open");
        aliases.put("fcopy", "file_copy");
        aliases.put("fdelete", "file_delete");
        aliases.put("list_add", "list_add_element");
        aliases.put("list_remove", "list_remove_element");
        aliases.put("list_get_at", "list_get_at_index");
        aliases.put("list_index_of", "list_get_index_of");
        aliases.put("list_insert_at", "list_insert_at_index");
        aliases.put("list_set_at", "list_set_at_index");
        aliases.put("array_get_data_type", "list_get_data_type");
        aliases.put("pop", "list_pop");
        aliases.put("list_to_associative_array", "list_to_map");
        aliases.put("associative_array_get", "map_get");
        aliases.put("associative_array_remove", "map_remove");
        aliases.put("associative_array_put", "map_put");
        aliases.put("associative_array_contains", "map_contains");
        aliases.put("associative_array_get_keys", "map_get_keys");
        aliases.put("associative_array_flip", "map_flip");
        aliases.put("associative_array_create_ordered", "map_create_ordered");
        aliases.put("clamp", "limit_real");
        aliases.put("calculate_min", "calculate_minimum");
        aliases.put("min", "calculate_minimum");
        aliases.put("calculate_max", "calculate_maximum");
        aliases.put("max", "calculate_maximum");
        aliases.put("mean", "calculate_mean");
        aliases.put("get_average", "calculate_mean");
        aliases.put("average", "calculate_mean");
        aliases.put("mode", "calculate_mode");
        aliases.put("median", "calculate_median");
        aliases.put("percentile", "calculate_percentile");
        aliases.put("standard_deviation", "calculate_standard_deviation");
        aliases.put("lerp", "calculate_linear_interpolation");
        aliases.put("to_json", "json_encode");
        aliases.put("parse_csv", "csv_decode");
        aliases.put("parse_json", "json_decode");
        aliases.put("parse_xml", "xml_decode");
        try {
            HelperFunctions.saveProperties(aliases, ZPEInstance.INSTALL_PATH + "/aliases.properties", "This is a list of internal function aliases.");
        }
        catch (Exception e) {
            ZPECore.printError("Aliases could not be saved correctly.");
        }
    }

    static void writeDefaultProperties() {
        Properties prop = new Properties();
        File f = new File(ZPEInstance.INSTALL_PATH);
        System.out.println("Creating directory " + ZPEInstance.INSTALL_PATH + ".");
        if (!f.exists() && !f.mkdirs()) {
            ZPECore.log("Properties folders `" + String.valueOf(f.getAbsoluteFile()) + "` could not be created in ZPEStartup");
        }
        System.out.println("No properties file found. Setting to defaults.");
        prop.setProperty("ALLOW_COMPILER_INCLUDES", "true");
        prop.setProperty("SHOW_COMPILE_COMPLETE_MESSAGE", "false");
        prop.setProperty("ERROR_LEVEL", "2");
        prop.setProperty("DEFAULT_PERMISSION_LEVEL", "3");
        prop.setProperty("PERMISSION_LEVEL", "-");
        prop.setProperty("CASE_INSENSITIVE_COMPILE", "false");
        prop.setProperty("SHORT_CIRCUIT_EVALUATION", "true");
        prop.setProperty("FORCE_CLI_COLOUR", "false");
        prop.setProperty("DISABLED_FUNCTIONS", "shutdown;get_unique_id;update_zpe;");
        prop.setProperty("SERVER_AUTO_UPDATE", "false");
        prop.setProperty("SERVER_MESSAGE", "Welcome to ZPE Remote.");
        prop.setProperty("ALLOW_SERVER_COMMANDS", "true");
        prop.setProperty("USE_CAMEL_CASE", "false");
        prop.setProperty("INDEX_SAFETY", "false");
        prop.setProperty("ALLOW_SHORT_IFS", "true");
        prop.setProperty("OPTION_BASE_1", "false");
        prop.setProperty("ALLOW_UNBOUND_VARIABLES", "true");
        prop.setProperty("DOCUMENT_ROOT", System.getProperty("user.home") + "/public_html/");
        prop.setProperty("ONLINE_PATH", "https://online.zpe.jamiebalfour.scot");
        prop.setProperty("ZULE_PATH", "https://zpe.jamiebalfour.scot/zule");
        prop.setProperty("UPDATE_PATH", "https://www.jamiebalfour.scot/projects/zpe/version.php?verbose=true");
        prop.setProperty("USE_SANDBOX", "true");
        prop.setProperty("AUTO_PREPEND_PATH", "-");
        prop.setProperty("REQUIRE_EXPLICIT_VARIABLE_DECLARATION", "false");
        prop.setProperty("ALWAYS_BEAUTIFY_OUTPUT", "false");
        prop.setProperty("USE_ZPEC", "false");
        prop.setProperty("ALWAYS_BEAUTIFY_OUTPUT", "false");
        prop.setProperty("CHATGPT_URL", "https://api.openai.com/v1/chat/completions");
        prop.setProperty("CHATGPT_KEY", "");
        prop.setProperty("CHATGPT_MODEL", "gpt-4o-mini");
        try {
            HelperFunctions.saveProperties(prop, ZPEInstance.CONFIGURATION_PATH, "This is a list of ZPE properties and can be modified to change ZPE settings.");
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
            ZPECore.printError("Startup properties could not be saved correctly.");
        }
    }

    static void loadSettings() {
        File prepend;
        String f;
        File fi;
        ZPEStartup.makeConfigurationDirectories();
        Properties main_properties = ZPEStartup.loadProperties();
        if (main_properties == null) {
            return;
        }
        ZPEInstance.ALLOW_COMPILER_INCLUDES = main_properties.getProperty("ALLOW_COMPILER_INCLUDES", "true").equals("true");
        ZPEInstance.SHOW_COMPILE_COMPLETE_MESSAGE = main_properties.getProperty("SHOW_COMPILE_COMPLETE_MESSAGE", "false").equals("true");
        ZPEInstance.ERROR_LEVEL = HelperFunctions.stringToInteger(main_properties.getProperty("ERROR_LEVEL", "2"));
        ZPEInstance.CASE_INSENSITIVE = main_properties.getProperty("CASE_INSENSITIVE_COMPILE", "").equals("true");
        ZPEInstance.USE_COLOR = main_properties.getProperty("FORCE_CLI_COLOUR", "false").equals("true");
        ZPEInstance.DISABLED_COMMANDS = main_properties.getProperty("DISABLED_FUNCTIONS", "").split(";");
        ZPEInstance.DISABLED_OBJECTS = main_properties.getProperty("DISABLED_OBJECTS", "").split(";");
        ZPEInstance.INDEX_SAFETY = main_properties.getProperty("INDEX_SAFETY", "false").equals("true");
        ZPEInstance.ALLOW_SHORT_IFS = main_properties.getProperty("ALLOW_SHORT_IFS", "true").equals("true");
        ZPEInstance.DOCUMENT_ROOT = main_properties.getProperty("DOCUMENT_ROOT", System.getProperty("user.home") + "/public_html/");
        ZPEInstance.USER_DEFINED_PERMISSION_LEVEL = HelperFunctions.stringToInteger(main_properties.getProperty("DEFAULT_PERMISSION_LEVEL", "3"));
        ZPEInstance.SERVER_AUTO_UPDATE = main_properties.getProperty("SERVER_AUTO_UPDATE", "false").equals("true");
        ZPEInstance.SERVER_MESSAGE = main_properties.getProperty("SERVER_MESSAGE", "Welcome to ZPE Remote.");
        ZPEInstance.ALLOW_SERVER_COMMANDS = main_properties.getProperty("ALLOW_SERVER_COMMANDS", "true").equals("true");
        ZPEInstance.USE_CAMEL_CASE = main_properties.getProperty("USE_CAMEL_CASE", "false").equals("true");
        ZPEInstance.OPTION_BASE_1 = main_properties.getProperty("OPTION_BASE_1", "false").equals("true");
        ZPEInstance.ALLOW_UNBOUND_VARIABLES = main_properties.getProperty("ALLOW_UNBOUND_VARIABLES", "true").equals("true");
        ZPEInstance.GUI_START = HelperFunctions.stringToInteger(main_properties.getProperty("GUI_START", "0"));
        ZPEInstance.ONLINE_PATH = main_properties.getProperty("ONLINE_PATH", "https://online.zpe.jamiebalfour.scot");
        ZPEInstance.ZULE_PATH = main_properties.getProperty("ZULE_PATH", "https://zpe.jamiebalfour.scot/zule");
        ZPEInstance.UPDATE_PATH = main_properties.getProperty("UPDATE_PATH", "https://www.jamiebalfour.scot/projects/zpe/version.php?verbose=true");
        ZPEInstance.USE_SANDBOX = main_properties.getProperty("USE_SANDBOX", "true").equals("true");
        ZPEInstance.USE_ZPEC = main_properties.getProperty("USE_ZPEC", "false").equals("true");
        ZPEInstance.REQUIRE_EXPLICIT_VARIABLE_DECLARATION = main_properties.getProperty("REQUIRE_EXPLICIT_VARIABLE_DECLARATION", "false").equals("true");
        ZPEInstance.ALWAYS_BEAUTIFY_OUTPUT = main_properties.getProperty("ALWAYS_BEAUTIFY_OUTPUT", "false").equals("true");
        ZPEInstance.CHATGPT_URL = main_properties.getProperty("CHATGPT_URL", null);
        ZPEInstance.CHATGPT_KEY = main_properties.getProperty("CHATGPT_KEY", null);
        ZPEInstance.CHATGPT_MODEL = main_properties.getProperty("CHATGPT_MODEL", null);
        if (!main_properties.getProperty("PERMISSION_LEVEL", "-").equals("-")) {
            ZPEInstance.USER_DEFINED_PERMISSION_LEVEL = HelperFunctions.stringToInteger(main_properties.getProperty("PERMISSION_LEVEL", "3"));
            ZPEInstance.PERMISSION_LEVEL_LOCKED = true;
        }
        if (ZPEInstance.SERVER_MESSAGE.startsWith("file//") && (fi = new File(new File(f = ZPEInstance.INSTALL_PATH + ZPEInstance.SERVER_MESSAGE.substring(6)).getAbsolutePath())).exists()) {
            try {
                ZPEInstance.SERVER_MESSAGE = FileHelperFunctions.readFileAsString(f);
            }
            catch (Exception e) {
                ZPEInstance.SERVER_MESSAGE = "Welcome to ZPE Remote.";
            }
        }
        if (!main_properties.getProperty("AUTO_PREPEND_PATH", "-").equals("-") && (prepend = new File(main_properties.getProperty("AUTO_PREPEND_PATH", "-"))).exists()) {
            try {
                ZPEInstance.AUTO_PREPEND = new IAST();
                YASSCompiler c = new YASSCompiler();
                IAST temp = c.compile(FileHelperFunctions.readFileAsString(prepend.getAbsolutePath()));
                IAST current = temp.next;
                while (current.next != null) {
                    if (current.next.type == 12 && (current.next.id.equals("main") || current.next.id.equals("start"))) {
                        current.next = current.next.next;
                        break;
                    }
                    current = current.next;
                }
                ZPEInstance.AUTO_PREPEND = temp;
            }
            catch (Exception e) {
                System.err.println("File " + ZPEInstance.INSTALL_PATH + "/prepend.yass could not be successfully prepended.");
            }
        }
    }

    static void makeConfigurationDirectories() {
        File cache;
        File aliases;
        File constants;
        File baseSettings;
        File config;
        File plugins;
        File sandbox;
        File transpilers;
        File libs;
        File tmpPath;
        File installPath = new File(ZPEInstance.INSTALL_PATH);
        if (!installPath.exists() && !installPath.mkdirs()) {
            ZPECore.log("Could not make the install path directory");
        }
        if (!(tmpPath = new File(ZPEInstance.INSTALL_PATH + "/tmp")).exists() && !tmpPath.mkdirs()) {
            ZPECore.log("Could not make the tmp directory");
        }
        if (!(libs = new File(ZPEInstance.LIBRARY_IMPORT_DIRECTORY)).exists() && !libs.mkdirs()) {
            ZPECore.log("Could not make the libs directory");
        }
        if (!(transpilers = new File(ZPEInstance.TRANSPILERS_DIRECTORY)).exists() && !transpilers.mkdirs()) {
            ZPECore.log("Could not make the converts import directory");
        }
        if (!(sandbox = new File(ZPEInstance.SANDBOX_DIR)).exists() && !sandbox.mkdirs()) {
            ZPECore.log("Could not make the sandbox directory");
        }
        if (!(plugins = new File(ZPEInstance.PLUGIN_DIRECTORY)).exists() && !plugins.mkdirs()) {
            ZPECore.log("Could not make the plugins directory");
        }
        if (!(config = new File(ZPEInstance.CONFIGURATION_PATH)).exists()) {
            ZPEStartup.writeDefaultProperties();
        }
        if (!(baseSettings = new File(ZPEInstance.BASE_SETTINGS_PATH)).exists()) {
            ZPEStartup.createDefaultSettingsFile();
        }
        if (!(constants = new File(ZPEInstance.INSTALL_PATH + "/constants.json")).exists()) {
            ZPEStartup.writeDefaultConstants();
        }
        if (!(aliases = new File(ZPEInstance.INSTALL_PATH + "/aliases.properties")).exists()) {
            ZPEStartup.writeDefaultAliases();
        }
        if (!(cache = new File(ZPEInstance.getCacheDirectory())).exists()) {
            cache.mkdirs();
        }
    }
}

