/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.SerialisableObject;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEEntity;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.ArgumentException;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.UnacceptableTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.Undefined;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ZPEObject
extends ZPEEntity
implements Iterable<String>,
ZPEPropertyWrapper,
Serializable {
    private static final long serialVersionUID = -6866976117394947674L;
    protected BinarySearchTree<String, ZPEVariable> properties = new BinarySearchTree();
    ZPEPropertyWrapper parent;
    byte scope = 0;
    int type = 0;
    private ZPEType returnValue = null;
    private String id;
    boolean anonymous = false;

    public ZPEObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent, String name) {
        this.ownerRuntime = z;
        this.id = name;
        this.parent = parent;
    }

    public ZPEObject(ZPEObject o) {
        this.ownerRuntime = o.ownerRuntime;
        this.id = o.id;
        this.parent = o.parent;
        this.scope = o.scope;
        this.type = o.type;
        this.returnValue = o.returnValue;
        for (String prop : o.properties.keySet()) {
            this.properties.put(prop, o.properties.get(prop));
        }
    }

    protected void copyData(ZPEObject o) {
        o.ownerRuntime = this.ownerRuntime;
        o.id = this.id;
        o.parent = this.parent;
        o.scope = this.scope;
        o.type = this.type;
        for (String prop : o.properties.keySet()) {
            o.properties.put(prop, o.properties.get(prop));
        }
    }

    @Override
    public ZPEType copyOfMe() {
        return this;
    }

    public boolean equals(Object obj) {
        block16: {
            if (!(obj instanceof ZPEObject)) {
                return false;
            }
            ZPEObject comparison = (ZPEObject)obj;
            if (this.properties.containsKey("_compare")) {
                ZPEType o = this.getVariable("_compare");
                if (o instanceof ZPEObjectNativeMethod) {
                    BinarySearchTree<String, ZPEType> parameters = new BinarySearchTree<String, ZPEType>();
                    for (String s : ((ZPEObjectNativeMethod)o).getParameterNames()) {
                        parameters.put(s, comparison);
                    }
                    try {
                        return ZPEHelperFunctions.ToBoolean(((ZPEObjectNativeMethod)o).MainMethod(parameters, this));
                    }
                    catch (ZPERuntimeException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExitHalt e) {
                        break block16;
                    }
                }
                if (o instanceof ZPEFunction) {
                    ZPEFunction f = (ZPEFunction)o;
                    for (String s : f.parameterNames) {
                        try {
                            f.addParameter(s);
                        }
                        catch (ZPERuntimeException e) {
                            throw new RuntimeException(e);
                        }
                        try {
                            f.setParameter(s, comparison);
                        }
                        catch (ZPERuntimeException e) {
                            ZPECore.log(e.getMessage());
                        }
                    }
                    try {
                        return ZPEHelperFunctions.ToBoolean(f.run());
                    }
                    catch (BreakPointHalt | ExitHalt e) {
                    }
                    catch (ZPERuntimeException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return false;
    }

    public ZPEType getProperty(String propertyName) {
        if (this.properties.containsKey(propertyName)) {
            ZPEVariable prop = this.properties.get(propertyName);
            if (prop.scope == 2 || this.anonymous) {
                return prop.getValue();
            }
        }
        return null;
    }

    public String toString() {
        if (this.properties.containsKey("_output") && (this.properties.get("_output").getValue() instanceof ZPEFunction || this.properties.get("_output").getValue() instanceof ZPEObjectNativeMethod)) {
            if (this.properties.get("_output").getValue() instanceof ZPEObjectNativeMethod) {
                ZPEObjectNativeMethod output = (ZPEObjectNativeMethod)this.properties.get("_output").getValue();
                try {
                    this.runNativeMethod(output, new IAST());
                    return this.returnValue.toString();
                }
                catch (ExitHalt e) {
                    return "";
                }
                catch (BreakPointHalt | ZPEException e) {
                    throw new RuntimeException(e);
                }
            }
            ZPEFunction output = (ZPEFunction)this.properties.get("_output").getValue();
            output.parent = this;
            try {
                return output.run().toString();
            }
            catch (BreakPointHalt | ExitHalt e) {
                return "";
            }
            catch (ZPERuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        int pos = 0;
        StringBuilder values2 = new StringBuilder();
        for (Map.Entry<String, ZPEVariable> f : this.properties.entrySet()) {
            if (f.getValue() != null && (f.getValue().scope == 2 || this.anonymous)) {
                if (!values2.toString().isEmpty()) {
                    values2.append(", ");
                }
                values2.append(f.getKey());
            }
            ++pos;
        }
        return this.id + " => {" + String.valueOf(values2) + "}";
    }

    public String printBeautified() {
        int pos = 0;
        StringBuilder values2 = new StringBuilder();
        for (Map.Entry<String, ZPEVariable> f : this.properties.entrySet()) {
            if (f.getValue().scope == 2) {
                values2.append("  [").append(f.getKey()).append("]");
                if (pos + 1 != this.properties.keySet().size()) {
                    values2.append(System.lineSeparator());
                }
            }
            ++pos;
        }
        return this.id + System.lineSeparator() + "(" + System.lineSeparator() + String.valueOf(values2) + System.lineSeparator() + ")";
    }

    @Override
    protected ZPERuntimeEnvironment getRuntime() {
        return this.ownerRuntime;
    }

    void setRuntime(ZPERuntimeEnvironment p) {
        this.ownerRuntime = p;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void removeProperty(String propertyName) {
        if (this.properties.containsKey(propertyName)) {
            this.properties.get(propertyName).destroy();
            this.properties.put(propertyName, null);
            this.properties.remove(propertyName);
            this.properties.keySet().remove(propertyName);
            return;
        }
        if (this.parent != null) {
            if (this.parent.hasVariable(propertyName)) {
                this.parent.removeProperty(propertyName);
            }
            return;
        }
        if (this.ownerRuntime.globalVariableExists(propertyName)) {
            this.ownerRuntime.removeGlobalVariable(propertyName);
        }
    }

    void pushProperty(String name, ZPEVariable variable) throws ZPERuntimeException {
        if (!(this.id.isEmpty() || this.properties.containsKey(name) || this.anonymous)) {
            return;
        }
        this.properties.put(name, variable);
    }

    public String[] getProperties() {
        ArrayList<String> props = new ArrayList<String>();
        for (String s : this.properties.keySet()) {
            if (this.properties.get((String)s).scope != 2) continue;
            if (this.properties.get((String)s).value instanceof ZPEObjectNativeMethod) {
                ZPEObjectNativeMethod x = (ZPEObjectNativeMethod)this.properties.get((String)s).value;
                props.add(s);
                continue;
            }
            props.add(s);
        }
        String[] o = new String[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            o[i] = (String)props.get(i);
        }
        return o;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public void setProperty(String name, ZPEType value) throws ZPERuntimeException {
        if (!(this.id.isEmpty() || this.properties.containsKey(name) || this.anonymous)) {
            return;
        }
        if (!name.isEmpty()) {
            int scope = 0;
            if (this.hasVariable(name)) {
                this.properties.get(name).setValue(value);
            } else {
                this.pushProperty(name, this.createGeneralVariable(name, value, scope, this, (byte)118));
            }
        }
    }

    @Override
    public void setProperty(String n, ZPEType value, byte type) throws ZPERuntimeException {
        if (!this.id.isEmpty() && !this.properties.containsKey(n)) {
            return;
        }
        if (this.hasVariable(n)) {
            this.properties.get(n).setValue(value);
        } else {
            this.pushProperty(n, this.createGeneralVariable(n, value, this.scope, this, type));
        }
    }

    public void setProperty(String n, ZPEType value, byte scope, byte type) throws ZPERuntimeException {
        if (!(this.id.isEmpty() || this.properties.containsKey(n) || this.anonymous)) {
            return;
        }
        if (this.hasVariable(n)) {
            this.properties.get(n).setValue(value);
            this.properties.get((String)n).scope = scope;
        } else {
            this.pushProperty(n, this.createGeneralVariable(n, value, scope, this, type));
        }
    }

    @Override
    public ZPEType getVariable(String n) {
        if (this.properties.containsKey(n)) {
            return this.properties.get(n).getValue();
        }
        if (this.parent != null) {
            return this.parent.getVariable(n);
        }
        if (this.ownerRuntime.globalVariableExists(n)) {
            return this.ownerRuntime.getGlobalVariable(n);
        }
        return ZPECore.UNDEFINED;
    }

    @Override
    public boolean hasVariable(String key) {
        return this.properties.containsKey(key);
    }

    void construct(IAST paramsAST) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (this.properties.containsKey("_construct") || this.properties.containsKey(this.id)) {
            ZPEType var = this.properties.containsKey("_construct") ? this.properties.get("_construct").getValue() : this.properties.get(this.id).getValue();
            if (var instanceof ZPEFunction) {
                ZPEFunction constructor = (ZPEFunction)var;
                ZPEType[] parameters = this.ownerRuntime.generateArguments(paramsAST);
                constructor.parameterMap.clear();
                if (parameters.length > constructor.parameterNames.size()) {
                    throw new ArgumentException("Generate structure", "" + constructor.parameterNames.size());
                }
                for (int i = 0; i < parameters.length; ++i) {
                    String n = constructor.parameterNames.get(i);
                    constructor.addParameter(n);
                    constructor.setParameter(n, parameters[i]);
                }
                constructor.parent = this;
                constructor.ownerRuntime = this.ownerRuntime;
                constructor.run();
            } else if (var instanceof ZPEObjectNativeMethod) {
                ZPEObjectNativeMethod constructor = (ZPEObjectNativeMethod)var;
                this.runNativeMethod(constructor, paramsAST);
            } else {
                throw new IncorrectDataTypeException("function", "object constructor");
            }
        }
    }

    void inherit(String id, ZPEFunction caller) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEObject inherit = this.getStructure(id, caller);
        for (String var : inherit.properties.keySet()) {
            if (this.properties.containsKey(var)) continue;
            this.pushProperty(var, inherit.properties.get(var));
        }
    }

    ZPEBoolean serialise(String file) throws ZPERuntimeException {
        if (this.ownerRuntime.getPermissionLevel() < 4) {
            return new ZPEBoolean(false);
        }
        try {
            FileOutputStream fout = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            SerialisableObject s = this.SerialiseObject(this);
            oos.writeObject(s);
            oos.close();
            return new ZPEBoolean(true);
        }
        catch (Exception e) {
            throw new ZPERuntimeException("Problem serialising object.");
        }
    }

    public ZPEString getDefinition() {
        return new ZPEString(this.id);
    }

    private SerialisableObject SerialiseObject(ZPEObject obj) throws ZPERuntimeException {
        SerialisableObject s = new SerialisableObject();
        s.name = obj.id;
        for (String v : obj.properties.keySet()) {
            ZPEVariable var = obj.properties.get(v);
            s.pushVariable(v, new ZPEVariable(v, this.getValue(var.getValue()), null));
        }
        return s;
    }

    private ZPEType getValue(ZPEType value) throws ZPERuntimeException {
        ZPEMemberType out;
        ZPEMemberType l;
        ZPEType output = null;
        if (value instanceof ZPEFunction) {
            IAST ast = new IAST();
            ast.left = ((ZPEFunction)value).code;
            ast.type = (byte)12;
        }
        if (value instanceof ZPEObject) {
            output = this.SerialiseObject((ZPEObject)value);
        }
        if (value instanceof ZPEList) {
            l = (ZPEList)value;
            out = new ZPEList();
            for (ZPEType o : ((ZPEList)l).items()) {
                if (o instanceof ZPEFunction || o instanceof ZPEObject || o instanceof ZPEList || o instanceof ZPEMap) {
                    ((ZPEList)out).add(this.getValue(o));
                    continue;
                }
                ((ZPEList)out).add(o);
            }
            output = out;
        }
        if (value instanceof ZPEMap) {
            l = (ZPEMap)value;
            out = new ZPEMap();
            Iterator<ZPEType> iterator2 = ((ZPEMap)l).keySet().iterator();
            while (iterator2.hasNext()) {
                ZPEType v;
                ZPEType o;
                ZPEType key = o = iterator2.next();
                if (o instanceof ZPEFunction || o instanceof ZPEObject || o instanceof ZPEList || o instanceof ZPEMap) {
                    key = this.getValue(key);
                }
                if ((v = ((ZPEMap)l).get(o)) instanceof ZPEFunction || v instanceof ZPEObject || v instanceof ZPEList || v instanceof ZPEMap) {
                    v = this.getValue(v);
                }
                ((ZPEMap)out).put(key, v);
            }
            output = out;
        } else {
            output = value;
        }
        return output;
    }

    ZPEObject setInnerValue(IAST node, ZPEType v, ZPEFunction caller) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        byte type = 118;
        if (node.left == null || node.left.type == 62) {
            // empty if block
        }
        if (node.next != null) {
            ZPEType o = this.getVariable(node.id);
            if (!(o instanceof ZPEObject)) {
                throw new IncorrectDataTypeException("object or structure", "pointer value");
            }
            ZPEObject zo = (ZPEObject)o;
            ZPEObject var = zo.setInnerValue(node.next, v, caller);
            this.setProperty(node.id, var);
        } else {
            ZPEType output = v;
            String name = node.id;
            if (node.type == 88) {
                assert (node.left != null);
                name = node.left.id;
                ZPEType current = this.getVariable(name);
                ZPEType index = this.ownerRuntime.evaluateExpression((IAST)node.value, this);
                output = ZPERuntimeEnvironment.setIndex(current, index, v);
            } else {
                output = v;
            }
            if (this.properties.containsKey(name)) {
                byte s = this.properties.get((String)name).scope;
                boolean set = false;
                if (s == 2) {
                    set = true;
                } else if (s == 0) {
                    if (caller.isDescendantOf(this) || this.isDescendantOf(caller)) {
                        set = true;
                    } else {
                        ZPECore.printWarning("The variable " + name + " is protected and cannot be accessed.");
                    }
                } else if (s == 1 && caller.isDescendantOf(this)) {
                    set = true;
                } else {
                    this.returnValue = null;
                    ZPECore.printWarning("The variable " + name + " is private and cannot be accessed.");
                }
                if (set) {
                    this.setProperty(name, output, this.properties.get((String)name).scope, type);
                }
            } else {
                this.setProperty(name, output, (byte)2, type);
            }
        }
        return this;
    }

    ZPEType getReturnValue() {
        return this.returnValue;
    }

    private Object getVariableCheck(String n, ZPEFunction caller) {
        if (caller.parent != this && this.properties.get(n) != null && this.properties.get((String)n).scope == 1) {
            return null;
        }
        return this.properties.get(n).getValue();
    }

    private boolean canAccessFunction(ZPEFunction fun, ZPEFunction caller) throws ZPERuntimeException {
        if (fun.scope == 1 && caller.parent == this) {
            if (caller.parent == this) {
                return true;
            }
            ZPECore.printError("The function " + fun.name + " is private and cannot be accessed.");
            return false;
        }
        if (fun.scope == 0 && (caller.isDescendantOf(this) || caller.isDescendantOf(this.ownerRuntime.globalFunction))) {
            ZPECore.printError("The function " + fun.name + " is protected and cannot be accessed.");
            return false;
        }
        return true;
    }

    public boolean hasInnerValue(IAST node, ZPEFunction caller) {
        if (node.next != null) {
            if (!this.properties.containsKey(node.id)) {
                return false;
            }
            if (!(this.properties.get(node.id).getValue() instanceof ZPEObject)) {
                return false;
            }
            return ((ZPEObject)this.properties.get(node.id).getValue()).hasInnerValue(node.next, caller);
        }
        try {
            if (this.getInnerValue(node, caller) != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZPEObject getInnerValue(IAST node, ZPEFunction caller) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        Object v;
        if (node.type == 3 || node.type == 71) {
            ZPEType fun;
            if (node.type == 3) {
                if (node.id.equals("inherit")) {
                    ZPEType[] params = this.ownerRuntime.generateArguments((IAST)node.value);
                    this.inherit(params[0].toString(), caller);
                    this.returnValue = ZPECore.UNDEFINED;
                    return this;
                }
                if (node.id.equals("serialise")) {
                    ZPEType[] params = this.ownerRuntime.generateArguments((IAST)node.value);
                    this.returnValue = this.serialise(params[0].toString());
                    return this;
                }
                if (node.id.equals("get_definition")) {
                    this.returnValue = this.getDefinition();
                    return this;
                }
                if (node.id.equals("get_properties")) {
                    ZPEList l = new ZPEList();
                    l.addAll(this.properties.keySet());
                    this.returnValue = l;
                    return this;
                }
                if (node.id.equals("has_function")) {
                    ZPEVariable v2;
                    ZPEType[] params = this.ownerRuntime.generateArguments((IAST)node.value);
                    if (this.properties.containsKey(params[0].toString()) && (v2 = this.properties.get(params[0].toString())).getValue() instanceof ZPEFunction) {
                        ZPEFunction f = (ZPEFunction)v2.getValue();
                        this.returnValue = new ZPEBoolean(this.canAccessFunction(f, caller));
                        return this;
                    }
                    this.returnValue = new ZPEBoolean(false);
                    return this;
                }
            }
            v = null;
            v = node.type == 71 ? this.getVariableCheck(node.left.id, caller) : this.getVariableCheck(node.id, caller);
            if (v instanceof ZPEFunction) {
                fun = (ZPEFunction)v;
                ((ZPEFunction)fun).parent = this;
                boolean accessible = true;
                if (node.type == 3) {
                    accessible = this.canAccessFunction((ZPEFunction)fun, caller);
                }
                if (accessible) {
                    ZPEType[] params = this.ownerRuntime.generateArguments((IAST)node.value);
                    int i = 0;
                    for (String k : ((ZPEFunction)fun).parameterNames) {
                        if (i >= params.length) break;
                        ((ZPEFunction)fun).addParameter(k);
                        ((ZPEFunction)fun).setParameter(k, params[i]);
                        ++i;
                    }
                    ZPEType value = ((ZPEFunction)fun).run();
                    if (node.left != null && node.left.type == 88) {
                        ZPEType index = this.ownerRuntime.evaluateExpression((IAST)node.left.value, this.ownerRuntime.getCurrentFunction());
                        try {
                            value = ZPERuntimeEnvironment.getIndex(value, index);
                        }
                        catch (UnacceptableTypeException e) {
                            ZPECore.printWarning(e.getMessage());
                        }
                    }
                    this.returnValue = value;
                }
            } else {
                if (!(v instanceof ZPEObjectNativeMethod)) throw new IncorrectDataTypeException("object", "pointer evaluation");
                fun = (ZPEObjectNativeMethod)v;
                this.runNativeMethod((ZPEObjectNativeMethod)fun, (IAST)node.value);
            }
        } else if (node.type == 88) {
            ZPEType variable = this.ownerRuntime.evaluateExpression(node.left, this);
            ZPEType index = this.ownerRuntime.evaluateExpression((IAST)node.value, this);
            try {
                this.returnValue = ZPERuntimeEnvironment.getIndex(variable, index);
            }
            catch (UnacceptableTypeException e) {
                ZPECore.printError(e.getMessage());
            }
        } else {
            v = this.properties.get(node.id);
            if (v == null) {
                throw new ZPERuntimeException(node.id + " is not a property of " + this.id + ".");
            }
            byte scope = ((ZPEVariable)v).scope;
            boolean giveBack = false;
            if (scope == 2) {
                giveBack = true;
            } else if (scope == 0) {
                if (caller.isDescendantOf(this) || this.isDescendantOf(caller)) {
                    giveBack = true;
                } else {
                    ZPECore.printError("The variable " + node.id + " is protected and cannot be accessed.");
                }
            } else if (scope == 1 && caller.parent == this) {
                giveBack = true;
            } else {
                this.returnValue = null;
                ZPECore.printError("The variable " + node.id + " is private and cannot be accessed.");
            }
            if (giveBack) {
                ZPEType current = this.getVariable(node.id);
                if (node.type == 88) {
                    ZPEType index = this.ownerRuntime.evaluateExpression((IAST)node.value, this);
                    ZPEType output = null;
                    try {
                        output = ZPERuntimeEnvironment.getIndex(current, index);
                    }
                    catch (UnacceptableTypeException e) {
                        ZPECore.printError(e.getMessage());
                    }
                    this.returnValue = output;
                } else {
                    this.returnValue = current;
                }
            }
        }
        if (node.next == null) return this;
        ZPEType o = this.returnValue;
        if (!(o instanceof ZPEObject)) {
            throw new IncorrectDataTypeException("object or structure", "pointer evaluation");
        }
        ZPEObject zo = (ZPEObject)o;
        zo = zo.getInnerValue(node.next, caller);
        this.setProperty(node.id, zo);
        this.returnValue = zo.getReturnValue();
        return this;
    }

    @Override
    public ZPEVariable getRawVariable(String n) {
        if (this.hasVariable(n)) {
            return this.properties.get(n);
        }
        return null;
    }

    public ZPEFunction getFunction(String id) {
        ZPEType v;
        if (this.properties.containsKey(id) && (v = this.properties.get((String)id).value) instanceof ZPEFunction) {
            return (ZPEFunction)v;
        }
        if (this.parent != null) {
            ZPEEntity p;
            if (this.parent instanceof ZPEFunction) {
                p = (ZPEFunction)this.parent;
                return ((ZPEFunction)p).getFunction(id);
            }
            if (this.parent instanceof ZPEObject) {
                p = (ZPEObject)this.parent;
                return ((ZPEObject)p).getFunction(id);
            }
        }
        return null;
    }

    @Override
    public ZPEPropertyWrapper getParent() {
        return this.parent;
    }

    public void addPropertyByName(String n) throws ZPERuntimeException {
        this.properties.put(n, new ZPEVariable(n, new Undefined(), 2, this, 118));
    }

    private void runNativeMethod(ZPEObjectNativeMethod fun, IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEType[] params = this.ownerRuntime.generateArguments(node);
        int i = 0;
        BinarySearchTree<String, ZPEType> parameterMap = new BinarySearchTree<String, ZPEType>();
        for (String k : fun.getParameterNames()) {
            if (i >= params.length) break;
            parameterMap.put(k, params[i]);
            ++i;
        }
        if (this.ownerRuntime.getPermissionLevel() >= fun.getRequiredPermissionLevel()) {
            this.returnValue = fun.MainMethod(parameterMap, this);
        } else {
            ZPECore.printWarning("Function " + fun.getName() + " requires a permission level of " + fun.getRequiredPermissionLevel() + " and cannot be run.");
            this.returnValue = ZPECore.UNDEFINED;
        }
    }

    private ArrayList<String> getPrivateProperties() {
        ArrayList<String> props = new ArrayList<String>();
        for (String prop : this.properties.keySet()) {
            if (this.properties.get((String)prop).scope != 2) continue;
            props.add(prop);
        }
        return props;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getPrivateProperties().iterator();
    }
}

