/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.UndefinedPath;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.ZPEBuildInformation;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.gui.ZPEConsole;
import jamiebalfour.zpe.types.Undefined;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.jline.reader.LineReader;

public class ZPECore {
    public static final String VERSION_NUMBER_MAJOR = "1.13";
    public static final String VERSION_NUMBER_MINOR = "9";
    public static final String CLI_VERSION_NUMBER = "1.8.1";
    public static final String YASS_VERSION_NAME = "YASS 25.5";
    public static final String YASS_VERSION_YEAR = "2025";
    public static final String VERSION_NAME = "Gillygate";
    public static final String VERSION_DATE = "September 2025";
    public static final int ERROR_WARNING_LEVEL = 1;
    public static final int ERROR_EXCEPTION_LEVEL = 2;
    public static final int ERROR_JAVA_LEVEL = 3;
    public static final Undefined UNDEFINED = new Undefined();
    public static final UndefinedPath UNDEFINED_PATH = new UndefinedPath();
    public static boolean IGNORE_STARTUP = false;
    public static String[] programArguments = new String[0];

    public static String getVersionNumber() {
        return "1.13.9." + ZPECore.getBuildVersion();
    }

    public static String getCLIVersionNumber() {
        return CLI_VERSION_NUMBER;
    }

    public static String getVersionDate() {
        return VERSION_DATE;
    }

    public static String getVersionName() {
        return VERSION_NAME;
    }

    public static void print() {
        ZPECore.print(System.lineSeparator());
    }

    public static void print(String s) {
        System.out.print(s + System.lineSeparator());
    }

    public static void print(String s, boolean same_line) {
        if (same_line) {
            System.out.print(s);
        } else {
            ZPECore.print(s);
        }
    }

    public static String readLine() {
        return ZPECore.readLine("");
    }

    public static String readLine(String out) {
        String line;
        if (!out.isEmpty()) {
            ZPECore.print(out, false);
        }
        InputStreamReader converter = new InputStreamReader(System.in, StandardCharsets.UTF_8);
        BufferedReader in = new BufferedReader(converter);
        try {
            line = in.readLine();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            line = "";
        }
        return line;
    }

    public static void printWarning(String s) throws ZPERuntimeException {
        if (ZPEInstance.getErrorLevelProperty() >= 1) {
            System.err.println("ZPE WARNING : " + s);
        }
        if (ZPEInstance.getErrorLevelProperty() >= 2) {
            throw new ZPERuntimeException("ZPE WARNING: " + s);
        }
    }

    public static void printError(String err) throws ZPERuntimeException {
        ZPECore.printError(err, null);
    }

    public static void printError(String err, LineReader r) throws ZPERuntimeException {
        if (ZPEInstance.getSupressErrorsProperty()) {
            if (r != null) {
                r.printAbove(ZPEHelperFunctions.setConsoleEffectToRed(err));
            } else {
                System.err.println(err);
            }
        } else {
            throw new ZPERuntimeException(err);
        }
    }

    public static void PrintCompileWarning(String s) throws CompileException {
        if (ZPEInstance.getErrorLevelProperty() >= 1) {
            ZPECore.print("ZPE WARNING : " + s);
        }
        if (ZPEInstance.getErrorLevelProperty() >= 2) {
            throw new CompileException("ZPE WARNING: " + s);
        }
    }

    public static void printCompileError(String err) throws CompileException {
        if (!ZPEInstance.getSupressErrorsProperty()) {
            throw new CompileException(err);
        }
        System.err.println(err);
    }

    static String ASTtoString(IAST a, int depth) {
        YASSByteCodes b = new YASSByteCodes();
        String s = b.symbolToString(a.type);
        Object out = "";
        if (!a.id.isEmpty()) {
            out = (String)out + ZPECore.tabulate(depth) + s + " : {ID:" + a.id + "}\n";
        }
        if (a.left != null) {
            out = (String)out + ZPECore.ASTtoString(a.left, depth + 1);
        }
        if (a.middle != null) {
            out = (String)out + ZPECore.ASTtoString(a.middle, depth + 1);
        }
        if (a.value instanceof IAST) {
            out = (String)out + ZPECore.ASTtoString((IAST)a.value, depth + 1);
        }
        if (a.next != null) {
            out = (String)out + ZPECore.ASTtoString(a.next, depth);
        }
        return out;
    }

    static String tabulate(int depth) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            out.append("  ");
        }
        return out.toString();
    }

    static void saveUrl(String filename, String urlString) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new URL(urlString).openStream());
             FileOutputStream fout = new FileOutputStream(filename);){
            int count;
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
    }

    public static int getBuildVersion() {
        return HelperFunctions.stringToInteger(ZPEBuildInformation.build);
    }

    public static String getBuildDate() {
        return ZPEBuildInformation.date;
    }

    public static String getBuildTime() {
        return ZPEBuildInformation.time;
    }

    public static void log(String s) {
        File logDirectory;
        File[] files;
        String fileName = ZPEInstance.getInstallPath() + "/log.txt";
        if (new File(fileName).length() > 2000000L) {
            try {
                boolean res = new File(fileName).renameTo(new File(ZPEInstance.getLogPath() + "/log-" + System.nanoTime() + ".txt"));
                if (!res) {
                    new File(fileName).delete();
                }
            }
            catch (Exception res) {
                // empty catch block
            }
        }
        if ((files = (logDirectory = new File(ZPEInstance.getLogPath())).listFiles()) != null && files.length > 3) {
            try {
                Arrays.sort(files, Comparator.comparingLong(File::lastModified));
                files[0].delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            FileWriter fw = new FileWriter(fileName, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(s);
            bw.newLine();
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void startConsole(String[] args2) {
        HashMap<String, String> argv;
        try {
            argv = HelperFunctions.generateArgumentMap(args2);
        }
        catch (HelperFunctions.NoArgumentValueProvided e) {
            throw new RuntimeException(e);
        }
        String file = argv.get("-g");
        boolean ci = false;
        if (argv.containsKey("--debugging")) {
            ZPEKit.setDebugging(true);
        }
        new ZPEConsole(5).setAlwaysOnTop(true);
    }
}

