/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import extensions.mindrot.BCrypt;
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.parsers.csv.ZenithCSVParser;
import jamiebalfour.parsers.ini.MalformedINIException;
import jamiebalfour.parsers.ini.ZenithINIParser;
import jamiebalfour.parsers.jbml.MalformedJBMLException;
import jamiebalfour.parsers.jbml.ZenithJBMLParser;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.parsers.toml.MalformedTOMLException;
import jamiebalfour.parsers.toml.ZenithTOMLParser;
import jamiebalfour.parsers.xml.MalformedXMLException;
import jamiebalfour.parsers.xml.ZenithXMLParser;
import jamiebalfour.zpe.core.CronJob;
import jamiebalfour.zpe.core.ExceptionObject;
import jamiebalfour.zpe.core.FunctionReference;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.SerialisableObject;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPEPluginManager;
import jamiebalfour.zpe.core.ZPERandomizer;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPESerialisedPropertyFile;
import jamiebalfour.zpe.core.ZPESettingsFile;
import jamiebalfour.zpe.core.ZPEStartup;
import jamiebalfour.zpe.core.ZPEUpdater;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.ArgumentException;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.PermissionLevelException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPECoreType;
import jamiebalfour.zpe.interfaces.ZPECustomFunction;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEInternalFunction;
import jamiebalfour.zpe.interfaces.ZPELibrary;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.objects.AudioStreamObject;
import jamiebalfour.zpe.objects.ByteListObject;
import jamiebalfour.zpe.objects.DateObject;
import jamiebalfour.zpe.objects.DoNothingObject;
import jamiebalfour.zpe.objects.ProcessObject;
import jamiebalfour.zpe.objects.ScheduledCommandObject;
import jamiebalfour.zpe.objects.SequentialFileObject;
import jamiebalfour.zpe.types.ZPEArray;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEOrderedAssociativeArray;
import jamiebalfour.zpe.types.ZPERecord;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.variables.ZPENumberVariable;
import jamiebalfour.zpe.zen.ZENClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

class YASSPredefinedFunctions {
    static final ArrayList<String> Commands = new ArrayList();
    static final int NO_OVERWRITE_MODE = 1;
    static final int NORMAL_MODE = 0;
    private static final ArrayList<String> Aliases = new ArrayList();
    static HashMap<String, String> internalAliases = new HashMap();
    static HashMap<String, String> userDefinedAliases = new HashMap();
    private int CommandCount = 0;

    YASSPredefinedFunctions() {
        this.addBuiltInCommand("run_script");
        this.addBuiltInCommand("run_command");
        this.addBuiltInCommand("exit");
        this.addBuiltInCommand("shell");
        this.addBuiltInCommand("run_process");
        this.addBuiltInCommand("pipe");
        this.addBuiltInCommand("std_new_line");
        this.addBuiltInCommand("throw_error");
        this.addBuiltInCommand("write_log");
        this.addBuiltInCommand("handle_of");
        this.addBuiltInCommand("copy_of");
        this.addBuiltInCommand("permission_level_of");
        this.addBuiltInCommand("list_local_variables");
        this.addBuiltInCommand("list_structures");
        this.addBuiltInCommand("list_parameters");
        this.addBuiltInCommand("list_global_variables");
        this.addBuiltInCommand("create_variable");
        this.addBuiltInCommand("is_function");
        this.addBuiltInCommand("get_call_stack");
        this.addBuiltInCommand("do_nothing");
        this.addBuiltInCommand("run_in_thread");
        this.addBuiltInCommand("run_in");
        this.addBuiltInCommand("run_at");
        this.addBuiltInCommand("list_object_properties");
        this.addBuiltInCommand("get_object_property");
        this.addBuiltInCommand("get_environment_variables");
        this.addBuiltInCommand("get_nanoseconds");
        this.addBuiltInCommand("time");
        this.addBuiltInCommand("wait");
        this.addBuiltInCommand("shutdown");
        this.addBuiltInCommand("get_max_memory");
        this.addBuiltInCommand("get_os_name");
        this.addBuiltInCommand("write_cache_value");
        this.addBuiltInCommand("read_cache_value");
        this.addBuiltInCommand("list_cache_values");
        this.addBuiltInCommand("update_zpe");
        this.addBuiltInCommand("get_zpe_property");
        this.addBuiltInCommand("get_version");
        this.addBuiltInCommand("supports");
        this.addBuiltInCommand("feedback");
        this.addBuiltInCommand("get_function_information");
        this.addBuiltInCommand("list_zpe_functions");
        this.addBuiltInCommand("list_zpe_aliases");
        this.addBuiltInCommand("list_plugins");
        this.addBuiltInCommand("list_libraries");
        this.addBuiltInCommand("get_unique_id");
        this.addBuiltInCommand("function_exists");
        this.addBuiltInCommand("sprintf");
        this.addBuiltInCommand("std_err");
        this.addBuiltInCommand("print");
        this.addBuiltInCommand("std_out");
        this.addBuiltInCommand("std_in");
        this.addBuiltInCommand("input_restricted");
        this.addBuiltInCommand("auto_input");
        this.addBuiltInCommand("write");
        this.addBuiltInCommand("get_password_input");
        this.addBuiltInCommand("print_warning");
        this.addBuiltInCommand("deserialise");
        this.addBuiltInCommand("get_yes_no");
        this.addBuiltInCommand("beep");
        this.addBuiltInCommand("open_audio_stream");
        if (ZPEInstance.EXPERIMENTAL) {
            this.addBuiltInCommand("grep");
        }
        this.addBuiltInCommand("wake_on_lan");
        this.addBuiltInCommand("ping");
        this.addBuiltInCommand("get_hostname");
        this.addBuiltInCommand("http_post");
        this.addBuiltInCommand("http_download");
        this.addBuiltInCommand("send_zpe_server_request");
        this.addBuiltInCommand("get_ip_address");
        this.addBuiltInCommand("get_remote_ip_address");
        this.addBuiltInCommand("absolute_value");
        this.addBuiltInCommand("square_root");
        this.addBuiltInCommand("cube_root");
        this.addBuiltInCommand("log");
        this.addBuiltInCommand("factorial");
        this.addBuiltInCommand("is_prime_number");
        this.addBuiltInCommand("sign");
        this.addBuiltInCommand("floor");
        this.addBuiltInCommand("ceiling");
        this.addBuiltInCommand("round");
        this.addBuiltInCommand("significant_figures");
        this.addBuiltInCommand("limit_real");
        this.addBuiltInCommand("value");
        this.addBuiltInCommand("remove_exponent");
        this.addBuiltInCommand("to_binary");
        this.addBuiltInCommand("to_octal");
        this.addBuiltInCommand("to_hexadecimal");
        this.addBuiltInCommand("to_denary");
        this.addBuiltInCommand("evaluate");
        this.addBuiltInCommand("sine");
        this.addBuiltInCommand("cosine");
        this.addBuiltInCommand("tangent");
        this.addBuiltInCommand("random_number");
        this.addBuiltInCommand("range");
        this.addBuiltInCommand("counter");
        this.addBuiltInCommand("calculate_minimum");
        this.addBuiltInCommand("calculate_maximum");
        this.addBuiltInCommand("calculate_range");
        this.addBuiltInCommand("calculate_mean");
        this.addBuiltInCommand("calculate_mode");
        this.addBuiltInCommand("calculate_median");
        this.addBuiltInCommand("calculate_percentile");
        this.addBuiltInCommand("calculate_standard_deviation");
        this.addBuiltInCommand("generate_histogram");
        this.addBuiltInCommand("calculate_linear_interpolation");
        this.addBuiltInCommand("greater_than_all");
        this.addBuiltInCommand("greater_than_any");
        this.addBuiltInCommand("less_than_all");
        this.addBuiltInCommand("less_than_any");
        this.addBuiltInCommand("equals_any");
        this.addBuiltInCommand("all_true");
        this.addBuiltInCommand("all_false");
        this.addBuiltInCommand("any_true");
        this.addBuiltInCommand("any_false");
        this.addBuiltInCommand("in_range");
        this.addBuiltInCommand("xor");
        this.addBuiltInCommand("implies");
        this.addBuiltInCommand("iif");
        this.addBuiltInCommand("nor");
        this.addBuiltInCommand("aes_encrypt");
        this.addBuiltInCommand("aes_decrypt");
        this.addBuiltInCommand("sha1");
        this.addBuiltInCommand("sha256");
        this.addBuiltInCommand("md5");
        this.addBuiltInCommand("password_hash");
        this.addBuiltInCommand("password_verify");
        this.addBuiltInCommand("file_encrypt");
        this.addBuiltInCommand("file_decrypt");
        this.addBuiltInCommand("base64_encode");
        this.addBuiltInCommand("base64_decode");
        this.addBuiltInCommand("integer_to_character");
        this.addBuiltInCommand("character_to_integer");
        this.addBuiltInCommand("string_to_list");
        this.addBuiltInCommand("string_get_character_at");
        this.addBuiltInCommand("string_get_length");
        this.addBuiltInCommand("string_count_occurrences");
        this.addBuiltInCommand("string_contains");
        this.addBuiltInCommand("string_split");
        this.addBuiltInCommand("string_splice");
        this.addBuiltInCommand("string_divide");
        this.addBuiltInCommand("string_find_occurrences");
        this.addBuiltInCommand("string_get_substring");
        this.addBuiltInCommand("string_to_lowercase");
        this.addBuiltInCommand("string_to_uppercase");
        this.addBuiltInCommand("string_replace");
        this.addBuiltInCommand("string_starts_with");
        this.addBuiltInCommand("string_ends_with");
        this.addBuiltInCommand("string_cut");
        this.addBuiltInCommand("string_trim");
        this.addBuiltInCommand("string_trim_start");
        this.addBuiltInCommand("string_trim_end");
        this.addBuiltInCommand("string_matches");
        this.addBuiltInCommand("string_to_date");
        this.addBuiltInCommand("string_is_numeric");
        this.addBuiltInCommand("string_is_lowercase");
        this.addBuiltInCommand("string_is_uppercase");
        this.addBuiltInCommand("string_text_compare");
        this.addBuiltInCommand("string_compare");
        this.addBuiltInCommand("input_validate");
        this.addBuiltInCommand("beautify");
        this.addBuiltInCommand("generate_random_string");
        this.addBuiltInCommand("generate_alphabet");
        this.addBuiltInCommand("format_string");
        this.addBuiltInCommand("speak");
        this.addBuiltInCommand("is_symlink");
        this.addBuiltInCommand("create_symlink");
        this.addBuiltInCommand("replace_symlink");
        this.addBuiltInCommand("list_drives");
        this.addBuiltInCommand("is_directory");
        this.addBuiltInCommand("directory_exists");
        this.addBuiltInCommand("directory_list_files");
        this.addBuiltInCommand("directory_create");
        this.addBuiltInCommand("is_file");
        this.addBuiltInCommand("file_exists");
        this.addBuiltInCommand("file_touch");
        this.addBuiltInCommand("file_get_size");
        this.addBuiltInCommand("file_get_name");
        this.addBuiltInCommand("file_get_path");
        this.addBuiltInCommand("file_get_parent_path");
        this.addBuiltInCommand("file_open");
        this.addBuiltInCommand("file_get_bytes");
        this.addBuiltInCommand("file_put_bytes");
        this.addBuiltInCommand("file_get_contents");
        this.addBuiltInCommand("file_put_contents");
        this.addBuiltInCommand("file_copy");
        this.addBuiltInCommand("file_delete");
        this.addBuiltInCommand("create_temporary_file");
        this.addBuiltInCommand("array_to_list");
        this.addBuiltInCommand("list_get_data_type");
        this.addBuiltInCommand("list_to_array");
        this.addBuiltInCommand("list_add_element");
        this.addBuiltInCommand("list_remove_element");
        this.addBuiltInCommand("list_remove_all");
        this.addBuiltInCommand("list_get_at_index");
        this.addBuiltInCommand("list_get_at_random_index");
        this.addBuiltInCommand("list_shuffle");
        this.addBuiltInCommand("list_compress");
        this.addBuiltInCommand("list_pop");
        this.addBuiltInCommand("list_dequeue");
        this.addBuiltInCommand("list_get_length");
        this.addBuiltInCommand("list_contains");
        this.addBuiltInCommand("list_contains_all");
        this.addBuiltInCommand("list_get_index_of");
        this.addBuiltInCommand("list_count_occurrences");
        this.addBuiltInCommand("list_count_if");
        this.addBuiltInCommand("list_find_duplicates");
        this.addBuiltInCommand("list_insert_at_index");
        this.addBuiltInCommand("list_set_at_index");
        this.addBuiltInCommand("list_reverse");
        this.addBuiltInCommand("list_sort");
        this.addBuiltInCommand("list_swap_elements");
        this.addBuiltInCommand("list_join");
        this.addBuiltInCommand("list_slice");
        this.addBuiltInCommand("list_is_a_set");
        this.addBuiltInCommand("list_populate");
        this.addBuiltInCommand("list_auto_populate");
        this.addBuiltInCommand("list_process");
        this.addBuiltInCommand("list_combine");
        this.addBuiltInCommand("list_compose");
        this.addBuiltInCommand("set_from_list");
        this.addBuiltInCommand("set_intersection");
        this.addBuiltInCommand("set_union");
        this.addBuiltInCommand("set_difference");
        this.addBuiltInCommand("set_cartesian_product");
        this.addBuiltInCommand("list_to_map");
        this.addBuiltInCommand("map_get");
        this.addBuiltInCommand("map_remove");
        this.addBuiltInCommand("map_put");
        this.addBuiltInCommand("map_contains");
        this.addBuiltInCommand("map_get_keys");
        this.addBuiltInCommand("map_flip");
        this.addBuiltInCommand("map_create_ordered");
        this.addBuiltInCommand("csv_decode");
        this.addBuiltInCommand("csv_encode");
        this.addBuiltInCommand("ini_decode");
        this.addBuiltInCommand("toml_decode");
        this.addBuiltInCommand("jbml_decode");
        this.addBuiltInCommand("json_decode");
        this.addBuiltInCommand("json_encode");
        this.addBuiltInCommand("xml_decode");
        if (ZPEInstance.EXPERIMENTAL) {
            this.addBuiltInCommand("get_wikipedia_references");
        }
        try {
            if (ZPEInstance.INTERNAL_ALIASES != null) {
                for (Object prop : ZPEInstance.INTERNAL_ALIASES.keySet()) {
                    this.addInternalAlias(prop.toString(), ZPEInstance.INTERNAL_ALIASES.getProperty(prop.toString()));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayList<String> getCommands() {
        return Commands;
    }

    public static ArrayList<String> getAliases() {
        return Aliases;
    }

    static int requiredPermissionLevels(Class<? extends ZPEInternalFunction> c) {
        try {
            return HelperFunctions.stringToInteger(c.getDeclaredMethod("RequiredPermissionLevel", new Class[0]).invoke(null, new Object[0]).toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    static double getVersion(Class<? extends ZPEInternalFunction> c) {
        try {
            return HelperFunctions.stringToDouble(c.getDeclaredMethod("Version", new Class[0]).invoke(null, new Object[0]).toString());
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    static String getManualHeader(Class<? extends ZPEInternalFunction> c) {
        try {
            return c.getDeclaredMethod("ManualHeader", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static String getManualEntry(Class<? extends ZPEInternalFunction> c) {
        try {
            return c.getDeclaredMethod("ManualEntry", new Class[0]).invoke(null, new Object[0]).toString().replace("**", "").replace("__", "").replace("~~", "");
        }
        catch (Exception e) {
            return "";
        }
    }

    static String getManualEntryAsHTML(Class<? extends ZPEInternalFunction> c) {
        try {
            String message = c.getDeclaredMethod("ManualEntry", new Class[0]).invoke(null, new Object[0]).toString();
            return ZPEHelperFunctions.processDescriptionToHtml(message);
        }
        catch (Exception e) {
            return "";
        }
    }

    static String getManualEntryAsStyledHTML(Class<? extends ZPEInternalFunction> c, boolean dark) {
        try {
            String message = c.getDeclaredMethod("ManualEntry", new Class[0]).invoke(null, new Object[0]).toString();
            String html = ZPEHelperFunctions.processDescriptionToHtml(message);
            html = html.replace("<span class='string'>", "<span style='color:#0a0;'>");
            html = html.replace("<span class='function'>", "<span style='color:#0af;'>");
            html = dark ? html.replace("<code>", "<code style='background:#555;border-radius:5px;padding:0 4px;'>") : html.replace("<code>", "<code style='background:#f0f0f0;border-radius:5px;padding 0 4px;'>");
            return html;
        }
        catch (Exception e) {
            return "";
        }
    }

    static byte getReturnType(Class<? extends ZPEInternalFunction> c) {
        try {
            return (byte)HelperFunctions.stringToInteger(c.getDeclaredMethod("ReturnType", new Class[0]).invoke(null, new Object[0]).toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    static String getCategory(Class<? extends ZPEInternalFunction> c) {
        try {
            return c.getDeclaredMethod("Category", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static int getMode(Class<? extends ZPEInternalFunction> c) {
        try {
            return HelperFunctions.stringToInteger(c.getDeclaredMethod("Mode", new Class[0]).invoke(null, new Object[0]).toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    static ZPEType mainMethod(Class<? extends ZPEInternalFunction> c, ZPEType[] params, ZPERuntimeEnvironment runtime) throws ExitHalt, InternalException {
        try {
            Method m = c.getDeclaredMethod("MainMethod", ZPEType[].class, ZPERuntimeEnvironment.class);
            ZPEType returnVal = (ZPEType)m.invoke(c, params, runtime);
            if (returnVal instanceof ExitHalt) {
                throw (ExitHalt)returnVal;
            }
            if (returnVal instanceof InternalException) {
                throw (InternalException)returnVal;
            }
            return returnVal;
        }
        catch (InternalException e) {
            throw e;
        }
        catch (Exception e) {
            if (!(e instanceof ExitHalt)) {
                throw new RuntimeException(e);
            }
            throw (ExitHalt)e;
        }
    }

    static boolean hasInternalMethod(String s) {
        return Commands.contains(s);
    }

    static boolean hasInternalAlias(String s) {
        return internalAliases.containsKey(s);
    }

    static boolean hasUserDefinedAlias(String s) {
        return userDefinedAliases.containsKey(s);
    }

    static String getFunctionFromAlias(String alias) {
        return internalAliases.get(alias);
    }

    static Class<? extends ZPEInternalFunction> getInternalMethod(String id) {
        try {
            Class<?> c = Class.forName("jamiebalfour.zpe.core.YASSPredefinedFunctions$" + id + "_Command");
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getCommandCount() {
        return this.CommandCount;
    }

    int minimumParams(Class<? extends ZPEInternalFunction> c) {
        try {
            return HelperFunctions.stringToInteger(c.getDeclaredMethod("MinimumParameters", new Class[0]).invoke(null, new Object[0]).toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public ZPEType runFunction(String id, IAST paramAST, ZPERuntimeEnvironment runtime) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        Class<? extends ZPEInternalFunction> b = YASSPredefinedFunctions.getInternalMethod(id);
        ZPEType[] parameters = runtime.generateArguments(paramAST);
        if (b != null && YASSPredefinedFunctions.getMode(b) == 1) {
            if (this.minimumParams(b) > parameters.length) {
                throw new ArgumentException(id, "" + parameters.length);
            }
            if (YASSPredefinedFunctions.requiredPermissionLevels(b) > runtime.getPermissionLevel()) {
                throw new PermissionLevelException(id, YASSPredefinedFunctions.requiredPermissionLevels(b), runtime.getPermissionLevel());
            }
            return YASSPredefinedFunctions.mainMethod(b, parameters, runtime);
        }
        if (YASSPredefinedFunctions.hasUserDefinedAlias(id)) {
            Class<? extends ZPEInternalFunction> f = ZPEInstance.BUILT_IN_COMMANDS.getInternalMethodFromUserDefinedAliase(id);
            if (this.minimumParams(f) > parameters.length) {
                throw new ArgumentException(id, "" + this.minimumParams(f));
            }
            if (YASSPredefinedFunctions.requiredPermissionLevels(f) > runtime.getPermissionLevel()) {
                throw new PermissionLevelException(id, YASSPredefinedFunctions.requiredPermissionLevels(f), runtime.getPermissionLevel());
            }
            return YASSPredefinedFunctions.mainMethod(f, parameters, runtime);
        }
        if (ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.containsKey(id)) {
            ZPECustomFunction x = ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.get(id);
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            if (parameters.length > x.getParameterNames().length) {
                ZPECore.printWarning("Too many parameters for this function.");
            }
            int pos = 0;
            for (ZPEType p : parameters) {
                parameterMap.put(x.getParameterNames()[pos], p);
                ++pos;
            }
            return x.MainMethod(parameterMap, runtime, runtime.getCurrentFunction());
        }
        if (YASSPredefinedFunctions.hasInternalAlias(id)) {
            Class<? extends ZPEInternalFunction> f = ZPEInstance.BUILT_IN_COMMANDS.getInternalMethodFromAlias(id);
            if (this.minimumParams(f) > parameters.length) {
                throw new ArgumentException(id, "" + this.minimumParams(f));
            }
            if (YASSPredefinedFunctions.requiredPermissionLevels(f) > runtime.getPermissionLevel()) {
                throw new PermissionLevelException(id, YASSPredefinedFunctions.requiredPermissionLevels(f), runtime.getPermissionLevel());
            }
            return YASSPredefinedFunctions.mainMethod(f, parameters, runtime);
        }
        if (b != null) {
            if (this.minimumParams(b) > parameters.length) {
                throw new ArgumentException(id, "" + this.minimumParams(b));
            }
            if (YASSPredefinedFunctions.requiredPermissionLevels(b) > runtime.getPermissionLevel()) {
                throw new PermissionLevelException(id, YASSPredefinedFunctions.requiredPermissionLevels(b), runtime.getPermissionLevel());
            }
            return YASSPredefinedFunctions.mainMethod(b, parameters, runtime);
        }
        return ZPECore.UNDEFINED_PATH;
    }

    private String dash_to_camel_case(String id) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            if (id.charAt(i) == '_' && !HelperFunctions.isNumeric(Character.valueOf(id.charAt(i)))) {
                output.append(("" + id.charAt(++i)).toUpperCase());
                continue;
            }
            output.append(id.charAt(i));
        }
        return output.toString();
    }

    private void addBuiltInCommand(String id) {
        if (!Arrays.asList(ZPEInstance.DISABLED_COMMANDS).contains(id)) {
            String camel;
            if (ZPEInstance.USE_CAMEL_CASE && !(camel = this.dash_to_camel_case(id)).equals(id)) {
                this.addInternalAlias(camel, id);
            }
            Commands.add(id);
            ++this.CommandCount;
        }
    }

    void addInternalAlias(String id, String o) {
        if (!Arrays.asList(ZPEInstance.DISABLED_COMMANDS).contains(id) && !Arrays.asList(ZPEInstance.DISABLED_COMMANDS).contains(o)) {
            if (ZPEInstance.USE_CAMEL_CASE) {
                id = this.dash_to_camel_case(id);
            }
            internalAliases.put(id, o);
            Aliases.add(id);
        }
    }

    void addUserDefinedAlias(String id, String o) {
        if (ZPEInstance.USE_CAMEL_CASE) {
            id = this.dash_to_camel_case(id);
            o = this.dash_to_camel_case(o);
        }
        if (!Arrays.asList(ZPEInstance.DISABLED_COMMANDS).contains(id) && !Arrays.asList(ZPEInstance.DISABLED_COMMANDS).contains(o)) {
            userDefinedAliases.put(id, o);
            Aliases.add(id);
        }
    }

    Class<? extends ZPEInternalFunction> getInternalMethodFromUserDefinedAliase(String id) {
        String q = userDefinedAliases.get(id);
        return YASSPredefinedFunctions.getInternalMethod(q);
    }

    Class<? extends ZPEInternalFunction> getInternalMethodFromAlias(String id) {
        String q = internalAliases.get(id);
        return YASSPredefinedFunctions.getInternalMethod(q);
    }

    private static class get_wikipedia_references
    implements ZPEInternalFunction {
        private get_wikipedia_references() {
        }

        public static String ManualHeader() {
            return "";
        }

        public static String ManualEntry() {
            return "";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String p = parameters[0].toString();
            try {
                p = URLEncoder.encode(p, "UTF-8");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            String path = "https://en.wikipedia.org/w/api.php?format=json&action=query&prop=extracts&exintro=&explaintext=&titles=" + p;
            String json = "";
            try {
                Scanner scanner = new Scanner(new URL(path).openStream(), StandardCharsets.UTF_8.toString());
                scanner.useDelimiter("\\A");
                json = scanner.hasNext() ? scanner.next() : "";
                scanner.close();
            }
            catch (Exception e) {
                throw new ZPERuntimeException("URL not found in get_wikipedia_references");
            }
            ZenithJSONParser parser = new ZenithJSONParser();
            ZPEMap z = null;
            try {
                z = (ZPEMap)parser.jsonDecode(json, false);
            }
            catch (MalformedJSONException e) {
                ZPECore.log(e.getMessage());
                ZPECore.printError(e.getMessage());
            }
            return z;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Specialised";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class xml_decode_Command
    implements ZPEInternalFunction {
        private xml_decode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String xml = parameters[0].toString();
            ZenithXMLParser parser = new ZenithXMLParser();
            try {
                return (ZPEMap)parser.ParseXMLString(xml);
            }
            catch (MalformedXMLException e) {
                return null;
            }
        }

        public static String ManualHeader() {
            return "xml_decode ({string} data)";
        }

        public static String ManualEntry() {
            return "Reads some XML content and translates it to a map.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class toml_decode_Command
    implements ZPEInternalFunction {
        private toml_decode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            ZenithTOMLParser p = new ZenithTOMLParser();
            try {
                return p.parseTOMLToMap(s);
            }
            catch (MalformedTOMLException e) {
                ZPECore.log(e.getMessage());
                ZPECore.printError(e.getMessage());
                return null;
            }
        }

        public static String ManualHeader() {
            return "toml_decode ({string} data)";
        }

        public static String ManualEntry() {
            return "Parses a string in the TOML format to a map. The resulting map may contain additional maps inside it representing groups of values. For more information see https://en.wikipedia.org/wiki/TOML.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class json_encode_Command
    implements ZPEInternalFunction {
        private json_encode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEType json = parameters[0];
            ZenithJSONParser parser = new ZenithJSONParser();
            String out = parser.jsonEncode(json);
            return new ZPEString(out);
        }

        public static String ManualHeader() {
            return "json_encode ({mixed} data)";
        }

        public static String ManualEntry() {
            return "Translates a map or list into a JSON string.";
        }

        public static int RequiredPermissionLevel() {
            return 3;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class json_decode_Command
    implements ZPEInternalFunction {
        private json_decode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String json = parameters[0].toString();
            boolean useObjects = false;
            if (parameters.length > 1) {
                useObjects = ZPEHelperFunctions.ToBoolean(parameters[1].toString());
            }
            try {
                return ZPEKit.jsonDecode(json, useObjects);
            }
            catch (MalformedJSONException e) {
                return null;
            }
        }

        public static String ManualHeader() {
            return "json_decode ({string} data[, boolean use_objects])";
        }

        public static String ManualEntry() {
            return "Reads some JSON content and translates it to a map or list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class jbml_decode_Command
    implements ZPEInternalFunction {
        private jbml_decode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            ZenithJBMLParser p = new ZenithJBMLParser();
            try {
                return p.parseJBMLToMap(s);
            }
            catch (MalformedJBMLException e) {
                ZPECore.log(e.getMessage());
                ZPECore.printError(e.getMessage());
                return null;
            }
        }

        public static String ManualHeader() {
            return "jbml_decode ({string} data)";
        }

        public static String ManualEntry() {
            return "Parses a string in the JBML format to a map. The resulting map may contain additional maps inside it representing groups of values. For more information see https://github.com/jamiebalfour04/JBML-Formal-Specification/.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class ini_decode_Command
    implements ZPEInternalFunction {
        private ini_decode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            ZenithINIParser p = new ZenithINIParser();
            try {
                return p.parseINIToMap(s);
            }
            catch (MalformedINIException e) {
                ZPECore.log(e.getMessage());
                ZPECore.printError(e.getMessage());
                return null;
            }
        }

        public static String ManualHeader() {
            return "ini_decode ({string} data)";
        }

        public static String ManualEntry() {
            return "Parses a string in the INI format to a map. The resulting map may contain additional maps inside it representing groups of values. For more information see https://en.wikipedia.org/wiki/INI_file.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class csv_encode_Command
    implements ZPEInternalFunction {
        private csv_encode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEType list = parameters[0];
            String out = "";
            ZenithCSVParser parser = new ZenithCSVParser();
            if (list instanceof ZPEList) {
                out = parser.ZPEList_To_CSV((ZPEList)list);
            }
            return new ZPEString(out);
        }

        public static String ManualHeader() {
            return "csv_encode ({mixed} data)";
        }

        public static String ManualEntry() {
            return "Translates a map or list object into a JSON string.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class csv_decode_Command
    implements ZPEInternalFunction {
        private csv_decode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            ZPEFunction f = null;
            if (parameters.length == 2) {
                if (!ZPEHelperFunctions.isFunction(parameters[1])) {
                    throw new IncorrectDataTypeException("function", "csv_decode", "2");
                }
                f = (ZPEFunction)parameters[1];
                if (f.parameterNames.isEmpty()) {
                    ZPECore.print("Too few parameters for this function.");
                }
            }
            ZenithCSVParser csvparser = new ZenithCSVParser();
            ZPEList out = (ZPEList)csvparser.CSV_String_To_ZPEList(s);
            if (f != null) {
                int rowindex = 0;
                ZPEList output = new ZPEList();
                for (ZPEType rw : out.items()) {
                    if (rw instanceof ZPEList) {
                        ZPEList row = (ZPEList)rw;
                        int columnindex = 0;
                        ZPEList row_out = new ZPEList();
                        Iterator<ZPEType> iterator2 = row.items().iterator();
                        while (iterator2.hasNext()) {
                            String varId;
                            ZPEType column;
                            ZPEType data = column = iterator2.next();
                            String id = f.parameterNames.get(0);
                            f.addParameter(id, (byte)118);
                            f.setParameter(id, data);
                            if (f.parameterNames.size() >= 2) {
                                varId = f.parameterNames.get(1);
                                f.addParameter(varId, (byte)118);
                                f.setParameter(varId, new ZPENumber(rowindex));
                            }
                            if (f.parameterNames.size() >= 3) {
                                varId = f.parameterNames.get(2);
                                f.addParameter(varId, (byte)118);
                                f.setParameter(varId, new ZPENumber(columnindex));
                            }
                            column = new ZPEString(f.run().toString());
                            row_out.add(column);
                            ++columnindex;
                        }
                        rw = row_out;
                    }
                    output.add(rw);
                    ++rowindex;
                }
                out = output;
            }
            return out;
        }

        public static String ManualHeader() {
            return "csv_decode ({string} data[, {fn} f])";
        }

        public static String ManualEntry() {
            return "Reads a string which consists of comma separated values and splits them on new lines and commas into a list of lists of values. The optional __f__ parameter specifies some function that receives the value of each column to the function and obtains it's return value. This makes it easy to work on CSV files. The function must have at least one parameter.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Data";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_create_ordered_Command
    implements ZPEInternalFunction {
        private map_create_ordered_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            ZPEOrderedAssociativeArray o1 = new ZPEOrderedAssociativeArray();
            for (ZPEType p : parameters) {
                ZPEList l;
                if (p instanceof ZPEList) {
                    l = (ZPEList)p;
                    if (l.size() < 2) {
                        throw new IncorrectDataTypeException("list", "map_create_ordered", "1 and 2");
                    }
                } else {
                    throw new IncorrectDataTypeException("list", "map_create_ordered", "1 and 2");
                }
                o1.put(l.get(0), l.get(1));
            }
            return o1;
        }

        public static String ManualHeader() {
            return "map_create_ordered ({map} a)";
        }

        public static String ManualEntry() {
            return "Returns a new ordered map.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_flip_Command
    implements ZPEInternalFunction {
        private map_flip_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isMap(parameters[0])) {
                throw new IncorrectDataTypeException("map", "map_flip", "1");
            }
            ZPEMap o1 = (ZPEMap)parameters[0];
            o1.flip();
            return o1;
        }

        public static String ManualHeader() {
            return "map_flip ({map} a)";
        }

        public static String ManualEntry() {
            return "Flips the map, __a__, turning keys into values and values into keys.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_get_keys_Command
    implements ZPEInternalFunction {
        private map_get_keys_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isMap(parameters[0])) {
                throw new IncorrectDataTypeException("map", "map_get_keys", "1");
            }
            ZPEMap o1 = (ZPEMap)parameters[0];
            ZPEList out = new ZPEList();
            out.addAll(o1.keySet());
            return out;
        }

        public static String ManualHeader() {
            return "map_get_keys ({map} a)";
        }

        public static String ManualEntry() {
            return "Returns a set of all keys contained in the map, __a__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_contains_Command
    implements ZPEInternalFunction {
        private map_contains_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isMap(parameters[0])) {
                throw new IncorrectDataTypeException("map", "map_contains", "1");
            }
            ZPEMap o1 = (ZPEMap)parameters[0];
            return new ZPEBoolean(o1.containsKey(parameters[1]));
        }

        public static String ManualHeader() {
            return "map_contains ({map} a, {mixed} k)";
        }

        public static String ManualEntry() {
            return "Returns a boolean true or false if the map, __a__, contains the key, __k__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_put_Command
    implements ZPEInternalFunction {
        private map_put_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isMap(parameters[0])) {
                throw new IncorrectDataTypeException("map", "map_put", "1");
            }
            ZPEMap in = (ZPEMap)parameters[0];
            in.put(parameters[1], parameters[2]);
            return in;
        }

        public static String ManualHeader() {
            return "map_put ({map} a, {mixed} k, {mixed} v)";
        }

        public static String ManualEntry() {
            return "Adds a value, __v__, to the map, a with the key, __k__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_remove_Command
    implements ZPEInternalFunction {
        private map_remove_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isMap(parameters[0])) {
                throw new IncorrectDataTypeException("map", "map_remove", "1");
            }
            ZPEMap o1 = (ZPEMap)parameters[0];
            ZPEType key = parameters[1];
            o1.remove((Object)key);
            return o1;
        }

        public static String ManualHeader() {
            return "map_remove ({map} a, {mixed} k)";
        }

        public static String ManualEntry() {
            return "If the map, __a__, contains the key, __k__, it will remove the key to value pair.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class map_get_Command
    implements ZPEInternalFunction {
        private map_get_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isMap(parameters[0])) {
                throw new IncorrectDataTypeException("map", "map_get", "1");
            }
            ZPEMap o1 = (ZPEMap)parameters[0];
            ZPEType key = parameters[1];
            return o1.get((Object)key);
        }

        public static String ManualHeader() {
            return "map_get ({map} a, {mixed} k)";
        }

        public static String ManualEntry() {
            return "If the map, __a__, contains the key, __k__, it will return the value associated to that key.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_to_map_Command
    implements ZPEInternalFunction {
        private list_to_map_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_to_map", "1");
            }
            if (!ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("list", "list_to_map", "2");
            }
            ZPEList keys2 = (ZPEList)parameters[0];
            ZPEList values2 = (ZPEList)parameters[1];
            if (keys2.size() != values2.size()) {
                ZPECore.printWarning("Key length and value length are not equal.");
            }
            ZPEMap a = new ZPEMap();
            int i = 0;
            for (ZPEType k : keys2) {
                if (i >= values2.size()) break;
                a.put(k, values2.get(i));
                ++i;
            }
            return a;
        }

        public static String ManualHeader() {
            return "list_to_map ({list} keys, {list} values)";
        }

        public static String ManualEntry() {
            return "Converts a list to an map by taking a list of keys and a list of values and matching them.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Maps";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class set_cartesian_product_Command
    implements ZPEInternalFunction {
        private set_cartesian_product_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0]) && !ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("array", "set_cartesian_product", "1 and 2");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            ZPEList o2 = (ZPEList)parameters[1];
            ZPEList output = new ZPEList();
            for (ZPEType ob1 : o1.items()) {
                for (ZPEType ob2 : o2.items()) {
                    ZPEList out = new ZPEList();
                    out.add(ob1);
                    out.add(ob2);
                    output.add(out);
                }
            }
            return output;
        }

        public static String ManualHeader() {
            return "set_cartesian_product ({list} l, {list} m)";
        }

        public static String ManualEntry() {
            return "Generates a new set that is the Cartesian Product of two sets __l__ and __m__. Output will be a list of lists. For example given two lists [1, 2] and [3, 4], the result will be: \n**[[1, 3], [1, 4], [2, 3], [2, 4]]**.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Set";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class set_difference_Command
    implements ZPEInternalFunction {
        private set_difference_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0]) && !ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("array", "set_difference", "1 and 2");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            ZPEList o2 = (ZPEList)parameters[1];
            ZPEList output = new ZPEList();
            for (ZPEType v : o1.items()) {
                if (o2.contains(v)) continue;
                output.add(v);
            }
            return output;
        }

        public static String ManualHeader() {
            return "set_difference ({list} l, {list} m)";
        }

        public static String ManualEntry() {
            return "Generates a new set that is the difference of two sets, __l__ DIFFERENCE __m__";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Set";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class set_union_Command
    implements ZPEInternalFunction {
        private set_union_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0]) && !ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("array", "set_union", "1 and 2");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            ZPEList o2 = (ZPEList)parameters[1];
            ZPEList output = new ZPEList();
            for (ZPEType ob : o1.items()) {
                if (output.contains(ob)) continue;
                output.add(ob);
            }
            for (ZPEType ob : o2.items()) {
                if (output.contains(ob)) continue;
                output.add(ob);
            }
            return output;
        }

        public static String ManualHeader() {
            return "set_union ({list} l, {list} m)";
        }

        public static String ManualEntry() {
            return "Generates a new set that is the union of two sets, __l__ UNION __m__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Set";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class set_intersection_Command
    implements ZPEInternalFunction {
        private set_intersection_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0]) && !ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("array", "set_intersection", "1 and 2");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            ZPEList o2 = (ZPEList)parameters[1];
            ZPEList output = new ZPEList();
            for (ZPEType ob : o1.items()) {
                if (!o2.contains(ob) || output.contains(ob)) continue;
                output.add(ob);
            }
            return output;
        }

        public static String ManualHeader() {
            return "set_intersection ({list} l, {list} m)";
        }

        public static String ManualEntry() {
            return "Generates a new set that is the intersection of two sets, __l__ INTERSECTS __m__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Set";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class set_from_list_Command
    implements ZPEInternalFunction {
        private set_from_list_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "set_from_list", "1");
            }
            ZPEList output = new ZPEList();
            ZPEList o = (ZPEList)parameters[0];
            for (ZPEType ob : o.items()) {
                if (output.contains(ob)) continue;
                output.add(ob);
            }
            return output;
        }

        public static String ManualHeader() {
            return "set_from_list ({list} l)";
        }

        public static String ManualEntry() {
            return "Converts a list, __l__, to a set without duplication.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Set";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_compose_Command
    implements ZPEInternalFunction {
        private list_compose_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (!(parameters[1] instanceof ZPEFunction)) {
                throw new IncorrectDataTypeException("array", "list_compose", "1");
            }
            int n = HelperFunctions.stringToInteger(parameters[0].toString());
            ZPEFunction func = (ZPEFunction)parameters[1];
            ZPEList output = new ZPEList();
            ZPEType previous = null;
            for (int i = 0; i < n; ++i) {
                String id;
                if (!func.parameterNames.isEmpty()) {
                    id = func.parameterNames.get(0);
                    func.addParameter(id, (byte)118);
                    func.setParameter(id, new ZPENumber(i));
                }
                if (func.parameterNames.size() >= 2) {
                    id = func.parameterNames.get(1);
                    func.addParameter(id, (byte)118);
                    func.setParameter(id, previous);
                }
                previous = func.run();
                output.add(previous);
            }
            return output;
        }

        public static String ManualHeader() {
            return "list_compose ({integer} count, {fn} composer)";
        }

        public static String ManualEntry() {
            return "Produces a list containing a specified number of values created from the composer function.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_combine_Command
    implements ZPEInternalFunction {
        private list_combine_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_combine", "1");
            }
            ZPEList l = (ZPEList)parameters[0];
            String separator = "";
            if (parameters.length > 1) {
                separator = parameters[1].toString();
            }
            Object output = "";
            for (ZPEType o : l) {
                output = (String)output + o.toString() + separator;
            }
            return new ZPEString((String)output);
        }

        public static String ManualHeader() {
            return "list_combine ({list} l[, {string} separator])";
        }

        public static String ManualEntry() {
            return "Appends all elements into one string for output.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_process_Command
    implements ZPEInternalFunction {
        private list_process_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_process", "1");
            }
            if (!(parameters[1] instanceof ZPEFunction)) {
                throw new IncorrectDataTypeException("function", "list_process", "2");
            }
            ZPEList l = (ZPEList)parameters[0];
            ZPEFunction f = (ZPEFunction)parameters[1];
            String var_id = f.parameterNames.get(0);
            int pos = 0;
            for (ZPEType o : l) {
                f.addParameter(var_id, (byte)118);
                f.setParameter(var_id, o);
                o = f.run();
                l.set(pos, o);
                ++pos;
            }
            return l;
        }

        public static String ManualHeader() {
            return "list_process ({list} l, {fn} process)";
        }

        public static String ManualEntry() {
            return "Runs through a list or array and processes each element with a specified function as the processor.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_auto_populate_Command
    implements ZPEInternalFunction {
        private list_auto_populate_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ExitHalt, ZPERuntimeException, BreakPointHalt {
            ZPEList l;
            if (!(parameters[1] instanceof ZPEFunction)) {
                throw new IncorrectDataTypeException("list", "list_auto_populate", "2");
            }
            if (parameters.length > 2) {
                if (!(parameters[2] instanceof ZPEList)) {
                    throw new IncorrectDataTypeException("list", "list_auto_populate", "3");
                }
                l = (ZPEList)parameters[2];
            } else {
                l = new ZPEList();
            }
            long count = HelperFunctions.stringToLong(parameters[0].toString());
            ZPEFunction f = (ZPEFunction)parameters[1];
            for (long i = 0L; i < count; ++i) {
                l.add(f.run());
            }
            return l;
        }

        public static String ManualHeader() {
            return "list_auto_populate ({integer} count, {fn} process[, {list} l])";
        }

        public static String ManualEntry() {
            return "Returns a list with count autofilled items and generated by a function, process. A list, __l__, can be specified to append to.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_populate_Command
    implements ZPEInternalFunction {
        private list_populate_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList l = new ZPEList();
            int times = HelperFunctions.stringToInteger(parameters[0].toString());
            String message = parameters[1].toString();
            if (parameters.length == 3 && parameters[2].toString().equals("true")) {
                l = new ZPEArray(new ZPEString(""), times);
            }
            while (times > 0) {
                ZPECore.print(message);
                l.add(new ZPEString(ZPECore.readLine()));
                --times;
            }
            return l;
        }

        public static String ManualHeader() {
            return "list_populate ({integer} entries, {string} message[, {boolean} is_array])";
        }

        public static String ManualEntry() {
            return "Loops the number of times specified in the entries parameter asking a message for input. The input given is then put into a list and the list returned. The __is_array__ parameter determines whether to use a ZPEList or a fixed size ZPEArray to populate.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_is_a_set_Command
    implements ZPEInternalFunction {
        private list_is_a_set_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_is_a_set", "1");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            for (int i = 0; i < o1.size(); ++i) {
                String s = o1.get(i).toString();
                for (int j = i + 1; j < o1.size(); ++j) {
                    String t = o1.get(j).toString();
                    if (!s.equals(t)) continue;
                    return new ZPEBoolean(false);
                }
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "list_is_a_set ({list} l)";
        }

        public static String ManualEntry() {
            return "Returns true if a list, __l__, is a set, that is, a list without duplication.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_slice_Command
    implements ZPEInternalFunction {
        private list_slice_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_slice", "1");
            }
            ZPEList in = (ZPEList)parameters[0];
            int start = HelperFunctions.stringToInteger(parameters[1].toString());
            int length = in.size() - start;
            if (parameters.length > 2) {
                length = HelperFunctions.stringToInteger(parameters[2].toString());
            }
            ZPEList output = new ZPEList();
            for (int i = start; i < start + length; ++i) {
                output.add(in.get(i));
            }
            return output;
        }

        public static String ManualHeader() {
            return "list_slice ({list} l, {integer} offset[, {integer} length])";
        }

        public static String ManualEntry() {
            return "Extracts a portion of the list from __offset__ up to the specified __length__ and returns it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_join_Command
    implements ZPEInternalFunction {
        private list_join_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0]) || !ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("list", "list_join", "1 and 2");
            }
            ZPEList in1 = (ZPEList)parameters[0];
            ZPEList in2 = (ZPEList)parameters[1];
            ZPEList o1 = new ZPEList();
            o1.addAll(in1);
            ZPEList o2 = new ZPEList();
            o1.addAll(in2);
            ZPEList output = new ZPEList();
            for (ZPEType o : o1.items()) {
                output.add(o);
            }
            for (ZPEType o : o2.items()) {
                output.add(o);
            }
            return output;
        }

        public static String ManualHeader() {
            return "list_join ({list} l1, {list} l2)";
        }

        public static String ManualEntry() {
            return "Joins two lists, __l1__ and __l2__, and returns the joint lists.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_swap_elements_Command
    implements ZPEInternalFunction {
        private list_swap_elements_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            int ele1 = HelperFunctions.stringToInteger(parameters[1].toString());
            int ele2 = HelperFunctions.stringToInteger(parameters[2].toString());
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_swap_elements", "1");
            }
            ZPEList in = (ZPEList)parameters[0];
            ZPEType temp = in.get(ele1);
            in.set(ele1, in.get(ele2));
            in.set(ele2, temp);
            return in;
        }

        public static String ManualHeader() {
            return "list_swap_elements ({list} l, {integer} p1, {integer} p2)";
        }

        public static String ManualEntry() {
            return "Swaps two elements within the list, __l__, at positions __p1__ and __p2__ within the list. Note: This function does not copy the list, __l__, but simply swaps the elements in the original list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_sort_Command
    implements ZPEInternalFunction {
        private list_sort_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            boolean sortNumeric;
            boolean bl = sortNumeric = parameters.length > 1 && parameters[1].toString().equals("true");
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_sort", "1");
            }
            ZPEList in = (ZPEList)parameters[0];
            ZPEList o1 = new ZPEList();
            o1.addAll(in);
            Object[] ob = o1.toArray();
            int pos = 0;
            if (sortNumeric) {
                double[] j = new double[ob.length];
                for (Object o : ob) {
                    double t = HelperFunctions.stringToDouble(o.toString());
                    j[pos++] = t;
                }
                Arrays.sort(j);
                pos = 0;
                double[] dArray = j;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Object o;
                    o = dArray[i];
                    String v = o.toString();
                    o1.set(pos++, (ZPEType)new ZPEString(HelperFunctions.removeExcessDecimalPoints(v)));
                }
            } else {
                Arrays.sort(ob);
                for (Object o : ob) {
                    o1.set(pos++, (ZPEType)o);
                }
            }
            return o1;
        }

        public static String ManualHeader() {
            return "list_sort ({list} l[, {boolean} numeric])";
        }

        public static String ManualEntry() {
            return "Sorts a list, __l__ by order. If the optional parameter, __numeric__, is set to true, the system treats the list as a list of numbers and sorts them on this assumption. Strings are ordered by their ASCII prime number, that is, each character is transformed to a number, and given a prime number power that is equivalent to it's position in the string. It is then multiplied by the next giving a unique number. Then it is transformed to a string again. Note: This function copies the list, __l__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_reverse_Command
    implements ZPEInternalFunction {
        private list_reverse_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_reverse", "1");
            }
            ZPEList ob = (ZPEList)parameters[0];
            ZPEList out = new ZPEList();
            for (int pos = 0; pos < ob.size(); ++pos) {
                out.add(ob.get(ob.size() - pos - 1));
            }
            return out;
        }

        public static String ManualHeader() {
            return "list_reverse ({list} l)";
        }

        public static String ManualEntry() {
            return "Copies the list, __l__, returns the reversed list of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_set_at_index_Command
    implements ZPEInternalFunction {
        private list_set_at_index_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            ZPEType v = parameters[0];
            if (!ZPEHelperFunctions.isList(v)) {
                throw new IncorrectDataTypeException("list", "list_set_at_index", "1");
            }
            ZPEList in = (ZPEList)v;
            int pos = HelperFunctions.stringToInteger(parameters[1].toString());
            if (ZPEInstance.INDEX_SAFETY && pos > in.size() - 1) {
                pos = in.size() - 1;
            }
            in.set(pos, parameters[2]);
            return in;
        }

        public static String ManualHeader() {
            return "list_set_at_index ({list} l, {integer} p, {mixed} v)";
        }

        public static String ManualEntry() {
            return "Updates an existing element at the index of the array with a new value, v, to the list, l, at an index, p.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_insert_at_index_Command
    implements ZPEInternalFunction {
        private list_insert_at_index_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            ZPEType v = parameters[0];
            if (!ZPEHelperFunctions.isList(v)) {
                throw new IncorrectDataTypeException("array", "list_insert_at_index", "1");
            }
            ZPEList in = (ZPEList)v;
            int pos = HelperFunctions.stringToInteger(parameters[1].toString());
            in.add(pos, parameters[2]);
            return in;
        }

        public static String ManualHeader() {
            return "list_insert_at_index ({list} l, {integer} pos, {mixed} element)";
        }

        public static String ManualEntry() {
            return "Adds an element, __element__, to the list, __l__, at a position, __pos__. Note: This function does not copy the list, __l__, but simply adds to it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_find_duplicates_Command
    implements ZPEInternalFunction {
        private list_find_duplicates_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!(parameters[0] instanceof ZPEList)) {
                throw new IncorrectDataTypeException("list", "list_find_duplicates", "1");
            }
            ZPEList l = (ZPEList)parameters[0];
            ZPEMap arr = new ZPEMap();
            ZPEMap output = new ZPEMap();
            for (ZPEType o : l) {
                if (arr.containsKey(o)) {
                    output.put(o, null);
                    continue;
                }
                arr.put(o, null);
            }
            ZPEList outlist = new ZPEList();
            for (ZPEType o : output.keySet()) {
                outlist.add(o);
            }
            return outlist;
        }

        public static String ManualHeader() {
            return "list_find_duplicates ({list} l)";
        }

        public static String ManualEntry() {
            return "Finds all duplicates in a list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_count_if_Command
    implements ZPEInternalFunction {
        private list_count_if_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (!(parameters[0] instanceof ZPEList)) {
                throw new IncorrectDataTypeException("list", "list_count_if", "1");
            }
            ZPEList l = (ZPEList)parameters[0];
            ZPEFunction comp = (ZPEFunction)parameters[1];
            int counter = 0;
            for (ZPEType o : l) {
                String id = comp.parameterNames.get(0);
                comp.addParameter(id, (byte)118);
                comp.setParameter(id, o);
                if (!ZPEHelperFunctions.ToBoolean(comp.run())) continue;
                ++counter;
            }
            return new ZPENumber(counter);
        }

        public static String ManualHeader() {
            return "list_count_if ({list} l, {fn} comparator_fn)";
        }

        public static String ManualEntry() {
            return "Sequentially visits each item in the list and compares it with a comparator function. If the function returns true, then the counter is increased.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_count_occurrences_Command
    implements ZPEInternalFunction {
        private list_count_occurrences_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!(parameters[0] instanceof ZPEList)) {
                throw new IncorrectDataTypeException("list", "list_count_occurrences", "1");
            }
            ZPEList l = (ZPEList)parameters[0];
            ZPEType comp = parameters[1];
            int counter = 0;
            for (ZPEType o : l) {
                if (!o.equals(comp)) continue;
                ++counter;
            }
            return new ZPENumber(counter);
        }

        public static String ManualHeader() {
            return "list_count_occurrences ({list} l, {mixed} value)";
        }

        public static String ManualEntry() {
            return "Counts the number of times an item appears within a list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_get_index_of_Command
    implements ZPEInternalFunction {
        private list_get_index_of_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_get_index_of", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            return new ZPENumber(o.indexOf(parameters[1]));
        }

        public static String ManualHeader() {
            return "list_get_index_of ({list} l, {mixed} element)";
        }

        public static String ManualEntry() {
            return "From the list, __l__, obtains the index of an element, __element__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_contains_all_Command
    implements ZPEInternalFunction {
        private list_contains_all_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_contains_all", "1");
            }
            if (!ZPEHelperFunctions.isList(parameters[1])) {
                throw new IncorrectDataTypeException("list", "list_contains_all", "2");
            }
            ZPEList list1 = (ZPEList)parameters[0];
            ZPEList list2 = (ZPEList)parameters[1];
            return new ZPEBoolean(list1.containsAll(list2.items()));
        }

        public static String ManualHeader() {
            return "list_contains_all ({list} l1, {list} l2)";
        }

        public static String ManualEntry() {
            return "Checks whether a list, __l1__, contains all items from another list, __l2__. This function accepts duplicates as being contained.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_contains_Command
    implements ZPEInternalFunction {
        private list_contains_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_contains", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            if (o.contains(parameters[1].toString())) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "list_contains ({list} l, {mixed} element)";
        }

        public static String ManualEntry() {
            return "Checks whether a list, __l__, contains an element, __element__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_get_length_Command
    implements ZPEInternalFunction {
        private list_get_length_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_get_length", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            return new ZPENumber(o.size());
        }

        public static String ManualHeader() {
            return "list_get_length ({list} l)";
        }

        public static String ManualEntry() {
            return "Gets the length of a list, __l__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_dequeue_Command
    implements ZPEInternalFunction {
        private list_dequeue_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_dequeue", "1");
            }
            int i = 0;
            ZPEList o = (ZPEList)parameters[0];
            if (i >= o.size()) {
                return null;
            }
            ZPEType value = o.get(i);
            o.remove(i);
            return value;
        }

        public static String ManualHeader() {
            return "list_dequeue ({list} l)";
        }

        public static String ManualEntry() {
            return "Gets and removes the first element from the list and returns the value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_pop_Command
    implements ZPEInternalFunction {
        private list_pop_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "list_pop", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            int i = o.size() - 1;
            ZPEType value = null;
            if (i > -1) {
                value = o.get(i);
            }
            if (o.isEmpty()) {
                return null;
            }
            o.remove(i);
            return value;
        }

        public static String ManualHeader() {
            return "list_pop ({list} l)";
        }

        public static String ManualEntry() {
            return "Gets and removes the last element from the list and returns the value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class list_compress_Command
    implements ZPEInternalFunction {
        private list_compress_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_compress", "1");
            }
            int size = HelperFunctions.stringToInteger(parameters[1].toString());
            ZPEList o = (ZPEList)parameters[0];
            int tot = o.size() - size;
            for (int i = 0; i < tot; ++i) {
                o.remove(o.size() - 1);
            }
            return o;
        }

        public static String ManualHeader() {
            return "list_compress ({list} l, {integer} size)";
        }

        public static String ManualEntry() {
            return "Compresses a list to a specified size.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_shuffle_Command
    implements ZPEInternalFunction {
        private list_shuffle_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_shuffle", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            o.shuffle();
            return o;
        }

        public static String ManualHeader() {
            return "list_shuffle ({list} l)";
        }

        public static String ManualEntry() {
            return "Shuffles a list randomly.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_get_at_random_index_Command
    implements ZPEInternalFunction {
        private list_get_at_random_index_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_get_at_random_index", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            int maximum = o.size() - 1;
            int minimum = 0;
            int i = ZPERandomizer.generate(minimum, maximum);
            if (!o.isEmpty()) {
                return o.get(i);
            }
            return o;
        }

        public static String ManualHeader() {
            return "list_get_at_random_index ({list} l)";
        }

        public static String ManualEntry() {
            return "Gets an element from a list, __l__, at a random index.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_get_at_index_Command
    implements ZPEInternalFunction {
        private list_get_at_index_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_get_at_index", "1");
            }
            ZPEList o = (ZPEList)parameters[0];
            int i = HelperFunctions.stringToInteger(parameters[1].toString());
            if (i < o.size() && i > -1) {
                return o.get(i);
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public static String ManualHeader() {
            return "list_get_at_index ({list} l, {integer} position)";
        }

        public static String ManualEntry() {
            return "Gets an element from a list, __l__, at a specified index, __position__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_remove_all_Command
    implements ZPEInternalFunction {
        private list_remove_all_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_remove_all", "1");
            }
            if (parameters[0] instanceof ZPEArray) {
                ZPEArray in = (ZPEArray)parameters[0];
                while (in.contains(parameters[1])) {
                    int pos = in.lastIndexOf(parameters[1]);
                    in.set(pos, null);
                }
                return in;
            }
            ZPEList in = (ZPEList)parameters[0];
            while (in.contains(parameters[1])) {
                in.remove(parameters[1]);
            }
            return in;
        }

        public static String ManualHeader() {
            return "list_remove_element ({list} l, {integer} position)";
        }

        public static String ManualEntry() {
            return "Removes an element from a list, l, at a specified index position. Note: This function does not copy the list, l, but simply remove from it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_remove_element_Command
    implements ZPEInternalFunction {
        private list_remove_element_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("array", "list_remove_element", "1");
            }
            if (parameters[0] instanceof ZPEArray) {
                ZPEArray in = (ZPEArray)parameters[0];
                int pos = HelperFunctions.stringToInteger(parameters[1].toString());
                in.set(pos, null);
                return in;
            }
            ZPEList in = (ZPEList)parameters[0];
            int pos = HelperFunctions.stringToInteger(parameters[1].toString());
            in.remove(pos);
            return in;
        }

        public static String ManualHeader() {
            return "list_remove_element ({list} l, {integer} position)";
        }

        public static String ManualEntry() {
            return "Removes an element from a list, __l__, at a specified index, __position__. Note: This function does not copy the list, __l__, but simply removes an element from it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_add_element_Command
    implements ZPEInternalFunction {
        private list_add_element_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!ZPEHelperFunctions.isList(parameters[0]) || parameters[0] instanceof ZPEArray) {
                throw new IncorrectDataTypeException("array", "list_add_element", "1");
            }
            ZPEList in = (ZPEList)parameters[0];
            ZPEType v = parameters[1];
            in.add(v);
            return in;
        }

        public static String ManualHeader() {
            return "list_add_element ({list} l, {mixed} o)";
        }

        public static String ManualEntry() {
            return "Adds an element to a list, __l__. Note: This function does not copy the list, __l__, but simply adds to it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_to_array_Command
    implements ZPEInternalFunction {
        private list_to_array_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!(parameters[0] instanceof ZPEList)) {
                throw new IncorrectDataTypeException("list", "list_to_array", "1");
            }
            return ((ZPEArray)parameters[0]).toZPEArray();
        }

        public static String ManualHeader() {
            return "list_to_array ({list} l)";
        }

        public static String ManualEntry() {
            return "Converts a ZPE list to a ZPE array.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_get_data_type_Command
    implements ZPEInternalFunction {
        private list_get_data_type_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (parameters[0] instanceof ZPEArray) {
                YASSByteCodes y = new YASSByteCodes();
                return new ZPEString(y.symbolToString(((ZPEArray)parameters[0]).getDataType()).toUpperCase());
            }
            if (parameters[0] instanceof ZPEList) {
                YASSByteCodes y = new YASSByteCodes();
                return new ZPEString(y.symbolToString(((ZPEList)parameters[0]).getDataType()).toUpperCase());
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "list_get_data_type ({list} l)";
        }

        public static String ManualEntry() {
            return "Get the internal data type of an array. Note that this will not work with lists since data types can vary per element.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class array_to_list_Command
    implements ZPEInternalFunction {
        private array_to_list_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (!(parameters[0] instanceof ZPEArray)) {
                throw new IncorrectDataTypeException("array", "array_to_list", "1");
            }
            return ((ZPEArray)parameters[0]).toList();
        }

        public static String ManualHeader() {
            return "array_to_list ({list} l)";
        }

        public static String ManualEntry() {
            return "Converts a ZPE array to a ZPE list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "List";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class create_temporary_file_Command
    implements ZPEInternalFunction {
        private create_temporary_file_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            try {
                return new ZPEString(File.createTempFile("zpe_tmp", ".dat").getAbsolutePath());
            }
            catch (IOException e) {
                return new ZPEBoolean(false);
            }
        }

        public static String ManualHeader() {
            return "create_temporary_file ()";
        }

        public static String ManualEntry() {
            return "Attempts to create a temporary file which can be easily removed.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_delete_Command
    implements ZPEInternalFunction {
        private file_delete_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String src = parameters[0].toString();
            File f = new File(src);
            if (!f.exists()) {
                return new ZPEBoolean(false);
            }
            f.delete();
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "file_delete ({string} source)";
        }

        public static String ManualEntry() {
            return "Deletes a file, __source__, then returns a boolean based on whether the file was deleted successfully or not.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_copy_Command
    implements ZPEInternalFunction {
        private file_copy_Command() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String src = parameters[0].toString();
            String dst = parameters[1].toString();
            try (FileInputStream in = new FileInputStream(src);
                 FileOutputStream out = new FileOutputStream(dst);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "file_copy ({string} source, {string} destination)";
        }

        public static String ManualEntry() {
            return "Copies a file, __source__, to another location on the file system, __destination__. Returns a boolean based on whether the file was copied successfully or not.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_put_contents_Command
    implements ZPEInternalFunction {
        private file_put_contents_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            int pos = 1;
            boolean append = false;
            if (parameters.length >= 3 && parameters[parameters.length - 1].toString().equals("true")) {
                pos = 2;
                append = true;
            }
            String[] out = new String[parameters.length - pos];
            int p = 0;
            for (ZPEType o : parameters) {
                if (p >= pos) {
                    out[p - pos] = o.toString();
                }
                ++p;
            }
            try {
                FileHelperFunctions.writeFile(parameters[0].toString(), out, append);
                return new ZPEBoolean(true);
            }
            catch (Exception e) {
                ZPECore.printWarning("File " + parameters[0].toString() + " could not be written properly.");
                return new ZPEBoolean(false);
            }
        }

        public static String ManualHeader() {
            return "file_put_contents ({string} file[, {boolean} append], {string} contents1[, {string} contents2, {string} contents3, ..., {string} contentsN])";
        }

        public static String ManualEntry() {
            return "Writes an infinite amount of parameters to a text file. You can append text on the end by inserting the boolean __append__ before writing the file. Note, if you do choose to do this and wish to write a boolean true or false value to the file, the preferred option is that you should use file_write(\"filename.txt\", \"\", true) as the second parameter will not be recognised as append boolean.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_get_contents_Command
    implements ZPEInternalFunction {
        private file_get_contents_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = "";
            String type = "utf-8";
            String fileName = parameters[0].toString();
            try {
                s = FileHelperFunctions.readFileAsString(fileName, type);
                boolean escape = false;
                if (parameters.length > 1 && parameters[1].toString().equalsIgnoreCase("true")) {
                    escape = true;
                }
                if (escape) {
                    s = s.replace("\"", "\\\"");
                    s = s.replace("'", "'");
                }
                return new ZPEString(s);
            }
            catch (Exception e) {
                return new ZPEString("");
            }
        }

        public static String ManualHeader() {
            return "file_get_contents ({string} file[, {boolean} escape_string])";
        }

        public static String ManualEntry() {
            return "Reads all text within a file and returns it as a string.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class file_put_bytes_Command
    implements ZPEInternalFunction {
        private file_put_bytes_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            String fileName = parameters[0].toString();
            if (parameters[1] instanceof ByteListObject) {
                try {
                    ByteListObject bl = (ByteListObject)parameters[1];
                    boolean append = false;
                    if (parameters.length == 3) {
                        append = ZPEHelperFunctions.ToBoolean(parameters[2]);
                    }
                    FileOutputStream stream = new FileOutputStream(fileName, append);
                    try {
                        stream.write(bl.get());
                        stream.close();
                    }
                    catch (Exception e) {
                        stream.close();
                        return new ZPEBoolean(false);
                    }
                    return new ZPEBoolean(true);
                }
                catch (Exception e) {
                    return new ZPEBoolean(false);
                }
            }
            throw new IncorrectDataTypeException("ZPEByteList", "file_put_bytes", "1");
        }

        public static String ManualHeader() {
            return "file_put_bytes ({string} file, {object} byte_list[, {boolean} append])";
        }

        public static String ManualEntry() {
            return "Writes all bytes to a file.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_get_bytes_Command
    implements ZPEInternalFunction {
        private file_get_bytes_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String fileName = parameters[0].toString();
            try {
                ByteListObject bl = new ByteListObject(parent, parent.getCurrentFunction());
                byte[] res = FileHelperFunctions.readFile(fileName);
                bl.set(res);
                return bl;
            }
            catch (Exception e) {
                return new ZPENumber(0);
            }
        }

        public static String ManualHeader() {
            return "file_get_bytes ({string} file)";
        }

        public static String ManualEntry() {
            return "Reads all bytes within a file and returns it as a ZPEByteList object.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_open_Command
    implements ZPEInternalFunction {
        private file_open_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            String fileName = parameters[0].toString();
            SequentialFileObject o = new SequentialFileObject(parent, parent.getCurrentFunction());
            try {
                o.open(fileName);
            }
            catch (FileNotFoundException e) {
                return new ZPEBoolean(false);
            }
            return o;
        }

        public static String ManualHeader() {
            return "file_open ({string} file)";
        }

        public static String ManualEntry() {
            return "Opens a file for sequential reading. May return false if the file is unreadable or non-existent.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_get_parent_path_Command
    implements ZPEInternalFunction {
        private file_get_parent_path_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            String p = f.getAbsoluteFile().toString();
            Object s = new File(p).getParentFile().getAbsoluteFile().toString();
            if (!((String)s).endsWith(System.getProperty("file.separator"))) {
                s = (String)s + System.getProperty("file.separator");
            }
            return new ZPEString((String)s);
        }

        public static String ManualHeader() {
            return "file_get_parent_path ({string} file)";
        }

        public static String ManualEntry() {
            return "Returns the full path of the parent path of a file or directory.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_get_path_Command
    implements ZPEInternalFunction {
        private file_get_path_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            Object p = f.getAbsoluteFile().toString();
            if (f.exists() && f.isDirectory()) {
                if (!((String)p).endsWith(FileSystems.getDefault().getSeparator())) {
                    p = (String)p + FileSystems.getDefault().getSeparator();
                }
                return new ZPEString((String)p);
            }
            return new ZPEString((String)p);
        }

        public static String ManualHeader() {
            return "file_get_path ({string} file)";
        }

        public static String ManualEntry() {
            return "Returns the full cannonical path of a file or directory.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_get_name_Command
    implements ZPEInternalFunction {
        private file_get_name_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists()) {
                return new ZPEString(f.getName());
            }
            return new ZPEString("-1");
        }

        public static String ManualHeader() {
            return "file_get_name ({string} file)";
        }

        public static String ManualEntry() {
            return "Returns the name of a file. This return the actual name of the file, minus directories, so it is essentially the last part of the path. E.g. \n**file_get_name(\"/User/Documents/f.txt\")**\n would return f.txt";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_get_size_Command
    implements ZPEInternalFunction {
        private file_get_size_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists() && !f.isDirectory()) {
                return new ZPENumber(f.length());
            }
            return new ZPENumber(-1);
        }

        public static String ManualHeader() {
            return "file_get_size ({string} file)";
        }

        public static String ManualEntry() {
            return "Returns the size of a file, in bytes. If the file is not found it returns -1.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_touch_Command
    implements ZPEInternalFunction {
        private file_touch_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists() && !f.isDirectory()) {
                if (parameters.length > 1) {
                    long t = HelperFunctions.stringToLong(parameters[1].toString());
                    return new ZPEBoolean(f.setLastModified(t));
                }
                return new ZPEBoolean(f.setLastModified(new Date().getTime()));
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "file_touch ({string} file, [{integer} time])";
        }

        public static String ManualEntry() {
            return "'Touches' a file, setting its modification time to the current time. Optionally takes a __time__ parameter to set it to.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_exists_Command
    implements ZPEInternalFunction {
        private file_exists_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists() && !f.isDirectory()) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "file_exists ({string} file)";
        }

        public static String ManualEntry() {
            return "Determines if a file exists within the local file system.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class is_file_Command
    implements ZPEInternalFunction {
        private is_file_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists()) {
                return new ZPEString(("" + !f.isDirectory()).toLowerCase());
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "is_file ({string} file)";
        }

        public static String ManualEntry() {
            return "Determines if the object at the end of the path, __file__, is a file. If the file does not exist it returns 0.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class directory_create_Command
    implements ZPEInternalFunction {
        private directory_create_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File dir = new File(parameters[0].toString());
            if (dir.mkdir()) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "directory_create ({string} directory_path)";
        }

        public static String ManualEntry() {
            return "Creates an empty directory at the location specified and returns the boolean true on success.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class directory_list_files_Command
    implements ZPEInternalFunction {
        private directory_list_files_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList fileList = new ZPEList();
            String s = parameters[0].toString();
            File f = new File(s);
            if (s.isEmpty()) {
                f = new File(f.getAbsoluteFile().toString());
            }
            String toFind = "";
            if (parameters.length == 2) {
                toFind = parameters[1].toString();
            }
            if (f.exists() && f.isDirectory()) {
                for (File fi : Objects.requireNonNull(f.listFiles())) {
                    if (!fi.toString().endsWith(toFind)) continue;
                    fileList.add(new ZPEString(fi.getAbsolutePath()));
                }
                return fileList;
            }
            return fileList;
        }

        public static String ManualHeader() {
            return "directory_list_files ({string} path)";
        }

        public static String ManualEntry() {
            return "Returns a list of files that exist in a specified path.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class directory_exists_Command
    implements ZPEInternalFunction {
        private directory_exists_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists() && f.isDirectory()) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "directory_exists ({string} file)";
        }

        public static String ManualEntry() {
            return "Determines if a directory exists within the local file system.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class is_directory_Command
    implements ZPEInternalFunction {
        private is_directory_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            File f = new File(parameters[0].toString());
            if (f.exists()) {
                return new ZPEString(("" + f.isDirectory()).toLowerCase());
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "is_directory ({string} file)";
        }

        public static String ManualEntry() {
            return "Determines if the object at the end of the path is a directory. If the directory does not exist it returns 0.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_drives_Command
    implements ZPEInternalFunction {
        private list_drives_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            File[] paths;
            if (parameters == null) {
                return null;
            }
            ZPEList out = new ZPEList();
            for (File path : paths = File.listRoots()) {
                out.add(new ZPEString(path.toString()));
            }
            return out;
        }

        public static String ManualHeader() {
            return "list_drives ()";
        }

        public static String ManualEntry() {
            return "Lists all drives or root directories on this system.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class replace_symlink_Command
    implements ZPEInternalFunction {
        private replace_symlink_Command() {
        }

        public static String ManualHeader() {
            return "replace_symlink ({string} link, {string} search, {string} replacement[, {boolean} absolute]})";
        }

        public static String ManualEntry() {
            return "Replaces a part of a symlink path, __link__, and searches for __search__, replacing it with a replacement, __replacement__. If __absolute__ is set to true, the new link is set with an absolute path.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            String p1 = parameters[0].toString();
            String find = parameters[1].toString();
            String replace = parameters[2].toString();
            boolean absolute = false;
            if (parameters.length == 4) {
                absolute = ZPEHelperFunctions.ToBoolean(parameters[3]);
            }
            File file = new File(p1);
            file.getAbsolutePath();
            if (!Files.isSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]))) {
                throw new ZPERuntimeException("File " + p1 + " not symbolic link");
            }
            try {
                Path p = Files.readSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]));
                String actualPath = p.toString();
                if (absolute) {
                    actualPath = p.toAbsolutePath().toString();
                }
                actualPath = actualPath.replace(find, replace);
                File file2 = new File(file.getAbsolutePath() + "_old");
                file.renameTo(file2);
                Files.createSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(actualPath, new String[0]), new FileAttribute[0]);
                return new ZPEBoolean(true);
            }
            catch (IOException e) {
                return new ZPEBoolean(false);
            }
        }

        public static int RequiredPermissionLevel() {
            return 5;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class create_symlink_Command
    implements ZPEInternalFunction {
        private create_symlink_Command() {
        }

        public static String ManualHeader() {
            return "create_symlink ({string} link, {string} target)";
        }

        public static String ManualEntry() {
            return "Attempts to create a symlink at the path, __link__, to the path, __target__.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            String p1 = parameters[0].toString();
            String p2 = parameters[1].toString();
            File file = new File(p1);
            File file2 = new File(p2);
            if (file.exists()) {
                ZPECore.printWarning("File " + p1 + " already exists");
                return new ZPEBoolean(false);
            }
            try {
                Files.createSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(file2.getAbsolutePath(), new String[0]), new FileAttribute[0]);
                return new ZPEBoolean(true);
            }
            catch (IOException e) {
                return new ZPEBoolean(false);
            }
        }

        public static int RequiredPermissionLevel() {
            return 5;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class is_symlink_Command
    implements ZPEInternalFunction {
        private is_symlink_Command() {
        }

        public static String ManualHeader() {
            return "is_symlink ({string} file)";
        }

        public static String ManualEntry() {
            return "Determines if a file or directory is a symbolic link or not.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String p1 = parameters[0].toString();
            File file = new File(p1);
            if (!file.exists()) {
                ZPECore.printWarning("File " + p1 + " not found");
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(Files.isSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0])));
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "File";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class speak_Command
    implements ZPEInternalFunction {
        private speak_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IOException {
            if (parameters == null) {
                return null;
            }
            if (HelperFunctions.isMac()) {
                String voice = "Daniel";
                int rate = -1;
                String cmd = "say '" + parameters[0].toString() + "'";
                if (parameters.length > 1) {
                    rate = HelperFunctions.stringToInteger(parameters[1].toString());
                    cmd = cmd + " -r " + rate;
                }
                if (parameters.length > 2) {
                    voice = parameters[2].toString();
                    cmd = cmd + " -v " + voice;
                }
                HelperFunctions.shellExec(cmd);
                return new ZPEBoolean(true);
            }
            if (HelperFunctions.isWindows()) {
                String cmd = "PowerShell -Command \"Add-Type \u2013AssemblyName System.Speech; (New-Object System.Speech.Synthesis.SpeechSynthesizer).Speak('" + parameters[0].toString() + "');";
                HelperFunctions.shellExec(cmd);
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "speak ({string} contents[, {integer} rate[, {string} voice]])";
        }

        public static String ManualEntry() {
            return "Attempts to speak the text, __contents__ given to it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class format_string_Command
    implements ZPEInternalFunction {
        private format_string_Command() {
        }

        public static String ManualHeader() {
            return "format_string({mixed} message, {integer} format)";
        }

        public static String ManualEntry() {
            return "Formats a string, __message__, using the standard output of the current console. If the FORCE_COLOUR setting is set to false this function will simply return the original string.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            int format = 0;
            String toPrint = parameters[0].toString();
            format = HelperFunctions.stringToInteger(parameters[1].toString());
            if (!Objects.equals(toPrint, "")) {
                if (format == 1) {
                    toPrint = ZPEHelperFunctions.setConsoleEffectToGreen(toPrint);
                } else if (format == 2) {
                    toPrint = ZPEHelperFunctions.setConsoleEffectToBlue(toPrint);
                } else if (format == 3) {
                    toPrint = ZPEHelperFunctions.setConsoleEffectToRed(toPrint);
                } else if (format == 4) {
                    toPrint = ZPEHelperFunctions.setConsoleEffectToCyan(toPrint);
                } else if (format == 5) {
                    toPrint = ZPEHelperFunctions.setConsoleEffectToMagenta(toPrint);
                } else if (format == 6) {
                    toPrint = ZPEHelperFunctions.setConsoleEffectToYellow(toPrint);
                } else if (format == 7) {
                    toPrint = ZPEHelperFunctions.createRainbow(toPrint, false);
                } else if (format == 8) {
                    toPrint = ZPEHelperFunctions.createRainbow(toPrint, true);
                }
            }
            return new ZPEString(toPrint);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class generate_alphabet_Command
    implements ZPEInternalFunction {
        private generate_alphabet_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList listA = new ZPEList();
            int first = 65;
            int last = 90;
            int start = first;
            int end = last;
            if (parameters.length > 0) {
                start = parameters[0].toString().toUpperCase().charAt(0);
            }
            if (parameters.length > 1) {
                end = parameters[1].toString().toUpperCase().charAt(0);
            }
            for (int i = start; i < end + 1 && i < start + 26; ++i) {
                listA.add(new ZPEString((char)i));
            }
            if (parameters.length > 0) {
                start = parameters[0].toString().toLowerCase().charAt(0);
            } else {
                start = 97;
                end = 122;
            }
            if (parameters.length > 1) {
                end = parameters[1].toString().toLowerCase().charAt(0);
            }
            ZPEList listB = new ZPEList();
            for (int i = start; i < end + 1 && i < start + 26; ++i) {
                listB.add(new ZPEString((char)i));
            }
            ZPEList out = new ZPEList();
            out.add(listA);
            out.add(listB);
            return out;
        }

        public static String ManualHeader() {
            return "generate_alphabet ([{string} start][, {string} end])";
        }

        public static String ManualEntry() {
            return "Generates a list of lists containing an alphabet from A-Z and then a second list of a-z.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class generate_random_string_Command
    implements ZPEInternalFunction {
        private generate_random_string_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPEString(ZPEHelperFunctions.generateRandomWord(HelperFunctions.stringToInteger(parameters[0].toString())));
        }

        public static String ManualHeader() {
            return "generate_random_string ({integer} length)";
        }

        public static String ManualEntry() {
            return "Generates a random string of a certain length.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class beautify_Command
    implements ZPEInternalFunction {
        private beautify_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            return new ZPEString(ZPEHelperFunctions.beautify(parameters[0], 0));
        }

        public static String ManualHeader() {
            return "beautify ({mixed} value)";
        }

        public static String ManualEntry() {
            return "Returns a beautified version of a value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class input_validate_Command
    implements ZPEInternalFunction {
        private input_validate_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            ZPEString item = new ZPEString(ZPECore.readLine(""));
            ZPEFunction f = (ZPEFunction)parameters[0];
            long max_times = 0L;
            if (parameters.length == 3) {
                max_times = HelperFunctions.stringToLong(parameters[2].toString());
            }
            String id = f.parameterNames.get(0);
            f.addParameter(id, (byte)118);
            f.setParameter(id, item);
            String fail_msg = parameters[1].toString();
            boolean result = ZPEHelperFunctions.ToBoolean(f.run());
            while (!result) {
                ZPECore.print(fail_msg);
                item = new ZPEString(ZPECore.readLine(""));
                f.addParameter(id, (byte)118);
                f.setParameter(id, item);
                result = ZPEHelperFunctions.ToBoolean(f.run());
                if (--max_times != 0L) continue;
                return new ExitHalt(1);
            }
            return new ZPEString(item);
        }

        public static String ManualHeader() {
            return "input_validate ({fn} f, {string} failure_message, [{integer} max_times])";
        }

        public static String ManualEntry() {
            return "Runs a standard input validation algorithm that will wait for the user to enter a valid response. Using a lambda function or a function call, this method can use a custom validation tool. If the __max_times__ parameter is set, the validation will run a maximum of that number of times before stopping and throwing an invalid input error.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_compare_Command
    implements ZPEInternalFunction {
        private string_compare_Command() {
        }

        private static int compareStrings(String word1, String word2, boolean insensitive) {
            String w1 = word1;
            String w2 = word2;
            if (insensitive) {
                w1 = w1.toLowerCase();
                w2 = w2.toLowerCase();
            }
            boolean flipped = false;
            if (word1.length() < word2.length()) {
                w1 = word2;
                w2 = word1;
                flipped = true;
            }
            for (int i = 0; i < w1.length(); ++i) {
                if (i >= w2.length()) {
                    if (flipped) {
                        return -1;
                    }
                    return 1;
                }
                if (w1.charAt(i) < w2.charAt(i)) {
                    if (flipped) {
                        return 1;
                    }
                    return -1;
                }
                if (w2.charAt(i) >= w1.charAt(i)) continue;
                if (flipped) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String text1 = parameters[0].toString();
            String text2 = parameters[1].toString();
            boolean caseInsensitive = false;
            if (parameters.length > 2) {
                caseInsensitive = ZPEHelperFunctions.ToBoolean(parameters[2]);
            }
            return new ZPENumber(string_compare_Command.compareStrings(text1, text2, caseInsensitive));
        }

        public static String ManualHeader() {
            return "string_compare ({string} text1, {string} text2, {boolean} insensitively)";
        }

        public static String ManualEntry() {
            return "Compares two strings alphabetically. Returns -1 if the first word comes before the second, returns 0 if both words are exactly equal, returns 1 if the second word comes before the first.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_text_compare_Command
    implements ZPEInternalFunction {
        private string_text_compare_Command() {
        }

        private static String process(String text) {
            char ch = text.charAt(0);
            StringBuilder output = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                ch = text.charAt(i);
                if (ch == ' ' || ("" + ch).equals(System.lineSeparator())) continue;
                output.append(ch);
            }
            return output.toString();
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String text1 = parameters[0].toString();
            String text2 = parameters[1].toString();
            text1 = string_text_compare_Command.process(text1);
            text2 = string_text_compare_Command.process(text2);
            return new ZPEBoolean(text1.equalsIgnoreCase(text2));
        }

        public static String ManualHeader() {
            return "string_text_compare ({string} text1, {string} text2)";
        }

        public static String ManualEntry() {
            return "Compares two pieces of text for character equality without spaces and case insensitively. It works by parsing the strings character by character and removing whitespace and lower casing the whole string.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_is_uppercase_Command
    implements ZPEInternalFunction {
        private string_is_uppercase_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            for (char c : s.toCharArray()) {
                String q = "" + c;
                if (q.toUpperCase().equals(q)) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "string_is_uppercase ({string} text)";
        }

        public static String ManualEntry() {
            return "Returns true if the string or character specified is an uppercase string or character.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_is_lowercase_Command
    implements ZPEInternalFunction {
        private string_is_lowercase_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            for (char c : s.toCharArray()) {
                String q = "" + c;
                if (q.toLowerCase().equals(q)) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "string_is_lowercase ({string} text)";
        }

        public static String ManualEntry() {
            return "Returns true if the string or character specified is a lowercase string or character.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_is_numeric_Command
    implements ZPEInternalFunction {
        private string_is_numeric_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (HelperFunctions.isNumeric(parameters[0].toString())) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "string_is_numeric ({string} text)";
        }

        public static String ManualEntry() {
            return "Determines if a string, __text__, is of the number format.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_to_date_Command
    implements ZPEInternalFunction {
        private string_to_date_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String f = parameters[1].toString();
            DateObject d = new DateObject(parent, parent.getCurrentFunction());
            try {
                d.setDate(HelperFunctions.stringToDate(s, f));
            }
            catch (Exception e) {
                throw new ZPERuntimeException(e.getMessage());
            }
            return d;
        }

        public static String ManualHeader() {
            return "string_to_date ({string} date, {string} format)";
        }

        public static String ManualEntry() {
            return "Transforms a string, __date__, which is the of the format, __format__, to a date. E.g. string_to_date(\"25-10-2015 14:00:24\", \"dd-MM-yyyy hh:mm:ss\")";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 125;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_matches_Command
    implements ZPEInternalFunction {
        private string_matches_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String f = parameters[1].toString();
            return new ZPEBoolean(s.matches(f));
        }

        public static String ManualHeader() {
            return "string_matches ({string} text, {string} regex_pattern)";
        }

        public static String ManualEntry() {
            return "Returns a boolean true or false value as to whether a string, __text__, matches the regular language pattern, __regex_pattern__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_trim_end_Command
    implements ZPEInternalFunction {
        private string_trim_end_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String find = parameters.length == 1 ? " " : parameters[1].toString();
            if (find.isEmpty() || s.isEmpty()) {
                throw new ZPERuntimeException("LENGTH 0");
            }
            int backpos = s.length() - 1;
            int temppos = find.length() - 1;
            char c = s.charAt(backpos);
            char ch = find.charAt(temppos);
            while (ch == c && backpos > 0) {
                --backpos;
                if (--temppos <= 0) {
                    temppos = find.length() - 1;
                }
                ch = find.charAt(temppos);
                c = s.charAt(backpos);
            }
            return new ZPEString(s.substring(0, backpos));
        }

        public static String ManualHeader() {
            return "string_trim ({string} text[, {string} search])";
        }

        public static String ManualEntry() {
            return "Trims a string, __text__, at the end, removing all instances of a character. If no __search__ parameter is given, the function simply takes the space character and trims the string of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_trim_start_Command
    implements ZPEInternalFunction {
        private string_trim_start_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String find = parameters.length == 1 ? " " : parameters[1].toString();
            if (find.isEmpty() || s.isEmpty()) {
                throw new ZPERuntimeException("LENGTH 0");
            }
            int frontpos = 0;
            int temppos = 0;
            char c = s.charAt(frontpos);
            char ch = find.charAt(temppos);
            while (ch == c) {
                ++frontpos;
                if (++temppos >= find.length()) {
                    temppos = 0;
                }
                ch = find.charAt(temppos);
                c = s.charAt(frontpos);
            }
            return new ZPEString(s.substring(frontpos));
        }

        public static String ManualHeader() {
            return "string_trim_start ({string} text[, {string} search])";
        }

        public static String ManualEntry() {
            return "Trims a string, __text__ at the start, removing all instances of a character. If no __search__ parameter is given, the function simply takes the space character and trims the string of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_trim_Command
    implements ZPEInternalFunction {
        private string_trim_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            if (parameters.length == 1) {
                return new ZPEString(s.trim());
            }
            String find = parameters[1].toString();
            if (find.isEmpty() || s.isEmpty()) {
                throw new ZPERuntimeException("LENGTH 0");
            }
            int frontpos = 0;
            int temppos = 0;
            char c = s.charAt(frontpos);
            char ch = find.charAt(temppos);
            while (ch == c) {
                ++frontpos;
                if (++temppos >= find.length()) {
                    temppos = 0;
                }
                ch = find.charAt(temppos);
                c = s.charAt(frontpos);
            }
            int backpos = s.length() - 1;
            temppos = find.length() - 1;
            c = s.charAt(backpos);
            ch = find.charAt(temppos);
            while (ch == c && backpos > 0) {
                --backpos;
                if (--temppos <= 0) {
                    temppos = find.length() - 1;
                }
                ch = find.charAt(temppos);
                c = s.charAt(backpos);
            }
            return new ZPEString(s.substring(frontpos, backpos));
        }

        public static String ManualHeader() {
            return "string_trim ({string} text[, {string} search])";
        }

        public static String ManualEntry() {
            return "Trims a string, __text__, at the start and the end, removing all instances of a character. If no __search__ parameter is provided, the function simply takes the space character and trims the string of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_cut_Command
    implements ZPEInternalFunction {
        private string_cut_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            int start_cut = HelperFunctions.stringToInteger(parameters[1].toString());
            int end_cut = -1;
            int backpos = 0;
            int frontpos = start_cut;
            if (parameters.length > 2) {
                end_cut = HelperFunctions.stringToInteger(parameters[2].toString());
                backpos = s.length() - end_cut;
            }
            if (start_cut + end_cut > s.length() || frontpos > backpos) {
                throw new ZPERuntimeException("Too many characters have attempted to be cut!");
            }
            return new ZPEString(s.substring(frontpos, backpos));
        }

        public static String ManualHeader() {
            return "string_cut ({string} text, {integer} start_cut[, {integer} end_cut])";
        }

        public static String ManualEntry() {
            return "Cuts a certain number of characters from a string. If only __start_cut__ is provided, it will cut the same number from the start and end.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_ends_with_Command
    implements ZPEInternalFunction {
        private string_ends_with_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String f = parameters[1].toString();
            return new ZPEBoolean(s.endsWith(f));
        }

        public static String ManualHeader() {
            return "string_ends_with ({string} text, {string} search)";
        }

        public static String ManualEntry() {
            return "Returns a boolean true or false value as to whether a string, __text__, ends with the regular expression, __search__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_starts_with_Command
    implements ZPEInternalFunction {
        private string_starts_with_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String f = parameters[1].toString();
            return new ZPEBoolean(s.startsWith(f));
        }

        public static String ManualHeader() {
            return "string_starts_with ({string} text, {string} search)";
        }

        public static String ManualEntry() {
            return "Returns a boolean true or false value as to whether a string, __text__, starts with the regular expression, __search__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_replace_Command
    implements ZPEInternalFunction {
        private string_replace_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String needle = parameters[1].toString();
            String rep = parameters[2].toString();
            return new ZPEString(s.replaceAll(needle, rep));
        }

        public static String ManualHeader() {
            return "string_replace ({string} text, {string} search, {string} replace)";
        }

        public static String ManualEntry() {
            return "Performs a regular expression match for __search__, and replaces it with a string, __replace__, in __text__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_to_uppercase_Command
    implements ZPEInternalFunction {
        private string_to_uppercase_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (parameters[0] == null) {
                return new ZPENumber(0);
            }
            String s = parameters[0].toString();
            return new ZPEString(s.toUpperCase());
        }

        public static String ManualHeader() {
            return "string_to_uppercase ({string} text)";
        }

        public static String ManualEntry() {
            return "Converts a string, __text__, to an uppercase version of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_to_lowercase_Command
    implements ZPEInternalFunction {
        private string_to_lowercase_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            return new ZPEString(s.toLowerCase());
        }

        public static String ManualHeader() {
            return "string_to_lowercase ({string} text)";
        }

        public static String ManualEntry() {
            return "Converts a string, __text__, to a lowercase version of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_get_substring_Command
    implements ZPEInternalFunction {
        private string_get_substring_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            int start = HelperFunctions.stringToInteger(parameters[1].toString());
            int end = HelperFunctions.stringToInteger(parameters[2].toString());
            return new ZPEString(s.substring(start, end));
        }

        public static String ManualHeader() {
            return "string_get_substring ({string} text, {integer} start, {integer} end)";
        }

        public static String ManualEntry() {
            return "Returns a substring that is a portion of the main string, __text__, that begins at the index __start__ and finishes at the index __end__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_find_occurrences_Command
    implements ZPEInternalFunction {
        private string_find_occurrences_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String occ = parameters[1].toString();
            ZPEList out = new ZPEList();
            for (int pos = 0; pos < s.length(); ++pos) {
                char c = s.charAt(pos);
                if (c != occ.charAt(0)) continue;
                int tpos = pos;
                int inner = 0;
                while (s.charAt(tpos) == occ.charAt(inner)) {
                    ++tpos;
                    if (++inner != occ.length()) continue;
                    out.add(new ZPENumber(pos));
                    break;
                }
                pos = tpos;
            }
            return out;
        }

        public static String ManualHeader() {
            return "string_find_occurrences ({string} haystack, {string} needle)";
        }

        public static String ManualEntry() {
            return "Returns a list of integers which represent the position at which each **needle** appears within the **haystack** string.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_divide_Command
    implements ZPEInternalFunction {
        private string_divide_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            int inc = HelperFunctions.stringToInteger(parameters[1].toString());
            ZPEList out = new ZPEList();
            int old_pos = 0;
            int i = 0;
            while (i + inc < s.length()) {
                if (i + inc <= s.length()) {
                    out.add(new ZPEString(s.substring(old_pos, i + inc)));
                } else {
                    out.add(new ZPEString(s.substring(old_pos)));
                }
                old_pos = i += inc;
            }
            if (i < s.length()) {
                out.add(new ZPEString(s.substring(i)));
            }
            return out;
        }

        public static String ManualHeader() {
            return "string_divide ({string} text, {integer} length)";
        }

        public static String ManualEntry() {
            return "Splits a string, **text**, at after a certain number of characters, **length**, and puts the split strings into a list. The remaining characters will be put into the list also.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_splice_Command
    implements ZPEInternalFunction {
        private string_splice_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IncorrectDataTypeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            if (!(parameters[1] instanceof ZPEList)) {
                throw new IncorrectDataTypeException("list", "string_splice");
            }
            ZPEList l = (ZPEList)parameters[1];
            ZPEList out = new ZPEList();
            int old_pos = 0;
            for (Object o : l.toArray()) {
                int i = HelperFunctions.stringToInteger(o.toString());
                if (i < old_pos) {
                    throw new ArrayIndexOutOfBoundsException("string_splice");
                }
                if (i <= s.length()) {
                    out.add(new ZPEString(s.substring(old_pos, i)));
                } else {
                    out.add(new ZPEString(s.substring(old_pos)));
                }
                old_pos = i;
            }
            return out;
        }

        public static String ManualHeader() {
            return "string_splice ({string} text, {list} split_points)";
        }

        public static String ManualEntry() {
            return "Splits a string, **text**, at certain points specified in a list, **list**. The function then returns a list of strings.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_split_Command
    implements ZPEInternalFunction {
        private string_split_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String splitter = " ";
            if (parameters.length == 2) {
                splitter = parameters[1].toString();
            }
            String[] split = s.split(splitter);
            ZPEList out = new ZPEList();
            for (String sp : split) {
                out.add(new ZPEString(sp));
            }
            return out;
        }

        public static String ManualHeader() {
            return "string_split ({string} text[, {string} delimiter])";
        }

        public static String ManualEntry() {
            return "Splits a string, __text__, using __delimiter__. The default delimiter is the space symbol.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_contains_Command
    implements ZPEInternalFunction {
        private string_contains_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            for (int i = 1; i < parameters.length; ++i) {
                if (parameters[0].toString().contains(parameters[i++].toString())) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "string_contains ({string} text, {string} word1[, {string} word2, {string} word3, ..., {string} wordN])";
        }

        public static String ManualEntry() {
            return "Checks if a string, __text__, contains an infinite number of other strings or characters, listed as __wordN__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_count_occurrences_Command
    implements ZPEInternalFunction {
        private string_count_occurrences_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            int count = 0;
            boolean insensitively = false;
            if (parameters.length > 2) {
                insensitively = ZPEHelperFunctions.ToBoolean(parameters[2]);
            }
            boolean remove = false;
            if (parameters.length > 3) {
                remove = ZPEHelperFunctions.ToBoolean(parameters[3]);
            }
            String txt = parameters[0].toString();
            if (insensitively) {
                txt = txt.toLowerCase();
            }
            if (parameters[1] instanceof ZPEList) {
                ZPEList l = (ZPEList)parameters[1];
                for (ZPEType e : l) {
                    if (!(e instanceof ZPEString)) continue;
                    String x = e.toString();
                    if (insensitively) {
                        x = x.toLowerCase();
                    }
                    count += txt.split(x).length - 1;
                    if (!remove) continue;
                    txt = txt.replace(x, "");
                }
            } else if (parameters[1] instanceof ZPEString) {
                String x = parameters[1].toString();
                if (insensitively) {
                    x = x.toLowerCase();
                }
                return new ZPENumber(txt.split(x).length - 1);
            }
            return new ZPENumber(count);
        }

        public static String ManualHeader() {
            return "string_count_occurrences ({string} text, {list} search, [{boolean} insensitively[, {boolean} ignore_duplicates]])";
        }

        public static String ManualEntry() {
            return "Counts the number of occurrences in the string **text** of each occurrence in **list**. List may also be defined as a single string. If **ignore_duplicates** is true, duplication is ignored. For example, in [is, i] the i would not be recounted in the is.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_get_length_Command
    implements ZPEInternalFunction {
        private string_get_length_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            return new ZPENumber(s.length());
        }

        public static String ManualHeader() {
            return "string_get_length ({string} text)";
        }

        public static String ManualEntry() {
            return "Gets the length of any fixed length string, **text**.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_get_character_at_Command
    implements ZPEInternalFunction {
        private string_get_character_at_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            int pos = HelperFunctions.stringToInteger(parameters[1].toString());
            if (pos >= s.length()) {
                pos = s.length() - 1;
            }
            return new ZPEString("" + s.charAt(pos));
        }

        public static String ManualHeader() {
            return "string_get_character_at ({string} text, {integer} index)";
        }

        public static String ManualEntry() {
            return "Gets a character from a string, __text__, at the position, __index__, specified.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class string_to_list_Command
    implements ZPEInternalFunction {
        private string_to_list_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            ZPEList output = new ZPEList();
            for (int i = 0; i < s.length(); ++i) {
                output.add(new ZPEString(s.charAt(i)));
            }
            return output;
        }

        public static String ManualHeader() {
            return "string_to_list ({string} str)";
        }

        public static String ManualEntry() {
            return "Converts a string, __str__, into a list, character by character.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class character_to_integer_Command
    implements ZPEInternalFunction {
        private character_to_integer_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            char c = parameters[0].toString().charAt(0);
            return new ZPENumber((int)c);
        }

        public static String ManualHeader() {
            return "character_to_integer ({string} c)";
        }

        public static String ManualEntry() {
            return "Converts a single character, __c__, to an integer.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class integer_to_character_Command
    implements ZPEInternalFunction {
        private integer_to_character_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            long c = HelperFunctions.stringToLong(parameters[0].toString());
            return new ZPEString("" + (char)c);
        }

        public static String ManualHeader() {
            return "integer_to_character ({integer} i)";
        }

        public static String ManualEntry() {
            return "Converts a single integer, __i__, to a character.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "String";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class base64_decode_Command
    implements ZPEInternalFunction {
        private base64_decode_Command() {
        }

        public static String ManualHeader() {
            return "base64_decode ({string} input)";
        }

        public static String ManualEntry() {
            return "Decodes a Base64-encoded string, __input__, back to its original text. Returns an empty string if the input is invalid.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String input = parameters[0].toString();
            return new ZPEString(new String(Base64.getDecoder().decode(input)));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class base64_encode_Command
    implements ZPEInternalFunction {
        private base64_encode_Command() {
        }

        public static String ManualHeader() {
            return "base64_encode ({string} input)";
        }

        public static String ManualEntry() {
            return "Encodes a plain text string, __input__, into Base64 format. Useful for safely transmitting binary or text data over media designed to handle textual data.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String input = parameters[0].toString();
            return new ZPEString(Base64.getEncoder().encodeToString(input.getBytes()));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_decrypt_Command
    implements ZPEInternalFunction {
        private file_decrypt_Command() {
        }

        public static String ManualHeader() {
            return "file_decrypt ({string} filepath, {string} new_path, {string} password)";
        }

        public static String ManualEntry() {
            return "Decrypts a file, __filepath__, that was encrypted using ZPE-based encryption and saves it to __new_path__.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String path = parameters[0].toString();
            String path2 = parameters[1].toString();
            String password = parameters[2].toString();
            password = HelperFunctions.padString(password, 16);
            File f = new File(path);
            if (!f.exists()) {
                throw new ZPERuntimeException("File does not exist.");
            }
            try {
                byte[] content = FileHelperFunctions.readFile(f.getAbsolutePath());
                byte[] decrypted = (byte[])HelperFunctions.readEncryptedObject(content, password);
                FileHelperFunctions.writeByteFile(path2, decrypted);
            }
            catch (Exception e) {
                return new ZPENumber(0);
            }
            return new ZPENumber(1);
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class file_encrypt_Command
    implements ZPEInternalFunction {
        private file_encrypt_Command() {
        }

        public static String ManualHeader() {
            return "file_encrypt ({string} filepath, {string} new_path, {string} password)";
        }

        public static String ManualEntry() {
            return "Encrypts a file, __filepath__ using ZPE-based encryption and saves it at __new_path__. -1 means that the file doesn't exist, 0 means there was a non-specified error and 1 means success.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String path = parameters[0].toString();
            String path2 = parameters[1].toString();
            String password = parameters[2].toString();
            password = HelperFunctions.padString(password, 16);
            File f = new File(path);
            if (!f.exists()) {
                return new ZPENumber(-1);
            }
            try {
                byte[] content = FileHelperFunctions.readFile(f.getAbsolutePath());
                byte[] encrypted = HelperFunctions.writeEncryptedObject((Object)content, password);
                FileHelperFunctions.writeByteFile(path2, encrypted);
            }
            catch (Exception e) {
                return new ZPENumber(0);
            }
            return new ZPENumber(1);
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class password_verify_Command
    implements ZPEInternalFunction {
        private password_verify_Command() {
        }

        public static String ManualHeader() {
            return "password_verify ({string} confirm, {string} password_hash)";
        }

        public static String ManualEntry() {
            return "Returns a true or false value based on whether or not the password provided, __confirm__, matches a hashed password, __pasword_hash_.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String password = parameters[0].toString();
            String password_hash = parameters[1].toString();
            return new ZPEBoolean(BCrypt.checkpw(password, password_hash));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class password_hash_Command
    implements ZPEInternalFunction {
        private password_hash_Command() {
        }

        public static String ManualHeader() {
            return "password_hash ({string} password[, {integer} complexity])";
        }

        public static String ManualEntry() {
            return "Returns a password that can be stored for later use and verification.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            String salt;
            if (parameters == null) {
                return null;
            }
            String password = parameters[0].toString();
            if (parameters.length > 1) {
                int rounds = HelperFunctions.stringToInteger(parameters[1].toString());
                if (rounds < 31) {
                    salt = BCrypt.gensalt(rounds);
                } else {
                    ZPECore.printWarning("BCrypt rounds exceeds the maximum number of rounds (30). Setting to 30.");
                    salt = BCrypt.gensalt(30);
                }
            } else {
                salt = BCrypt.gensalt();
            }
            String s = BCrypt.hashpw(password, salt);
            return new ZPEString(s);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class md5_Command
    implements ZPEInternalFunction {
        private md5_Command() {
        }

        public static String ManualHeader() {
            return "md5 ({string} message)";
        }

        public static String ManualEntry() {
            return "Returns a MD5 version of some message given to the function.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            try {
                return new ZPEString(HelperFunctions.md5(s));
            }
            catch (Exception e) {
                return ZPECore.UNDEFINED;
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class sha256_Command
    implements ZPEInternalFunction {
        private sha256_Command() {
        }

        public static String ManualHeader() {
            return "sha256 ({string} message)";
        }

        public static String ManualEntry() {
            return "Returns a SHA256 version of some message given to the function.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            try {
                return new ZPEString(HelperFunctions.sha256(s));
            }
            catch (Exception e) {
                return ZPECore.UNDEFINED;
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class sha1_Command
    implements ZPEInternalFunction {
        private sha1_Command() {
        }

        public static String ManualHeader() {
            return "sha1 ({string} message)";
        }

        public static String ManualEntry() {
            return "Returns a SHA1 version of some message given to the function.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            try {
                return new ZPEString(HelperFunctions.sha1(s));
            }
            catch (Exception e) {
                return ZPECore.UNDEFINED;
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class aes_decrypt_Command
    implements ZPEInternalFunction {
        private aes_decrypt_Command() {
        }

        public static String ManualHeader() {
            return "aes_decrypt ({string} message, {string} cipher_text)";
        }

        public static String ManualEntry() {
            return "Returns an AES decrypted message.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String cipher = parameters[1].toString();
            int rounds = 0;
            if (parameters.length > 2) {
                rounds = HelperFunctions.stringToInteger(parameters[2].toString());
            }
            if (cipher.length() < 16) {
                cipher = HelperFunctions.padString(cipher, 16);
            }
            if (cipher.length() > 16 && cipher.length() < 32) {
                cipher = HelperFunctions.padString(cipher, 32);
            }
            try {
                if (rounds > 0) {
                    return new ZPEString(HelperFunctions.decrypt(cipher, cipher, s, rounds));
                }
                return new ZPEString(HelperFunctions.decrypt(cipher, cipher, s));
            }
            catch (Exception e) {
                return new ZPEString("");
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class aes_encrypt_Command
    implements ZPEInternalFunction {
        private aes_encrypt_Command() {
        }

        public static String ManualHeader() {
            return "aes_encrypt ({string} message, {string} cipher_text)";
        }

        public static String ManualEntry() {
            return "Returns an AES encrypted message.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            String cipher = parameters[1].toString();
            int rounds = 0;
            if (parameters.length > 2) {
                rounds = HelperFunctions.stringToInteger(parameters[2].toString());
            }
            if (cipher.length() < 16) {
                cipher = HelperFunctions.padString(cipher, 16);
            }
            if (cipher.length() > 16 && cipher.length() < 32) {
                cipher = HelperFunctions.padString(cipher, 32);
            }
            try {
                if (rounds > 0) {
                    return new ZPEString(HelperFunctions.encrypt(cipher, cipher, s, rounds));
                }
                return new ZPEString(HelperFunctions.encrypt(cipher, cipher, s));
            }
            catch (Exception e) {
                return new ZPEString("");
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Encryption and decryption";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class nor_Command
    implements ZPEInternalFunction {
        private nor_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            boolean a = ZPEHelperFunctions.ToBoolean(parameters[0]);
            boolean b = ZPEHelperFunctions.ToBoolean(parameters[1]);
            return new ZPEBoolean(!a || !b);
        }

        public static String ManualHeader() {
            return "nor ({boolean} a, {boolean} b])";
        }

        public static String ManualEntry() {
            return "Returns the result of a NOR on a && b. This will basically invert the result of an OR.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class iif_Command
    implements ZPEInternalFunction {
        private iif_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            boolean result = ZPEHelperFunctions.ToBoolean(parameters[0]);
            if (result) {
                return parameters[1];
            }
            return parameters[2];
        }

        public static String ManualHeader() {
            return "iif ({boolean} expression, {mixed} true_value, {mixed} false_value])";
        }

        public static String ManualEntry() {
            return "Returns the result __true_value__ if the expression is true, or __false_value__ if the expression results in a false value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class implies_Command
    implements ZPEInternalFunction {
        private implies_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            boolean a = ZPEHelperFunctions.ToBoolean(parameters[0]);
            boolean b = ZPEHelperFunctions.ToBoolean(parameters[1]);
            return new ZPEBoolean(!a || b);
        }

        public static String ManualHeader() {
            return "implies ({boolean} a, {boolean} b)";
        }

        public static String ManualEntry() {
            return "Returns the result of logical implication on __a__ -> __b__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class xor_Command
    implements ZPEInternalFunction {
        private xor_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            boolean a = ZPEHelperFunctions.ToBoolean(parameters[0]);
            boolean b = ZPEHelperFunctions.ToBoolean(parameters[1]);
            if (!(a && b || !a && !b)) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "xor ({boolean} a, {boolean} b)";
        }

        public static String ManualEntry() {
            return "Returns the exclusive-or (XOR) on two boolean values. i.e. !($a && $b) && ($a || $b).";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class in_range_Command
    implements ZPEInternalFunction {
        private in_range_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double min = HelperFunctions.stringToDouble(parameters[1].toString());
            double max = HelperFunctions.stringToDouble(parameters[2].toString());
            if (parameters[0] instanceof ZPEList) {
                for (ZPEType o : (ZPEList)parameters[0]) {
                    double d = HelperFunctions.stringToDouble(o.toString());
                    if (!(d < min) && !(d > max)) continue;
                    return new ZPEBoolean(false);
                }
            } else {
                double d = HelperFunctions.stringToDouble(parameters[0].toString());
                if (d < min || d > max) {
                    return new ZPEBoolean(false);
                }
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "in_range ({mixed} value, {real} min, {real} max)";
        }

        public static String ManualEntry() {
            return "Determines whether a value or list of values is within a range of numbers.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class any_false_Command
    implements ZPEInternalFunction {
        private any_false_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            for (int i = 0; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!s.toString().equals("false")) continue;
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "any_false ({boolean} val1[, {boolean} val2, {boolean} val3, ..., {boolean} valN])";
        }

        public static String ManualEntry() {
            return "Assesses a list of parameters to see if any values equate to false. It is the equivalent to building a comparison with many ORs.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class any_true_Command
    implements ZPEInternalFunction {
        private any_true_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            for (int i = 0; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!s.toString().equals("true")) continue;
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "any_true ({boolean} val1[, {boolean} val2, {boolean} val3, ..., {boolean} valN])";
        }

        public static String ManualEntry() {
            return "Assesses a list of parameters to see if any values equate to true. It is the equivalent to building a comparison with many ORs.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class all_false_Command
    implements ZPEInternalFunction {
        private all_false_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            for (int i = 0; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!s.toString().equals("false")) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "all_false ({boolean} val1[, {boolean} val2, {boolean} val3, ..., {boolean} valN])";
        }

        public static String ManualEntry() {
            return "Assesses a list of parameters to see if all values equate to false. It is the equivalent to building a comparison with many ANDs.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class all_true_Command
    implements ZPEInternalFunction {
        private all_true_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            for (int i = 0; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!s.toString().equals("false")) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "all_true ({boolean} val1[, {boolean} val2, {boolean} val3, ..., {boolean} valN])";
        }

        public static String ManualEntry() {
            return "Assesses a list of parameters to see if all values equate to true. It is the equivalent to building a comparison with many ANDs.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class equals_any_Command
    implements ZPEInternalFunction {
        private equals_any_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (HelperFunctions.isNumeric(parameters[0].toString())) {
                double checker = HelperFunctions.stringToDouble(parameters[0].toString());
                for (int i = 1; i < parameters.length; ++i) {
                    ZPEType s = parameters[i];
                    if (!(s instanceof ZPEList) && HelperFunctions.stringToDouble(s.toString()) != checker) continue;
                    return new ZPEBoolean(true);
                }
                return new ZPEBoolean(false);
            }
            String q = parameters[0].toString();
            for (int i = 1; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!q.equals(s.toString())) continue;
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "equals_any ({real} val1[, {real} val2[, {real} val3[, ..., {real} valN]]])";
        }

        public static String ManualEntry() {
            return "Compares the first value as a real to a collection of reals and returns a boolean stating whether first value equals any other value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class less_than_any_Command
    implements ZPEInternalFunction {
        private less_than_any_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double checker = HelperFunctions.stringToDouble(parameters[0].toString());
            for (int i = 1; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!(s instanceof ZPEList) && !(checker > HelperFunctions.stringToDouble(s.toString()))) continue;
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "less_than_any ({real} val1[, {real} val2[, {real} val3[, ..., {real} valN]]])";
        }

        public static String ManualEntry() {
            return "Compares the first value as a real to a collection of reals and returns a boolean stating whether any value is less than the first value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class less_than_all_Command
    implements ZPEInternalFunction {
        private less_than_all_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double checker = HelperFunctions.stringToDouble(parameters[0].toString());
            for (int i = 1; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!(s instanceof ZPEList) && !(HelperFunctions.stringToDouble(s.toString()) <= checker)) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "less_than_all ({real} val1[, {real} val2[, {real} val3[, ..., {real} valN]]])";
        }

        public static String ManualEntry() {
            return "Compares the first value as a real to a collection of reals and returns a boolean stating whether the first value is less than all other values.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class greater_than_any_Command
    implements ZPEInternalFunction {
        private greater_than_any_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double checker = HelperFunctions.stringToDouble(parameters[0].toString());
            for (int i = 1; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!(s instanceof ZPEList) && !(checker > HelperFunctions.stringToDouble(s.toString()))) continue;
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "greater_than_any ({real} val1[, {real} val2[, {real} val3[, ..., {real} valN]]])";
        }

        public static String ManualEntry() {
            return "Compares the first value as a real to a collection of reals and returns a boolean stating whether any value is greater than the first value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class greater_than_all_Command
    implements ZPEInternalFunction {
        private greater_than_all_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double checker = HelperFunctions.stringToDouble(parameters[0].toString());
            for (int i = 1; i < parameters.length; ++i) {
                ZPEType s = parameters[i];
                if (!(s instanceof ZPEList) && !(HelperFunctions.stringToDouble(s.toString()) >= checker)) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "greater_than_all ({real} val1[, {real} val2[, {real} val3[, ..., {real} valN]]])";
        }

        public static String ManualEntry() {
            return "Compares the first value as a real to a collection of reals and returns a boolean stating whether the first value is greater than all other values.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Logical";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_linear_interpolation_Command
    implements ZPEInternalFunction {
        private calculate_linear_interpolation_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double a = HelperFunctions.stringToDouble(parameters[0].toString());
            double b = HelperFunctions.stringToDouble(parameters[1].toString());
            double t = HelperFunctions.stringToDouble(parameters[2].toString());
            if (t < 0.0 || t > 1.0) {
                return new ZPENumber(0);
            }
            return new ZPENumber(a + (b - a) * t);
        }

        public static String ManualHeader() {
            return "calculate_linear_interpolation ({real} a, {real} b, {real} t)";
        }

        public static String ManualEntry() {
            return "Returns a value that is a linear interpolation between two numbers based on a proportion. The __t__ parameter should be between 0 and 1, where 0 returns the start value and 1 returns the end value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class generate_histogram_Command
    implements ZPEInternalFunction {
        private generate_histogram_Command() {
        }

        public static ZPEList histogram(List<Double> values2, int bins, ZPERuntimeEnvironment parent) {
            ZPEList result = new ZPEList();
            if (values2.isEmpty() || bins <= 0) {
                return result;
            }
            double min = Collections.min(values2);
            double max = Collections.max(values2);
            double range = max - min;
            double binSize = range / (double)bins;
            for (int i = 0; i < bins; ++i) {
                double start = min + (double)i * binSize;
                double end = i == bins - 1 ? max : start + binSize;
                ZPEObject bin = new ZPEObject(parent, parent.getCurrentFunction(), "bin");
                bin.anonymous = true;
                bin.pushProperty("low", new ZPENumberVariable("low", new ZPENumber(start), null));
                bin.pushProperty("high", new ZPENumberVariable("high", new ZPENumber(end), null));
                bin.pushProperty("count", new ZPENumberVariable("count", new ZPENumber(0), null));
                result.add(bin);
            }
            for (double val : values2) {
                int index = (int)((val - min) / binSize);
                if (index >= bins) {
                    index = bins - 1;
                }
                ZPEObject bin = (ZPEObject)result.get(index);
                int updatedCount = ((ZPENumber)bin.getProperty("count")).intValue() + 1;
                bin.setProperty("count", new ZPENumber(updatedCount));
            }
            return result;
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "histogram");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            int bins = HelperFunctions.stringToInteger(parameters[1].toString());
            ArrayList<Double> actualList = new ArrayList<Double>();
            for (ZPEType o : o1) {
                actualList.add(HelperFunctions.stringToDouble(o.toString()));
            }
            return generate_histogram_Command.histogram(actualList, bins, parent);
        }

        public static String ManualHeader() {
            return "generate_histogram ({list} values, {integer} bins)";
        }

        public static String ManualEntry() {
            return "Splits a list of numbers into a specified number of equal-width bins and returns a list of objects, each representing a bin. Each object contains the lower bound (low), upper bound (high), and the number of values (count) that fall within that range.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_standard_deviation_Command
    implements ZPEInternalFunction {
        private calculate_standard_deviation_Command() {
        }

        public static double standard_deviation(List<Double> values2) {
            if (values2.isEmpty()) {
                return 0.0;
            }
            double sum = 0.0;
            for (double value : values2) {
                sum += value;
            }
            double mean = sum / (double)values2.size();
            double sumOfSquaredDifferences = 0.0;
            for (double value : values2) {
                double difference = value - mean;
                sumOfSquaredDifferences += difference * difference;
            }
            double variance = sumOfSquaredDifferences / (double)values2.size();
            return Math.sqrt(variance);
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "get_standard_deviation");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            ArrayList<Double> actualList = new ArrayList<Double>();
            for (ZPEType o : o1) {
                actualList.add(HelperFunctions.stringToDouble(o.toString()));
            }
            return new ZPENumber(calculate_standard_deviation_Command.standard_deviation(actualList));
        }

        public static String ManualHeader() {
            return "calculate_standard_deviation ({list} values)";
        }

        public static String ManualEntry() {
            return "Calculates the population standard deviation of the values in the list, __values__, indicating how spread out the numbers are from the mean.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_percentile_Command
    implements ZPEInternalFunction {
        private calculate_percentile_Command() {
        }

        public static double percentile(List<Double> values2, double percentile) {
            Collections.sort(values2);
            if (values2.isEmpty()) {
                return 0.0;
            }
            double index = percentile / 100.0 * (double)(values2.size() - 1);
            int i = (int)index;
            double fraction = index - (double)i;
            if (i + 1 < values2.size()) {
                return values2.get(i) + fraction * (values2.get(i + 1) - values2.get(i));
            }
            return values2.get(i);
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                throw new IncorrectDataTypeException("list", "get_percentile");
            }
            ZPEList o1 = (ZPEList)parameters[0];
            ArrayList<Double> actualList = new ArrayList<Double>();
            for (ZPEType o : o1) {
                actualList.add(HelperFunctions.stringToDouble(o.toString()));
            }
            return new ZPENumber(calculate_percentile_Command.percentile(actualList, HelperFunctions.stringToDouble(parameters[1].toString())));
        }

        public static String ManualHeader() {
            return "calculate_percentile ({list} values, {real} percentile)";
        }

        public static String ManualEntry() {
            return "Returns the p-th percentile value in a numeric list. The list is automatically sorted before calculation. For example, the 90th percentile gives the value below which 90% of the data falls.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_median_Command
    implements ZPEInternalFunction {
        private calculate_median_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                Arrays.sort(parameters);
                return parameters[parameters.length / 2];
            }
            ZPEList o1 = (ZPEList)parameters[0];
            Object[] ob = new ZPEType[o1.size()];
            int pos = 0;
            for (ZPEType o : o1) {
                ob[pos++] = o;
            }
            Arrays.sort(ob);
            return ob[Math.round(o1.size() / 2)];
        }

        public static String ManualHeader() {
            return "calculate_median ({real} number1, {real} number2[, {real} number3, ..., {real} numberN])";
        }

        public static String ManualEntry() {
            return "Determines the median of a specified list of numbers. Parameters can also be condensed to a single list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_mode_Command
    implements ZPEInternalFunction {
        private calculate_mode_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            HashMap<ZPEType, Integer> m = new HashMap<ZPEType, Integer>();
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                for (int i = 0; i < parameters.length; ++i) {
                    ZPEType o = parameters[i];
                    if (m.containsKey(o)) {
                        int j = (Integer)m.get(o);
                        m.put(o, j + 1);
                        continue;
                    }
                    m.put(o, 1);
                }
                int max = (Integer)m.get(parameters[0]);
                ZPEType cur = parameters[0];
                for (int i = 1; i < parameters.length; ++i) {
                    ZPEType o = parameters[i];
                    if ((Integer)m.get(o) <= max) continue;
                    cur = o;
                }
                return cur;
            }
            ZPEList o1 = (ZPEList)parameters[0];
            for (int i = 0; i < o1.size(); ++i) {
                ZPEType o = o1.get(i);
                if (m.containsKey(o)) {
                    int j = (Integer)m.get(o);
                    m.put(o, j + 1);
                    continue;
                }
                m.put(o, 1);
            }
            int max = (Integer)m.get(o1.get(0));
            ZPEType cur = o1.get(0);
            for (int i = 1; i < o1.size(); ++i) {
                ZPEType o = o1.get(i);
                if ((Integer)m.get(o) <= max) continue;
                cur = o;
            }
            return cur;
        }

        public static String ManualHeader() {
            return "calculate_mode ({real} number1, {real} number2[, {real} number3, ..., {real} numberN])";
        }

        public static String ManualEntry() {
            return "Determines the mode of a specified list of numbers. Parameters can also be condensed to a single list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_mean_Command
    implements ZPEInternalFunction {
        private calculate_mean_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double total = 0.0;
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                for (int i = 0; i < parameters.length; ++i) {
                    double curr = HelperFunctions.stringToDouble(parameters[i].toString());
                    total += curr;
                }
                total /= (double)parameters.length;
            } else {
                ZPEList o1 = (ZPEList)parameters[0];
                for (int i = 0; i < o1.size(); ++i) {
                    double curr = Double.parseDouble(o1.get(i).toString());
                    total += curr;
                }
                total /= (double)o1.size();
            }
            return new ZPENumber(total);
        }

        public static String ManualHeader() {
            return "calculate_mean ({real} number1, {real} number2[, {real} number3, ..., {real} numberN])";
        }

        public static String ManualEntry() {
            return "Determines the mean of a specified list of numbers. Parameters can also be condensed to a single list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_range_Command
    implements ZPEInternalFunction {
        private calculate_range_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double max = -1.0;
            double min = -1.0;
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                min = max = HelperFunctions.stringToDouble(parameters[0].toString());
                for (int i = 1; i < parameters.length; ++i) {
                    double curr = HelperFunctions.stringToDouble(parameters[i].toString());
                    if (curr > max) {
                        max = curr;
                    }
                    if (!(curr < min)) continue;
                    min = curr;
                }
                return new ZPENumber(max);
            }
            ZPEList o1 = (ZPEList)parameters[0];
            if (!o1.isEmpty()) {
                min = max = HelperFunctions.stringToDouble(o1.get(0).toString());
            }
            for (int i = 1; i < o1.size(); ++i) {
                double curr = Double.parseDouble(o1.get(i).toString());
                if (curr > max) {
                    max = curr;
                }
                if (!(curr < min)) continue;
                min = curr;
            }
            return new ZPENumber(max - min);
        }

        public static String ManualHeader() {
            return "calculate_range ({real} number1, {real} number2[, {real} number3, ..., {real} numberN])";
        }

        public static String ManualEntry() {
            return "Determines the range of a specified list of numbers. Parameters can also be condensed to a single list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_maximum_Command
    implements ZPEInternalFunction {
        private calculate_maximum_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                ZPENumber max = (ZPENumber)parameters[0];
                for (int i = 1; i < parameters.length; ++i) {
                    ZPENumber curr = (ZPENumber)parameters[i];
                    if (curr.compareTo(max) <= 0) continue;
                    max = new ZPENumber(curr);
                }
                return max;
            }
            ZPENumber max = new ZPENumber(-1);
            ZPEList o1 = (ZPEList)parameters[0];
            if (!o1.isEmpty()) {
                max = new ZPENumber((ZPENumber)o1.get(0));
            }
            for (int i = 1; i < o1.size(); ++i) {
                ZPENumber curr = (ZPENumber)o1.get(i);
                if (curr.compareTo(max) <= 0) continue;
                max = new ZPENumber(curr);
            }
            return max;
        }

        public static String ManualHeader() {
            return "calculate_maximum ({real} number1, {real} number2[, {real} number3, ..., {real} numberN])";
        }

        public static String ManualEntry() {
            return "Determines the maximum of a specified list of numbers. Parameters can also be condensed to a single list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class calculate_minimum_Command
    implements ZPEInternalFunction {
        private calculate_minimum_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!ZPEHelperFunctions.isList(parameters[0])) {
                ZPENumber min = (ZPENumber)parameters[0];
                for (int i = 1; i < parameters.length; ++i) {
                    ZPENumber curr = (ZPENumber)parameters[i];
                    if (curr.compareTo(min) >= 0) continue;
                    min = new ZPENumber(curr.currentValue());
                }
                return min;
            }
            ZPENumber min = new ZPENumber(-1);
            ZPEList o1 = (ZPEList)parameters[0];
            if (!o1.isEmpty()) {
                min = new ZPENumber((ZPENumber)o1.get(0));
            }
            for (int i = 1; i < o1.size(); ++i) {
                ZPENumber curr = (ZPENumber)o1.get(i);
                if (curr.compareTo(min) >= 0) continue;
                min = new ZPENumber(curr);
            }
            return min;
        }

        public static String ManualHeader() {
            return "calculate_minimum ({real} number1, {real} number2[, {real} number3, ..., {real} numberN])";
        }

        public static String ManualEntry() {
            return "Determines the minimum of a specified list of numbers. Parameters can also be condensed to a single list.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class counter_Command
    implements ZPEInternalFunction {
        private counter_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            ZPEList items = (ZPEList)parameters[0];
            ZPEMap dict = new ZPEMap();
            for (ZPEType i : items.items()) {
                int count = 0;
                ZPEType item = i;
                if (parameters.length > 1) {
                    ZPEFunction f = (ZPEFunction)parameters[1];
                    if (f.parameterNames.isEmpty()) {
                        ZPECore.printError("Too many parameters for this function");
                    }
                    String id = f.parameterNames.get(0);
                    f.addParameter(id, (byte)118);
                    f.setParameter(id, item);
                    item = f.run();
                    f.parameterMap.remove(id);
                }
                if (dict.containsKey(item)) {
                    count = (int)HelperFunctions.stringToDouble(dict.get(item).toString());
                }
                dict.remove(item);
                dict.put(new ZPEString(item.toString()), new ZPENumber(++count));
            }
            return dict;
        }

        public static String ManualHeader() {
            return "counter ({list} items[, {fn} f])";
        }

        public static String ManualEntry() {
            return "Generates a map which contains the count of all instances of each value from the __items__ array. If a function, __f__, is supplied to this, each item will be passed to the function first.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class range_Command
    implements ZPEInternalFunction {
        private range_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            long min = 0L;
            long max = 0L;
            boolean inclusive = false;
            if (parameters.length >= 2) {
                if (HelperFunctions.isNumeric(parameters[0].toString())) {
                    min = HelperFunctions.stringToLong(parameters[0].toString());
                }
                if (HelperFunctions.isNumeric(parameters[1].toString())) {
                    max = HelperFunctions.stringToLong(parameters[1].toString());
                }
            } else if (HelperFunctions.isNumeric(parameters[0].toString())) {
                max = HelperFunctions.stringToLong(parameters[0].toString());
            }
            long incrementer = 1L;
            if (parameters.length == 3) {
                if (parameters[2] instanceof ZPENumber) {
                    incrementer = HelperFunctions.stringToLong(parameters[2].toString());
                } else if (parameters[2] instanceof ZPEBoolean) {
                    inclusive = ZPEHelperFunctions.ToBoolean(parameters[2]);
                }
            }
            if (inclusive) {
                ++max;
            }
            ZPEList output = new ZPEList();
            for (long i = min; i < max; i += incrementer) {
                output.add(new ZPENumber(i));
            }
            return output;
        }

        public static String ManualHeader() {
            return "range ({integer} max[, {integer} min[, {mixed} increment]])";
        }

        public static String ManualEntry() {
            return "Generates a list of integers ranging from the minimum to the maximum. The third parameter can be a boolean to indicate whether the range should include the maximum value or an number to indicate the incrementer.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class random_number_Command
    implements ZPEInternalFunction {
        private random_number_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPENumber min = (ZPENumber)parameters[1];
            ZPENumber max = (ZPENumber)parameters[0];
            if (min.compareTo(max) > 0) {
                Number t = max.currentValue();
                max.setValue(min.currentValue());
                min.setValue(t);
            }
            int maximum = (int)Math.floor(max.doubleValue());
            int minimum = (int)Math.ceil(min.doubleValue());
            return new ZPENumber(ZPERandomizer.generate(minimum, maximum));
        }

        public static String ManualHeader() {
            return "random_number ({real} max, {real} min)";
        }

        public static String ManualEntry() {
            return "Generates a random number.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class tangent_Command
    implements ZPEInternalFunction {
        private tangent_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.tan(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "tangent ({real} value)";
        }

        public static String ManualEntry() {
            return "Takes a value as a real and calculates it's tangent value as a real.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class cosine_Command
    implements ZPEInternalFunction {
        private cosine_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.cos(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "cosine ({real} value)";
        }

        public static String ManualEntry() {
            return "Takes a value as a real and calculates it's cosine value as a real.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class sine_Command
    implements ZPEInternalFunction {
        private sine_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.sin(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "sine ({real} value)";
        }

        public static String ManualEntry() {
            return "Takes a value as a real and calculates it's sine value as a real.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Scientific Mathematics";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class evaluate_Command
    implements ZPEInternalFunction {
        private evaluate_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            String p1 = parameters[0].toString();
            if (p1.matches("([0-9]+ [+-/*%] [0-9]+)+")) {
                ZPERuntimeEnvironment j = new ZPERuntimeEnvironment(parent.getPermissionLevel());
                try {
                    return new ZPEString(j.interpret("function main() {return " + p1 + "}", new ZPEType[0]).toString());
                }
                catch (CompileException e) {
                    return new ZPEString(e.getMessage());
                }
                catch (ZPERuntimeException e) {
                    ZPECore.printError("Code could not be evaluated correctly in the evaluate command");
                }
            }
            return null;
        }

        public static String ManualHeader() {
            return "evaluate ({string} expr)";
        }

        public static String ManualEntry() {
            return "Evaluates a mathematical expression, __expr__, from a string. Brackets are not supported.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class to_denary_Command
    implements ZPEInternalFunction {
        private to_denary_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String input = parameters[0].toString();
            if (input.matches("0b[01]*")) {
                double total = 0.0;
                double placeholder = Math.pow(2.0, input.length() - 1);
                for (int i = input.length(); i > 0; --i) {
                    if (input.charAt(i - 1) == '1') {
                        total += placeholder;
                    }
                    placeholder /= 2.0;
                }
                return new ZPENumber(total);
            }
            if (input.matches("0x[0-9a-fA-f]+")) {
                double total = 0.0;
                input = input.toLowerCase();
                for (int i = 0; i < input.length(); ++i) {
                    char ch = input.charAt(i);
                    long val = ch == 'a' ? 10L : (ch == 'b' ? 11L : (ch == 'c' ? 12L : (ch == 'd' ? 13L : (ch == 'e' ? 14L : (ch == 'f' ? 15L : HelperFunctions.stringToLong("" + ch))))));
                    double pow = Math.pow(16.0, input.length() - 1 - i);
                    total += (double)val * pow;
                }
                return new ZPENumber(total);
            }
            if (input.matches("0[0-7]+")) {
                double total = 0.0;
                input = input.toLowerCase();
                for (int i = 0; i < input.length(); ++i) {
                    char ch = input.charAt(i);
                    long val = HelperFunctions.stringToLong("" + ch);
                    double pow = Math.pow(8.0, input.length() - 1 - i);
                    total += (double)val * pow;
                }
                return new ZPENumber(total);
            }
            return new ZPENumber(0);
        }

        public static String ManualHeader() {
            return "to_decimal ({string} value)";
        }

        public static String ManualEntry() {
            return "Transforms a string such as a binary string, octal string or a hexadecimal string into a decimal value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class to_hexadecimal_Command
    implements ZPEInternalFunction {
        private to_hexadecimal_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!HelperFunctions.isNumeric(parameters[0].toString())) {
                return new ZPENumber(0);
            }
            long i = HelperFunctions.stringToLong(parameters[0].toString());
            return new ZPEString(Long.toHexString(i));
        }

        public static String ManualHeader() {
            return "to_hexadecimal ({real} value)";
        }

        public static String ManualEntry() {
            return "Transforms a real into a hexadecimal string.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class to_octal_Command
    implements ZPEInternalFunction {
        private to_octal_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!HelperFunctions.isNumeric(parameters[0].toString())) {
                return new ZPENumber(0);
            }
            long i = HelperFunctions.stringToLong(parameters[0].toString());
            return new ZPEString(Long.toOctalString(i));
        }

        public static String ManualHeader() {
            return "to_octal ({real} value)";
        }

        public static String ManualEntry() {
            return "Transforms a real into a octal string.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class to_binary_Command
    implements ZPEInternalFunction {
        private to_binary_Command() {
        }

        private static String pad(String s, boolean positive) {
            int pow;
            for (pow = 0; pow < s.length(); pow += 8) {
            }
            pow -= s.length();
            StringBuilder sBuilder = new StringBuilder(s);
            for (int x = 0; x < pow + 1; ++x) {
                if (positive) {
                    sBuilder.insert(0, "0");
                    continue;
                }
                sBuilder.insert(0, "1");
            }
            s = sBuilder.toString();
            return s;
        }

        private static String microConvert(Long no) {
            String s = Long.toBinaryString(no);
            if (no < 0L) {
                String nonNegative = Long.toBinaryString(Math.abs(no));
                return to_binary_Command.pad(s.substring(s.length() - nonNegative.length()), false);
            }
            return to_binary_Command.pad(s, true);
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!HelperFunctions.isNumeric(parameters[0].toString())) {
                ZPEList output = new ZPEList();
                if (parameters[0] instanceof ZPEString) {
                    String str = parameters[0].toString();
                    for (int i = 0; i < str.length(); ++i) {
                        output.add(new ZPEString(to_binary_Command.microConvert(HelperFunctions.stringToLong("" + str.charAt(i)))));
                    }
                }
                return output;
            }
            long no = HelperFunctions.stringToLong(parameters[0].toString());
            return new ZPEString(to_binary_Command.microConvert(no));
        }

        public static String ManualHeader() {
            return "to_binary ({mixed} value)";
        }

        public static String ManualEntry() {
            return "Transforms a real into a binary string, or a string into a list of binary strings.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class remove_exponent_Command
    implements ZPEInternalFunction {
        private remove_exponent_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!HelperFunctions.isNumeric(parameters[0].toString())) {
                return new ZPEString(parameters[0].toString());
            }
            if (!parameters[0].toString().contains("E")) {
                return new ZPEString(parameters[0].toString());
            }
            String s = parameters[0].toString();
            String[] splits = s.split("E");
            String[] mantissaSplit = splits[0].split("\\.");
            int mantissa = mantissaSplit[1].length();
            StringBuilder exp = new StringBuilder();
            int d = HelperFunctions.stringToInteger(splits[1]) - mantissa;
            for (int i = 0; i < d; ++i) {
                exp.append("0");
            }
            return new ZPEString(splits[0].replace(".", "") + String.valueOf(exp));
        }

        public static String ManualHeader() {
            return "remove_exponent ({real} value)";
        }

        public static String ManualEntry() {
            return "Removes the exponent and transforms the number to a non-floating point number string.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class value_Command
    implements ZPEInternalFunction {
        private value_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (parameters[0].toString().equals("false")) {
                return new ZPENumber(0);
            }
            if (parameters[0].toString().equals("true")) {
                return new ZPENumber(1);
            }
            if (!HelperFunctions.isNumeric(parameters[0].toString())) {
                return new ZPENumber(0);
            }
            String p = parameters[0].toString();
            if (p.matches("[+-]?\\d+")) {
                return new ZPENumber(HelperFunctions.stringToInteger(p));
            }
            return new ZPENumber(HelperFunctions.stringToDouble(p));
        }

        public static String ManualHeader() {
            return "value ({string} value)";
        }

        public static String ManualEntry() {
            return "Parses a string which holds an integer or real value to an integer or a real.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "3.0";
        }
    }

    private static class limit_real_Command
    implements ZPEInternalFunction {
        private limit_real_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            int max;
            if (parameters == null) {
                return null;
            }
            double i = HelperFunctions.stringToDouble(parameters[0].toString());
            int min = HelperFunctions.stringToInteger(parameters[1].toString());
            if (min > (max = HelperFunctions.stringToInteger(parameters[2].toString()))) {
                return new ZPENumber(i);
            }
            return new ZPENumber(ZPEHelperFunctions.limitInteger(i, min, max));
        }

        public static String ManualHeader() {
            return "limit_real ({real} value, {real} min, {real} max)";
        }

        public static String ManualEntry() {
            return "Forces a number to be within the range of the __min__ and __max__ value. If the number is within the range, it will return the number, otherwise if it is less than __min__ it will return __min__ or if it is greater than the __max__ value it will return __max__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class significant_figures_Command
    implements ZPEInternalFunction {
        private significant_figures_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double num = HelperFunctions.stringToDouble(parameters[0].toString());
            long n = HelperFunctions.stringToLong(parameters[1].toString());
            if (num == 0.0) {
                return new ZPENumber(0);
            }
            double maxPowerOfTen = Math.floor(Math.log10(Double.MAX_VALUE));
            double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
            long power = n - (long)((int)d);
            double firstMagnitudeFactor = 1.0;
            double secondMagnitudeFactor = 1.0;
            if ((double)power > maxPowerOfTen) {
                firstMagnitudeFactor = Math.pow(10.0, maxPowerOfTen);
                secondMagnitudeFactor = Math.pow(10.0, (double)power - maxPowerOfTen);
            } else {
                firstMagnitudeFactor = Math.pow(10.0, power);
            }
            double toBeRounded = num * firstMagnitudeFactor;
            long shifted = Math.round(toBeRounded *= secondMagnitudeFactor);
            double rounded = (double)shifted / firstMagnitudeFactor;
            return new ZPENumber(rounded /= secondMagnitudeFactor);
        }

        public static String ManualHeader() {
            return "significant_figures ({real} value, {integer} number_of_sig_figs)";
        }

        public static String ManualEntry() {
            return "Rounds a number, __value__, to a specified number of significant figures, __number_of_sig_figs__.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class round_Command
    implements ZPEInternalFunction {
        private round_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double n = ((ZPENumber)parameters[0]).doubleValue();
            if (parameters.length > 1) {
                int times = HelperFunctions.stringToInteger(parameters[1].toString());
                double divisible = Math.pow(10.0, times);
                n = Math.floor(n * divisible);
                return new ZPENumber(n /= divisible);
            }
            return new ZPENumber(Math.round(n));
        }

        public static String ManualHeader() {
            return "round ({real} value[, {integer} decimal_places])";
        }

        public static String ManualEntry() {
            return "Rounds a number up or down to the closest full number.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class ceiling_Command
    implements ZPEInternalFunction {
        private ceiling_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.ceil(HelperFunctions.stringToDouble(parameters[0].toString())));
        }

        public static String ManualHeader() {
            return "ceiling ({real} value)";
        }

        public static String ManualEntry() {
            return "Rounds a number up.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class floor_Command
    implements ZPEInternalFunction {
        private floor_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.floor(HelperFunctions.stringToDouble(parameters[0].toString())));
        }

        public static String ManualHeader() {
            return "floor ({real} value)";
        }

        public static String ManualEntry() {
            return "Rounds a number down.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class sign_Command
    implements ZPEInternalFunction {
        private sign_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            double n = HelperFunctions.stringToDouble(parameters[0].toString());
            if (n < 0.0) {
                return new ZPENumber(-1);
            }
            return new ZPENumber(1);
        }

        public static String ManualHeader() {
            return "sign ({real} value)";
        }

        public static String ManualEntry() {
            return "Checks if a number, __value__, is a negative number (returns -1) or a positive number (returns 1).";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class is_prime_number_Command
    implements ZPEInternalFunction {
        private is_prime_number_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            long n = HelperFunctions.stringToLong(parameters[0].toString());
            for (long i = 2L; i < n / 2L + 1L; ++i) {
                if (n % i != 0L) continue;
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "is_prime_number ({real} value)";
        }

        public static String ManualEntry() {
            return "Checks if a number, __value__, is a prime number.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class factorial_Command
    implements ZPEInternalFunction {
        private factorial_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            long n = ((ZPENumber)parameters[0]).longValue();
            if (n >= 100L) {
                return new ZPENumber(-1);
            }
            long q = 1L;
            for (long i = n; i > 1L; --i) {
                q *= i;
            }
            return new ZPENumber(q);
        }

        public static String ManualHeader() {
            return "factorial ({integer} n)";
        }

        public static String ManualEntry() {
            return "Takes a value, __n__, as an integer and returns it's factorial, that is __n__!. If __n__ is \u2265 40 it will return -1 as it would result in an arithmetic overflow.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class log_Command
    implements ZPEInternalFunction {
        private log_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.log(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "log ({real} value)";
        }

        public static String ManualEntry() {
            return "Takes a value as a real and calculates the logarithmic value of it.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class cube_root_Command
    implements ZPEInternalFunction {
        private cube_root_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.cbrt(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "cube_root ({real} value)";
        }

        public static String ManualEntry() {
            return "Takes a value as a real and calculates the square root of that value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class square_root_Command
    implements ZPEInternalFunction {
        private square_root_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.sqrt(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "square_root ({real} value)";
        }

        public static String ManualEntry() {
            return "Takes a value as a real and calculates the square root of that value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class absolute_value_Command
    implements ZPEInternalFunction {
        private absolute_value_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Math.abs(((ZPENumber)parameters[0]).doubleValue()));
        }

        public static String ManualHeader() {
            return "absolute_value ({real} value)";
        }

        public static String ManualEntry() {
            return "Calculates the absolute value of a number. E.g. absolute_value(-5) = 5.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Numerical and Arithmetic";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_remote_ip_address_Command
    implements ZPEInternalFunction {
        private get_remote_ip_address_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            String addr;
            block9: {
                if (parameters == null) {
                    return null;
                }
                addr = "";
                try {
                    ZPEType out = ZPEHelperFunctions.urlToJson("https://ipv4.jsonip.com/");
                    if (out instanceof ZPEMap) {
                        if (((ZPEMap)out).containsKey("ip")) {
                            addr = ((ZPEMap)out).get("ip").toString();
                        }
                        break block9;
                    }
                    return new ZPEBoolean(false);
                }
                catch (Exception e) {
                    block10: {
                        try {
                            ZPEType out = ZPEHelperFunctions.urlToJson("https://api.ipify.org/?format=json");
                            if (out instanceof ZPEMap) {
                                if (((ZPEMap)out).containsKey("ip")) {
                                    addr = ((ZPEMap)out).get("ip").toString();
                                }
                                break block10;
                            }
                            return new ZPEBoolean(false);
                        }
                        catch (Exception e1) {
                            System.out.println("Unable to connect to api.ipify.org service");
                        }
                    }
                    System.out.println("Unable to connect to jsonip.com service");
                }
            }
            return new ZPEString(addr);
        }

        public static String ManualHeader() {
            return "get_remote_ip_address ()";
        }

        public static String ManualEntry() {
            return "Attempts to return the current systems IP public/remote address. May return false on failure.";
        }

        public static int RequiredPermissionLevel() {
            return 3;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_ip_address_Command
    implements ZPEInternalFunction {
        private get_ip_address_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            Object addr = "";
            try {
                addr = String.valueOf(InetAddress.getLocalHost());
                if (((String)addr).contains("/")) {
                    return new ZPEString(((String)addr).split("/")[1]);
                }
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
            return new ZPEString((String)addr);
        }

        public static String ManualHeader() {
            return "get_ip_address ()";
        }

        public static String ManualEntry() {
            return "Attempts to return the current systems IP address. May return false on failure.";
        }

        public static int RequiredPermissionLevel() {
            return 3;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class send_zpe_server_request_Command
    implements ZPEInternalFunction {
        private send_zpe_server_request_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZENClient client = new ZENClient(parameters[0].toString(), HelperFunctions.stringToInteger(parameters[1].toString()), parent);
            try {
                client.openConnection();
                return client.sendZPECommand(parameters[2].toString());
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public static String ManualHeader() {
            return "send_zpe_server_request ({string} host, {integer} port, {string} request)";
        }

        public static String ManualEntry() {
            return "Sends a request to a remote ZPE Server.";
        }

        public static int RequiredPermissionLevel() {
            return 1;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 3;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class http_download_Command
    implements ZPEInternalFunction {
        private http_download_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            try {
                URL website = new URL(parameters[0].toString());
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(parameters[1].toString());
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
                return new ZPEBoolean(true);
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public static String ManualHeader() {
            return "http_download ({string} url, {string} path)";
        }

        public static String ManualEntry() {
            return "Uses the HTTP POST method to download a file to a path. This method will return true if successful or return false if the request throws an error.";
        }

        public static int RequiredPermissionLevel() {
            return 5;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class http_post_Command
    implements ZPEInternalFunction {
        private http_post_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (parameters.length == 2) {
                String url = parameters[0].toString();
                if (parameters[1] instanceof ZPEMap) {
                    ZPEMap arguments = (ZPEMap)parameters[1];
                    try {
                        return new ZPEString(HelperFunctions.makePOSTRequest(url, arguments.stringify()));
                    }
                    catch (Exception e) {
                        throw new ZPERuntimeException("http_post failed");
                    }
                }
                return null;
            }
            String url = parameters[0].toString();
            if (parameters[1] instanceof ZPEMap) {
                ZPEMap arguments = (ZPEMap)parameters[1];
                String body = parameters[2].toString();
                try {
                    return new ZPEString(HelperFunctions.makePOSTRequest(url, body, arguments.stringify()));
                }
                catch (Exception e) {
                    throw new ZPERuntimeException("http_post failed");
                }
            }
            throw new IncorrectDataTypeException("map", "hhtp_post", "1");
        }

        public static String ManualHeader() {
            return "http_post ({string} url, {map} arguments[, {string} body])";
        }

        public static String ManualEntry() {
            return "Uses the HTTP POST method to post data specified as a map to the specified URL. This method will return a string if successful or return null if the request throws an error.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_hostname_Command
    implements ZPEInternalFunction {
        private get_hostname_Command() {
        }

        public static String ManualHeader() {
            return "get_hostname ({string} ip)";
        }

        public static String ManualEntry() {
            return "Checks that an IP address is reachable and attempts to get its hostname.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String ipAddress = parameters[0].toString();
            try {
                InetAddress res = InetAddress.getByName(ipAddress);
                if (res.isReachable(2000)) {
                    return new ZPEString(res.getHostName());
                }
                return new ZPEString("");
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public static int RequiredPermissionLevel() {
            return 3;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class ping_Command
    implements ZPEInternalFunction {
        private ping_Command() {
        }

        public static String ManualHeader() {
            return "ping ({string} ip, {integer} timeout)";
        }

        public static String ManualEntry() {
            return "Checks that an IP address is reachable and pings it with a certain number of bytes.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String ipAddress = parameters[0].toString();
            int timeout2 = 2000;
            if (parameters.length > 1) {
                timeout2 = HelperFunctions.stringToInteger(parameters[1].toString());
            }
            try {
                InetAddress res = InetAddress.getByName(ipAddress);
                if (res.isReachable(timeout2)) {
                    return new ZPEBoolean(true);
                }
                return new ZPEBoolean(false);
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public static int RequiredPermissionLevel() {
            return 3;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class wake_on_lan_Command
    implements ZPEInternalFunction {
        private wake_on_lan_Command() {
        }

        public static String ManualHeader() {
            return "wake_on_lan ({string} mac_address)";
        }

        public static String ManualEntry() {
            return "Attempts to send a magic packet (Wake On LAN packet) to a system using it's MAC address.";
        }

        public static void wol(String MAC) throws IOException, IllegalArgumentException {
            int m;
            String HEX = "0123456789ABCDEF";
            byte[] bMAC = new byte[6];
            int i = 0;
            int h = 0;
            MAC = MAC.toUpperCase();
            for (m = 0; m < MAC.length() && i < 12; ++m) {
                int n = "0123456789ABCDEF".indexOf(MAC.charAt(m));
                if (n < 0) continue;
                if (i % 2 == 0) {
                    h = n;
                } else {
                    bMAC[i / 2] = (byte)(h * 16 + n);
                }
                ++i;
            }
            if (m < MAC.length()) {
                throw new IllegalArgumentException("MAC Address must be 12 Hex digits exactly");
            }
            wake_on_lan_Command.wol(bMAC);
        }

        public static void wol(byte[] MAC) throws IOException {
            if (MAC == null || MAC.length != 6) {
                throw new IllegalArgumentException("MAC array must be present and 6 bytes long");
            }
            int packetLength = 102;
            byte[] packetData = new byte[packetLength];
            int m = 0;
            packetData[m++] = -1;
            packetData[m++] = -1;
            packetData[m++] = -1;
            packetData[m++] = -1;
            packetData[m++] = -1;
            packetData[m++] = -1;
            for (int i = 0; i < 96; ++i) {
                packetData[m] = MAC[m % 6];
                ++m;
            }
            try (DatagramSocket socket = new DatagramSocket(1);){
                InetSocketAddress address = new InetSocketAddress("255.255.255.255", 2304);
                DatagramPacket datagram = new DatagramPacket(packetData, packetLength, address);
                socket.setBroadcast(true);
                socket.send(datagram);
            }
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            try {
                wake_on_lan_Command.wol(parameters[0].toString());
            }
            catch (Exception e) {
                ZPECore.printError(e.getMessage());
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        public static int RequiredPermissionLevel() {
            return 3;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 0;
        }

        public static String Category() {
            return "Networking";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class open_audio_stream_Command
    implements ZPEInternalFunction {
        private open_audio_stream_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            try {
                String url = parameters[0].toString();
                if (new File(url).exists()) {
                    AudioStreamObject stream = new AudioStreamObject(parent, parent.getCurrentFunction());
                    stream.open(url);
                    return stream;
                }
                ZPECore.printError("File " + url + " not found");
                return new ZPEBoolean(false);
            }
            catch (Exception e) {
                throw new ZPERuntimeException("Cannot play audio file. Check the file type.");
            }
        }

        public static String ManualHeader() {
            return "open_audio_stream ({string} url)";
        }

        public static String ManualEntry() {
            return "Open a stream to an audio file and returns a ZPEAudioStream object. The format must be supported. Currently WAV files are the only supported format.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class beep_Command
    implements ZPEInternalFunction {
        private beep_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            try {
                int freq = HelperFunctions.stringToInteger(parameters[0].toString());
                int millis = HelperFunctions.stringToInteger(parameters[1].toString());
                if (parameters.length == 2) {
                    HelperFunctions.systemBeep(freq, millis);
                } else {
                    HelperFunctions.systemBeepOld(freq, millis);
                }
                return new ZPEBoolean(true);
            }
            catch (Exception e) {
                throw new ZPERuntimeException("Beep function is not setup correctly on this system.");
            }
        }

        public static String ManualHeader() {
            return "beep ({integer} frequency, {integer} duration)";
        }

        public static String ManualEntry() {
            return "Send a beep sound effect from the system.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.2";
        }
    }

    private static class get_yes_no_Command
    implements ZPEInternalFunction {
        private get_yes_no_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            StringBuilder out = new StringBuilder();
            for (ZPEType s : parameters) {
                out.append(s.toString());
            }
            ZPECore.print(out.toString());
            String v = ZPECore.readLine("Enter yes or no.").toLowerCase();
            while (!(v.equals("yes") || v.equals("no") || v.equals("y") || v.equals("n"))) {
                ZPECore.print("The value must be yes or no");
                v = ZPECore.readLine("Enter yes or no.").toLowerCase();
            }
            if (v.equals("yes") || v.equals("y")) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "get_yes_no ({string} message[, {string} title])";
        }

        public static String ManualEntry() {
            return "Gets a boolean Yes or No from the user.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class deserialise_Command
    implements ZPEInternalFunction {
        private deserialise_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (parameters[0] != null) {
                String file = parameters[0].toString();
                ObjectInputStream reader = null;
                try {
                    FileInputStream door = new FileInputStream(file);
                    reader = new ObjectInputStream(door);
                    SerialisableObject k = (SerialisableObject)reader.readObject();
                    ZPEObject o = deserialise_Command.SerialisedObjectToObject(k, parent);
                    reader.close();
                    return o;
                }
                catch (Exception e) {
                    try {
                        assert (reader != null);
                        reader.close();
                    }
                    catch (IOException e1) {
                        ZPECore.log(e.getMessage());
                    }
                    throw new ZPERuntimeException("Problem deserialising object.");
                }
            }
            return new ZPEBoolean(false);
        }

        private static ZPEObject SerialisedObjectToObject(SerialisableObject k, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            ZPEObject o = new ZPEObject(parent, null, k.name);
            o.setId(k.name);
            for (String var : k.variables.keySet()) {
                ZPEVariable v = k.variables.get(var);
                ZPEType value = deserialise_Command.GetValue(v.getValue(), parent);
                if (value instanceof ZPEFunction) {
                    ZPEFunction f = (ZPEFunction)value;
                    f.name = var;
                }
                o.properties.put(var, new ZPEVariable(var, value, v.scope, o, 118));
            }
            return o;
        }

        private static ZPEType GetValue(Object v, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            ZPEType value = null;
            if (v instanceof IAST) {
                IAST ast = (IAST)v;
                if (ast.type == 124) {
                    value = new ZPEFunction(parent, ast.id, ast.left, true);
                }
            } else if (v instanceof SerialisableObject) {
                value = deserialise_Command.SerialisedObjectToObject((SerialisableObject)v, parent);
            } else if (v instanceof ZPEList) {
                ZPEList l = (ZPEList)v;
                ZPEList out = new ZPEList();
                for (Object item : l.toArray()) {
                    if (item instanceof IAST || item instanceof SerialisableObject || item instanceof ZPEList || item instanceof ZPEMap) {
                        out.add(deserialise_Command.GetValue(item, parent));
                        continue;
                    }
                    out.add((ZPEType)item);
                }
                value = out;
            } else if (v instanceof ZPEMap) {
                ZPEMap l = (ZPEMap)v;
                ZPEMap out = new ZPEMap();
                for (ZPEType item : l.keySet()) {
                    ZPEType entry;
                    ZPEType key = item;
                    if (key instanceof IAST || key instanceof SerialisableObject || key instanceof ZPEList || key instanceof ZPEMap) {
                        key = deserialise_Command.GetValue(key, parent);
                    }
                    if ((entry = l.get(key)) instanceof IAST || entry instanceof SerialisableObject || entry instanceof ZPEList || entry instanceof ZPEMap) {
                        entry = deserialise_Command.GetValue(entry, parent);
                    }
                    out.put(key, entry);
                }
                value = out;
            } else {
                value = (ZPEType)v;
            }
            return value;
        }

        public static String ManualHeader() {
            return "deserialise ({string} file)";
        }

        public static String ManualEntry() {
            return "Deserialises an object or structure from a file.";
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class print_warning_Command
    implements ZPEInternalFunction {
        private print_warning_Command() {
        }

        public static String ManualHeader() {
            return "print_warning ({string} message)";
        }

        public static String ManualEntry() {
            return "Displays a warning message on the console. These will be ignored if the user has turned off warnings.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            StringBuilder out = new StringBuilder();
            for (ZPEType s : parameters) {
                out.append(s.toString());
            }
            ZPECore.printWarning(out.toString());
            return new ZPEString(out.toString());
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_password_input_Command
    implements ZPEInternalFunction {
        private get_password_input_Command() {
        }

        public static String ManualHeader() {
            return "get_password_input ([{string} message])";
        }

        public static String ManualEntry() {
            return "Gets a user password input from the command line or dialog in GUI mode.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            StringBuilder out = new StringBuilder();
            for (ZPEType s : parameters) {
                out.append(s.toString());
            }
            if (!out.toString().isEmpty()) {
                ZPECore.print(out.toString());
            }
            if (System.console() != null) {
                return new ZPEString(String.valueOf(System.console().readPassword()));
            }
            return ZPECore.UNDEFINED;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class write_Command
    implements ZPEInternalFunction {
        private write_Command() {
        }

        public static String ManualHeader() {
            return "write ({string} message[, {integer} duration])";
        }

        public static String ManualEntry() {
            return "Writes a message on the display delaying each character by a duration.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ExitHalt, ZPERuntimeException, BreakPointHalt {
            if (parameters == null) {
                return null;
            }
            int dur = 20;
            String out = parameters[0].toString();
            ZPEFunction func = null;
            if (parameters.length > 2 && parameters[2] instanceof ZPEFunction) {
                func = (ZPEFunction)parameters[2];
            }
            if (parameters.length > 1) {
                dur = HelperFunctions.stringToInteger(parameters[1].toString());
            }
            for (int i = 0; i < out.length(); ++i) {
                System.out.print(out.charAt(i));
                System.out.flush();
                try {
                    Thread.sleep(dur);
                    if (func == null) continue;
                    func.run();
                    continue;
                }
                catch (InterruptedException e) {
                    ZPECore.log(e.getMessage());
                }
            }
            System.out.println();
            return new ZPEString(out);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class auto_input_Command
    implements ZPEInternalFunction {
        private auto_input_Command() {
        }

        public static String ManualHeader() {
            return "auto_input ([{string} message])";
        }

        public static String ManualEntry() {
            return "Gets a user input from the command line and converts it the appropriate data type. ";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            StringBuilder out = new StringBuilder();
            for (ZPEType s : parameters) {
                out.append(s.toString());
            }
            String in = ZPECore.readLine(out.toString());
            if (HelperFunctions.isNumeric(in)) {
                if (Math.abs(HelperFunctions.stringToDouble(in)) == (double)((int)Math.abs(HelperFunctions.stringToDouble(in)))) {
                    return new ZPENumber((int)Math.abs(HelperFunctions.stringToDouble(in)));
                }
                return new ZPENumber(Math.abs(HelperFunctions.stringToDouble(in)));
            }
            if (in.equals("true") || in.equals("false")) {
                return new ZPEBoolean(ZPEHelperFunctions.ToBoolean(in));
            }
            return new ZPEString(in);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class input_restricted_Command
    implements ZPEInternalFunction {
        private input_restricted_Command() {
        }

        public static String ManualHeader() {
            return "input_restricted ({list} restriction [, {string} message])";
        }

        public static String ManualEntry() {
            return "Reads a line as user input and causes a runtime error if the input is not within the restriction group, __restriction__.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList l = (ZPEList)parameters[0];
            StringBuilder out = new StringBuilder();
            for (int i = 1; i < parameters.length; ++i) {
                out.append(parameters[i].toString());
            }
            ZPEString output = new ZPEString(ZPECore.readLine(out.toString()));
            if (!l.contains(output)) {
                throw new ZPERuntimeException("Input not accepted due to restrictive input.");
            }
            return output;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class std_in_Command
    implements ZPEInternalFunction {
        private std_in_Command() {
        }

        public static String ManualHeader() {
            return "std_in ([{string} message])";
        }

        public static String ManualEntry() {
            return "Reads a line as user input.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            StringBuilder out = new StringBuilder();
            for (ZPEType s : parameters) {
                out.append(s.toString());
            }
            return new ZPEString(ZPECore.readLine(out.toString()));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class std_out_Command
    implements ZPEInternalFunction {
        private std_out_Command() {
        }

        public static String ManualHeader() {
            return "std_out ([{mixed} message])";
        }

        public static String ManualEntry() {
            return "Prints a message to the standard output of the system and returns the message. This works faster than print as it does not transform a value to a string first but requests the value prints itself.";
        }

        /*
         * Enabled aggressive block sorting
         */
        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt {
            if (parameters == null) {
                return null;
            }
            Object toPrint = "";
            int param_no = 0;
            if (parameters.length == 0) {
                ZPECore.print();
                return new ZPEString("");
            }
            ZPEType param2 = parameters[0];
            ++param_no;
            if (param2 == null) {
                return null;
            }
            if (param2 instanceof ZPEObject) {
                ZPEObject o = (ZPEObject)param2;
                if (!o.properties.containsKey("_print")) {
                    toPrint = (String)toPrint + o.toString();
                    ZPECore.print((String)toPrint, true);
                    return new ZPEString((String)toPrint);
                }
                BinarySearchTree<String, ZPEType> params = new BinarySearchTree<String, ZPEType>();
                params.put("object", o);
                ZPEVariable p = o.properties.get("_print");
                if (p instanceof ZPEObjectNativeMethod) {
                    toPrint = (String)toPrint + String.valueOf(((ZPEObjectNativeMethod)((Object)p)).MainMethod(params, o));
                }
            } else {
                toPrint = (String)toPrint + param2.toString();
                ZPECore.print("", true);
                toPrint = (String)toPrint + param2.toString();
            }
            if (param_no != parameters.length) {
                toPrint = (String)toPrint + " ";
            }
            if (!((String)toPrint).isEmpty()) {
                ZPECore.print((String)toPrint, true);
            }
            return new ZPEString((String)toPrint);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "2.1";
        }
    }

    private static class print_Command
    implements ZPEInternalFunction {
        private print_Command() {
        }

        public static String ManualHeader() {
            return "print ([{mixed} message1, {mixed} message2, {mixed} message3, ..., {mixed} messageN])";
        }

        public static String ManualEntry() {
            return "Prints a message to the standard output of the system and returns the message. It also has infinite arguments which will be joined before printing.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException, ExitHalt {
            if (parameters == null) {
                return null;
            }
            StringBuilder toPrint = new StringBuilder();
            int param_no = 0;
            if (parameters.length == 0) {
                ZPECore.print();
                return new ZPEString("");
            }
            if (parameters[0] instanceof DoNothingObject) {
                return null;
            }
            for (ZPEType param2 : parameters) {
                ++param_no;
                if (param2 == null) {
                    toPrint.append("null");
                } else if (param2 instanceof ZPEObject) {
                    ZPEObject o = (ZPEObject)param2;
                    if (o.properties.containsKey("_print")) {
                        BinarySearchTree<String, ZPEType> params = new BinarySearchTree<String, ZPEType>();
                        params.put("object", o);
                        ZPEVariable p = o.properties.get("_print");
                        if (p instanceof ZPEObjectNativeMethod) {
                            toPrint.append(((ZPEObjectNativeMethod)((Object)p)).MainMethod(params, o));
                        }
                    } else if (ZPEInstance.ALWAYS_BEAUTIFY_OUTPUT) {
                        try {
                            toPrint.append(ZPEHelperFunctions.beautify(o, 0));
                        }
                        catch (BreakPointHalt e) {
                            toPrint.append(o);
                        }
                    } else {
                        toPrint.append(o);
                    }
                } else {
                    try {
                        if (ZPEInstance.ALWAYS_BEAUTIFY_OUTPUT) {
                            try {
                                toPrint.append(ZPEHelperFunctions.beautify(param2, 0));
                            }
                            catch (BreakPointHalt e) {
                                toPrint.append(param2);
                            }
                        } else {
                            toPrint.append(param2);
                        }
                    }
                    catch (Exception e) {
                        ZPECore.log(e.getMessage());
                    }
                }
                if (param_no == parameters.length) continue;
                toPrint.append(" ");
            }
            String output = toPrint.toString();
            if (!output.isEmpty()) {
                ZPECore.print(output);
            }
            return new ZPEString(output);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class std_err_Command
    implements ZPEInternalFunction {
        private std_err_Command() {
        }

        public static String ManualHeader() {
            return "std_err({mixed} message1[, {mixed} message2, {mixed} message3, ..., {mixed} messageN])";
        }

        public static String ManualEntry() {
            return "Prints an error message to the standard error of the system and returns the message. It also has infinite arguments which will be concatenated (joined) before printing.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            StringBuilder toPrint = new StringBuilder();
            for (ZPEType param2 : parameters) {
                toPrint.append(param2);
            }
            ZPECore.printError(toPrint.toString());
            return new ZPEString(toPrint.toString());
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class sprintf_Command
    implements ZPEInternalFunction {
        private sprintf_Command() {
        }

        public static String ManualHeader() {
            return "sprintf ({string} str[, {mixed} sprint1, {mixed} sprint2, {mixed} sprint3, ..., {mixed} sprintN])";
        }

        public static String ManualEntry() {
            return "Performs a replacement of each %s 'sprint' within a string, __str__.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String s = parameters[0].toString();
            Object[] items = new Object[parameters.length - 1];
            for (int i = 1; i < parameters.length; ++i) {
                ZPEType v = parameters[i];
                items[i - 1] = v.toString();
            }
            return new ZPEString(String.format(s, items));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "I/O";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class function_exists_Command
    implements ZPEInternalFunction {
        private function_exists_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String fn = parameters[0].toString();
            if (Commands.contains(fn) || Aliases.contains(fn) || internalAliases.containsKey(fn)) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static String ManualHeader() {
            return "function_exists ({string} func)";
        }

        public static String ManualEntry() {
            return "Returns whether or not a function is defined within the runtime.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class get_unique_id_Command
    implements ZPEInternalFunction {
        private get_unique_id_Command() {
        }

        public static String ManualHeader() {
            return "get_unique_id ()";
        }

        public static String ManualEntry() {
            return "Returns a semi-unique randomly generated string that can help identify this instance of ZPE";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            try {
                FileInputStream door = new FileInputStream(ZPEInstance.BASE_SETTINGS_PATH);
                ObjectInputStream reader = new ObjectInputStream(door);
                ZPESettingsFile k = (ZPESettingsFile)reader.readObject();
                reader.close();
                return new ZPEString(k.uniqueID);
            }
            catch (Exception e) {
                ZPECore.log("Could not generate a unique ID for the ZPE instance.");
                return new ZPEString("");
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_libraries_Command
    implements ZPEInternalFunction {
        private list_libraries_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList zl = new ZPEList();
            zl.addAll(ZPEInstance.IMPORTED_YASS_LIBRARIES);
            return zl;
        }

        public static String ManualHeader() {
            return "list_libraries ()";
        }

        public static String ManualEntry() {
            return "Returns a list containing all libraries currently available.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_plugins_Command
    implements ZPEInternalFunction {
        private list_plugins_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList zl = new ZPEList();
            Map<String, ZPELibrary> z = ZPEPluginManager.IMPORTED_PLUGINS;
            zl.addAll(z.keySet());
            return zl;
        }

        public static String ManualHeader() {
            return "list_plugins ()";
        }

        public static String ManualEntry() {
            return "Returns a list containing all plugins currently running.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_zpe_aliases_Command
    implements ZPEInternalFunction {
        private list_zpe_aliases_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEOrderedAssociativeArray zl = new ZPEOrderedAssociativeArray();
            for (String s : internalAliases.keySet()) {
                zl.put(new ZPEString(s), new ZPEString(internalAliases.get(s)));
            }
            return zl;
        }

        public static String ManualHeader() {
            return "list_zpe_aliases ()";
        }

        public static String ManualEntry() {
            return "Returns a list containing all ZPE aliases.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_zpe_functions_Command
    implements ZPEInternalFunction {
        private list_zpe_functions_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            boolean map = false;
            if (parameters.length > 0 && parameters[0] instanceof ZPEBoolean) {
                map = ((ZPEBoolean)parameters[0]).toBoolean();
            }
            ZPEOrderedAssociativeArray zl = new ZPEOrderedAssociativeArray();
            String lastCategory = "";
            for (String s : YASSPredefinedFunctions.getCommands()) {
                ZPEMemberType outputType;
                Class<? extends ZPEInternalFunction> f = YASSPredefinedFunctions.getInternalMethod(s);
                if (!zl.containsKey(new ZPEString(YASSPredefinedFunctions.getCategory(f)))) {
                    zl.put(new ZPEString(YASSPredefinedFunctions.getCategory(f)), new ZPEList());
                }
                if (map) {
                    ZPEMap o = new ZPEMap();
                    o.put(new ZPEString("name"), new ZPEString(s));
                    o.put(new ZPEString("version"), new ZPEString("" + ZPEKit.getFunctionVersion(s)));
                    outputType = o;
                } else {
                    outputType = new ZPEString(s);
                }
                ((ZPEList)zl.get(new ZPEString(YASSPredefinedFunctions.getCategory(f)))).add(outputType);
            }
            return zl;
        }

        public static String ManualHeader() {
            return "list_zpe_functions ()";
        }

        public static String ManualEntry() {
            return "Returns a list containing all ZPE functions.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_function_information_Command
    implements ZPEInternalFunction {
        private get_function_information_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String id = parameters[0].toString();
            Class<? extends ZPEInternalFunction> z = YASSPredefinedFunctions.getInternalMethod(id);
            if (z == null) {
                z = ZPEInstance.BUILT_IN_COMMANDS.getInternalMethodFromAlias(id);
            }
            if (z == null) {
                return ZPECore.UNDEFINED;
            }
            return new ZPEString(YASSPredefinedFunctions.getManualHeader(z));
        }

        public static String ManualHeader() {
            return "get_function_information ({string} func)";
        }

        public static String ManualEntry() {
            return "Returns the internal documentation on a function within ZPE.";
        }

        public static int RequiredPermissionLevel() {
            return 1;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class feedback_Command
    implements ZPEInternalFunction {
        private feedback_Command() {
        }

        public static String ManualHeader() {
            return "feedback ({string} message, [{string} email])";
        }

        public static String ManualEntry() {
            return "Sends feedback directly to Jamie Balfour using his website.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            String from = null;
            if (parameters.length >= 2) {
                from = parameters[1].toString();
            }
            return new ZPEBoolean(ZPEHelperFunctions.sendFeedback(parameters[0].toString(), from));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class supports_Command
    implements ZPEInternalFunction {
        private supports_Command() {
        }

        public static String ManualHeader() {
            return "supports ({string} function_name)";
        }

        public static String ManualEntry() {
            return "Returns whether or not a specified function is within the function list and supported by the current version of ZPE. This can be used to determine if a built in function is supported, for instance if a future version is added later. It is similar to Apache <IfModule> or the CSS @supports query.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String p = parameters[0].toString();
            if (Commands.contains(p)) {
                return new ZPEBoolean(true);
            }
            if (internalAliases.containsKey(p)) {
                return new ZPEBoolean(true);
            }
            for (ZPEFunction current = parent.getCurrentFunction(); current != null; current = (ZPEFunction)current.getParent()) {
                if (current.functionMap.containsKey(p)) {
                    return new ZPEBoolean(true);
                }
                if (current.getParent() instanceof ZPEFunction) {
                    continue;
                }
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(false);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class get_version_Command
    implements ZPEInternalFunction {
        private get_version_Command() {
        }

        public static String ManualHeader() {
            return "get_version ([{boolean} minor])";
        }

        public static String ManualEntry() {
            return "Gets the current version of ZPE as a string. If minor is specified and given a true value, it will return the minor version instead of the major.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (parameters.length == 1) {
                if (parameters[0].toString().equals("true")) {
                    return new ZPEString("9." + ZPECore.getBuildVersion());
                }
                return new ZPEString("1.13");
            }
            return new ZPEString("1.13.9");
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_zpe_property_Command
    implements ZPEInternalFunction {
        private get_zpe_property_Command() {
        }

        public static String ManualHeader() {
            return "get_zpe_property ({string} key)";
        }

        public static String ManualEntry() {
            return "Returns the value of a ZPE property used by the ZPE core. If the key does not exist, it returns false and displays an error message explaining that the key was not found.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            Properties main_properties = ZPEStartup.loadProperties();
            if (parameters.length != 0) {
                String key = parameters[0].toString();
                if (key.equals("SANDBOX")) {
                    return new ZPEString(ZPEInstance.SANDBOX_DIR);
                }
                if (main_properties.containsKey(key)) {
                    return new ZPEString(main_properties.get(key).toString());
                }
                ZPECore.printWarning("No key with the name " + key + " was found in the ZPE properties list.");
                return new ZPEBoolean(false);
            }
            ZPEMap props = new ZPEMap();
            props.putAll((Map)main_properties);
            return props;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class update_zpe_Command
    implements ZPEInternalFunction {
        private update_zpe_Command() {
        }

        public static String ManualHeader() {
            return "update_zpe ()";
        }

        public static String ManualEntry() {
            return "Attempts to update ZPE using the built-in updater.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            try {
                return new ZPEBoolean(ZPEUpdater.getInstance().runUpdate(false));
            }
            catch (Exception e) {
                ZPECore.printWarning("Update command failed.");
                return new ZPEBoolean(false);
            }
        }

        public static int RequiredPermissionLevel() {
            return 5;
        }

        public static byte ReturnType() {
            return -4;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_cache_values_Command
    implements ZPEInternalFunction {
        private list_cache_values_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return ZPESerialisedPropertyFile.getKeys(ZPEInstance.INSTALL_PATH + "/cache_values.prop");
        }

        public static String ManualHeader() {
            return "list_cache_values ()";
        }

        public static String ManualEntry() {
            return "Lists all cached values stored within the ZPE cache.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class read_cache_value_Command
    implements ZPEInternalFunction {
        private read_cache_value_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            ZPEString name = (ZPEString)parameters[0];
            ZPESerialisedPropertyFile f = ZPESerialisedPropertyFile.openMap(ZPEInstance.INSTALL_PATH + "/cache_values.prop");
            Object value = f.get(name.toString());
            if (parameters.length > 1) {
                String encrypt = parameters[1].toString();
                if (encrypt.length() != 16) {
                    ZPECore.printError("Encryption key must be 128 bits (16 characters) in size");
                    return ZPECore.UNDEFINED;
                }
                try {
                    value = HelperFunctions.decrypt(encrypt, encrypt, value.toString());
                }
                catch (Exception e) {
                    value = ZPECore.UNDEFINED;
                }
            }
            return new ZPEString(value.toString());
        }

        public static String ManualHeader() {
            return "read_cache_value ({string} name[, {string} decryption])";
        }

        public static String ManualEntry() {
            return "Reads a value from the cached values. If the value is a string and is encrypted, a decryption string needs provided.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class write_cache_value_Command
    implements ZPEInternalFunction {
        private write_cache_value_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            ZPEString name = (ZPEString)parameters[0];
            Object value = parameters[1];
            if (parameters.length > 2) {
                String encrypt = parameters[2].toString();
                if (encrypt.length() != 16) {
                    ZPECore.printError("Encryption key must be 128 bits (16 characters) in size");
                    return ZPECore.UNDEFINED;
                }
                try {
                    value = HelperFunctions.encrypt(encrypt, encrypt, value.toString());
                }
                catch (Exception e) {
                    value = ZPECore.UNDEFINED;
                }
            }
            ZPESerialisedPropertyFile f = ZPESerialisedPropertyFile.openMap(ZPEInstance.INSTALL_PATH + "/cache_values.prop");
            f.put(name.toString(), value);
            ZPESerialisedPropertyFile.saveMap(ZPEInstance.INSTALL_PATH + "/cache_values.prop", f);
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "write_cache_value ({string} name, {mixed} value[, {string} encryption])";
        }

        public static String ManualEntry() {
            return "Caches a value into the properties list so that it can be accessed by another instance of ZPE or at a later date. Optionally, for a string value the value can be encrypted.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "ZPE";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_os_name_Command
    implements ZPEInternalFunction {
        private get_os_name_Command() {
        }

        public static String ManualHeader() {
            return "get_os_name ()";
        }

        public static String ManualEntry() {
            return "Returns the operating system name.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPEString(System.getProperty("os.name"));
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_max_memory_Command
    implements ZPEInternalFunction {
        private get_max_memory_Command() {
        }

        public static String ManualHeader() {
            return "get_max_memory ()";
        }

        public static String ManualEntry() {
            return "Returns the maximum allocated memory given to the JVM and in turn this application.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Runtime.getRuntime().maxMemory());
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class shutdown_Command
    implements ZPEInternalFunction {
        private shutdown_Command() {
        }

        public static String ManualHeader() {
            return "shutdown ({string} command[, {integer} minutes])";
        }

        public static String ManualEntry() {
            return "Runs the shutdown command given an argument, __command__, which specifies the shutdown request (e.g. r for restart).";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            String cmd;
            if (parameters == null) {
                return null;
            }
            String q = "s";
            if (parameters.length >= 1) {
                q = parameters[0].toString();
            }
            if (HelperFunctions.isWindows()) {
                String time = "0";
                if (parameters.length > 1) {
                    time = parameters[1].toString();
                }
                cmd = "shutdown -" + q + " -t " + time;
            } else {
                String time = "now";
                if (q.equals("s")) {
                    q = "P";
                }
                if (parameters.length > 1) {
                    time = parameters[1].toString();
                }
                cmd = "shutdown -" + q + " " + time;
            }
            try {
                Runtime.getRuntime().exec(cmd);
                return new ZPEBoolean(true);
            }
            catch (IOException e) {
                return new ZPEBoolean(false);
            }
        }

        public static int RequiredPermissionLevel() {
            return 5;
        }

        public static byte ReturnType() {
            return -4;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.2";
        }
    }

    private static class wait_Command
    implements ZPEInternalFunction {
        private wait_Command() {
        }

        public static String ManualHeader() {
            return "wait ({integer} milliseconds)";
        }

        public static String ManualEntry() {
            return "Waits for a number of milliseconds specified before continuing execution.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            long ms = HelperFunctions.stringToLong(parameters[0].toString());
            try {
                TimeUnit.MILLISECONDS.sleep(ms);
            }
            catch (InterruptedException e) {
                throw new ZPERuntimeException("Wait command failed.");
            }
            return new ZPEBoolean(true);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class time_Command
    implements ZPEInternalFunction {
        private time_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(Instant.now().toEpochMilli());
        }

        public static String ManualHeader() {
            return "time ()";
        }

        public static String ManualEntry() {
            return "Gets the current epoch time in milliseconds.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_nanoseconds_Command
    implements ZPEInternalFunction {
        private get_nanoseconds_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPENumber(System.nanoTime());
        }

        public static String ManualHeader() {
            return "get_nanoseconds ()";
        }

        public static String ManualEntry() {
            return "Returns the current number of nanoseconds.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_environment_variables_Command
    implements ZPEInternalFunction {
        private get_environment_variables_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            ZPEMap vars = new ZPEMap();
            Map<String, String> env = System.getenv();
            for (String envName : env.keySet()) {
                vars.put(new ZPEString(envName), new ZPEString(env.get(envName)));
            }
            return vars;
        }

        public static String ManualHeader() {
            return "get_environment_variables ()";
        }

        public static String ManualEntry() {
            return "Returns a map of all environment variables and their values. ";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 123;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "System";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class get_object_property_Command
    implements ZPEInternalFunction {
        private get_object_property_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (!(parameters[0] instanceof ZPEObject)) {
                ZPECore.printError("Non-object type passed to list_object_properties function.");
                return new ZPEBoolean(false);
            }
            ZPEObject o = (ZPEObject)parameters[0];
            return o.getProperty(parameters[1].toString());
        }

        public static String ManualHeader() {
            return "get_object_property ({object} o, {string} property)";
        }

        public static String ManualEntry() {
            return "Returns the value of a property within an object using its name.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_object_properties_Command
    implements ZPEInternalFunction {
        private list_object_properties_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (!(parameters[0] instanceof ZPEObject)) {
                ZPECore.printError("Non-object type passed to list_object_properties function.");
                return new ZPEBoolean(false);
            }
            ZPEObject o = (ZPEObject)parameters[0];
            ZPEList output = new ZPEList();
            output.addAll(o.properties.keySet());
            return output;
        }

        public static String ManualHeader() {
            return "list_object_properties ({object} o)";
        }

        public static String ManualEntry() {
            return "Lists all properties of a given object.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class run_at_Command
    implements ZPEInternalFunction {
        private run_at_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (!(parameters[0] instanceof ZPEFunction)) {
                return new ZPEBoolean(false);
            }
            long time = HelperFunctions.stringToLong(parameters[1].toString());
            if (time <= Instant.now().toEpochMilli()) {
                ZPECore.printWarning("You cannot set a time in past.");
                return new ZPEBoolean(false);
            }
            long delay = time - Instant.now().toEpochMilli();
            ZPEFunction f = (ZPEFunction)parameters[0];
            Timer timer = new Timer();
            CronJob mTask = new CronJob(timer, f, true);
            timer.scheduleAtFixedRate((TimerTask)mTask, delay, time);
            return new ScheduledCommandObject(parent, (ZPEPropertyWrapper)parent.getCurrentFunction(), mTask);
        }

        public static String ManualHeader() {
            return "run_at ({fn} f, {integer} time)";
        }

        public static String ManualEntry() {
            return "Runs a function or lambda function within a separate thread at a specific time in the form of an epoch time.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 125;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class run_in_Command
    implements ZPEInternalFunction {
        private run_in_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            if (!(parameters[0] instanceof ZPEFunction)) {
                return new ZPEBoolean(false);
            }
            long time = HelperFunctions.stringToLong(parameters[1].toString());
            ZPEFunction f = (ZPEFunction)parameters[0];
            boolean once = false;
            if (parameters.length == 3) {
                once = ZPEHelperFunctions.ToBoolean(parameters[2]);
            }
            Timer t = new Timer();
            CronJob mTask = new CronJob(t, f, once);
            t.scheduleAtFixedRate((TimerTask)mTask, time, time);
            return new ScheduledCommandObject(parent, (ZPEPropertyWrapper)parent.getCurrentFunction(), mTask);
        }

        public static String ManualHeader() {
            return "run_in ({fn} f, {integer} delay[, {boolean} once])";
        }

        public static String ManualEntry() {
            return "Runs a function or lambda function within a separate thread repeatedly after a certain time. The once function will allow this to run just once then stop.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 125;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class run_in_thread_Command
    implements ZPEInternalFunction {
        private run_in_thread_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (!(parameters[0] instanceof ZPEFunction)) {
                return new ZPEBoolean(false);
            }
            ZPEFunction f = (ZPEFunction)parameters[0];
            Thread t = new Thread(new run_thread(f));
            t.setDaemon(true);
            t.start();
            return new ZPEBoolean(true);
        }

        public static String ManualHeader() {
            return "run_in_thread ({fn} f)";
        }

        public static String ManualEntry() {
            return "Runs a function or lambda function within a separate thread.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }

        static class run_thread
        implements Runnable {
            ZPEFunction f;

            public run_thread(ZPEFunction func) {
                this.f = func;
            }

            @Override
            public void run() {
                try {
                    this.f.run();
                }
                catch (ExitHalt e) {
                    System.exit(HelperFunctions.stringToInteger(e.getMessage()));
                }
                catch (ZPERuntimeException e) {
                    throw new RuntimeException(e);
                }
                catch (BreakPointHalt breakPointHalt) {
                    // empty catch block
                }
            }
        }
    }

    private static class grep_Command
    implements ZPEInternalFunction {
        private grep_Command() {
        }

        public static String ManualHeader() {
            return "grep ({string} path, {string} searchterm)";
        }

        public static String ManualEntry() {
            return "A function that runs a grep program underneath and translates it to ZPE file objects.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws IOException {
            if (parameters == null) {
                return null;
            }
            String path = parameters[0].toString();
            String term = parameters[1].toString();
            if (HelperFunctions.unixProgramExists("grep")) {
                String cmd = "grep -r '" + term + "' '" + path + "'";
                System.out.println(cmd);
                return new ZPEString(HelperFunctions.shellExec(cmd));
            }
            return new ZPEString("");
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return -4;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class do_nothing_Command
    implements ZPEInternalFunction {
        private do_nothing_Command() {
        }

        public static String ManualHeader() {
            return "do_nothing ()";
        }

        public static String ManualEntry() {
            return "A very special method that returns a new DoNothing value.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new DoNothingObject(parent, parent.getCurrentFunction());
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 125;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class get_call_stack_Command
    implements ZPEInternalFunction {
        private get_call_stack_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList zl = new ZPEList();
            for (ZPEFunction zpeFunction : parent.callStack) {
                zl.add(new ZPEString(zpeFunction.name));
            }
            return zl;
        }

        public static String ManualHeader() {
            return "get_call_stack ()";
        }

        public static String ManualEntry() {
            return "Returns the call stack as it is on the call of this method.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class is_function_Command
    implements ZPEInternalFunction {
        private is_function_Command() {
        }

        public static String ManualHeader() {
            return "is_function ({mixed} f)";
        }

        public static String ManualEntry() {
            return "Returns a boolean on whether or not __f__ is a function. This is a simplified and faster method than using the type function.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (parameters[0] instanceof ZPEFunction) {
                return new ZPEBoolean(true);
            }
            return new ZPEBoolean(false);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class create_variable_Command
    implements ZPEInternalFunction {
        private create_variable_Command() {
        }

        public static String ManualHeader() {
            return "create_variable (string name, mixed value)";
        }

        public static String ManualEntry() {
            return "Creates a local variable in the current context.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            Object n = parameters[0].toString();
            ZPEType v = parameters[1];
            ZPEFunction f = parent.getCurrentFunction();
            if (!((String)n).startsWith("$")) {
                n = "$" + (String)n;
            }
            if (!((String)n).substring(1).matches("_?([A-z][A-z0-9_~]*)")) {
                ZPECore.printError("Variable name string in incorrect format.");
                return new ZPEBoolean(false);
            }
            f.setProperty((String)n, v);
            return new ZPEBoolean(true);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 121;
        }

        public static int MinimumParameters() {
            return 2;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_global_variables_Command
    implements ZPEInternalFunction {
        private list_global_variables_Command() {
        }

        public static String ManualHeader() {
            return "list_global_variables ()";
        }

        public static String ManualEntry() {
            return "Returns a list that contains the identifiers of all global variables.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList output = new ZPEList();
            for (String key : parent.globalFunction.variableMap.keySet()) {
                if (key.startsWith("#")) continue;
                output.add(new ZPEString(key));
            }
            return output;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_parameters_Command
    implements ZPEInternalFunction {
        private list_parameters_Command() {
        }

        public static String ManualHeader() {
            return "list_parameters ()";
        }

        public static String ManualEntry() {
            return "Returns a list that contains the identifiers of all parameters in the current function.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            if (parent.getCurrentFunction() != null) {
                return parent.getCurrentFunction().getParameterIds();
            }
            return null;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_structures_Command
    implements ZPEInternalFunction {
        private list_structures_Command() {
        }

        public static String ManualHeader() {
            return "list_structures ()";
        }

        public static String ManualEntry() {
            return "Returns a list that contains the identifiers of all structures.";
        }

        private static void findStructures(ZPEList l, ZPEFunction x) {
            l.addAll((Collection)x.structureMap.keySet());
            l.addAll((Collection)x.abstractStructureMap.keySet());
            if (x.parent != null && x.parent instanceof ZPEFunction) {
                list_structures_Command.findStructures(l, (ZPEFunction)x.parent);
            }
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList output = new ZPEList();
            if (parent.getCurrentFunction() != null) {
                list_structures_Command.findStructures(output, parent.getCurrentFunction());
            }
            for (String s : ZPEInstance.BUILT_IN_STRUCTURES.keySet()) {
                output.add(new ZPEString(s));
            }
            return output;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class list_local_variables_Command
    implements ZPEInternalFunction {
        private list_local_variables_Command() {
        }

        public static String ManualHeader() {
            return "list_local_variables ()";
        }

        public static String ManualEntry() {
            return "Returns a list that contains the identifiers of all local variables.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEList output = new ZPEList();
            if (parent.getCurrentFunction() != null) {
                output.addAll(parent.getCurrentFunction().variableMap.keySet());
            }
            return output;
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 122;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class permission_level_of_Command
    implements ZPEInternalFunction {
        private permission_level_of_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String id = parameters[0].toString();
            if (Commands.contains(id)) {
                Class<? extends ZPEInternalFunction> l = YASSPredefinedFunctions.getInternalMethod(id);
                return new ZPENumber(YASSPredefinedFunctions.requiredPermissionLevels(l));
            }
            return new ZPENumber(-1);
        }

        public static String ManualHeader() {
            return "permission_level_of ({string} function_name)";
        }

        public static String ManualEntry() {
            return "Gets the permission level of a function given as a function handle.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 120;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class copy_of_Command
    implements ZPEInternalFunction {
        private copy_of_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEType o = parameters[0];
            if (o instanceof ZPECoreType) {
                return ((ZPECoreType)o).copyOfMe();
            }
            return o;
        }

        public static String ManualHeader() {
            return "copy_of ({mixed} value)";
        }

        public static String ManualEntry() {
            return "Returns a pure copy of a value.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 118;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class handle_of_Command
    implements ZPEInternalFunction {
        private handle_of_Command() {
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return parent.globalFunction.functionMap.get(parameters[0].toString());
        }

        public static String ManualHeader() {
            return "handle_of ({string} function_name)";
        }

        public static String ManualEntry() {
            return "Gets a function from it's name, __function_name__ and returns it. This gives the actual function, not a reference to it and therefore certain other functions will be able to take the function in.";
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 124;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class write_log_Command
    implements ZPEInternalFunction {
        private write_log_Command() {
        }

        public static String ManualHeader() {
            return "write_log({string} msg)";
        }

        public static String ManualEntry() {
            return "Writes a message, __msg__, to the ZPE Log.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String msg = parameters[0].toString();
            ZPECore.log(msg);
            return new ZPEString(msg);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class throw_error_Command
    implements ZPEInternalFunction {
        private throw_error_Command() {
        }

        public static String ManualHeader() {
            return "throw_error({object of type Exception} exception)";
        }

        public static String ManualEntry() {
            return "Throws an error with the message given in msg. If the error is not caught, ZPE will exit the program.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) throws ZPERuntimeException {
            if (parameters == null) {
                return null;
            }
            ZPEObject o = (ZPEObject)parameters[0];
            if (o instanceof ExceptionObject) {
                return new InternalException((ExceptionObject)o);
            }
            throw new IncorrectDataTypeException("throw_error", "Exception object");
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return -4;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "2.0";
        }
    }

    private static class std_new_line_Command
    implements ZPEInternalFunction {
        private std_new_line_Command() {
        }

        public static String ManualHeader() {
            return "std_new_line()";
        }

        public static String ManualEntry() {
            return "Gets the environment new line character. For instance, on macOS this is the \\n character.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            return new ZPEString(System.lineSeparator());
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class type_Command
    implements ZPEInternalFunction {
        private type_Command() {
        }

        public static String ManualHeader() {
            return "type ({mixed} o)";
        }

        public static String ManualEntry() {
            return "Returns the type of a variable stored in the memory or the type of a value. It's important to note that comparing types of values should not be done by comparing the result of the type command against a string value but it should be compared against another type function. E.g. the first example following is not recommended but the second example is:\n**type([32, 44]) == \"list\"** \n**type([32, 44]) == type([])** is.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            YASSByteCodes y = new YASSByteCodes();
            if (parameters[0] instanceof ZPEString) {
                return new ZPEString("STRING");
            }
            if (parameters[0] instanceof ZPEObject) {
                return new ZPEString("OBJECT");
            }
            if (parameters[0] instanceof ZPERecord) {
                return new ZPEString("RECORD");
            }
            return new ZPEString(y.symbolToString(ZPEHelperFunctions.getDataType(parameters[0])).toUpperCase());
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class pipe_Command
    implements ZPEInternalFunction {
        private pipe_Command() {
        }

        public static String ManualHeader() {
            return "pipe ({mixed} value, {function} func1, {function} func2, {function} func3, ..., {function} funcN)";
        }

        public static String ManualEntry() {
            return "Pushes a value quickly through a pipeline of functions. This saves writing a lot of code. E.g. pipe(5, doubleNum, addFour, squareNum) will take 5 as the value and apply three defined functions to it.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            ZPEType value = parameters[0];
            for (int i = 1; i < parameters.length; ++i) {
                FunctionReference fr = (FunctionReference)parameters[i];
                ZPEFunction f = parent.getCurrentFunction().getFunction(fr.functionName);
                ZPEVariable v = new ZPEVariable(f.parameterNames.get(0), value, parent.getCurrentFunction());
                f.parameterMap.put(f.parameterNames.get(0), v);
                try {
                    value = f.run();
                    continue;
                }
                catch (BreakPointHalt | ExitHalt e) {
                    throw new RuntimeException(e);
                }
            }
            return value;
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class run_process_Command
    implements ZPEInternalFunction {
        private run_process_Command() {
        }

        public static String ManualHeader() {
            return "run_process ({string} command)";
        }

        public static String ManualEntry() {
            return "Runs a shell command, for example a Bash command. It then returns a string with the return value of the command.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String cmd = parameters[0].toString();
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                ProcessObject proc = new ProcessObject(parent, parent.getCurrentFunction());
                proc.setProcess(p);
                return proc;
            }
            catch (IOException e) {
                throw new ZPERuntimeException(e.getMessage());
            }
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class shell_Command
    implements ZPEInternalFunction {
        private shell_Command() {
        }

        public static String ManualHeader() {
            return "shell ({string} command)";
        }

        public static String ManualEntry() {
            return "Runs a shell command, for example a Bash command. It then returns a string with the return value of the command.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String cmd = parameters[0].toString();
            try {
                return new ZPEString(HelperFunctions.shellExec(cmd));
            }
            catch (IOException e) {
                throw new ZPERuntimeException(e.getMessage());
            }
        }

        public static int RequiredPermissionLevel() {
            return 4;
        }

        public static byte ReturnType() {
            return 119;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class exit_Command
    implements ZPEInternalFunction {
        private exit_Command() {
        }

        public static String ManualHeader() {
            return "exit ([{string} message[, {integer} code]])";
        }

        public static String ManualEntry() {
            return "Optionally prints a message and then exits the program.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            String v;
            if (parameters == null) {
                return null;
            }
            int code = 0;
            if (parameters.length >= 1 && !(v = parameters[0].toString()).isEmpty()) {
                ZPECore.print(v);
            }
            if (parameters.length >= 2) {
                code = HelperFunctions.stringToInteger(parameters[1].toString());
            }
            return new ExitHalt(code);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return -4;
        }

        public static int MinimumParameters() {
            return 0;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.1";
        }
    }

    private static class run_command_Command
    implements ZPEInternalFunction {
        private run_command_Command() {
        }

        public static String ManualHeader() {
            return "run_command ({string} command)";
        }

        public static String ManualEntry() {
            return "Runs a single command from a string such as a mathematical expression and returns the return value from it. This allows on-the-fly interpreting. It can be used to return the value of a mathematical term such as: **~~run_command~~(\"5 + 5\")**.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String q = "return(" + parameters[0].toString() + ")";
            ZPERuntimeEnvironment j = new ZPERuntimeEnvironment(parent.getPermissionLevel());
            try {
                return new ZPEString(j.interpret(q, new ZPEType[0]).toString());
            }
            catch (Exception e) {
                return new ZPEString(e.getMessage());
            }
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 125;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }

    private static class run_script_Command
    implements ZPEInternalFunction {
        private run_script_Command() {
        }

        public static String ManualHeader() {
            return "run_script ({string} file)";
        }

        public static String ManualEntry() {
            return "Runs a script inside a new runtime environment. Scripts cannot directly interact as part of the sandbox feature, unless they are specifically instructed to via some kind of file system. If the script returns a value, this function will take that value as it's own return value.";
        }

        public static ZPEType MainMethod(ZPEType[] parameters, ZPERuntimeEnvironment parent) {
            if (parameters == null) {
                return null;
            }
            String f = parameters[0].toString();
            File m = new File(f);
            if (m.exists()) {
                try {
                    String q = FileHelperFunctions.readFileAsString(f, "utf-8");
                    ZPERuntimeEnvironment j = new ZPERuntimeEnvironment(parent.getPermissionLevel());
                    try {
                        return new ZPEString(j.interpret(q, new ZPEType[0]).toString());
                    }
                    catch (Exception e) {
                        return new ZPEString(e.getMessage());
                    }
                }
                catch (IOException e) {
                    return new ZPENumber(-1);
                }
            }
            return new ZPENumber(-1);
        }

        public static int RequiredPermissionLevel() {
            return 0;
        }

        public static byte ReturnType() {
            return 125;
        }

        public static int MinimumParameters() {
            return 1;
        }

        public static int Mode() {
            return 1;
        }

        public static String Category() {
            return "Core";
        }

        public static String Version() {
            return "1.0";
        }
    }
}

