/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import extensions.mindrot.BCrypt;
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.AbstractRecord;
import jamiebalfour.zpe.core.AbstractStructure;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.Pair;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.YASSCompiledProgram;
import jamiebalfour.zpe.core.YASSTemplateCompiler;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v5.ZenithParsingEngine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class YASSCompiler {
    private final Map<String, CompilerConstant> constantMap = new HashMap<String, CompilerConstant>();
    Stack<CompilerFunction> functionList = new Stack();
    CompilerModule currentModule = null;
    Map<String, ZPEType> globalVars = null;
    ZenithParsingEngine parser;
    CompilerFunction global = null;
    HashMap<String, String> directives = new HashMap();
    String[] acceptedDirectives = new String[]{"prevent_auto_includes", "requires_explicit_declaration"};
    HashMap<IAST, CompilerFunction> functionDefinitions = new HashMap();
    ArrayList<String> requiredLibraries = new ArrayList();
    private boolean requiresExplicitDeclaration = ZPEInstance.REQUIRE_EXPLICIT_VARIABLE_DECLARATION;
    private HashMap<String, IAST> labels = new HashMap();

    public YASSCompiler() {
        if (ZPEInstance.INTERACTIVE) {
            for (String c : ZPEInstance.INTERACTIVE_COMPILER_CONSTANTS.keySet()) {
                this.constantMap.put(c, ZPEInstance.INTERACTIVE_COMPILER_CONSTANTS.get(c));
            }
        }
    }

    static boolean astContainsFunctionOrStructure(IAST rootNode) {
        IAST cur = rootNode;
        while (cur.next != null) {
            cur = cur.next;
            if (cur.type != 12 && cur.type != 64) continue;
            return true;
        }
        return false;
    }

    IAST compile(String code) throws CompileException {
        this.parser = new ZenithParsingEngine(code, ZPEInstance.CASE_INSENSITIVE, new YASSByteCodes());
        this.functionList.clear();
        if (this.global == null) {
            this.global = new CompilerFunction(this);
        }
        this.functionList.add(this.global);
        if (this.globalVars != null) {
            for (String var : this.globalVars.keySet()) {
                this.global.vars.put(var, new CompilerFunction.CompilerFunctionVariable(ZPEHelperFunctions.getDataType(this.globalVars.get(var)), null));
            }
        }
        return this.compileToAST();
    }

    Pair compile(String code, String file, CompileDetails details, boolean includeMainFunction) throws IOException, CompileException {
        return this.compile(code, file, details, false, includeMainFunction, null, null);
    }

    Pair compile(String code, String file, CompileDetails details, boolean includeMainFunction, String passcode, String[] files) throws IOException, CompileException {
        return this.compile(code, file, details, false, includeMainFunction, passcode, files);
    }

    Pair compile(String code, String file, CompileDetails details, boolean caseInsensitive, boolean includeMainFunction, String passcode, String[] files) throws IOException, CompileException {
        CompilerFunction globalFunc = new CompilerFunction(this);
        this.functionList.clear();
        this.functionList.add(globalFunc);
        if (this.globalVars != null) {
            for (String var : this.globalVars.keySet()) {
                globalFunc.vars.put(var, new CompilerFunction.CompilerFunctionVariable(ZPEHelperFunctions.getDataType(this.globalVars.get(var)), null));
            }
        }
        ZPEInstance.CASE_INSENSITIVE = caseInsensitive;
        IAST rootNode = this.compile(code);
        if (!YASSCompiler.astContainsFunctionOrStructure(rootNode)) {
            return new Pair(2, null);
        }
        if (!((String)file).endsWith(".yex")) {
            file = (String)file + ".yex";
        }
        if ((Integer)rootNode.value > -2) {
            YASSCompiledExecutable output = this.compileProgramToFile((String)file, details, rootNode, includeMainFunction, passcode, files);
            return new Pair(0, output);
        }
        return new Pair(1, null);
    }

    ArrayList<String> generateCodeOutline(String code) throws CompileException {
        IAST root = this.compile(code);
        ArrayList<String> ouline = new ArrayList<String>();
        IAST current = root.next;
        while (current != null) {
            IAST innerCurrent;
            if (current.type == -17) {
                ouline.add(current.id);
                innerCurrent = (IAST)current.value;
                while (innerCurrent != null) {
                    if (innerCurrent.type == 12) {
                        ouline.add("    " + innerCurrent.id);
                    }
                    if (innerCurrent.type == 64) {
                        ouline.add("    " + innerCurrent.id);
                    }
                    innerCurrent = innerCurrent.next;
                }
            } else if (current.type == 12) {
                ouline.add(current.id);
                innerCurrent = current.left;
                while (innerCurrent != null) {
                    if (innerCurrent.type == 12) {
                        ouline.add("    " + innerCurrent.id);
                    }
                    innerCurrent = innerCurrent.next;
                }
            }
            current = current.next;
        }
        return ouline;
    }

    ArrayList<String> getModuleNames(String code) throws CompileException {
        IAST root = this.compile(code);
        ArrayList<String> modules = new ArrayList<String>();
        IAST current = root.next;
        while (current != null) {
            if (current.type == -17) {
                modules.add(current.id);
                IAST innerCurrent = current.left;
                while (innerCurrent != null) {
                    if (innerCurrent.type == -17) {
                        modules.add("    " + innerCurrent.id);
                    }
                    innerCurrent = innerCurrent.next;
                }
            }
            current = current.next;
        }
        return modules;
    }

    ArrayList<String> getFunctionNames(String code) throws CompileException {
        IAST root = this.compile(code);
        ArrayList<String> funcs = new ArrayList<String>();
        IAST current = root.next;
        while (current != null) {
            if (current.type == 12) {
                funcs.add(current.id);
                IAST innerCurrent = current.left;
                while (innerCurrent != null) {
                    if (innerCurrent.type == 12) {
                        funcs.add("    " + innerCurrent.id);
                    }
                    innerCurrent = innerCurrent.next;
                }
            }
            current = current.next;
        }
        return funcs;
    }

    boolean validateCode(String code) throws CompileException {
        YASSCompiler c = new YASSCompiler();
        IAST rootNode = new IAST();
        rootNode.value = (byte)-2;
        rootNode = c.compile(code);
        return (Integer)rootNode.value > -2;
    }

    private IAST compilerOptimise(IAST ast) {
        if (ast.next != null && (ast.next.type == 93 || ast.next.type == -14)) {
            ast.next = ast.next.next;
        }
        if (ast.type == 32 && ast.value instanceof IAST) {
            IAST v = (IAST)ast.value;
            if (v.type == -9 && v.value instanceof IAST) {
                v = (IAST)v.value;
                if (v.middle.type == 5 || v.middle.type == 6) {
                    Object value = v.middle.value;
                    IAST vx = new IAST();
                    vx.value = value;
                    vx.type = (byte)97;
                    ast.value = vx;
                    ast.middle.value = 1;
                }
            }
        }
        if (ast.left != null) {
            this.compilerOptimise(ast.left);
        }
        if (ast.middle != null) {
            this.compilerOptimise(ast.middle);
        }
        if (ast.next != null) {
            this.compilerOptimise(ast.next);
        }
        if (ast.value instanceof IAST) {
            this.compilerOptimise((IAST)ast.value);
        }
        return ast;
    }

    private YASSCompiledExecutable compileProgramToFile(String file, CompileDetails details, IAST a, boolean includeMain, String passcode, String[] files) throws IOException, StackOverflowError {
        String[] m;
        Iterator v2;
        String name = "";
        String author = "";
        if (details != null) {
            name = details.name;
            author = details.author;
        }
        FileOutputStream fout = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        YASSCompiledExecutable compiled_executable = new YASSCompiledExecutable();
        YASSCompiledProgram program = new YASSCompiledProgram();
        if (this.directives.containsKey("prevent_auto_includes") && this.directives.get("prevent_auto_includes").equalsIgnoreCase("true")) {
            compiled_executable.prevent_auto_includes = true;
        }
        ZPERuntimeEnvironment zx = new ZPERuntimeEnvironment();
        try {
            zx.globalTraverse(a.next);
        }
        catch (BreakPointHalt | ExitHalt | InternalException exception) {
        }
        catch (ZPEException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Pair> functions = new ArrayList<Pair>();
        for (String string : zx.globalFunction.functionMap.keySet()) {
            ZPEFunction zPEFunction = zx.globalFunction.functionMap.get(string);
            if ((string.equalsIgnoreCase("main") || string.equalsIgnoreCase("start") && includeMain) && !includeMain) continue;
            IAST function = new IAST();
            function.id = zPEFunction.name;
            function.scope = (byte)zPEFunction.scope;
            function.next = ZPEInstance.OPTIMISE_COMPILES ? this.compilerOptimise(zPEFunction.code) : zPEFunction.code;
            Pair pair = new Pair(zPEFunction.name, function);
            functions.add(pair);
        }
        int i = 0;
        program.functions = new Pair[functions.size()];
        Iterator iterator2 = functions.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            program.functions[i] = pair = (Pair)iterator2.next();
            ++i;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (Iterator v2 : zx.globalFunction.abstractStructureMap.keySet()) {
            AbstractStructure abstractStructure = (AbstractStructure)zx.globalFunction.abstractStructureMap.get(v2);
            if (abstractStructure.module != -1) continue;
            this.compilerOptimise(abstractStructure.code);
            m = new Pair(v2, abstractStructure);
            arrayList.add(m);
        }
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        for (String string : zx.globalFunction.abstractRecordMap.keySet()) {
            AbstractRecord record_struc = (AbstractRecord)zx.globalFunction.abstractRecordMap.get(string);
            if (record_struc.module != -1) continue;
            this.compilerOptimise(record_struc.code);
            Pair m4 = new Pair(string, record_struc);
            arrayList2.add(m4);
        }
        i = 0;
        program.structures = new Pair[arrayList.size()];
        v2 = arrayList.iterator();
        while (v2.hasNext()) {
            Pair pair;
            program.structures[i] = pair = (Pair)v2.next();
            ++i;
        }
        i = 0;
        program.record_structures = new Pair[arrayList2.size()];
        v2 = arrayList2.iterator();
        while (v2.hasNext()) {
            Pair pair;
            program.record_structures[i] = pair = (Pair)v2.next();
            ++i;
        }
        ArrayList<Pair> vars = new ArrayList<Pair>();
        for (String v3 : zx.globalFunction.variableMap.keySet()) {
            ZPEVariable var = zx.globalFunction.variableMap.get(v3);
            Pair m5 = new Pair(v3, var.getValue());
            vars.add(m5);
        }
        i = 0;
        program.variables = new Pair[vars.size()];
        Iterator iterator3 = vars.iterator();
        while (iterator3.hasNext()) {
            program.variables[i] = m = (Pair)iterator3.next();
            ++i;
        }
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (files != null) {
            for (String f : files) {
                hashMap.put(f, FileHelperFunctions.readFile(f));
            }
        }
        compiled_executable.files = hashMap;
        compiled_executable.experimental = ZPEInstance.EXPERIMENTAL;
        compiled_executable.name = name;
        compiled_executable.author = author;
        compiled_executable.time = System.currentTimeMillis();
        if (passcode != null) {
            String salt = BCrypt.gensalt();
            compiled_executable.passcode = BCrypt.hashpw(passcode, salt);
            String paddedKey = passcode;
            paddedKey = paddedKey.length() > 16 ? HelperFunctions.padString(paddedKey, 32) : HelperFunctions.padString(paddedKey, 16);
            try {
                compiled_executable.program = HelperFunctions.writeEncryptedObject((Object)program, paddedKey);
            }
            catch (StackOverflowError e) {
                throw e;
            }
            catch (Exception e) {
                oos.close();
                return null;
            }
        } else {
            compiled_executable.program = program;
        }
        oos.writeObject(compiled_executable);
        oos.close();
        return compiled_executable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void nextSymb() throws CompileException {
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 3) {
            CompilerConstant v;
            if (this.constantMap.containsKey(this.parser.getCurrentWord())) {
                v = this.constantMap.get(this.parser.getCurrentWord());
                this.parser.setCurrentWord(v.value);
                this.parser.setCurrentSymbol(v.type);
            } else if (ZPEInstance.CONSTANTS.containsKey(this.parser.getCurrentWord())) {
                v = ZPEInstance.CONSTANTS.get(this.parser.getCurrentWord());
                this.parser.setCurrentWord(v.value);
                this.parser.setCurrentSymbol(v.type);
            }
        }
        if (this.parser.getCurrentSymbol() != 81) return;
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 8) {
            if (this.parser.getCurrentWord().equalsIgnoreCase("online")) {
                this.nextSymb();
                String url = "https://www.jamiebalfour.scot/projects/zpe/online/read-code/?id=" + this.parser.getCurrentWord();
                try {
                    String result = ZPEHelperFunctions.readStringFromURL(url);
                    this.parser.insertProgramAtCounter(result);
                    return;
                }
                catch (IOException e) {
                    ZPECore.printError("ONLINE INCLUDES FAILED");
                }
                return;
            }
            try {
                throw new CompileException("Syntax error found in compilation at `INCLUDES` on line " + this.parser.getCurrentLine() + " when it expected STRING");
            }
            catch (CompileException e) {
                ZPECore.PrintCompileWarning("EXPECTED STRING AFTER INCLUDES");
                return;
            }
        }
        try {
            String p;
            String f = this.parser.getCurrentWord();
            if (new File(f).exists()) {
                p = FileHelperFunctions.readFileAsString(f, "utf-8");
                if (ZPEInstance.ALLOW_COMPILER_INCLUDES) {
                    this.parser.insertProgramAtCounter(" " + p + " ");
                } else {
                    ZPECore.PrintCompileWarning("WARNING: attempted to use ZPE INCLUDES yet it is disabled from the properties file.");
                }
            } else if (new File(ZPEInstance.SCRIPT_DIRECTORY + "/" + f).exists()) {
                if (ZPEInstance.ALLOW_COMPILER_INCLUDES) {
                    p = FileHelperFunctions.readFileAsString(ZPEInstance.SCRIPT_DIRECTORY + "/" + f, "utf-8");
                    this.parser.insertProgramAtCounter(" " + p + " ");
                } else {
                    ZPECore.PrintCompileWarning("WARNING: attempted to use ZPE INCLUDES yet it is disabled from the properties file.");
                }
            } else {
                ZPECore.PrintCompileWarning("ZPE INCLUDES: File not found " + f + " for inclusion.");
            }
        }
        catch (IOException e) {
            System.out.println("FAIL AT COMPILER INCLUDES");
        }
        this.parser.getNextSymbol();
    }

    private IAST compileToAST() throws CompileException {
        this.nextSymb();
        boolean failed = false;
        IAST rootNode = new IAST();
        rootNode.id = "Program";
        rootNode.value = 0;
        IAST currentNode = rootNode;
        long orgTime = System.nanoTime();
        while (this.parser.getCurrentSymbol() != -2) {
            if (System.nanoTime() - orgTime > 40000000000L) {
                throw new CompileException("Compiler error, took too long to complete.");
            }
            if (this.parser.getCurrentSymbol() == -1) {
                String remainder = this.parser.getProgram().substring(0, this.parser.getProgramCounter());
                StringBuilder charStr = new StringBuilder("[");
                for (char c : this.parser.getCurrentWord().toCharArray()) {
                    charStr.append((int)c).append(";");
                }
                charStr.append("]");
                if (!ZPEInstance.EXPERIMENTAL) {
                    ZPECore.printCompileError("Error in syntax at character " + this.parser.getProgramCounter() + ". ZPE found an unexpected symbol: \"" + this.parser.getCurrentWord() + "\" " + String.valueOf(charStr) + ". Full program: " + remainder);
                    break;
                }
                ZPECore.printCompileError("Error in syntax at character " + this.parser.getProgramCounter() + ". ZPE found an unexpected symbol: \"" + this.parser.getCurrentWord() + "\".");
                break;
            }
            currentNode.next = this.compileNode();
            while (currentNode.next != null) {
                currentNode = currentNode.next;
            }
            if (this.parser.getCurrentSymbol() == -2) {
                ZPECore.printCompileError("Invalid symbol or word: " + this.parser.getCurrentWord() + " at character " + this.parser.getProgramCounter() + ".");
                failed = true;
                break;
            }
            this.nextSymb();
        }
        if (failed) {
            rootNode.value = (byte)-2;
            return null;
        }
        IAST labelNode = new IAST();
        labelNode.value = this.labels;
        rootNode.left = labelNode;
        for (IAST fud : this.functionDefinitions.keySet()) {
            if (!this.functionDefinitions.get((Object)fud).vars.containsKey(fud.id)) continue;
            fud.type = (byte)4;
        }
        return rootNode;
    }

    private CompilerFunction getCurrentFunction() {
        return this.functionList.peek();
    }

    private boolean variableExists(String id) {
        for (CompilerFunction f : this.functionList) {
            if (!f.vars.containsKey(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isTuple() {
        int peeks = 1;
        if (this.parser.getCurrentSymbol() == 18) {
            while (this.parser.peekAhead(peeks) != 19) {
                if (this.parser.peekAhead(++peeks) != 20) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTupleDeconstruction() {
        int peeks = 1;
        if (this.parser.getCurrentSymbol() == 18) {
            while (this.parser.peekAhead(peeks) != 19) {
                ++peeks;
            }
            return this.parser.peekAhead(peeks + 1) == 16;
        }
        return false;
    }

    private boolean isAcceptableIdentifier(byte t) {
        return t == 3 || t == 95 || t == 110 || t == 28;
    }

    private boolean matchesName(int symb, int peek2) {
        return symb == 3 || symb == 4 && peek2 == 18;
    }

    private boolean matchesAnonymousFunction() {
        if (this.parser.getCurrentSymbol() == 18) {
            int peeker;
            if (this.parser.peekAhead() == 4 && this.parser.peekAhead(2) == 3) {
                peeker = 2;
            } else if (this.parser.peekAhead() == 3) {
                peeker = 1;
            } else if (ZPEHelperFunctions.isTypeByte(this.parser.peekAhead()) && this.parser.peekAhead(2) == 4 && this.parser.peekAhead(3) == 3) {
                peeker = 3;
            } else if (ZPEHelperFunctions.isTypeByte(this.parser.peekAhead()) && this.parser.peekAhead(2) == 3) {
                peeker = 2;
            } else {
                return false;
            }
            while (this.parser.peekAhead(peeker) != 19) {
                ++peeker;
            }
            return this.parser.peekAhead(peeker + 1) == 11 && this.parser.peekAhead(peeker + 2) == 53;
        }
        return false;
    }

    private boolean matchesModuleCall() {
        int i = 1;
        if (this.parser.getCurrentSymbol() != 3) {
            return false;
        }
        byte peek = this.parser.peekAhead();
        byte peek2 = this.parser.peekAhead(2);
        if (this.parser.peekAhead() == 58 && this.parser.peekAhead(2) == 3) {
            i += 2;
            while (this.parser.peekAhead(i) == 58 && this.parser.peekAhead(i + 1) == 3) {
                i += 2;
            }
        }
        return this.parser.peekAhead(i) == 113 && this.parser.peekAhead(i + 1) == 3 && this.parser.peekAhead(i + 2) == 18;
    }

    private IAST compileNode() throws CompileException {
        byte current = this.parser.getCurrentSymbol();
        byte peek1 = this.parser.peekAhead(1);
        byte peek2 = this.parser.peekAhead(2);
        int start = this.parser.getProgramCounter();
        IAST out = null;
        String label = null;
        if (current == -19) {
            this.parser.getNextSymbol();
            label = this.parser.getCurrentWord();
            this.parser.getNextSymbol();
            current = this.parser.getCurrentSymbol();
            peek1 = this.parser.peekAhead(1);
            peek2 = this.parser.peekAhead(2);
        }
        if (current == 72 && peek1 != -12) {
            out = this.parser.peekAheadWord(1).startsWith("\"") ? this.compileUnescapedString() : this.compileAtDocumentation();
        } else if (current == 72) {
            out = this.compileDirective();
        } else if (current == 95) {
            out = this.compileCount();
        } else if (current == 14) {
            out = this.compileIsSet();
        } else if (current == 15) {
            out = this.compileUnset();
        } else if (current == 13) {
            out = this.compileEmpty();
        } else if (current == -14) {
            out = this.compileBreakpoint();
        } else if (current == 114 && peek1 == 18 && (peek2 == 4 || peek2 == 3)) {
            out = this.compileGlobal();
        } else if (current == 84) {
            out = this.compileReturn();
        } else if (current == 85) {
            out = this.compileBreak();
        } else if (current == 112) {
            out = this.compileFunction();
        } else if (current == 3 && peek1 == 113) {
            out = this.compileModuleCall();
        } else if (current == 12 && peek1 != 4 && peek1 != 87 && peek1 != 3 && peek2 != 16) {
            out = this.compileFunction();
        } else if (ZPEHelperFunctions.isScopeByte(current, true) && peek1 == 112 && peek2 == 12 || peek1 == 12) {
            out = this.compileFunction();
        } else if (current == 64) {
            out = this.compileStructure();
        } else if (current == -17) {
            out = this.compileModule();
        } else if (ZPEHelperFunctions.isScopeByte(current, false) && peek1 == 64) {
            out = this.compileStructure();
        } else if (current == 110) {
            out = this.compileRecord();
        } else if (current == -18) {
            out = this.compileGoTo();
        } else if (ZPEHelperFunctions.isScopeByte(current, false) && peek1 == 110) {
            out = this.compileRecord();
        } else if (current == 75) {
            out = this.compileTry();
        } else if (current == 21) {
            out = this.compileIf();
        } else if (current == 24 || current == 26) {
            out = this.compileWhen();
        } else if (current == 30) {
            out = this.compileWhile();
        } else if (current == 52) {
            out = this.compileDoWhile();
        } else if (current == 98 && peek1 == 31) {
            out = this.compileLoopUntil();
        } else if (current == 32 && peek1 == 61) {
            out = this.compileForEach();
        } else if (current == 32) {
            out = this.compileFor();
        } else if (current == 101) {
            out = this.compileMatchExpression();
        }
        if (out != null) {
            out.programStart = start;
            out.programEnd = this.parser.getProgramCounter();
            return out;
        }
        if (current == 48 && peek1 == 4) {
            out = this.compilePreIncrement();
        } else if (current == 49 && peek1 == 4) {
            out = this.compilePreDecrement();
        } else if (current == 4 && peek2 == 48) {
            out = this.compilePostIncrement();
        } else if (current == 4 && peek2 == 49) {
            out = this.compilePostDecrement();
        } else if (current == 48 && peek1 == 3) {
            out = this.compilePreIncrement();
        } else if (current == 49 && peek1 == 3) {
            out = this.compilePreDecrement();
        } else if (current == 3 && peek1 == 48) {
            out = this.compilePostIncrement();
        } else if (current == 3 && peek1 == 49) {
            out = this.compilePostDecrement();
        } else if (current == 109 || current == 4 || current == 70 || current == 87) {
            out = this.compileVar();
        } else if (current == 105) {
            out = this.compileVar();
        } else if (current == 3 && peek1 == 16) {
            out = this.compileVar();
        } else if (ZPEHelperFunctions.isScopeByte(current, false) && (peek1 == 4 || peek1 == 109 || ZPEHelperFunctions.isTypeByte(peek1))) {
            out = this.compileVar();
        } else if (ZPEHelperFunctions.isTypeByte(current) && (peek1 == 4 || peek1 == 3 && peek2 == 16)) {
            out = this.compileVar();
        } else if (this.parser.getPreviousSymbol() == 66 && current == 3 && peek1 != 18) {
            out = this.compileVar();
        } else if (current == 3 && this.variableExists(this.parser.getCurrentWord())) {
            out = this.compileVar();
        } else if (current == 12) {
            out = this.compileFunction();
        } else if (current == 92 || current == 106) {
            out = this.compileVar();
        } else if (current == 18 && this.isTupleDeconstruction()) {
            out = this.compileDestructuringAssignment();
        } else if (current == 93) {
            out = this.compileAssertion();
        } else if (current == 82) {
            out = this.compileImport();
        } else if (current == 86) {
            out = this.compileNegation();
        } else if (current == 114 && peek1 == 18 && (peek2 == 4 || peek2 == 3)) {
            out = this.compileGlobal();
        } else if (this.matchesModuleCall()) {
            out = this.compileModuleCall();
        } else if (current == 3 && peek1 == 18) {
            out = this.compileIdentifier();
        } else if (current == 50) {
            out = this.compileList();
        } else if (current == 53) {
            out = this.compileObject();
        } else if (current == 65) {
            out = this.compileNewStructure();
        } else if (current == 57) {
            out = this.compileNegative();
        } else {
            out = new IAST();
            out.type = current;
            out.value = this.parser.getCurrentWord();
        }
        out = this.compileDotExpression(out);
        if (out != null) {
            out.programStart = start;
            out.programEnd = this.parser.getProgramCounter();
        }
        if (label != null) {
            this.labels.put(label, out);
        }
        return out;
    }

    private IAST compileGoTo() {
        IAST out = new IAST();
        out.type = (byte)-18;
        this.parser.getNextSymbol();
        out.id = this.parser.getCurrentWord();
        return out;
    }

    private IAST compileInnerExpression(boolean jump) throws CompileException {
        IAST expr = new IAST();
        if (jump) {
            this.nextSymb();
        }
        IAST n = new IAST();
        byte peek1 = this.parser.peekAhead(1);
        byte peek2 = this.parser.peekAhead(2);
        if (this.parser.getCurrentSymbol() == 48 && peek1 == 4) {
            n = this.compilePreIncrement();
        } else if (this.parser.getCurrentSymbol() == 48 && peek1 == 3) {
            n = this.compilePreIncrement();
        } else if (this.parser.getCurrentSymbol() == 49 && peek1 == 4) {
            n = this.compilePreDecrement();
        } else if (this.parser.getCurrentSymbol() == 49 && peek1 == 3) {
            n = this.compilePreDecrement();
        } else if (this.parser.getCurrentSymbol() == 115) {
            n = this.compileInlineIteration();
        } else if (this.parser.getCurrentSymbol() == 4 && peek2 == 48) {
            n = this.compilePostIncrement();
        } else if (this.parser.getCurrentSymbol() == 3 && peek1 == 48) {
            n = this.compilePostIncrement();
        } else if (this.parser.getCurrentSymbol() == 4 && peek2 == 49) {
            n = this.compilePostDecrement();
        } else if (ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol()) && (peek1 == 4 || peek1 == 3)) {
            n = this.compileVar();
        } else if (this.parser.getCurrentSymbol() == -16) {
            n = this.compileTemplate();
        } else if (this.parser.getCurrentSymbol() == 3 && peek1 == 49) {
            n = this.compilePostDecrement();
        } else if (this.parser.getCurrentSymbol() == 72 && this.parser.peekAheadWord(1).startsWith("\"")) {
            n = this.compileUnescapedString();
        } else if (this.parser.getCurrentSymbol() == 95) {
            n = this.compileCount();
        } else if (this.parser.getCurrentSymbol() == 3 && peek1 == 113) {
            n = this.compileModuleCall();
        } else if (this.parser.getCurrentSymbol() == -15) {
            n = this.compileType();
        } else if (this.parser.getCurrentSymbol() == 14) {
            n = this.compileIsSet();
        } else {
            if (this.parser.getCurrentSymbol() == 15) {
                return this.compileUnset();
            }
            if (this.parser.getCurrentSymbol() == 13) {
                return this.compileEmpty();
            }
            if (this.parser.getCurrentSymbol() == 109 || this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 70) {
                n = this.compileVar();
            } else if (this.parser.getCurrentSymbol() == 3 && this.variableExists(this.parser.getCurrentWord())) {
                n = this.compileVar();
            } else if (this.parser.getCurrentSymbol() == 3 && !this.variableExists(this.parser.getCurrentWord()) && peek1 != 18) {
                n = this.compileFunctionDefinition();
            } else if (this.parser.getCurrentSymbol() == 87) {
                n = this.compileVar();
            } else if (this.parser.getCurrentSymbol() == 12 && peek2 != 16) {
                n = this.compileFunction();
            } else if (this.parser.getCurrentSymbol() == -11) {
                n = this.compileCast();
            } else if (this.parser.getCurrentSymbol() == 101) {
                n = this.compileMatchExpression();
            } else if (this.matchesAnonymousFunction()) {
                n = this.compileAnonymousFunction();
            } else if (this.parser.getCurrentSymbol() == 18 && this.parser.peekAhead() == 19 && this.parser.peekAhead(2) == 11) {
                n = this.compileAnonymousFunction();
            } else if (this.parser.getCurrentSymbol() == 92) {
                n = this.compileVar();
            } else if (this.parser.getCurrentSymbol() == 86) {
                n = this.compileNegation();
            } else if (this.parser.getCurrentSymbol() == 3 && peek1 == 74) {
                n = this.compileIdentifier();
            } else if (this.matchesName(this.parser.getCurrentSymbol(), peek2)) {
                n = this.compileIdentifier();
            } else if (this.parser.getCurrentSymbol() == 50) {
                n = this.compileList();
            } else if (this.parser.getCurrentSymbol() == 53) {
                n = this.compileObject();
            } else if (this.parser.getCurrentSymbol() == 65) {
                n = this.compileNewStructure();
            } else if (this.parser.getCurrentSymbol() == 78) {
                n.type = (byte)5;
                n.value = this.parser.getCurrentWord().charAt(0) == '0' ? Long.valueOf(Long.parseLong(this.parser.getCurrentWord().substring(2), 16)) : Long.valueOf(-Long.parseLong(this.parser.getCurrentWord().substring(2), 16));
            } else if (this.parser.getCurrentSymbol() == 79) {
                n.type = (byte)5;
                n.value = this.parser.getCurrentWord().charAt(0) == '0' ? Long.valueOf(Long.parseLong(this.parser.getCurrentWord().substring(2), 8)) : Long.valueOf(-Long.parseLong(this.parser.getCurrentWord().substring(2), 8));
            } else if (this.parser.getCurrentSymbol() == 80) {
                n.type = (byte)5;
                n.value = this.parser.getCurrentWord().charAt(0) == '0' ? Long.valueOf(Long.parseLong(this.parser.getCurrentWord().substring(2), 2)) : Long.valueOf(-Long.parseLong(this.parser.getCurrentWord().substring(2), 2));
            } else if (this.parser.getCurrentSymbol() == 18) {
                n.type = this.parser.getCurrentSymbol();
                n.value = this.compileExpression((boolean)true).value;
                this.nextSymb();
            } else if (this.parser.getCurrentSymbol() == 57) {
                n.type = (byte)91;
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 3 && this.parser.peekAhead() != 18) {
                    n.value = this.compileVar();
                } else {
                    IAST val = new IAST();
                    val.type = this.parser.getCurrentSymbol();
                    String cur = this.parser.getCurrentWord();
                    val.value = cur.matches("[+-]?\\d+") ? (Number)HelperFunctions.stringToLong(cur) : (Number)HelperFunctions.stringToDouble(cur);
                    n.value = val;
                }
            } else if (this.parser.getCurrentSymbol() == -4) {
                n.type = (byte)-4;
            } else if (this.parser.getCurrentSymbol() == 7) {
                n.type = (byte)7;
                n.value = false;
                String cur = this.parser.getCurrentWord();
                if (cur.equals("true")) {
                    n.value = true;
                }
            } else if (this.parser.getCurrentSymbol() == 99) {
                n = this.compileInlineDoc();
            } else if (this.parser.getCurrentSymbol() == 5) {
                n.type = this.parser.getCurrentSymbol();
                n.value = HelperFunctions.stringToLong(this.parser.getCurrentWord());
            } else if (this.parser.getCurrentSymbol() == 6) {
                n.type = this.parser.getCurrentSymbol();
                n.value = HelperFunctions.stringToDouble(this.parser.getCurrentWord());
            } else if (this.parser.getCurrentSymbol() == -3) {
                n.type = this.parser.getCurrentSymbol();
                n.value = ZPECore.UNDEFINED;
            } else {
                if (this.parser.getCurrentSymbol() == -1) {
                    throw new CompileException("Syntax error found in compilation at `EXPRESSION` on line " + this.parser.getCurrentLine() + " when it expected EXPRESSION");
                }
                n.type = this.parser.getCurrentSymbol();
                n.value = this.parser.getCurrentWord();
            }
        }
        n = this.compileDotExpression(n);
        byte peek = this.parser.peekAhead();
        if (peek == 77 || this.parser.getCurrentSymbol() == 77) {
            if (peek == 77) {
                this.nextSymb();
            }
            IAST temp = new IAST();
            temp.type = (byte)77;
            temp.left = n;
            temp.next = this.compileExpression(true);
            n = temp;
        }
        if (!ZPEHelperFunctions.isMathsOperatorByte(peek) && peek != 49) {
            return n;
        }
        expr.left = n;
        this.nextSymb();
        if (peek != 49) {
            expr.type = this.parser.getCurrentSymbol();
            expr.next = this.compileInnerExpression(true);
        } else {
            expr.type = (byte)57;
            expr.next = this.compileInnerExpression(false);
        }
        return expr;
    }

    private IAST compileInlineIteration() throws CompileException {
        IAST values2;
        IAST out = new IAST();
        out.type = (byte)115;
        if (this.parser.getCurrentSymbol() == 115) {
            this.nextSymb();
        }
        IAST lower = this.compileNode();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 97) {
            this.nextSymb();
        }
        IAST upper = this.compileNode();
        out.left = values2 = new IAST();
        values2.left = lower;
        values2.middle = upper;
        if (this.parser.peekAhead() == 74) {
            this.nextSymb();
            this.nextSymb();
            out.middle = this.compileFunction();
        }
        return out;
    }

    private IAST compileNegative() throws CompileException {
        IAST out = new IAST();
        out.type = (byte)91;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 3 && this.parser.peekAhead() != 18) {
            out.value = this.compileVar();
        } else {
            IAST val = new IAST();
            val.type = this.parser.getCurrentSymbol();
            String cur = this.parser.getCurrentWord();
            val.value = cur.matches("[+-]?\\d+") ? (Number)HelperFunctions.stringToLong(cur) : (Number)HelperFunctions.stringToDouble(cur);
            out.value = val;
        }
        return out;
    }

    private IAST compileDotExpression(IAST tree) throws CompileException {
        if (this.parser.peekAhead() == 67 || this.parser.getCurrentSymbol() == 67) {
            if (this.parser.peekAhead() == 67) {
                this.nextSymb();
            }
            this.nextSymb();
            IAST out = new IAST();
            out.type = (byte)67;
            out.left = tree;
            if (this.parser.peekAhead() == 18) {
                out.value = this.compileIdentifier();
            } else {
                IAST var = new IAST();
                var.id = this.parser.getCurrentWord();
                var.type = (byte)4;
                out.value = this.parser.peekAhead() == 16 ? this.compileAssign(var, false, false) : var;
            }
            return this.compileDotExpression(out);
        }
        return tree;
    }

    private IAST compileAtDocumentation() throws CompileException {
        HashMap<String, String> docs = new HashMap<String, String>();
        while (this.parser.getCurrentSymbol() == 72) {
            this.nextSymb();
            String type = this.parser.getCurrentWord();
            if (!(this.parser.getCurrentWord().equals("doc") || this.parser.getCurrentWord().equals("author") || this.parser.getCurrentWord().equals("date"))) {
                throw new CompileException("Syntax error found in compilation at `DOCUMENTATION` on line " + this.parser.getCurrentLine() + " when it expected DOC");
            }
            this.nextSymb();
            docs.put(type, this.parser.getCurrentWord());
            this.nextSymb();
        }
        IAST node = this.compileNode();
        if (node.type != 64 && node.type != 12) {
            if (node.middle == null) {
                node.middle = new IAST();
                node.middle.type = (byte)72;
                node.middle.value = docs;
            } else {
                System.out.println("In use");
            }
        }
        return node;
    }

    private IAST compileDirective() throws CompileException {
        this.nextSymb();
        this.nextSymb();
        String property = this.parser.getCurrentWord();
        this.nextSymb();
        if (!this.isAcceptedDirective(property)) {
            ZPECore.printCompileError("Directive " + property + " not an accepted directive to ZPE/YASS.");
        }
        if (this.parser.getCurrentSymbol() != 74) {
            throw new CompileException("Syntax error found in compilation at `DIRECTIVE` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        this.nextSymb();
        String value = this.parser.getCurrentWord();
        this.directives.put(property, value);
        if (property.equals("requires_explicit_declaration") && value.equalsIgnoreCase("true")) {
            this.requiresExplicitDeclaration = true;
        }
        this.nextSymb();
        if (this.parser.hasNext()) {
            return this.compileNode();
        }
        return null;
    }

    private IAST compilePreIncrement() throws CompileException {
        if (this.parser.getCurrentSymbol() != 48) {
            throw new CompileException("Syntax error found in compilation at `PRE_INCREMENT` on line " + this.parser.getCurrentLine() + " when it expected INCREMENT");
        }
        this.nextSymb();
        if (!(this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 3 && this.variableExists(this.parser.getCurrentWord()))) {
            throw new CompileException("Syntax error found in compilation at `PRE_INCREMENT` on line " + this.parser.getCurrentLine() + " when it expected VAR");
        }
        Object name = "";
        if (this.parser.getCurrentSymbol() != 3 || !this.variableExists(this.parser.getCurrentWord())) {
            this.nextSymb();
            name = "$";
        }
        name = (String)name + this.parser.getCurrentWord();
        IAST output = new IAST();
        output.id = name;
        output.type = (byte)45;
        return output;
    }

    private IAST compilePostIncrement() throws CompileException {
        if (!(this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 3 && this.variableExists(this.parser.getCurrentWord()))) {
            throw new CompileException("Syntax error found in compilation at `POST_INCREMENT` on line " + this.parser.getCurrentLine() + " when it expected VAR");
        }
        Object name = "";
        if (this.parser.getCurrentSymbol() != 3 || !this.variableExists(this.parser.getCurrentWord())) {
            this.nextSymb();
            name = "$";
        }
        name = (String)name + this.parser.getCurrentWord();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 48) {
            throw new CompileException("Syntax error found in compilation at `POST_INCREMENT` on line " + this.parser.getCurrentLine() + " when it expected INCREMENT");
        }
        IAST output = new IAST();
        output.id = name;
        output.type = (byte)44;
        return output;
    }

    private IAST compilePreDecrement() throws CompileException {
        if (this.parser.getCurrentSymbol() != 49) {
            throw new CompileException("Syntax error found in compilation at `PRE_DECREMENT` on line " + this.parser.getCurrentLine() + " when it expected DECREMENT");
        }
        this.nextSymb();
        if (!(this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 3 && this.variableExists(this.parser.getCurrentWord()))) {
            throw new CompileException("Syntax error found in compilation at `PRE_DECREMENT` on line " + this.parser.getCurrentLine() + " when it expected VAR");
        }
        Object name = "";
        if (this.parser.getCurrentSymbol() != 3 || !this.variableExists(this.parser.getCurrentWord())) {
            this.nextSymb();
            name = "$";
        }
        name = (String)name + this.parser.getCurrentWord();
        IAST output = new IAST();
        output.id = name;
        output.type = (byte)47;
        return output;
    }

    private IAST compilePostDecrement() throws CompileException {
        if (!(this.parser.getCurrentSymbol() == 4 || this.parser.getCurrentSymbol() == 3 && this.variableExists(this.parser.getCurrentWord()))) {
            throw new CompileException("Syntax error found in compilation at `POST_DECREMENT` on line " + this.parser.getCurrentLine() + " when it expected VAR");
        }
        Object name = "";
        if (this.parser.getCurrentSymbol() != 3 || !this.variableExists(this.parser.getCurrentWord())) {
            this.nextSymb();
            name = "$";
        }
        name = (String)name + this.parser.getCurrentWord();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 49) {
            throw new CompileException("Syntax error found in compilation at `POST_DECREMENT` on line " + this.parser.getCurrentLine() + " when it expected DECREMENT");
        }
        IAST output = new IAST();
        output.id = name;
        output.type = (byte)46;
        return output;
    }

    private IAST compileGlobal() throws CompileException {
        IAST n = new IAST();
        n.type = (byte)114;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `GLOBAL` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 4) {
            this.nextSymb();
            n.id = "$" + this.parser.getCurrentWord();
        } else if (this.parser.getCurrentSymbol() == 3) {
            n.id = this.parser.getCurrentWord();
        } else {
            throw new CompileException("Syntax error found in compilation at `GLOBAL` on line " + this.parser.getCurrentLine() + " when it expected UNSUPPORTED GLOBAL");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `GLOBAL` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        return n;
    }

    private IAST compileModuleCall() throws CompileException {
        IAST node = new IAST();
        node.type = (byte)3;
        node.id = this.parser.getCurrentWord();
        if (this.parser.peekAhead() == 58 && this.parser.peekAhead(2) == 3) {
            StringBuilder id = new StringBuilder();
            this.nextSymb();
            this.nextSymb();
            while (this.parser.getCurrentSymbol() == 3 && this.parser.peekAhead() == 58) {
                id.append("/").append(this.parser.getCurrentWord());
                this.nextSymb();
                this.nextSymb();
            }
            node.id = node.id + "/" + this.parser.getCurrentWord();
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 113) {
            throw new CompileException("Syntax error found in compilation at `STATIC_CALL` on line " + this.parser.getCurrentLine() + " when it expected ::");
        }
        this.nextSymb();
        node.id = node.id + "~" + this.parser.getCurrentWord();
        if (this.parser.getCurrentSymbol() != 3) {
            throw new CompileException("Syntax error found in compilation at `STATIC_CALL` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
        }
        if (this.parser.peekAhead() != 18) {
            node.type = (byte)4;
            return node;
        }
        this.nextSymb();
        node.value = this.compileArguments();
        return node;
    }

    private IAST compileVar() throws CompileException {
        IAST out;
        IAST cur;
        boolean isObjectPointer = false;
        boolean isLet = false;
        boolean isTyped = false;
        boolean isStatic = false;
        byte type = -1;
        IAST n = new IAST();
        if (this.parser.getCurrentSymbol() == 66) {
            isObjectPointer = true;
            this.nextSymb();
        }
        n.scope = 0;
        if (this.parser.getPreviousSymbol() == 1) {
            n.scope = 1;
        } else if (this.parser.getPreviousSymbol() == 2) {
            n.scope = (byte)2;
        } else if (this.parser.getCurrentSymbol() == 1) {
            n.scope = 1;
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 2) {
            n.scope = (byte)2;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 112) {
            this.nextSymb();
        }
        if (ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol())) {
            isTyped = true;
            type = this.parser.getCurrentSymbol();
            if (type == 12) {
                type = 124;
            }
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 87) {
            this.nextSymb();
            n.type = (byte)87;
            if (!this.isAcceptableIdentifier(this.parser.getCurrentSymbol())) {
                throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
            }
            n.id = "$" + this.parser.getCurrentWord();
        } else if (this.parser.getCurrentSymbol() == 4) {
            this.nextSymb();
            n.type = (byte)4;
            if (!this.isAcceptableIdentifier(this.parser.getCurrentSymbol())) {
                throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
            }
            n.id = "$" + this.parser.getCurrentWord();
        } else if (this.parser.getPreviousSymbol() == 66 && this.parser.getCurrentSymbol() == 3) {
            if (this.parser.peekAhead() == 18) {
                return this.compileIdentifier();
            }
            n.type = (byte)4;
            if (!this.isAcceptableIdentifier(this.parser.getCurrentSymbol())) {
                throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
            }
            n.id = this.parser.getCurrentWord();
        } else {
            if (this.parser.getCurrentSymbol() == 92 || this.parser.getCurrentSymbol() == 106) {
                byte peek;
                this.nextSymb();
                String name = this.parser.getCurrentWord();
                if (this.parser.peekAhead() != 16 && this.parser.peekAhead() != 62) {
                    throw new CompileException("Syntax error found in compilation at `CONSTANT` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
                }
                this.nextSymb();
                this.nextSymb();
                CompilerConstant value = new CompilerConstant(this.parser.getCurrentWord(), this.parser.getCurrentSymbol());
                if (this.parser.getCurrentSymbol() != 5 && this.parser.getCurrentSymbol() != 6 && this.parser.getCurrentSymbol() != 8 && this.parser.getCurrentSymbol() != 7 && this.parser.getCurrentSymbol() != 78 && this.parser.getCurrentSymbol() != 79 && this.parser.getCurrentSymbol() != 80) {
                    throw new CompileException("Syntax error found in compilation at `CONSTANT` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
                }
                this.constantMap.put(name, value);
                if (ZPEInstance.INTERACTIVE) {
                    ZPEInstance.INTERACTIVE_COMPILER_CONSTANTS.put(name, value);
                }
                if (ZPEHelperFunctions.isMathsOperatorByte(peek = this.parser.peekAhead()) || ZPEHelperFunctions.isLogicalOperatorByte(peek) || ZPEHelperFunctions.isComparatorSymbolByte(peek)) {
                    throw new CompileException("Syntax error found in compilation at `CONSTANT` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
                }
                return null;
            }
            if (this.parser.getCurrentSymbol() == 70) {
                n.type = (byte)70;
                n.id = this.parser.getCurrentWord();
            } else if (this.parser.getCurrentSymbol() == 105 || this.parser.getCurrentSymbol() == 109) {
                if (this.parser.getCurrentSymbol() == 105) {
                    isLet = true;
                } else if (this.parser.getCurrentSymbol() == 109) {
                    isTyped = true;
                }
                this.nextSymb();
                Object id = "";
                if (this.parser.getCurrentSymbol() == 4) {
                    id = "$";
                    this.nextSymb();
                    if (!this.isAcceptableIdentifier(this.parser.getCurrentSymbol())) {
                        throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
                    }
                } else if (this.parser.getCurrentSymbol() != 3) {
                    throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
                }
                id = (String)id + this.parser.getCurrentWord();
                n.type = (byte)4;
                n.id = id;
            } else if (this.parser.getCurrentSymbol() == 3 && ZPEInstance.ALLOW_UNBOUND_VARIABLES) {
                if (!this.getCurrentFunction().containsKey(this.parser.getCurrentWord()) && this.parser.peekAhead() != 16) {
                    throw new CompileException("Compile undeclared variable error at line " + this.parser.getCurrentLine() + ". The variable " + this.parser.getCurrentWord() + " is undefined.");
                }
                n.type = (byte)4;
                if (this.parser.getCurrentSymbol() != 3) {
                    throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
                }
                n.id = this.parser.getCurrentWord();
                this.getCurrentFunction().setVariable(this.parser.getCurrentWord(), type);
            }
        }
        if (this.parser.peekAhead() == 50) {
            IAST outer = new IAST();
            this.nextSymb();
            this.nextSymb();
            IAST value = this.compileExpression(false);
            outer.type = (byte)88;
            outer.left = n;
            if (this.parser.peekAhead() == 74) {
                IAST range = new IAST();
                range.type = (byte)74;
                this.nextSymb();
                this.nextSymb();
                range.left = value;
                range.middle = this.compileExpression(false);
                outer.value = range;
            } else {
                outer.value = value;
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 51) {
                throw new CompileException("Syntax error found in compilation at `VARIABLE` on line " + this.parser.getCurrentLine() + " when it expected RSQBRACKET");
            }
            n = outer;
            if (this.parser.peekAhead() == 50) {
                cur = outer;
                while (this.parser.peekAhead() == 50) {
                    IAST m = new IAST();
                    this.nextSymb();
                    this.nextSymb();
                    IAST inner_value = this.compileExpression(false);
                    m.type = (byte)88;
                    if (this.parser.peekAhead() == 74) {
                        IAST range = new IAST();
                        range.type = (byte)74;
                        this.nextSymb();
                        this.nextSymb();
                        range.left = inner_value;
                        range.middle = this.compileExpression(false);
                        m.value = range;
                    } else {
                        m.value = inner_value;
                    }
                    this.nextSymb();
                    if (this.parser.getCurrentSymbol() != 51) {
                        throw new CompileException("Syntax error found in compilation at `VARIABLE` on line " + this.parser.getCurrentLine() + " when it expected RSQBRACKET");
                    }
                    m.left = cur;
                    cur = m;
                }
                n = cur;
            }
        }
        if (this.parser.peekAhead() == 18) {
            out = new IAST();
            out.type = (byte)71;
            out.left = n;
            this.nextSymb();
            out.value = this.compileArguments();
            if (this.parser.getCurrentSymbol() != 19) {
                throw new CompileException("Syntax error found in compilation at `VARIABLE` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
            }
            return out;
        }
        if (isObjectPointer) {
            return n;
        }
        if (this.parser.peekAhead() == 66) {
            IAST top;
            out = new IAST();
            out.type = (byte)66;
            out.middle = n;
            cur = top = new IAST();
            while (this.parser.peekAhead() == 66) {
                this.nextSymb();
                assert (cur != null);
                cur = cur.next = this.compileVar();
            }
            out.value = top.next;
            if (this.parser.peekAhead() == 16) {
                return this.compileAssign(out, false, isLet);
            }
            return out;
        }
        if (this.parser.peekAhead() == 108 && !isLet) {
            throw new CompileException("Syntax error found in compilation at `ASSIGN` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
        }
        if (isTyped && this.parser.peekAhead() == 16) {
            return this.compileAssign(n, isTyped, type, isLet);
        }
        if (isTyped && this.parser.peekAhead() == 62) {
            return this.compileAssign(n, isTyped, type, isLet);
        }
        if (isTyped && this.parser.peekAhead() != 16) {
            IAST typedVar = new IAST();
            typedVar.type = (byte)-13;
            typedVar.left = n;
            typedVar.middle = new IAST();
            typedVar.middle.type = type;
            return typedVar;
        }
        if (this.parser.peekAhead() == 16 || this.parser.peekAhead() == 108 && isLet || this.parser.peekAhead() == 62 && this.parser.peekAhead(3) == 16) {
            return this.compileAssign(n, isTyped, isLet);
        }
        if (ZPEHelperFunctions.isMathsOperatorByte(this.parser.peekAhead()) && this.parser.peekAhead(2) == 16) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 55) {
                n.type = (byte)48;
            } else if (this.parser.getCurrentSymbol() == 57) {
                n.type = (byte)49;
            } else if (this.parser.getCurrentSymbol() == 56) {
                n.type = (byte)102;
            } else if (this.parser.getCurrentSymbol() == 58) {
                n.type = (byte)103;
            } else if (this.parser.getCurrentSymbol() == 60) {
                n.type = (byte)104;
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 16) {
                throw new CompileException("Syntax error found in compilation at `VARIABLE` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
            }
            this.nextSymb();
            IAST val = new IAST();
            if (this.parser.getCurrentSymbol() == 5) {
                val.type = this.parser.getCurrentSymbol();
                val.value = HelperFunctions.stringToLong(this.parser.getCurrentWord());
            } else if (this.parser.getCurrentSymbol() == 6) {
                val.type = this.parser.getCurrentSymbol();
                val.value = HelperFunctions.stringToDouble(this.parser.getCurrentWord());
            } else {
                val = this.compileExpression(false);
            }
            n.value = val;
        }
        return n;
    }

    private IAST compileDestructuringAssignment() throws CompileException {
        IAST node = new IAST();
        this.nextSymb();
        node.left = new IAST();
        node.type = (byte)89;
        IAST current = node.left;
        while (this.parser.getCurrentSymbol() != 19) {
            IAST var = new IAST();
            if (this.parser.getCurrentSymbol() == 4) {
                this.nextSymb();
                var.id = "$";
            } else {
                this.getCurrentFunction().vars.put(this.parser.getCurrentWord(), new CompilerFunction.CompilerFunctionVariable(118, null));
            }
            var.id = var.id + this.parser.getCurrentWord();
            var.type = (byte)4;
            current.next = var;
            if (current.next.type != 4) {
                throw new CompileException("Syntax error found in compilation at `TUPLE` on line " + this.parser.getCurrentLine() + " when it expected VAR");
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 20 && this.parser.getCurrentSymbol() != 19) {
                throw new CompileException("Syntax error found in compilation at `TUPLE` on line " + this.parser.getCurrentLine() + " when it expected COMMA");
            }
            if (this.parser.getCurrentSymbol() == 20) {
                this.nextSymb();
            }
            current = current.next;
        }
        node.left = node.left.next;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 16) {
            throw new CompileException("Syntax error found in compilation at `TUPLE` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
        }
        this.nextSymb();
        node.value = this.compileExpression(false);
        return node;
    }

    private IAST compileInlineDoc() throws CompileException {
        StringBuilder out = new StringBuilder();
        this.nextSymb();
        IAST n = new IAST();
        n.type = (byte)8;
        while (this.parser.getCurrentSymbol() != 100 && this.parser.getCurrentSymbol() != -2) {
            this.parser.ignoreQuotes(true);
            out.append(this.parser.getWhitespace());
            out.append(this.parser.getCurrentWord(false));
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == -2) {
            throw new CompileException("Syntax error found in compilation at `INLINE DOC` on line " + this.parser.getCurrentLine() + " when it expected END OF FILE");
        }
        this.parser.ignoreQuotes(false);
        n.value = out.toString();
        IAST doc = new IAST();
        doc.type = (byte)99;
        doc.value = n;
        return doc;
    }

    private IAST compileUnescapedString() {
        IAST node = new IAST();
        this.parser.disableEscapeCharacters(true);
        this.parser.getNextSymbol();
        this.parser.disableEscapeCharacters(false);
        node.type = (byte)8;
        node.value = this.parser.getCurrentWord();
        return node;
    }

    private IAST compileCast() throws CompileException {
        IAST casting = new IAST();
        casting.type = (byte)-11;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `CAST` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        casting.left = this.compileNode();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 20) {
            throw new CompileException("Syntax error found in compilation at `CAST` on line " + this.parser.getCurrentLine() + " when it expected COMMA");
        }
        this.nextSymb();
        if (!ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol())) {
            throw new CompileException("Syntax error found in compilation at `CAST` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
        }
        casting.middle = new IAST();
        casting.middle.type = this.parser.getCurrentSymbol();
        this.nextSymb();
        return casting;
    }

    private IAST compileAssertion() throws CompileException {
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `ASSERTS` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        int pc = this.parser.getProgramCounter();
        this.nextSymb();
        IAST output = new IAST();
        output.type = (byte)93;
        output.value = this.compileExpression(false);
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `ASSERTS` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        int lineNumber = 0;
        lineNumber = this.parser.getProgram().substring(0, pc).split("\n").length;
        output.left = new IAST();
        output.left.value = this.parser.getProgram().substring(pc, this.parser.getProgramCounter() - 1);
        output.middle = new IAST();
        output.middle.value = lineNumber;
        return output;
    }

    private IAST compileImport() throws CompileException {
        this.nextSymb();
        IAST output = new IAST();
        output.type = (byte)82;
        boolean brackets = false;
        if (this.parser.getCurrentSymbol() == 18) {
            brackets = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 3 || this.parser.getCurrentSymbol() == 8) {
            output.id = this.parser.getCurrentWord();
            this.requiredLibraries.add(this.parser.getCurrentWord());
        }
        if (brackets && this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `IMPORT` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.peekAhead() == 62) {
            this.parser.getNextSymbol();
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 3) {
                throw new CompileException("Syntax error found in compilation at `IMPORT` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
            }
            output.value = this.parser.getCurrentWord();
        }
        return output;
    }

    private IAST compileAssign(IAST var, boolean typed, boolean let) throws CompileException {
        return this.compileAssign(var, typed, (byte)-1, let);
    }

    private IAST compileAssign(IAST var, boolean typed, byte type, boolean let) throws CompileException {
        byte scope = var.scope;
        this.nextSymb();
        if (typed && this.parser.getCurrentSymbol() == 62) {
            this.nextSymb();
            if (ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol())) {
                type = this.parser.getCurrentSymbol();
                if (type == 12) {
                    type = (byte)124;
                }
            } else {
                throw new CompileException("Syntax error found in compilation at `ASSIGNMENT_TYPE` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
            }
            this.nextSymb();
        }
        if (typed && type == -1) {
            throw new CompileException("Syntax error found in compilation at `ASSIGNMENT_TYPE` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
        }
        if (!typed && this.requiresExplicitDeclaration && !this.getCurrentFunction().vars.containsKey(var.id)) {
            throw new CompileException("Variable " + var.id + " not previously defined when the explicit variable declaration directive is set.");
        }
        if (this.parser.getCurrentSymbol() != 16 && this.parser.getCurrentSymbol() != 108) {
            throw new CompileException("Syntax error found in compilation at `ASSIGN` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN | BE");
        }
        this.nextSymb();
        IAST node = new IAST();
        node.scope = scope;
        node.type = (byte)16;
        if (type != -1) {
            IAST typeAST = new IAST();
            typeAST.type = (byte)62;
            typeAST.value = type;
            node.left = typeAST;
        }
        node.middle = var;
        node.value = this.parser.getCurrentSymbol() == 18 && this.isTuple() ? this.compileTuple(node.middle.id) : this.compileExpression(false);
        Object v = null;
        this.getCurrentFunction().vars.put(var.id, new CompilerFunction.CompilerFunctionVariable(((IAST)node.value).type, v));
        return node;
    }

    private IAST compileCount() throws CompileException {
        IAST output = new IAST();
        output.type = (byte)95;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `COUNT` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        output.left = this.compileExpression(false);
        if (output.left.value != null) {
            IAST node = (IAST)output.left.value;
            if (node.type == 8) {
                output.type = (byte)5;
                output.value = ((IAST)output.left.value).value.toString().length();
                output.left = null;
            }
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `COUNT` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        return output;
    }

    private IAST compileIsSet() throws CompileException {
        IAST output = new IAST();
        output.type = (byte)14;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `IS_SET` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        output.left = this.compileNode();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `IS_SET` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        return output;
    }

    private IAST compileUnset() throws CompileException {
        IAST output = new IAST();
        output.type = (byte)15;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `UNSET` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        output.left = this.compileNode();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `UNSET` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        return output;
    }

    private IAST compileEmpty() throws CompileException {
        IAST output = new IAST();
        output.type = (byte)13;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `EMPTY` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        output.left = this.compileExpression(false);
        if (output.left.value != null) {
            IAST node = (IAST)output.left.value;
            if (node.type == 8) {
                output.type = (byte)121;
                output.value = ((IAST)output.left.value).value.toString().isEmpty();
                output.left = null;
            }
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `EMPTY` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        return output;
    }

    private IAST compileBreakpoint() {
        IAST output = new IAST();
        output.type = (byte)-14;
        return output;
    }

    private IAST compileReturn() throws CompileException {
        IAST ast;
        IAST results;
        IAST output = new IAST();
        output.type = (byte)84;
        this.nextSymb();
        IAST current = results = new IAST();
        if (this.parser.getCurrentSymbol() == 70 && this.parser.peekAhead() != 66) {
            ast = new IAST();
            ast.id = "this";
            ast.type = (byte)70;
            current.next = ast;
        } else {
            current.next = this.compileExpression(false);
        }
        if (this.parser.peekAhead() == 20) {
            this.nextSymb();
            current = current.next;
            while (this.parser.getCurrentSymbol() == 20) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 70 && this.parser.peekAhead() != 66) {
                    ast = new IAST();
                    ast.id = "this";
                    ast.type = (byte)70;
                    current.next = ast;
                } else {
                    current.next = this.compileExpression(false);
                }
                if (this.parser.peekAhead() == 20) {
                    this.nextSymb();
                }
                current = current.next;
            }
        }
        output.left = results.next;
        return output;
    }

    private IAST compileBreak() {
        IAST output = new IAST();
        output.type = (byte)85;
        return output;
    }

    private IAST compileNewStructure() throws CompileException {
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 3) {
            throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
        }
        IAST a = new IAST();
        a.type = (byte)65;
        a.id = this.parser.getCurrentWord();
        if (this.parser.peekAhead() == 58 && this.parser.peekAhead(2) == 3) {
            StringBuilder id = new StringBuilder();
            this.nextSymb();
            this.nextSymb();
            while (this.parser.getCurrentSymbol() == 3 && this.parser.peekAhead() == 58) {
                id.append("/").append(this.parser.getCurrentWord());
                this.nextSymb();
                this.nextSymb();
            }
            a.id = id.toString();
            a.id = a.id + "/" + this.parser.getCurrentWord();
        }
        StringBuilder builder = new StringBuilder();
        if (this.parser.peekAhead() == 113) {
            this.parser.getNextSymbol();
            this.parser.getNextSymbol();
            a.id = a.id + "::" + this.parser.getCurrentWord();
        }
        while (this.parser.peekAhead() == 58) {
            this.parser.getNextSymbol();
            if (this.parser.getNextSymbol() != 3) {
                throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
            }
            builder.append("/").append(this.parser.getCurrentWord());
        }
        a.id = a.id + builder.toString();
        if (this.parser.peekAhead() != 18) {
            throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        a.value = this.compileArguments();
        return a;
    }

    private IAST compileExpression(boolean jump) throws CompileException {
        IAST node = this.compileLogicallyJoinedExpression(jump, null);
        if (this.parser.peekAhead() == 73) {
            if (ZPEHelperFunctions.isMathsOperatorByte(((IAST)node.value).type)) {
                throw new CompileException("Syntax error found in compilation at `EXPRESSION` on line " + this.parser.getCurrentLine() + " when it expected ?");
            }
            IAST results = new IAST();
            this.nextSymb();
            this.nextSymb();
            results.type = (byte)73;
            results.left = this.compileNode();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 74 && this.parser.getCurrentSymbol() != 29) {
                throw new CompileException("Syntax error found in compilation at `EXPRESSION` on line " + this.parser.getCurrentLine() + " when it expected COLON");
            }
            this.nextSymb();
            results.middle = this.compileNode();
            node.left = results;
        } else if (this.parser.peekAhead() == 96) {
            IAST results = new IAST();
            this.nextSymb();
            results.type = (byte)96;
            this.nextSymb();
            results.left = this.compileNode();
            node.left = results;
        }
        return node;
    }

    private IAST compileLogicallyJoinedExpression(boolean jump, IAST var) throws CompileException {
        byte peek;
        IAST node = new IAST();
        node.type = (byte)-8;
        do {
            IAST expr;
            IAST value = this.compileInnerExpression(jump);
            peek = this.parser.peekAhead();
            if (ZPEHelperFunctions.isComparatorSymbolByte(peek) || ZPEHelperFunctions.isComparatorSymbolByte(this.parser.getCurrentSymbol())) {
                expr = new IAST();
                if (ZPEHelperFunctions.isComparatorSymbolByte(this.parser.getCurrentSymbol()) && var != null && ZPEInstance.ALLOW_SHORT_IFS) {
                    expr.type = this.parser.getCurrentSymbol();
                    expr.left = var;
                    expr.middle = this.compileInnerExpression(true);
                } else {
                    this.nextSymb();
                    expr.type = this.parser.getCurrentSymbol();
                    expr.left = value;
                    expr.middle = this.compileInnerExpression(true);
                }
            } else {
                expr = value;
            }
            node.value = expr;
            peek = this.parser.peekAhead();
            if (peek == 4) {
                peek = this.parser.peekAhead(2);
            }
            if (!ZPEHelperFunctions.isLogicalOperatorByte(peek) || ZPEHelperFunctions.isMathsOperatorByte(expr.type)) break;
            this.nextSymb();
            IAST l = new IAST();
            l.type = this.parser.getCurrentSymbol();
            l.left = expr;
            l.next = (IAST)this.compileLogicallyJoinedExpression((boolean)true, (IAST)IAST.copy((IAST)value)).value;
            node.value = l;
        } while (ZPEHelperFunctions.isLogicalOperatorByte(peek = this.parser.peekAhead()));
        IAST temp = null;
        if (((IAST)node.value).type == 18) {
            temp = (IAST)node.value;
            while (temp != null && temp.type == 18) {
                temp = (IAST)temp.value;
            }
        }
        if (temp == null || !ZPEHelperFunctions.isLogicalOperatorByte(temp.type) && !ZPEHelperFunctions.isComparatorSymbolByte(temp.type)) {
            node.type = (byte)-9;
        }
        return node;
    }

    private IAST compileTuple(String id) throws CompileException {
        IAST current;
        IAST n = new IAST();
        n.type = (byte)90;
        n.id = id;
        boolean defintion = true;
        if (this.parser.getCurrentSymbol() == 18) {
            this.nextSymb();
        }
        if (ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol())) {
            current = n.left = new IAST();
        } else {
            current = n.middle = new IAST();
            defintion = false;
        }
        while (this.parser.getCurrentSymbol() != 19) {
            if (defintion) {
                current.next = new IAST();
                current.next.type = this.parser.getCurrentSymbol();
            } else {
                current.next = this.compileExpression(false);
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 20 && this.parser.getCurrentSymbol() != 19) {
                throw new CompileException("Syntax error found in compilation at `TUPLE` on line " + this.parser.getCurrentLine() + " when it expected COMMA | RBRA");
            }
            current = current.next;
            if (this.parser.getCurrentSymbol() == 19) continue;
            this.nextSymb();
        }
        if (defintion) {
            n.left = n.left.next;
        } else {
            n.middle = n.middle.next;
        }
        return n;
    }

    private IAST compileType() throws CompileException {
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `TYPE` on line " + this.parser.getCurrentLine() + " when it expected LBRA");
        }
        IAST n = new IAST();
        n.type = (byte)-15;
        this.nextSymb();
        n.value = this.compileNode();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `TYPE` on line " + this.parser.getCurrentLine() + " when it expected RBRA");
        }
        return n;
    }

    private IAST compileList() throws CompileException {
        IAST items;
        boolean is_associative = false;
        IAST currentNode = items = new IAST();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 11) {
            is_associative = true;
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 51) {
                throw new CompileException("Syntax error found in compilation at `ASSOCIATIVE_ARRAY` on line " + this.parser.getCurrentLine() + " when it expected RSQBRACKET");
            }
        }
        while (this.parser.getCurrentSymbol() != 51) {
            currentNode = currentNode.next = this.compileExpression(false);
            this.nextSymb();
            if (is_associative && this.parser.getCurrentSymbol() != 11) {
                throw new CompileException("Syntax error found in compilation at `ASSOCIATIVE_ARRAY` on line " + this.parser.getCurrentLine() + " when it expected ASSOCIATION");
            }
            if (this.parser.getCurrentSymbol() == 11) {
                is_associative = true;
            }
            if (is_associative) {
                this.nextSymb();
                currentNode = currentNode.next = this.compileExpression(false);
                this.nextSymb();
            }
            if (this.parser.getCurrentSymbol() == 51) break;
            if (this.parser.getCurrentSymbol() != 20) continue;
            this.nextSymb();
        }
        IAST out = new IAST();
        if (this.parser.peekAhead() == 56) {
            if (is_associative) {
                throw new CompileException("Syntax error found in compilation at `MAP` on line " + this.parser.getCurrentLine() + " when it expected UNEXPECTED MULT");
            }
            this.nextSymb();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 4) {
                out.left = this.compileVar();
            } else if (this.parser.getCurrentSymbol() == 5) {
                out.left = new IAST();
                out.left.type = (byte)5;
                out.left.value = HelperFunctions.stringToLong(this.parser.getCurrentWord());
            }
        }
        out.value = items.next;
        out.type = is_associative ? (byte)11 : (byte)10;
        return out;
    }

    private IAST compileObject() throws CompileException {
        IAST node;
        IAST currentNode = node = new IAST();
        this.nextSymb();
        while (this.parser.getCurrentSymbol() != 54) {
            IAST element = new IAST();
            if (this.parser.getCurrentSymbol() != 3 && this.parser.getCurrentSymbol() != 4 && this.parser.getCurrentSymbol() != 8) {
                throw new CompileException("Syntax error found in compilation at `OBJECT` on line " + this.parser.getCurrentLine() + " when it expected NAME|VAR");
            }
            element.id = this.parser.getCurrentWord();
            if (this.parser.getCurrentSymbol() == 4) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 3 && this.parser.getCurrentSymbol() != 4) {
                    throw new CompileException("Syntax error found in compilation at `OBJECT` on line " + this.parser.getCurrentLine() + " when it expected NAME");
                }
                element.id = "$" + this.parser.getCurrentWord();
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 74) {
                throw new CompileException("Syntax error found in compilation at `OBJECT` on line " + this.parser.getCurrentLine() + " when it expected COLON");
            }
            this.nextSymb();
            element.value = this.compileExpression(false);
            currentNode = currentNode.next = element;
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 54) break;
            if (this.parser.getCurrentSymbol() != 20) continue;
            this.nextSymb();
        }
        IAST out = new IAST();
        out.value = node.next;
        out.type = (byte)9;
        out.id = "object";
        return out;
    }

    private IAST compileModule() throws CompileException {
        IAST body;
        this.currentModule = new CompilerModule();
        if (this.parser.getCurrentSymbol() != -17) {
            throw new CompileException("Syntax error found in compilation at `MODULE` on line " + this.parser.getCurrentLine() + " when it expected MODULE");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 3) {
            throw new CompileException("Syntax error found in compilation at `MODULE` on line " + this.parser.getCurrentLine() + " when it expected NAME");
        }
        IAST module = new IAST();
        module.id = this.parser.getCurrentWord();
        this.nextSymb();
        boolean braces = false;
        if (this.parser.getCurrentSymbol() == 53) {
            braces = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 107) {
            this.parser.getNextSymbol();
            StringBuilder s = new StringBuilder();
            if (this.parser.getCurrentSymbol() != 3) {
                throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
            }
            s.append(this.parser.getCurrentWord());
            while (this.parser.peekAhead() == 58) {
                s.append("/");
                this.parser.getNextSymbol();
                if (this.parser.getNextSymbol() != 3) {
                    throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
                }
                s.append(this.parser.getCurrentWord());
            }
            module.id = String.valueOf(s) + "/" + module.id;
            this.parser.getNextSymbol();
        }
        module.left = new IAST();
        module.scope = (byte)2;
        IAST current = body = new IAST();
        while (this.parser.getCurrentSymbol() != 17 && this.parser.getCurrentSymbol() != 54) {
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        module.value = body.next;
        module.type = (byte)-17;
        if (this.parser.getCurrentSymbol() != 17 && this.parser.getCurrentSymbol() != 54 && braces) {
            throw new CompileException("Syntax error found in compilation at `MODULE` on line " + this.parser.getCurrentLine() + " when it expected END");
        }
        if (this.parser.getCurrentSymbol() == 17) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != -17) {
                throw new CompileException("Syntax error found in compilation at `MODULE` on line " + this.parser.getCurrentLine() + " when it expected MODULE");
            }
        }
        this.currentModule = null;
        return module;
    }

    private IAST compileStructure() throws CompileException {
        IAST body;
        int scope = 0;
        if (this.parser.getCurrentSymbol() == 1) {
            scope = 1;
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 2) {
            scope = 2;
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 0) {
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 64) {
            throw new CompileException("Syntax error found in compilation at `STRUCTURE` on line " + this.parser.getCurrentLine() + " when it expected STRUCTURE");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 3) {
            throw new CompileException("Syntax error found in compilation at `STRUCTURE` on line " + this.parser.getCurrentLine() + " when it expected NAME");
        }
        IAST struc = new IAST();
        struc.id = this.parser.getCurrentWord();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 94) {
            this.nextSymb();
            IAST inheritance = new IAST();
            inheritance.type = (byte)94;
            inheritance.id = this.parser.getCurrentWord();
            struc.middle = inheritance;
            this.nextSymb();
        }
        boolean braces = false;
        if (this.parser.getCurrentSymbol() == 53) {
            braces = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 107) {
            this.parser.getNextSymbol();
            StringBuilder s = new StringBuilder();
            if (this.parser.getCurrentSymbol() != 3) {
                throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
            }
            s.append(this.parser.getCurrentWord());
            while (this.parser.peekAhead() == 58) {
                s.append("/");
                this.parser.getNextSymbol();
                if (this.parser.getNextSymbol() != 3) {
                    throw new CompileException("Syntax error found in compilation at `NEW` on line " + this.parser.getCurrentLine() + " when it expected IDENTIFIER");
                }
                s.append(this.parser.getCurrentWord());
            }
            struc.id = String.valueOf(s) + "/" + struc.id;
            this.parser.getNextSymbol();
        }
        struc.left = new IAST();
        struc.scope = (byte)scope;
        IAST current = body = new IAST();
        while (this.parser.getCurrentSymbol() != 17 && this.parser.getCurrentSymbol() != 54) {
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        struc.value = body.next;
        struc.type = (byte)64;
        if (this.parser.getCurrentSymbol() != 17 && this.parser.getCurrentSymbol() != 54 && braces) {
            throw new CompileException("Syntax error found in compilation at `STRUCTURE` on line " + this.parser.getCurrentLine() + " when it expected END");
        }
        if (this.parser.getCurrentSymbol() == 17) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 64) {
                throw new CompileException("Syntax error found in compilation at `STRUCTURE` on line " + this.parser.getCurrentLine() + " when it expected STRUCTURE");
            }
        }
        return struc;
    }

    private IAST compileRecord() throws CompileException {
        IAST body;
        int scope = 0;
        boolean structureKeywordUsed = false;
        if (this.parser.getCurrentSymbol() == 1) {
            scope = 1;
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 2) {
            scope = 2;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 65) {
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 110) {
            throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected RECORD");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 64) {
            structureKeywordUsed = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 3) {
            throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected NAME");
        }
        IAST record = new IAST();
        record.id = this.parser.getCurrentWord();
        this.nextSymb();
        if (!structureKeywordUsed) {
            if (this.parser.getCurrentSymbol() != 25) {
                throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected IS");
            }
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 53) {
            throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected LBRACE");
        }
        this.nextSymb();
        record.left = new IAST();
        record.scope = (byte)scope;
        IAST current = body = new IAST();
        while (this.parser.getCurrentSymbol() != 17 && this.parser.getCurrentSymbol() != 54) {
            IAST node = new IAST();
            if (!ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol())) {
                throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
            }
            node.type = this.parser.getCurrentSymbol();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 3) {
                throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected NAME");
            }
            node.id = this.parser.getCurrentWord();
            if (this.parser.peekAhead() == 16) {
                this.nextSymb();
                this.nextSymb();
                node.value = this.compileInnerExpression(false);
            }
            current.next = node;
            if (this.parser.peekAhead() != 20 && this.parser.peekAhead() != 54) {
                throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected COMMA");
            }
            if (this.parser.peekAhead() == 20) {
                this.nextSymb();
            }
            current = this.compileNext(current);
            this.nextSymb();
        }
        record.value = body.next;
        record.type = (byte)110;
        if (this.parser.getCurrentSymbol() != 54) {
            throw new CompileException("Syntax error found in compilation at `RECORD` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
        }
        return record;
    }

    private IAST compileAnonymousFunction() throws CompileException {
        IAST conjoin;
        CompilerFunction this_func = new CompilerFunction(this);
        this.functionList.push(this_func);
        IAST node = new IAST();
        node.type = (byte)12;
        node.scope = 0;
        if (this.parser.getCurrentSymbol() == 18) {
            IAST params = this.compileParameters();
            node.value = params;
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 11) {
            throw new CompileException("Syntax error found in compilation at `FAT ARROW` on line " + this.parser.getCurrentLine() + " when it expected FUNCTION");
        }
        this.nextSymb();
        boolean braces = false;
        if (this.parser.getCurrentSymbol() == 53) {
            braces = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 54 || this.parser.getCurrentSymbol() == 17 && this.parser.peekAhead() == 12) {
            ZPECore.PrintCompileWarning("Empty function.");
        }
        IAST current = conjoin = new IAST();
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 12) break;
            }
            if (this.parser.getCurrentSymbol() == 54 && braces) break;
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        node.left = conjoin.next;
        node.id = "";
        this.functionList.pop();
        return node;
    }

    private IAST compileFunctionDefinition() {
        IAST node = new IAST();
        node.type = (byte)124;
        node.id = this.parser.getCurrentWord();
        this.functionDefinitions.put(node, this.functionList.peek());
        return node;
    }

    private IAST compileTemplate() throws CompileException {
        IAST node = new IAST();
        node.type = (byte)-16;
        if (this.parser.getCurrentSymbol() != -16) {
            throw new CompileException("Syntax error found in compilation at `TEMPLATE` on line " + this.parser.getCurrentLine() + " when it expected TEMPLATE");
        }
        this.parser.ignoreQuotes(true);
        String out = this.parser.parseTo((byte)-16);
        this.parser.ignoreQuotes(false);
        YASSTemplateCompiler comp = new YASSTemplateCompiler(out);
        comp.addGlobals(this);
        node.value = comp.toIAST();
        return node;
    }

    private IAST compileFunction() throws CompileException {
        IAST conjoin;
        int scope = 0;
        boolean isAnAnonymousFunction = false;
        boolean isStatic = false;
        IAST node = new IAST();
        node.type = (byte)12;
        if (this.parser.getCurrentSymbol() == 1) {
            scope = 1;
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 2) {
            scope = 2;
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 114) {
            scope = 114;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 112) {
            isStatic = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 12) {
            throw new CompileException("Syntax error found in compilation at `FUNCTION` on line " + this.parser.getCurrentLine() + " when it expected FUNCTION");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 3 && !isStatic) {
            isAnAnonymousFunction = true;
        }
        String name = "";
        if (!isAnAnonymousFunction) {
            name = this.parser.getCurrentWord();
            this.nextSymb();
        }
        CompilerFunction func = new CompilerFunction(this);
        this.functionList.add(func);
        if (this.parser.getCurrentSymbol() == 83) {
            if (name.isEmpty()) {
                throw new CompileException("Syntax error found in compilation at `FUNCTION` on line " + this.parser.getCurrentLine() + " when it expected NAME");
            }
            this.nextSymb();
            node.id = name;
            if (this.parser.getCurrentSymbol() == 3) {
                node.value = this.parser.getCurrentWord();
            }
            node.type = (byte)83;
            this.functionList.pop();
            return node;
        }
        IAST params = this.compileParameters();
        IAST current = conjoin = new IAST();
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 74 || this.parser.getCurrentSymbol() == 66) {
            this.nextSymb();
            ArrayList<Byte> returnTypes = new ArrayList<Byte>();
            while (ZPEHelperFunctions.isTypeByte(this.parser.getCurrentSymbol())) {
                returnTypes.add(this.parser.getCurrentSymbol());
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 116) break;
                this.nextSymb();
            }
            node.returnTypes = new byte[returnTypes.size()];
            for (int i = 0; i < returnTypes.size(); ++i) {
                node.returnTypes[i] = (Byte)returnTypes.get(i);
            }
        }
        boolean braces = false;
        if (this.parser.getCurrentSymbol() == 53) {
            braces = true;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 54 || this.parser.getCurrentSymbol() == 17 && this.parser.peekAhead() == 12) {
            ZPECore.PrintCompileWarning("Empty function.");
        }
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 12) break;
            }
            if (this.parser.getCurrentSymbol() == 54 && braces) break;
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        node.left = conjoin.next;
        node.value = params;
        node.id = name;
        node.scope = (byte)scope;
        if (isStatic) {
            node.type = (byte)112;
        }
        if (this.parser.peekAhead() == 74 && this.parser.peekAhead(2) == 18) {
            if (!isAnAnonymousFunction) {
                throw new CompileException("Syntax error found in compilation at `FUNCTION` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
            }
            this.nextSymb();
            this.nextSymb();
            node.middle = this.compileParameters();
        }
        this.functionList.pop();
        return node;
    }

    private IAST compileNext(IAST c) {
        IAST current = c;
        while (current.next != null) {
            current = current.next;
        }
        return current;
    }

    private IAST compileTry() throws CompileException {
        IAST bad_path;
        IAST good_path;
        this.nextSymb();
        boolean braces = false;
        if (this.parser.getCurrentSymbol() == 53) {
            braces = true;
            this.nextSymb();
        }
        IAST current = good_path = new IAST();
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                if (!braces) {
                    this.nextSymb();
                    if (this.parser.getCurrentSymbol() != 75) continue;
                    break;
                }
                throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected END");
            }
            if (this.parser.getCurrentSymbol() == 54) {
                if (braces) {
                    if (this.parser.peekAhead() != 76) break;
                    this.nextSymb();
                    break;
                }
                throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            if (this.parser.getCurrentSymbol() == 76 && !braces) break;
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        String exception_name = null;
        current = bad_path = new IAST();
        if (this.parser.getCurrentSymbol() == 76) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 18) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 4) {
                    throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected VAR");
                }
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 3) {
                    throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected VAR");
                }
                exception_name = "$" + this.parser.getCurrentWord();
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 19) {
                    throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
                }
                this.nextSymb();
            }
            if (braces && this.parser.getCurrentSymbol() != 53) {
                throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected LBRACE");
            }
            if (braces && this.parser.getCurrentSymbol() == 53) {
                this.nextSymb();
            }
            while (true) {
                if (this.parser.getCurrentSymbol() == 17) {
                    if (!braces) {
                        this.nextSymb();
                        if (this.parser.getCurrentSymbol() != 75) continue;
                        break;
                    }
                    throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected END");
                }
                if (this.parser.getCurrentSymbol() == 54) {
                    if (braces) break;
                    throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
                }
                current.next = this.compileNode();
                current = this.compileNext(current);
                this.nextSymb();
            }
        }
        if (this.parser.getCurrentSymbol() != 75 && this.parser.getCurrentSymbol() != 54) {
            throw new CompileException("Syntax error found in compilation at `TRY` on line " + this.parser.getCurrentLine() + " when it expected END");
        }
        IAST output = new IAST();
        output.type = (byte)75;
        output.left = good_path.next;
        output.middle = bad_path.next;
        output.value = exception_name;
        return output;
    }

    private IAST compileIf() throws CompileException {
        boolean colonMode = false;
        boolean thenMode = false;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            colonMode = true;
        } else {
            this.nextSymb();
        }
        IAST condition = null;
        if (this.parser.getCurrentSymbol() == 19) {
            throw new CompileException("Syntax error found in compilation at `IF` on line " + this.parser.getCurrentLine() + " when it expected ARGUMENTS");
        }
        if (this.parser.checkProgramCounter()) {
            condition = this.compileExpression(false);
            this.nextSymb();
        }
        if (!colonMode && this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `IF` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (colonMode && this.parser.getCurrentSymbol() != 68 && this.parser.getCurrentSymbol() != 74) {
            throw new CompileException("Syntax error found in compilation at `IF` on line " + this.parser.getCurrentLine() + " when it expected THEN");
        }
        if (this.parser.getCurrentSymbol() == 68) {
            thenMode = true;
        }
        this.nextSymb();
        IAST middle = new IAST();
        IAST mainIf = new IAST();
        if (thenMode) {
            mainIf.next = this.compileNode();
            if (this.parser.peekAhead() == 17 && this.parser.peekAhead(2) == 21) {
                throw new CompileException("Syntax error found in compilation at `END IF` on line " + this.parser.getCurrentLine() + " when it expected NEXT STATEMENT");
            }
            if (this.parser.peekAhead() == 22) {
                this.nextSymb();
                this.nextSymb();
                middle.next = this.compileNode();
            }
        } else {
            if (this.parser.getCurrentSymbol() == 69) {
                IAST node = new IAST();
                node.value = condition;
                node.type = (byte)21;
                return node;
            }
            boolean braces = false;
            if (this.parser.getCurrentSymbol() == 53) {
                braces = true;
                this.nextSymb();
            }
            boolean if_else = false;
            IAST current = mainIf;
            IAST midCurrent = middle;
            while (true) {
                if (this.parser.getCurrentSymbol() == 17) {
                    if (!braces) {
                        this.nextSymb();
                        if (this.parser.getCurrentSymbol() != 21) continue;
                        break;
                    }
                    throw new CompileException("Syntax error found in compilation at `IF` on line " + this.parser.getCurrentLine() + " when it expected END");
                }
                if (this.parser.getCurrentSymbol() == 69) break;
                if (this.parser.getCurrentSymbol() == 23 || this.parser.getCurrentSymbol() == 54 && this.parser.peekAhead() == 23) {
                    if (this.parser.getCurrentSymbol() == 54 || this.parser.getCurrentSymbol() == 22) {
                        this.nextSymb();
                    }
                    midCurrent.next = this.compileElseIf(braces, colonMode);
                    midCurrent = this.compileNext(midCurrent);
                    continue;
                }
                if (this.parser.getCurrentSymbol() == 22 || this.parser.getCurrentSymbol() == 54 && this.parser.peekAhead() == 22) {
                    if (this.parser.getCurrentSymbol() == 54) {
                        this.nextSymb();
                    }
                    if_else = true;
                    break;
                }
                if (this.parser.getCurrentSymbol() == 54) {
                    if (braces) break;
                    throw new CompileException("Syntax error found in compilation at `IF` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
                }
                current.next = this.compileNode();
                current = this.compileNext(current);
                this.nextSymb();
            }
            if (if_else) {
                midCurrent.next = this.compileElse(braces, colonMode);
            }
        }
        IAST node = new IAST();
        node.left = mainIf.next;
        if (middle.next != null) {
            node.middle = middle.next;
        }
        node.type = (byte)21;
        node.value = condition;
        return node;
    }

    private IAST compileElse(boolean braces, boolean colonMode) throws CompileException {
        IAST elseNode = new IAST();
        elseNode.value = new IAST();
        IAST current = (IAST)elseNode.value;
        elseNode.type = (byte)22;
        if (this.parser.getCurrentSymbol() == 74 && colonMode) {
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() != 74 && colonMode) {
            throw new CompileException("Syntax error found in compilation at `ELSE` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        if (this.parser.getCurrentSymbol() == 53 && braces) {
            this.nextSymb();
        } else if (this.parser.getCurrentSymbol() == 53 && !braces) {
            throw new CompileException("Syntax error found in compilation at `ELSE` on line " + this.parser.getCurrentLine() + " when it expected EXPRESSION");
        }
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                if (!braces) {
                    this.nextSymb();
                    if (this.parser.getCurrentSymbol() == 21) {
                        break;
                    }
                }
            } else if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `ELSE` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            if (this.parser.getCurrentSymbol() == 17) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 21) continue;
                break;
            }
            if (this.parser.getCurrentSymbol() == 54 && braces) break;
            this.nextSymb();
        }
        elseNode.left = ((IAST)elseNode.value).next.next;
        return elseNode;
    }

    private IAST compileElseIf(boolean braces, boolean colonMode) throws CompileException {
        IAST mainIf;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18 && !colonMode) {
            throw new CompileException("Syntax error found in compilation at `ELSEIF` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        if (!colonMode) {
            this.nextSymb();
        }
        IAST comparison = null;
        if (this.parser.getCurrentSymbol() == 19) {
            throw new CompileException("Syntax error found in compilation at `ELSEIF` on line " + this.parser.getCurrentLine() + " when it expected ARGUMENTS");
        }
        if (this.parser.checkProgramCounter()) {
            comparison = this.compileExpression(false);
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `ELSEIF` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.getCurrentSymbol() != 74 && colonMode) {
            throw new CompileException("Syntax error found in compilation at `ELSEIF` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 53) {
            if (braces) {
                this.nextSymb();
            } else {
                throw new CompileException("Syntax error found in compilation at `ELSEIF` on line " + this.parser.getCurrentLine() + " when it expected EXPRESSION");
            }
        }
        IAST current = mainIf = new IAST();
        while (!(this.parser.getCurrentSymbol() == 17 && this.parser.peekAhead() == 21 || this.parser.getCurrentSymbol() == 54 && braces || this.parser.getCurrentSymbol() == 22 || this.parser.getCurrentSymbol() == 23)) {
            if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `ELSEIF` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        IAST node = new IAST();
        node.left = mainIf.next;
        node.type = (byte)23;
        node.value = comparison;
        return node;
    }

    private IAST compileWhen() throws CompileException {
        String id;
        HashMap<String, IAST> map;
        boolean braces;
        boolean switchmode;
        block15: {
            switchmode = false;
            braces = false;
            map = new HashMap<String, IAST>();
            if (this.parser.getCurrentSymbol() == 26) {
                switchmode = true;
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 18) {
                throw new CompileException("Syntax error found in compilation at `WHEN` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 4) {
                throw new CompileException("Syntax error found in compilation at `WHEN` on line " + this.parser.getCurrentLine() + " when it expected VAR");
            }
            this.nextSymb();
            id = "$" + this.parser.getCurrentWord();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 19) {
                throw new CompileException("Syntax error found in compilation at `WHEN` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 53) {
                braces = true;
                this.nextSymb();
            }
            while (true) {
                Object value;
                if (!braces && this.parser.getCurrentSymbol() == 17) {
                    this.nextSymb();
                    if ((switchmode || this.parser.getCurrentSymbol() != 24) && (!switchmode || this.parser.getCurrentSymbol() != 26)) continue;
                    break block15;
                }
                if (braces && this.parser.getCurrentSymbol() == 54) break block15;
                if ((switchmode || this.parser.getCurrentSymbol() != 25) && (!switchmode || this.parser.getCurrentSymbol() != 27)) break;
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 57) {
                    this.nextSymb();
                    value = "-" + this.parser.getCurrentWord();
                } else {
                    value = this.parser.getCurrentWord();
                }
                map.put((String)value, this.compileIsStatement(switchmode, braces));
            }
            if (!(!switchmode && this.parser.getCurrentSymbol() == 29 || switchmode && this.parser.getCurrentSymbol() == 28)) {
                throw new CompileException("Syntax error found in compilation at `WHEN` on line " + this.parser.getCurrentLine() + " when it expected IS|END_WHEN");
            }
        }
        IAST node = new IAST();
        if (!switchmode && this.parser.getCurrentSymbol() == 29 || switchmode && this.parser.getCurrentSymbol() == 28) {
            IAST otherwise;
            IAST current = otherwise = new IAST();
            this.nextSymb();
            if (!switchmode && this.parser.getCurrentSymbol() == 52) {
                this.nextSymb();
            }
            if (switchmode && this.parser.getCurrentSymbol() != 74) {
                throw new CompileException("Syntax error found in compilation at `WHEN` on line " + this.parser.getCurrentLine() + " when it expected COLON");
            }
            while (!(!braces && this.parser.getCurrentSymbol() == 17 && (!switchmode && this.parser.peekAhead() == 24 || switchmode && this.parser.peekAhead() == 26) || braces && this.parser.getCurrentSymbol() == 54)) {
                current.next = this.compileNode();
                current = this.compileNext(current);
                this.nextSymb();
            }
            node.middle = otherwise.next;
            if (!braces && this.parser.getCurrentSymbol() == 17) {
                this.nextSymb();
            }
        }
        node.value = map;
        node.type = (byte)24;
        node.id = id;
        return node;
    }

    private IAST compileIsStatement(boolean switchmode, boolean braces) throws CompileException {
        IAST mainWhen;
        IAST current = mainWhen = new IAST();
        this.nextSymb();
        if (!switchmode && this.parser.getCurrentSymbol() == 52) {
            this.nextSymb();
        }
        if (switchmode && this.parser.getCurrentSymbol() != 74) {
            throw new CompileException("Syntax error found in compilation at `WHEN` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        while (!(!braces && this.parser.getCurrentSymbol() == 17 && (!switchmode && this.parser.peekAhead() == 24 || switchmode && this.parser.peekAhead() == 26) || braces && this.parser.getCurrentSymbol() == 54 || !switchmode && (this.parser.getCurrentSymbol() == 25 || this.parser.getCurrentSymbol() == 29) || switchmode && (this.parser.getCurrentSymbol() == 27 || this.parser.getCurrentSymbol() == 28))) {
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        return mainWhen;
    }

    private IAST compileMatchExpression() throws CompileException {
        IAST start;
        IAST node = new IAST();
        if (this.parser.getCurrentSymbol() != 101) {
            throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected MATCH");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        node.value = this.compileNode();
        this.nextSymb();
        boolean php_style = false;
        if (this.parser.getCurrentSymbol() == 19) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 53) {
                throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected LBRACE");
            }
            php_style = true;
        } else if (this.parser.getCurrentSymbol() != 74) {
            throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected COLON | RBRACKET");
        }
        this.nextSymb();
        IAST current = start = new IAST();
        while (!(!php_style && this.parser.getCurrentSymbol() == 19 || php_style && this.parser.getCurrentSymbol() == 54 || this.parser.getCurrentSymbol() == 22)) {
            current.next = new IAST();
            current.next.left = this.compileNode();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 11) {
                throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected ASSOCIATION");
            }
            this.nextSymb();
            current.next.middle = this.compileNode();
            current = current.next;
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 69) {
                throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected SEMI_COLON");
            }
            this.nextSymb();
            this.parser.skipSymbol((byte)20);
        }
        if (this.parser.getCurrentSymbol() == 22) {
            node.middle = new IAST();
            node.middle.type = (byte)22;
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 11) {
                throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected ASSOCIATION");
            }
            this.nextSymb();
            node.middle.left = this.compileNode();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 69) {
                throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected SEMI_COLON");
            }
            this.nextSymb();
        }
        if (!php_style && this.parser.getCurrentSymbol() != 19 || php_style && this.parser.getCurrentSymbol() != 54) {
            throw new CompileException("Syntax error found in compilation at `MATCH` on line " + this.parser.getCurrentLine() + " when it expected RBRA");
        }
        node.left = start.next;
        node.type = (byte)101;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAST compileWhile() throws CompileException {
        IAST whileBody;
        this.nextSymb();
        boolean colonMode = false;
        if (this.parser.getCurrentSymbol() != 18) {
            colonMode = true;
        } else {
            this.nextSymb();
        }
        IAST comparison = null;
        if (this.parser.getCurrentSymbol() == 19) {
            throw new CompileException("Syntax error found in compilation at `WHILE` on line " + this.parser.getCurrentLine() + " when it expected ARGUMENTS");
        }
        if (this.parser.checkProgramCounter()) {
            comparison = this.compileExpression(false);
            if (this.parser.getCurrentSymbol() != 19 && this.parser.getCurrentSymbol() != 74) {
                this.nextSymb();
            }
        }
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `WHILE` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.getCurrentSymbol() != 74 && colonMode) {
            throw new CompileException("Syntax error found in compilation at `WHILE` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        boolean braces = false;
        if (this.parser.peekAhead() == 53) {
            braces = true;
            this.nextSymb();
        }
        IAST current = whileBody = new IAST();
        this.nextSymb();
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                if (braces) throw new CompileException("Syntax error found in compilation at `WHILE` on line " + this.parser.getCurrentLine() + " when it expected END");
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 30 || this.parser.getCurrentSymbol() == 98) {
                    break;
                }
            } else if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `WHILE` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        IAST node = new IAST();
        node.left = whileBody.next;
        node.type = (byte)30;
        node.value = comparison;
        return node;
    }

    private IAST compileDoWhile() throws CompileException {
        IAST whileBody;
        boolean terminateWithSemiColon = false;
        this.nextSymb();
        boolean braces = false;
        if (this.parser.peekAhead() == 53) {
            braces = true;
            this.nextSymb();
        }
        IAST current = whileBody = new IAST();
        while (true) {
            if (this.parser.getCurrentSymbol() == 98 && this.parser.peekAhead() == 30) {
                if (!braces) {
                    this.nextSymb();
                    break;
                }
                throw new CompileException("Syntax error found in compilation at `DO_WHILE` on line " + this.parser.getCurrentLine() + " when it expected END");
            }
            if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `DO_WHILE` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() == 30) {
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 18) {
            terminateWithSemiColon = true;
        } else {
            this.nextSymb();
        }
        IAST comparison = null;
        if (this.parser.getCurrentSymbol() == 19 && !terminateWithSemiColon) {
            throw new CompileException("Syntax error found in compilation at `DO_WHILE` on line " + this.parser.getCurrentLine() + " when it expected ARGUMENTS");
        }
        if (this.parser.checkProgramCounter()) {
            comparison = this.compileExpression(false);
            if (this.parser.getCurrentSymbol() != 19) {
                this.nextSymb();
            }
        }
        if (this.parser.getCurrentSymbol() != 19 && !terminateWithSemiColon) {
            throw new CompileException("Syntax error found in compilation at `DO_WHILE` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.getCurrentSymbol() != 69 && terminateWithSemiColon) {
            throw new CompileException("Syntax error found in compilation at `DO_WHILE` on line " + this.parser.getCurrentLine() + " when it expected SEMI-COLON");
        }
        IAST node = new IAST();
        node.left = whileBody.next;
        node.type = (byte)52;
        node.value = comparison;
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAST compileLoopUntil() throws CompileException {
        IAST loopBody;
        this.nextSymb();
        boolean colonMode = false;
        if (this.parser.getCurrentSymbol() != 31) {
            throw new CompileException("Syntax error found in compilation at `LOOP_UNTIL` on line " + this.parser.getCurrentLine() + " when it expected UNTIL");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            colonMode = true;
        } else {
            this.nextSymb();
        }
        IAST comparison = null;
        if (this.parser.getCurrentSymbol() == 19) {
            throw new CompileException("Syntax error found in compilation at `LOOP_UNTIL` on line " + this.parser.getCurrentLine() + " when it expected ARGUMENTS");
        }
        if (this.parser.checkProgramCounter()) {
            comparison = this.compileExpression(false);
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 19 && !colonMode) {
            throw new CompileException("Syntax error found in compilation at `LOOP_UNTIL` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.getCurrentSymbol() != 74 && colonMode) {
            throw new CompileException("Syntax error found in compilation at `LOOP_UNTIL` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        boolean braces = false;
        if (this.parser.peekAhead() == 53) {
            braces = true;
            this.nextSymb();
        }
        IAST current = loopBody = new IAST();
        this.nextSymb();
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                if (braces) throw new CompileException("Syntax error found in compilation at `LOOP_UNTIL` on line " + this.parser.getCurrentLine() + " when it expected END");
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 98) {
                    break;
                }
            } else if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `LOOP_UNTIL` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        IAST node = new IAST();
        node.left = loopBody.next;
        node.type = (byte)31;
        node.value = comparison;
        return node;
    }

    private IAST compileFor() throws CompileException {
        IAST forbody;
        IAST assign = new IAST();
        boolean colonMode = false;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            colonMode = true;
        } else {
            this.nextSymb();
        }
        byte peek1 = this.parser.peekAhead(1);
        byte peek2 = this.parser.peekAhead(2);
        if (peek2 == 20 || peek2 == 69) {
            if (this.parser.getCurrentSymbol() == 4) {
                this.nextSymb();
                assign.id = "$" + this.parser.getCurrentWord();
                assign.type = (byte)4;
            } else if (this.parser.getCurrentSymbol() == 105) {
                this.nextSymb();
                assign.id = this.parser.getCurrentWord();
                assign.type = (byte)4;
            } else {
                assign.id = this.parser.getCurrentWord();
                assign.type = (byte)4;
            }
        } else if (this.parser.peekAhead(3) == 12) {
            if (this.parser.getCurrentSymbol() != 4) {
                throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected VAR");
            }
            this.nextSymb();
            String cId = "$" + this.parser.getCurrentWord();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 16) {
                throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected ASSIGN");
            }
            this.nextSymb();
            assign = this.compileFunction();
            assign.id = cId;
            assign.type = (byte)12;
        } else if (peek1 == 16 || peek2 == 16) {
            assign = this.compileVar();
        }
        this.nextSymb();
        boolean to_mode = false;
        if (this.parser.getCurrentSymbol() != 20 && this.parser.getCurrentSymbol() != 69) {
            if (this.parser.getCurrentSymbol() != 97) {
                throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected COMMA or TO");
            }
            to_mode = true;
        }
        IAST forNode = new IAST();
        forNode.type = (byte)32;
        IAST mid = new IAST();
        if (!to_mode) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 19 || this.parser.getCurrentSymbol() == 20 || this.parser.getCurrentSymbol() == 69) {
                throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected ARGUMENTS");
            }
            IAST comparison = null;
            if (this.parser.checkProgramCounter()) {
                comparison = this.compileExpression(false);
                this.nextSymb();
            }
            if (this.parser.getCurrentSymbol() != 20 && this.parser.getCurrentSymbol() != 69) {
                throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected COMMA");
            }
            this.nextSymb();
            IAST inc = this.compileExpression(false);
            this.nextSymb();
            mid.value = inc;
            forNode.value = comparison;
        } else {
            this.nextSymb();
            mid.value = 1;
            IAST to = new IAST();
            to.type = (byte)97;
            to.value = this.compileExpression(false);
            forNode.value = to;
            forNode.type = (byte)33;
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 19 && !colonMode) {
            throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.getCurrentSymbol() != 74 && colonMode) {
            throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        boolean braces = false;
        if (this.parser.peekAhead() == 53) {
            braces = true;
            this.nextSymb();
        }
        IAST current = forbody = new IAST();
        this.nextSymb();
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 32 || this.parser.getCurrentSymbol() == 98) {
                    break;
                }
            } else if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `FOR` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        IAST node = new IAST();
        node.left = forbody.next;
        mid.left = assign;
        forNode.left = forbody;
        forNode.middle = mid;
        return forNode;
    }

    private IAST compileForEach() throws CompileException {
        IAST body;
        IAST left;
        boolean colonMode = false;
        if (this.parser.getCurrentSymbol() != 32) {
            throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected FOR");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 61) {
            throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected EACH");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 18) {
            colonMode = true;
        } else {
            this.nextSymb();
        }
        if (this.parser.getCurrentSymbol() != 50 && this.parser.getCurrentSymbol() != 4 && this.parser.getCurrentSymbol() != 70 && this.parser.getCurrentSymbol() != 3 && this.parser.getCurrentSymbol() != 12) {
            throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected VALUE|ITERABLE");
        }
        IAST right = new IAST();
        if (this.parser.getCurrentSymbol() == 4 && this.parser.peekAhead(2) == 63 || this.parser.getCurrentSymbol() == 3 && this.parser.peekAhead() == 63) {
            if (this.parser.getCurrentSymbol() == 4) {
                this.nextSymb();
                right.value = "$" + this.parser.getCurrentWord();
            } else {
                this.getCurrentFunction().vars.put(this.parser.getCurrentWord(), new CompilerFunction.CompilerFunctionVariable(118, null));
                right.value = this.parser.getCurrentWord();
            }
            right.type = (byte)4;
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 63) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected IN");
            }
            this.nextSymb();
            left = this.compileNode();
            if (left.type != 4 && left.type != 3 && left.type != 66 && left.type != 10 && left.type != 11) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected VAR | FUNCTION | OBJECT | LIST | MAP");
            }
        } else {
            left = this.compileNode();
            if (left.type != 4 && left.type != 3 && left.type != 66 && left.type != 10 && left.type != 11) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected VAR | FUNCTION | OBJECT | LIST | MAP");
            }
            if (this.parser.peekAhead() == 62) {
                this.nextSymb();
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 4 && this.parser.getCurrentSymbol() != 3) {
                    throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected VAR | NAME");
                }
                if (this.parser.peekAhead() == 11 || this.parser.peekAhead(2) == 11) {
                    right.left = new IAST();
                    right.left.type = (byte)4;
                    if (this.parser.getCurrentSymbol() == 4) {
                        this.nextSymb();
                        right.left.value = "$" + this.parser.getCurrentWord();
                    } else {
                        this.getCurrentFunction().vars.put(this.parser.getCurrentWord(), new CompilerFunction.CompilerFunctionVariable(118, null));
                        right.left.value = this.parser.getCurrentWord();
                    }
                    this.nextSymb();
                    this.nextSymb();
                    if (this.parser.getCurrentSymbol() != 4 && this.parser.getCurrentSymbol() != 3) {
                        throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected VAR | NAME");
                    }
                    right.middle = new IAST();
                    right.middle.type = (byte)4;
                    if (this.parser.getCurrentSymbol() == 4) {
                        this.nextSymb();
                        right.middle.value = "$" + this.parser.getCurrentWord();
                    } else {
                        this.getCurrentFunction().vars.put(this.parser.getCurrentWord(), new CompilerFunction.CompilerFunctionVariable(118, null));
                        right.middle.value = this.parser.getCurrentWord();
                    }
                    right.type = (byte)11;
                } else {
                    right.type = (byte)4;
                    if (this.parser.getCurrentSymbol() == 4) {
                        this.nextSymb();
                        right.value = "$" + this.parser.getCurrentWord();
                    } else {
                        this.getCurrentFunction().vars.put(this.parser.getCurrentWord(), new CompilerFunction.CompilerFunctionVariable(118, null));
                        right.value = this.parser.getCurrentWord();
                    }
                }
            }
        }
        IAST assignment = new IAST();
        assignment.left = left;
        assignment.middle = right;
        IAST fornode = new IAST();
        fornode.type = (byte)61;
        fornode.left = assignment;
        this.nextSymb();
        if (!colonMode) {
            if (this.parser.getCurrentSymbol() != 19 && this.parser.getCurrentSymbol() != 85) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET|BREAK");
            }
        } else if (this.parser.getCurrentSymbol() != 74 && this.parser.getCurrentSymbol() != 85) {
            throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected COLON|BREAK");
        }
        if (this.parser.getCurrentSymbol() == 85) {
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 24) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH BREAK WHEN` on line " + this.parser.getCurrentLine() + " when it expected WHEN");
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 4) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH BREAK WHEN` on line " + this.parser.getCurrentLine() + " when it expected VAR");
            }
            this.nextSymb();
            IAST when = new IAST();
            when.id = "$" + this.parser.getCurrentWord();
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 25) {
                throw new CompileException("Syntax error found in compilation at `FOR_EACH BREAK WHEN` on line " + this.parser.getCurrentLine() + " when it expected IS");
            }
            this.nextSymb();
            when.value = this.compileExpression(false);
            this.nextSymb();
            fornode.value = when;
        }
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (this.parser.getCurrentSymbol() != 74 && colonMode) {
            throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected COLON");
        }
        boolean braces = false;
        if (this.parser.peekAhead() == 53) {
            braces = true;
            this.nextSymb();
        }
        IAST current = body = new IAST();
        this.nextSymb();
        while (true) {
            if (this.parser.getCurrentSymbol() == 17) {
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 32 || this.parser.getCurrentSymbol() == 98) {
                    break;
                }
            } else if (this.parser.getCurrentSymbol() == 54) {
                if (braces) break;
                throw new CompileException("Syntax error found in compilation at `FOR_EACH` on line " + this.parser.getCurrentLine() + " when it expected RBRACE");
            }
            current.next = this.compileNode();
            current = this.compileNext(current);
            this.nextSymb();
        }
        fornode.middle = body.next;
        return fornode;
    }

    private IAST compileNegation() throws CompileException {
        IAST output = new IAST();
        output.id = this.parser.getCurrentWord();
        boolean bracketed = false;
        if (this.parser.getCurrentWord().equalsIgnoreCase("not") && this.parser.peekAhead() != 18) {
            throw new CompileException("Syntax error found in compilation at `NEGATION` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        output.type = (byte)86;
        this.nextSymb();
        if (this.parser.getCurrentSymbol() == 18) {
            bracketed = true;
            this.nextSymb();
        }
        IAST out = new IAST();
        out.type = (byte)-6;
        out.next = bracketed ? this.compileExpression(false) : this.compileNode();
        output.value = out;
        if (this.parser.getCurrentSymbol() == 19 && bracketed) {
            this.nextSymb();
        }
        return output;
    }

    private IAST compileIdentifier() throws CompileException {
        IAST output = new IAST();
        output.id = this.parser.getCurrentWord();
        output.type = (byte)3;
        if (this.parser.peekAhead() == 113) {
            this.nextSymb();
            this.nextSymb();
            output.type = (byte)113;
            if (this.parser.getCurrentSymbol() != 74) {
                throw new CompileException("Syntax error found in compilation at `COLON` on line " + this.parser.getCurrentLine() + " when it expected COLON");
            }
            this.nextSymb();
            output.left = this.compileIdentifier();
            return output;
        }
        if (output.id.equals("return") || output.id.equals("echo") || output.id.equals("!")) {
            boolean bracketed = false;
            this.nextSymb();
            if (this.parser.getCurrentSymbol() == 18) {
                bracketed = true;
                this.nextSymb();
            }
            IAST out = new IAST();
            out.type = (byte)-6;
            out.next = this.compileExpression(false);
            output.value = out;
            if (this.parser.getCurrentSymbol() == 19 && bracketed) {
                this.nextSymb();
            }
        } else {
            this.nextSymb();
            output.value = this.compileArguments();
        }
        if (this.parser.peekAhead() == 50) {
            IAST index = new IAST();
            this.nextSymb();
            this.nextSymb();
            IAST value = this.compileExpression(false);
            index.type = (byte)88;
            if (this.parser.peekAhead() == 74) {
                IAST range = new IAST();
                range.type = (byte)74;
                this.nextSymb();
                this.nextSymb();
                range.left = value;
                range.middle = this.compileExpression(false);
                index.value = range;
            } else {
                index.value = value;
            }
            this.nextSymb();
            if (this.parser.getCurrentSymbol() != 51) {
                throw new CompileException("Syntax error found in compilation at `NEGATION` on line " + this.parser.getCurrentLine() + " when it expected RSQBRACKET");
            }
            index.left = output;
            output = index;
            if (this.parser.peekAhead() == 50) {
                IAST cur = output;
                while (this.parser.peekAhead() == 50) {
                    IAST m = new IAST();
                    this.nextSymb();
                    this.nextSymb();
                    IAST inner_value = this.compileExpression(false);
                    m.type = (byte)88;
                    if (this.parser.peekAhead() == 74) {
                        IAST range = new IAST();
                        range.type = (byte)74;
                        this.nextSymb();
                        this.nextSymb();
                        range.left = inner_value;
                        range.middle = this.compileExpression(false);
                        m.value = range;
                    } else {
                        m.value = inner_value;
                    }
                    this.nextSymb();
                    if (this.parser.getCurrentSymbol() != 51) {
                        throw new CompileException("Syntax error found in compilation at `VARIABLE` on line " + this.parser.getCurrentLine() + " when it expected RSQBRACKET");
                    }
                    m.left = cur;
                    cur = m;
                }
                output = cur;
            }
        }
        return output;
    }

    private IAST compileArguments() throws CompileException {
        IAST out = new IAST();
        out.type = (byte)-6;
        IAST current = out;
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            while (this.parser.getCurrentSymbol() != 19) {
                IAST node = this.parser.getCurrentSymbol() == 87 ? this.compileVar() : this.compileExpression(false);
                assert (current != null);
                current = current.next = node;
                this.nextSymb();
                if (this.parser.getCurrentSymbol() == 16) {
                    this.nextSymb();
                    assert (node != null);
                    node.value = this.compileExpression(false);
                    this.nextSymb();
                }
                if (this.parser.getCurrentSymbol() != 20) {
                    if (this.parser.getCurrentSymbol() == 19 || this.parser.getProgramCounter() == this.parser.getProgram().length()) break;
                    throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected COMMA");
                }
                this.nextSymb();
            }
        }
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (out.next != null) {
            return out.next;
        }
        return out;
    }

    private boolean isAcceptedDirective(String d) {
        for (String s : this.acceptedDirectives) {
            if (!d.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private IAST compileParameters() throws CompileException {
        IAST out = new IAST();
        out.type = (byte)-5;
        IAST current = out;
        if (this.parser.getCurrentSymbol() != 18) {
            throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected LBRACKET");
        }
        this.nextSymb();
        if (this.parser.getCurrentSymbol() != 19) {
            while (this.parser.getCurrentSymbol() != 19) {
                IAST node;
                IAST var = new IAST();
                if (this.parser.getCurrentSymbol() == 3) {
                    String id = this.parser.getCurrentWord();
                    var.type = (byte)4;
                    if (this.parser.getCurrentSymbol() != 3) {
                        throw new CompileException("Syntax error found in compilation at `NAME` on line " + this.parser.getCurrentLine() + " when it expected TYPE");
                    }
                    var.id = id;
                    this.getCurrentFunction().vars.put(id, new CompilerFunction.CompilerFunctionVariable(118, null));
                } else {
                    var = this.compileVar();
                }
                if (this.parser.peekAhead() == 67 && this.parser.peekAhead(2) == 67) {
                    this.nextSymb();
                    this.nextSymb();
                    node = var;
                    assert (node != null);
                    node.type = (byte)-7;
                    assert (current != null);
                    current.next = node;
                    this.nextSymb();
                    if (this.parser.getCurrentSymbol() == 67) {
                        this.nextSymb();
                    }
                    if (this.parser.getCurrentSymbol() == 19) break;
                    throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected RBRA");
                }
                node = var;
                assert (current != null);
                current = current.next = node;
                this.nextSymb();
                if (this.parser.getCurrentSymbol() != 20 && this.parser.getCurrentSymbol() == 19) break;
                if (this.parser.getCurrentSymbol() != 20) {
                    throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected COMMA");
                }
                this.nextSymb();
            }
        }
        if (this.parser.getCurrentSymbol() != 19) {
            throw new CompileException("Syntax error found in compilation at `GET_PARAMETERS` on line " + this.parser.getCurrentLine() + " when it expected RBRACKET");
        }
        if (out.next != null) {
            return out.next;
        }
        return out;
    }

    private Object evaluateValue(Object v) {
        if (v instanceof IAST) {
            IAST ast = (IAST)v;
            if (ast.type == -9 && ast.value instanceof IAST) {
                IAST ast2 = (IAST)ast.value;
                if (ast.next != null) {
                    IAST current = ast2;
                    while (current.next != null) {
                    }
                } else {
                    if ((ast2.type == 5 || ast2.type == 6) && ast.next == null) {
                        return ast2.value;
                    }
                    if (ast2.type == 8 && ast.next == null) {
                        return ast2.value;
                    }
                }
            }
        }
        return null;
    }

    static class CompilerConstant {
        String value;
        byte type;

        public CompilerConstant(String value, byte type) {
            this.value = value;
            this.type = type;
        }
    }

    static class CompileDetails {
        public String name = "";
        public String author = "";

        public CompileDetails() {
        }

        public CompileDetails(String name, String author) {
            this.name = name;
            this.author = author;
        }
    }

    static class YASSCompiledExecutable
    implements Serializable {
        private static final long serialVersionUID = 9029406009755142869L;
        public boolean experimental = false;
        public Object program = null;
        public boolean prevent_auto_includes = false;
        String name = "";
        String author = "";
        long time = 0L;
        HashMap<String, byte[]> files;
        String passcode = "";
        private String compiler_version = "1.13.9";

        public String getName() {
            return this.name;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getCompilerVersion() {
            return this.compiler_version;
        }

        public long getCompiledTime() {
            return this.time;
        }
    }

    static class CompilerModule {
        private Map<String, Byte> vars = new HashMap<String, Byte>();
        private ArrayList<String> tuples = new ArrayList();

        CompilerModule() {
        }

        public void setVariable(String s, byte type) {
            this.vars.put(s, type);
        }
    }

    static class CompilerFunction {
        private Map<String, CompilerFunctionVariable> vars = new HashMap<String, CompilerFunctionVariable>();
        private ArrayList<String> tuples = new ArrayList();
        YASSCompiler c;

        public CompilerFunction(YASSCompiler c) {
            this.c = c;
        }

        public void setVariable(String s, byte type) {
            if (this.c.currentModule == null) {
                this.vars.put(s, new CompilerFunctionVariable(type, null));
            } else {
                this.c.currentModule.setVariable(s, type);
            }
        }

        public boolean containsKey(String s) {
            if (this.c.currentModule != null && this.c.currentModule.vars.containsKey(s)) {
                return true;
            }
            return this.vars.containsKey(s);
        }

        public byte get(String s) {
            return this.vars.get((Object)s).type;
        }

        public Set<String> keySet() {
            return this.vars.keySet();
        }

        static class CompilerFunctionVariable {
            public byte type;
            public Object value;

            public CompilerFunctionVariable(byte type, Object value) {
                this.type = type;
                this.value = value;
            }
        }
    }
}

