/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.components.BalfScrollbar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class BalfSearchBox
extends JTextField {
    private boolean darkMode = false;
    JPopupMenu suggestionPopup = new JPopupMenu();
    SuggestionList suggestionList = new SuggestionList();
    ArrayList<SearchSuggestion> suggestions = new ArrayList();
    String searchText = "Search...";
    int arc;
    int borderWidth = 0;
    Color borderColor = null;
    private boolean showCaret = true;
    private Timer caretTimer;
    private final List<SearchSuggestedClickListener> suggestionListeners = new ArrayList<SearchSuggestedClickListener>();
    private final List<KeyPressListener> keyPressListeners = new ArrayList<KeyPressListener>();
    private BufferedImage cache;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private boolean lastDarkMode = false;
    private int lastArc = -2;

    public BalfSearchBox(int arc) {
        this.arc = arc;
        this.setup();
    }

    public BalfSearchBox(String searchText, int arc) {
        this.searchText = searchText;
        this.arc = arc;
        this.setup();
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    private void setup() {
        this.setMaximumSize(new Dimension(190, 25));
        this.setPreferredSize(new Dimension(190, 35));
        this.setBorder(new EmptyBorder(16, 3, 16, 3));
        this.setForeground(Color.BLACK);
        this.setOpaque(false);
        this.setCaret(new HiddenCaret());
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            this.darkMode = enabled;
            if (this.darkMode) {
                this.setForeground(Color.WHITE);
            } else {
                this.setForeground(Color.BLACK);
            }
        });
        this.caretTimer = new Timer(500, e -> {
            this.showCaret = !this.showCaret;
            this.repaint();
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BalfSearchBox.this.caretTimer.start();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BalfSearchBox.this.caretTimer.stop();
                BalfSearchBox.this.showCaret = false;
                BalfSearchBox.this.repaint();
            }
        });
        this.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 14.0f));
        if (this.darkMode) {
            this.setForeground(Color.WHITE);
        } else {
            this.setForeground(Color.BLACK);
        }
        this.suggestionPopup.setBorder(new EmptyBorder(0, 0, 0, 0));
        BalfScrollbar b = new BalfScrollbar(this.suggestionList);
        this.suggestionList.setBorder(new EmptyBorder(0, 0, 0, 0));
        b.setBorder(new EmptyBorder(0, 0, 0, 0));
        b.setHorizontalScrollBarPolicy(31);
        this.suggestionPopup.add(b);
        this.suggestionPopup.setFocusable(false);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BalfSearchBox.this.showSuggestions();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BalfSearchBox.this.showSuggestions();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BalfSearchBox.this.showSuggestions();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                BalfSearchBox.this.repaint();
            }
        });
        this.suggestionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String selected = (String)BalfSearchBox.this.suggestionList.getSelectedValue();
                if (selected != null) {
                    for (SearchSuggestedClickListener l : BalfSearchBox.this.suggestionListeners) {
                        l.onSearchSuggestionClicked(selected);
                    }
                    BalfSearchBox.this.suggestionPopup.setVisible(false);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                block5: {
                    block7: {
                        int cur;
                        block6: {
                            super.keyReleased(e);
                            if (BalfSearchBox.this.suggestionList == null) break block5;
                            cur = BalfSearchBox.this.suggestionList.getSelectedIndex();
                            if (e.getKeyCode() != 40) break block6;
                            if (cur + 1 >= BalfSearchBox.this.suggestions.size()) break block5;
                            BalfSearchBox.this.suggestionList.setSelectedIndex(cur + 1);
                            break block5;
                        }
                        if (e.getKeyCode() != 38) break block7;
                        if (cur - 1 <= -1) break block5;
                        BalfSearchBox.this.suggestionList.setSelectedIndex(cur - 1);
                        break block5;
                    }
                    if (e.getKeyCode() == 10) {
                        if (BalfSearchBox.this.suggestionList.getSelectedIndex() != -1) {
                            for (SearchSuggestedClickListener l : BalfSearchBox.this.suggestionListeners) {
                                l.onSearchSuggestionClicked((String)BalfSearchBox.this.suggestionList.getSelectedValue());
                            }
                        } else {
                            for (KeyPressListener l : BalfSearchBox.this.keyPressListeners) {
                                l.onKeyPress(BalfSearchBox.this.getText());
                            }
                        }
                    }
                }
            }
        });
    }

    public void addSuggestion(SearchSuggestion suggestion) {
        this.suggestions.add(suggestion);
    }

    public void deleteSuggestion(SearchSuggestion suggestion) {
        this.suggestions.remove(suggestion);
    }

    public void deleteAllSuggestions() {
        this.suggestions.clear();
    }

    public void addBorder(int width, Color color) {
        this.borderWidth = width;
        this.borderColor = color;
        this.repaint();
    }

    private void drawSearchIcon(Graphics2D g2, int x, int y, int size) {
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(new Color(150, 150, 150));
        int radius = size / 2 - 2;
        g2.drawOval(x, y, radius * 2, radius * 2);
        int handleLength = size / 2 - 3;
        int cx = x + radius + 4;
        int cy = y + radius + 4;
        g2.drawLine(cx, cy, cx + handleLength, cy + handleLength);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2;
        boolean needsRepaint;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean bl = needsRepaint = this.cache == null || width != this.lastWidth || height != this.lastHeight || this.darkMode != this.lastDarkMode || this.arc != this.lastArc;
        if (needsRepaint) {
            int arcHeight;
            int arcWidth;
            this.cache = new BufferedImage(width, height, 2);
            g2 = this.cache.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            if (this.arc == -1) {
                arcWidth = width;
                arcHeight = height;
            } else {
                arcWidth = this.arc;
                arcHeight = this.arc;
            }
            int inset = this.borderWidth / 2 + 1;
            g2.setColor(this.darkMode ? BalfLafManager.getInstance().getDarkColorInputBackground() : Color.WHITE);
            g2.fillRoundRect(inset, inset, width - inset * 2, height - inset * 2, arcWidth, arcHeight);
            if (this.borderWidth > 0) {
                g2.setColor(this.borderColor);
                g2.setStroke(new BasicStroke(this.borderWidth));
                g2.drawRoundRect(inset, inset, width - this.borderWidth - inset * 2, height - this.borderWidth - inset * 2, this.arc, this.arc);
            }
            g2.dispose();
            this.lastWidth = width;
            this.lastHeight = height;
            this.lastDarkMode = this.darkMode;
            this.lastArc = this.arc;
        }
        g.drawImage(this.cache, 0, 0, null);
        g2 = (Graphics2D)g.create();
        if (this.getText().isEmpty() && !this.hasFocus() && !this.isFocusOwner()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(new Color(150, 150, 150));
            g2.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
            int x = 27;
            this.drawSearchIcon(g2, 5, (this.getHeight() - 14) / 2, 14);
            FontMetrics fm = g2.getFontMetrics();
            int y = (height - fm.getHeight()) / 2 + fm.getAscent();
            g2.drawString(this.searchText, x, y);
        }
        if (this.isFocusOwner() && this.showCaret) {
            try {
                g2.setColor(Color.BLACK);
                Rectangle2D shape = this.modelToView2D(this.getCaretPosition());
                if (shape != null) {
                    Rectangle2D rect = shape.getBounds2D();
                    g2.fillRect((int)rect.getX(), (int)rect.getY(), 1, (int)rect.getHeight());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        g2.dispose();
        super.paintComponent(g);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 10, 0, 10);
    }

    private void showSuggestions() {
        String input = this.getText().trim().toLowerCase();
        if (input.isEmpty()) {
            this.suggestionPopup.setVisible(false);
            return;
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (SearchSuggestion i : this.suggestions) {
            if (!i.suggestion.toLowerCase().contains(input)) continue;
            matches.add(i.displayText);
        }
        if (matches.isEmpty()) {
            this.suggestionPopup.setVisible(false);
            return;
        }
        this.suggestionList.setListData(matches.toArray(new String[0]));
        try {
            int height;
            Point location = this.getLocationOnScreen();
            int index = 0;
            Rectangle bounds = this.suggestionList.getCellBounds(index, index);
            int n = height = bounds != null ? bounds.height : -1;
            if (matches.size() < 10) {
                this.suggestionPopup.setPopupSize(this.getWidth() + 100, matches.size() * height);
            } else {
                this.suggestionPopup.setPopupSize(this.getWidth() + 100, 200);
            }
            this.suggestionPopup.show(this, -100, this.getHeight());
            this.suggestionList.setSelectedIndex(0);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void addSearchSuggestionListener(SearchSuggestedClickListener listener) {
        this.suggestionListeners.add(listener);
    }

    public void addKeyPressListener(KeyPressListener listener) {
        this.keyPressListeners.add(listener);
    }

    public void removeSearchSuggestionListener(SearchSuggestedClickListener listener) {
        this.suggestionListeners.remove(listener);
    }

    public void removeKeyPressListener(KeyPressListener listener) {
        this.keyPressListeners.remove(listener);
    }

    private static class HiddenCaret
    extends DefaultCaret {
        private HiddenCaret() {
        }

        @Override
        public void paint(Graphics g) {
        }
    }

    public static class SearchSuggestion {
        public String suggestion;
        public String displayText;

        public SearchSuggestion(String suggestionText, String displayText) {
            this.suggestion = suggestionText;
            this.displayText = displayText;
        }
    }

    public class SuggestionList
    extends JList<String> {
        boolean darkMode = false;

        public SuggestionList() {
            this.setOpaque(false);
            this.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
                JLabel label = new JLabel((String)value);
                label.setOpaque(true);
                if (this.darkMode) {
                    label.setBackground(isSelected ? new Color(60, 60, 80) : new Color(40, 40, 40));
                    label.setForeground(Color.WHITE);
                } else {
                    label.setBackground(isSelected ? new Color(220, 220, 255) : Color.WHITE);
                    label.setForeground(Color.BLACK);
                }
                return label;
            });
            BalfLafManager.getInstance().addDarkModeListener(enabled -> {
                this.darkMode = enabled;
                if (this.darkMode) {
                    this.setForeground(Color.WHITE);
                } else {
                    this.setForeground(Color.BLACK);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            if (this.darkMode) {
                g2d.setColor(new Color(40, 40, 40));
            } else {
                g2d.setColor(Color.WHITE);
            }
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
            super.paintComponent(g);
        }
    }

    public static interface KeyPressListener {
        public void onKeyPress(String var1);
    }

    public static interface SearchSuggestedClickListener {
        public void onSearchSuggestionClicked(String var1);
    }
}

