/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfLafManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BalfScrollbar
extends JScrollPane {
    Color lightColor;
    Color darkColour = HelperFunctions.adjustColorForContrast(BalfLafManager.getInstance().getDarkColorBackground(), 2);
    boolean allowDarkMode = true;

    public BalfScrollbar() {
        this.lightColor = this.getBackground();
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            if (enabled) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
        });
    }

    public void setLightColour(Color lightColour) {
        this.lightColor = lightColour;
        if (!BalfLafManager.getInstance().isDarkModeEnabled()) {
            this.setBackground(lightColour);
        }
    }

    public void setDarkColour(Color darkColour) {
        this.darkColour = darkColour;
        if (BalfLafManager.getInstance().isDarkModeEnabled()) {
            this.setBackground(darkColour);
        }
    }

    public BalfScrollbar(Component view) {
        super(view);
        this.lightColor = this.getBackground();
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            if (enabled) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
        });
    }

    public void disableDarkMode() {
        this.allowDarkMode = false;
        this.setForeground(Color.BLACK);
        this.repaint();
    }

    private void switchOnDarkMode() {
        if (this.allowDarkMode) {
            this.setUpScrollBar(this.darkColour, Color.decode("#777777"));
            this.setBackground(this.darkColour);
            this.getViewport().setBackground(this.darkColour);
        }
    }

    private void switchOffDarkMode() {
        this.setUpScrollBar(this.lightColor, Color.decode("#aaaaaa"));
        this.setBackground(this.lightColor);
        this.getViewport().setBackground(this.lightColor);
    }

    private void setUpScrollBar(final Color trackColour, final Color thumbColour) {
        this.getVerticalScrollBar().setUI(new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = thumbColour;
                this.trackColor = trackColour;
                this.scrollBarWidth = 7;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.thumbColor);
                int arc = 10;
                g2.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
                g2.dispose();
            }
        });
        this.getHorizontalScrollBar().setUI(new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = thumbColour;
                this.trackColor = trackColour;
                this.scrollBarWidth = 7;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return BalfScrollbar.this.createZeroButton();
            }

            @Override
            protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.thumbColor);
                int arc = 10;
                g2.fillRoundRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, arc, arc);
                g2.dispose();
            }
        });
    }

    private JButton createZeroButton() {
        JButton button = new JButton();
        Dimension zeroDim = new Dimension(0, 0);
        button.setPreferredSize(zeroDim);
        button.setMinimumSize(zeroDim);
        button.setMaximumSize(zeroDim);
        return button;
    }
}

