/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.ui.BalfLafManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;

public class BalfButton
extends JButton {
    int rounding;
    private boolean hovered = false;
    private boolean jbButtons = false;
    private boolean allowDarkMode = true;
    private BufferedImage cachedImage;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private boolean lastHovered = false;
    private boolean lastFocused = false;
    private boolean lastDarkMode = false;
    private boolean lastAllowDarkMode = false;
    private boolean lastJbButtons = false;
    private int lastRounding = -2;

    public BalfButton(String text, int rounding) {
        this.setText(text);
        this.rounding = rounding;
        this.setMinimumSize(new Dimension(200, 140));
        if (this.getPreferredSize() == null) {
            this.setPreferredSize(new Dimension(200, 140));
        }
        this.setFocusPainted(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.setBorder(new EmptyBorder(7, 15, 7, 15));
        this.setForeground(Color.BLACK);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                BalfButton.this.hovered = true;
                BalfButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                BalfButton.this.hovered = false;
                BalfButton.this.repaint();
            }
        });
        BalfLafManager.getInstance().addDarkModeListener(e -> {
            if (this.allowDarkMode) {
                this.setForeground(Color.BLACK);
                if (e) {
                    this.setForeground(BalfLafManager.getInstance().getDarkColorForeground());
                }
            } else {
                this.setForeground(Color.BLACK);
            }
            this.repaint();
        });
    }

    public void disableDarkMode() {
        this.allowDarkMode = false;
        this.setForeground(Color.BLACK);
        this.repaint();
    }

    public void setRounded(int rounding) {
        this.rounding = rounding;
    }

    public void useJBStyle(boolean enable) {
        this.jbButtons = enable;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean needsRedraw;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean bl = needsRedraw = this.cachedImage == null || width != this.lastWidth || height != this.lastHeight || this.hovered != this.lastHovered || this.hasFocus() != this.lastFocused || BalfLafManager.getInstance().isDarkModeEnabled() != this.lastDarkMode || this.allowDarkMode != this.lastAllowDarkMode || this.jbButtons != this.lastJbButtons || this.rounding != this.lastRounding;
        if (needsRedraw) {
            int arcWidth;
            this.cachedImage = new BufferedImage(width, height, 2);
            Graphics2D g2 = this.cachedImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            int arcHeight = arcWidth = this.rounding == -1 ? height : this.rounding;
            int inset = 1;
            Color fillColor = Color.WHITE;
            if (BalfLafManager.getInstance().isDarkModeEnabled() && this.allowDarkMode) {
                fillColor = BalfLafManager.getInstance().getDarkColorComponentBackground();
            }
            if (this.hovered && this.isEnabled()) {
                fillColor = new Color(235, 235, 235);
                if (BalfLafManager.getInstance().isDarkModeEnabled() && this.allowDarkMode) {
                    fillColor = BalfLafManager.getInstance().getDarkColorComponentBackground().darker();
                }
            }
            if (!this.jbButtons) {
                g2.setColor(fillColor);
            } else if (this.hovered && this.isEnabled()) {
                Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
                Point2D.Float end = new Point2D.Float(width, height);
                float[] dist = new float[]{0.0f, 1.0f};
                Color[] colors = new Color[]{new Color(16754176), new Color(13373400)};
                LinearGradientPaint paint = new LinearGradientPaint(start, end, dist, colors);
                g2.setPaint(paint);
            } else {
                g2.setColor(fillColor);
            }
            g2.fillRoundRect(inset, inset, width - inset * 2, height - inset * 2, arcWidth, arcHeight);
            Color borderColor = new Color(220, 220, 220);
            if (BalfLafManager.getInstance().isDarkModeEnabled() && this.allowDarkMode) {
                borderColor = new Color(19, 23, 43);
            }
            if (this.hasFocus()) {
                borderColor = new Color(255, 128, 0);
                if (BalfLafManager.getInstance().isDarkModeEnabled() && this.allowDarkMode) {
                    borderColor = new Color(46, 13, 80);
                }
            }
            if (this.hovered && this.isEnabled()) {
                borderColor = new Color(200, 200, 200);
                if (BalfLafManager.getInstance().isDarkModeEnabled() && this.allowDarkMode) {
                    borderColor = new Color(17, 31, 64);
                }
            }
            g2.setColor(borderColor);
            g2.setStroke(new BasicStroke(1.0f));
            if (!this.jbButtons) {
                g2.drawRoundRect(inset, inset, width - inset * 2, height - inset * 2, arcWidth, arcHeight);
            } else {
                g2.setColor(fillColor);
                int borderThickness = 3;
                int innerX = inset + borderThickness;
                int innerY = inset + borderThickness;
                int innerWidth = width - (inset + borderThickness) * 2;
                int innerHeight = height - (inset + borderThickness) * 2;
                int innerArcWidth = arcWidth - borderThickness * 2;
                int innerArcHeight = arcHeight - borderThickness * 2;
                if (innerArcWidth < 0) {
                    innerArcWidth = 0;
                }
                if (innerArcHeight < 0) {
                    innerArcHeight = 0;
                }
                g2.fillRoundRect(innerX, innerY, innerWidth, innerHeight, innerArcWidth, innerArcHeight);
            }
            g2.dispose();
            this.lastWidth = width;
            this.lastHeight = height;
            this.lastHovered = this.hovered;
            this.lastFocused = this.hasFocus();
            this.lastDarkMode = BalfLafManager.getInstance().isDarkModeEnabled();
            this.lastAllowDarkMode = this.allowDarkMode;
            this.lastJbButtons = this.jbButtons;
            this.lastRounding = this.rounding;
        }
        g.drawImage(this.cachedImage, 0, 0, null);
        super.paintComponent(g);
    }
}

