/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageEffects {
    public static BufferedImage generateGreyscaleImage(BufferedImage img) {
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                Color rgb = new Color(img.getRGB(x, y));
                int r = rgb.getRed();
                int g = rgb.getGreen();
                int b = rgb.getBlue();
                int t = (r + g + b) / 3;
                Color c = new Color(t, t, t);
                img.setRGB(x, y, c.getRGB());
                ++y;
            }
            ++x;
        }
        return img;
    }

    public static BufferedImage generateSepiaImage(BufferedImage img) {
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                Color rgb = new Color(img.getRGB(x, y));
                int inputRed = rgb.getRed();
                int inputGreen = rgb.getGreen();
                int inputBlue = rgb.getBlue();
                int outputRed = (int)((double)inputRed * 0.393 + (double)inputGreen * 0.769 + (double)inputBlue * 0.189);
                int outputGreen = (int)((double)inputRed * 0.349 + (double)inputGreen * 0.686 + (double)inputBlue * 0.168);
                int outputBlue = (int)((double)inputRed * 0.272 + (double)inputGreen * 0.534 + (double)inputBlue * 0.131);
                outputRed = ImageEffects.limitInteger(outputRed, 0, 255);
                outputGreen = ImageEffects.limitInteger(outputGreen, 0, 255);
                outputBlue = ImageEffects.limitInteger(outputBlue, 0, 255);
                Color c = new Color(outputRed, outputGreen, outputBlue);
                img.setRGB(x, y, c.getRGB());
                ++y;
            }
            ++x;
        }
        return img;
    }

    public static BufferedImage invertImageColour(BufferedImage img) {
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                Color rgb = new Color(img.getRGB(x, y));
                int inputRed = rgb.getRed();
                int inputGreen = rgb.getGreen();
                int inputBlue = rgb.getBlue();
                int outputRed = 255 - inputRed;
                int outputGreen = 255 - inputGreen;
                int outputBlue = 255 - inputBlue;
                outputRed = ImageEffects.limitInteger(outputRed, 0, 255);
                outputGreen = ImageEffects.limitInteger(outputGreen, 0, 255);
                outputBlue = ImageEffects.limitInteger(outputBlue, 0, 255);
                Color c = new Color(outputRed, outputGreen, outputBlue);
                img.setRGB(x, y, c.getRGB());
                ++y;
            }
            ++x;
        }
        return img;
    }

    public static BufferedImage resizeImage(BufferedImage img, int width, int height) {
        int type = img.getType() == 0 ? 2 : img.getType();
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return resizedImage;
    }

    public static BufferedImage rotateImage(BufferedImage img, int rotation) {
        int type = img.getType() == 0 ? 2 : img.getType();
        BufferedImage copyImg = new BufferedImage(img.getWidth(), img.getHeight(), type);
        Graphics2D g = copyImg.createGraphics();
        double rotationRequired = Math.toRadians(rotation);
        double locationX = (double)img.getWidth() / 2.0;
        double locationY = (double)img.getHeight() / 2.0;
        AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        g.drawImage((Image)op.filter(img, null), 0, 0, null);
        return copyImg;
    }

    public static boolean testImageEquality(BufferedImage img1, BufferedImage img2) {
        if (img1.getWidth() != img2.getWidth() || img1.getHeight() != img2.getHeight()) {
            return false;
        }
        int x = 0;
        while (x < img1.getWidth()) {
            int y = 0;
            while (y < img1.getHeight()) {
                int c2;
                int c1 = img1.getRGB(x, y);
                if (c1 != (c2 = img2.getRGB(x, y))) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public static BufferedImage darkenImage(BufferedImage img1) {
        BufferedImage img2 = new BufferedImage(img1.getWidth(), img1.getHeight(), 100);
        int x = 0;
        while (x < img2.getWidth()) {
            int y = 0;
            while (y < img2.getHeight()) {
                Color c = new Color(0, 0, 0, 100);
                img2.setRGB(x, y, c.getRGB());
                ++y;
            }
            ++x;
        }
        Graphics2D g = img1.createGraphics();
        g.drawImage(img2, 0, 0, img2.getWidth(), img2.getHeight(), null);
        return img1;
    }

    private static int limitInteger(int i, int min, int max) {
        int out = i;
        if (i > max) {
            out = max;
        }
        if (i < min) {
            out = min;
        }
        return out;
    }
}

