/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour;

import jamiebalfour.FontUtils;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class HelperFunctions {
    static boolean input_redirected = false;
    static String bestFont;
    static Font bestSystemFont;
    static Font bestTextFont;
    private static String OS;

    static {
        OS = System.getProperty("os.name").toLowerCase();
    }

    public static void main(String[] args2) {
    }

    public static boolean fileExists(String f) {
        return new File(f).exists();
    }

    public static boolean isDirectory(String f) {
        return new File(f).isDirectory();
    }

    public static boolean isJavaAvailable() {
        try {
            Process process = new ProcessBuilder("java", "-version").redirectErrorStream(true).start();
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemBeep(double freq, double millis) throws Exception {
        float sampleRate = 44100.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        int numSamples = (int)(millis / 1000.0 * (double)sampleRate);
        byte[] data = new byte[2 * numSamples];
        int i = 0;
        while (i < numSamples) {
            double angle = Math.PI * 2 * freq * (double)i / (double)sampleRate;
            short val = (short)(Math.sin(angle) * 32767.0);
            data[2 * i] = (byte)(val & 0xFF);
            data[2 * i + 1] = (byte)(val >> 8 & 0xFF);
            ++i;
        }
        Clip clip = AudioSystem.getClip();
        clip.open(format, data, 0, data.length);
        Object lock = new Object();
        clip.addLineListener(e -> {
            if (e.getType() == LineEvent.Type.STOP) {
                Object object2 = lock;
                synchronized (object2) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            clip.start();
            lock.wait();
        }
        clip.close();
    }

    public static Color adjustColorForContrast(Color c, int times) {
        double brightness = 0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue();
        if (brightness < 40.0) {
            int i = 0;
            while (i < times) {
                c = c.brighter();
                ++i;
            }
            return c;
        }
        if (brightness > 215.0) {
            int i = 0;
            while (i < times) {
                c = c.darker();
                ++i;
            }
            return c;
        }
        int i = 0;
        while (i < times) {
            c = c.darker();
            ++i;
        }
        return c;
    }

    public static void systemBeepOld(double freq, double millis) throws Exception {
        Clip clip = AudioSystem.getClip();
        AudioFormat af = clip.getFormat();
        if (af.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new UnsupportedOperationException("Unknown encoding");
        }
        if (af.getSampleSizeInBits() != 16) {
            System.err.println("Sample size not valid.");
            return;
        }
        int bytesPerFrame = af.getFrameSize();
        double fps = af.getFrameRate();
        int frames = (int)(fps * (millis / 1000.0));
        ByteBuffer data = ByteBuffer.allocate(frames * bytesPerFrame);
        double freqFactor = 1.5707963267948966 * freq / fps;
        double ampFactor = 32767.0;
        int frame = 0;
        while (frame < frames) {
            short sample = (short)(ampFactor * Math.sin((double)frame * freqFactor));
            data.putShort(sample);
            ++frame;
        }
        clip.open(af, data.array(), 0, data.position());
        class AudioListener
        implements LineListener {
            private boolean done = false;

            AudioListener() {
            }

            @Override
            public synchronized void update(LineEvent event) {
                if (event.getType() == LineEvent.Type.STOP || event.getType() == LineEvent.Type.CLOSE) {
                    this.done = true;
                    this.notifyAll();
                }
            }

            public synchronized void waitUntilDone() throws InterruptedException {
                while (!this.done) {
                    this.wait();
                }
            }
        }
        AudioListener listener = new AudioListener();
        clip.addLineListener(listener);
        clip.start();
        listener.waitUntilDone();
        clip.close();
    }

    public static String getHexString(byte[] b) throws Exception {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return result.toString();
    }

    public static String shellExec(String cmd) throws IOException {
        StringBuilder output = new StringBuilder();
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            if (!output.toString().isEmpty()) {
                output.append("\r\n");
            }
            output.append(s);
        }
        while ((s = stdError.readLine()) != null) {
            if (!output.toString().isEmpty()) {
                output.append("\r\n");
            }
            output.append(s);
        }
        return output.toString();
    }

    public static String padString(String s, int to) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.length() > to) {
            return s.substring(0, to);
        }
        StringBuilder out = new StringBuilder(s);
        int x = 0;
        int i = s.length();
        while (i < to) {
            char ch = (char)(s.charAt(x % s.length()) + x);
            out.append(ch);
            ++x;
            ++i;
        }
        return out.toString();
    }

    public static Object negateValue(Object v) {
        if (v.toString().equals("true")) {
            return false;
        }
        if (v.toString().equals("false")) {
            return true;
        }
        if (HelperFunctions.isNumeric(v.toString())) {
            String m = v.toString();
            if (m.startsWith("-")) {
                return m.substring(1);
            }
            return "-" + m;
        }
        return false;
    }

    public static boolean unixProgramExists(String cmd) throws IOException {
        String s = HelperFunctions.shellExec("whereis " + cmd);
        return !s.isEmpty();
    }

    private static void updateTextArea(final String text, final JTextArea j) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                j.setEditable(false);
                j.append(text);
                j.setCaretPosition(j.getDocument().getLength());
                j.update(j.getGraphics());
            }
        });
    }

    public static Properties readProperties(String filename) throws IOException {
        Properties prop = new Properties();
        if (!new File(filename).exists()) {
            return prop;
        }
        FileInputStream input = new FileInputStream(filename);
        prop.load(input);
        ((InputStream)input).close();
        return prop;
    }

    public static String md5(String msg) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        assert (md != null);
        return HelperFunctions.getHexString(md.digest(msg.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha1(String msg) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        assert (md != null);
        return HelperFunctions.getHexString(md.digest(msg.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha256(String msg) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        assert (md != null);
        return HelperFunctions.getHexString(md.digest(msg.getBytes(StandardCharsets.UTF_8)));
    }

    public static void saveProperties(Properties p, String path, String comment) throws IOException {
        OutputStream os = Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]);
        p.store(os, comment);
    }

    public static String readString(String url) throws IOException {
        Scanner s = new Scanner(new URL(url).openStream(), "UTF-8");
        String out = s.useDelimiter("\\A").next();
        s.close();
        return out;
    }

    public static void redirectSystemOutput(final JTextArea j) {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                HelperFunctions.updateTextArea(String.valueOf((char)b), j);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                HelperFunctions.updateTextArea(new String(b, off, len), j);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
        input_redirected = true;
    }

    public static PrintStream redirectSystemOutput(OutputStream outputstream) {
        PrintStream ps = new PrintStream(outputstream);
        System.setOut(ps);
        return ps;
    }

    public static Number stringToNumber(String s) {
        double v = HelperFunctions.stringToDouble(s);
        if (Math.floor(v) == v) {
            return (int)Math.floor(v);
        }
        return v;
    }

    public static double stringToDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        if (s.equals("true")) {
            return 1.0;
        }
        if (!HelperFunctions.isNumeric(s)) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    public static int stringToInteger(String s) {
        return (int)Math.floor(HelperFunctions.stringToDouble(s));
    }

    public static long stringToLong(String s) {
        return (long)Math.floor(HelperFunctions.stringToDouble(s));
    }

    public static boolean isNumeric(Object s) {
        if (s == null) {
            return false;
        }
        return s.toString().matches("(-)?[0-9]+(\\.[0-9]+)?(E(-?)[0-9]+)?");
    }

    public static String removeExcessDecimalPoints(String s) {
        if (s.matches("[0-9]+\\.0") && s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public static String encrypt(String key, String initVector, String value) throws Exception {
        return HelperFunctions.encrypt(key.getBytes("UTF-8"), initVector.getBytes("UTF-8"), value);
    }

    public static String encrypt(byte[] key, byte[] initVector, String value) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(value.getBytes());
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static byte[] encrypt(String key, String initVector, byte[] value) throws Exception {
        return HelperFunctions.encrypt(key.getBytes("UTF-8"), initVector.getBytes("UTF-8"), value);
    }

    public static byte[] writeEncryptedObject(Object o, String key) throws Exception {
        return HelperFunctions.writeEncryptedObject(o, key.getBytes("UTF-8"));
    }

    public static byte[] writeEncryptedObject(Object o, byte[] key) throws Exception {
        SecretKeySpec randomKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)randomKey, new IvParameterSpec(key));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        cipherOutputStream.write(HelperFunctions.toBytes(o));
        cipherOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static int closeFrameAndExitIfNoFramesRemain(JFrame f) {
        f.dispose();
        int activeFrames = 0;
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            if (frame instanceof JFrame && frame.isVisible()) {
                ++activeFrames;
            }
            ++n2;
        }
        if (activeFrames == 0) {
            System.exit(0);
        }
        return activeFrames;
    }

    private static byte[] toBytes(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(obj);
        return out.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var3_3 = null;
        try {
            Object obj;
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                try (ObjectInputStream ois = new ObjectInputStream(bis);){
                    obj = ois.readObject();
                }
                if (bis == null) return obj;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (bis == null) throw throwable;
                bis.close();
                throw throwable;
            }
            bis.close();
            return obj;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static Object readEncryptedObject(byte[] o, String key) throws Exception {
        return HelperFunctions.readEncryptedObject(o, key.getBytes("UTF-8"));
    }

    public static Object readEncryptedObject(byte[] o, byte[] key) throws Exception {
        SecretKeySpec randomKey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)randomKey, new IvParameterSpec(key));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(o);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int read = cipherInputStream.read();
        while (read != -1) {
            byteArrayOutputStream.write(read);
            read = cipherInputStream.read();
        }
        cipherInputStream.close();
        return HelperFunctions.fromBytes(byteArrayOutputStream.toByteArray());
    }

    public static byte[] encrypt(byte[] key, byte[] initVector, byte[] value) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(value);
        return Base64.getEncoder().encode(encrypted);
    }

    public static Font getSystemDisplayFont(int size) throws IOException, FontFormatException {
        if (bestSystemFont != null) {
            return bestSystemFont.deriveFont((float)size);
        }
        if (HelperFunctions.isMac()) {
            Font sf = FontUtils.loadSystemFontByName("SF-Compact-Display-Thin.otf", size);
            if (sf != null) {
                bestSystemFont = sf;
                return sf;
            }
            Font helvetica = FontUtils.loadSystemFontByName("HelveticaNeue-Thin.otf", size);
            if (helvetica != null) {
                bestSystemFont = helvetica;
                return helvetica;
            }
        } else if (HelperFunctions.isWindows()) {
            Font aptosLight = FontUtils.loadSystemFontByName("Aptos-Light.ttf", 14.0f);
            if (aptosLight != null) {
                bestSystemFont = aptosLight;
                return aptosLight;
            }
            Font segoe = FontUtils.loadSystemFontByName("segoeuil.ttf", size);
            if (segoe != null) {
                bestSystemFont = segoe;
                return segoe;
            }
        } else if (HelperFunctions.isUnix()) {
            Font noto = FontUtils.loadSystemFontByName("NotoSans-Light.ttf", size);
            if (noto != null) {
                bestSystemFont = noto;
                return noto;
            }
            Font deja = FontUtils.loadSystemFontByName("DejaVuSans.ttf", size);
            if (deja != null) {
                bestSystemFont = deja;
                return deja;
            }
        }
        return null;
    }

    public static Font getSystemUserFont(int size) throws IOException, FontFormatException {
        if (bestTextFont != null) {
            return bestTextFont.deriveFont((float)size);
        }
        if (HelperFunctions.isMac()) {
            Font sf = FontUtils.loadSystemFontByName("SF-Compact-Text-Regular.otf", size);
            if (sf != null) {
                bestTextFont = sf;
                return sf;
            }
            Font helvetica = FontUtils.loadSystemFontByName("Helvetica.otf", size);
            if (helvetica != null) {
                bestTextFont = helvetica;
                return helvetica;
            }
        } else if (HelperFunctions.isWindows()) {
            Font aptosLight = FontUtils.loadSystemFontByName("Aptos.ttf", 14.0f);
            if (aptosLight != null) {
                bestTextFont = aptosLight;
                return aptosLight;
            }
            Font segoe = FontUtils.loadSystemFontByName("Calibri.ttf", size);
            if (segoe != null) {
                bestTextFont = segoe;
                return segoe;
            }
        } else if (HelperFunctions.isUnix()) {
            Font noto = FontUtils.loadSystemFontByName("NotoSans.ttf", size);
            if (noto != null) {
                bestTextFont = noto;
                return noto;
            }
            Font deja = FontUtils.loadSystemFontByName("DejaVuSans.ttf", size);
            if (deja != null) {
                bestTextFont = deja;
                return deja;
            }
        }
        return null;
    }

    public static String getBestAvailableFont(boolean checkForLightFirst) {
        if (bestFont == null) {
            return bestFont;
        }
        if (HelperFunctions.isMac()) {
            String[] order = new String[]{"SF Pro", "Helvetica", "Arial"};
            if (checkForLightFirst) {
                order = new String[]{"SF Pro Light", "SF Pro", "Helvetica Light", "Helvetica", "Arial"};
            }
            String[] stringArray = order;
            int n = order.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (HelperFunctions.fontInstalled(s)) {
                    bestFont = s;
                    return bestFont;
                }
                ++n2;
            }
        } else {
            String[] order = new String[]{"Aptos Display", "Segoe UI", "Arial"};
            if (checkForLightFirst) {
                order = new String[]{"Aptos Narrow", "Segoe UI Light", "Segoe UI", "Arial"};
            }
            String[] stringArray = order;
            int n = order.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                if (HelperFunctions.fontInstalled(s)) {
                    bestFont = s;
                    return bestFont;
                }
                ++n3;
            }
        }
        return bestFont;
    }

    public static boolean fontInstalled(String font) {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(font)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String encrypt(String key, String initVector, String value, int rounds) throws Exception {
        String str = HelperFunctions.encrypt(key, initVector, value);
        int i = 1;
        while (i < rounds) {
            str = HelperFunctions.encrypt(key, initVector, str);
            ++i;
        }
        return str;
    }

    public static String decrypt(String key, String initVector, String encrypted) throws Exception {
        return HelperFunctions.decrypt(key.getBytes("UTF-8"), initVector.getBytes("UTF-8"), encrypted);
    }

    public static String decrypt(byte[] key, byte[] initVector, String encrypted) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));
        return new String(original);
    }

    public static byte[] decrypt(String key, String initVector, byte[] encrypted) throws Exception {
        return HelperFunctions.decrypt(key.getBytes("UTF-8"), initVector.getBytes("UTF-8"), encrypted);
    }

    public static byte[] decrypt(byte[] key, byte[] initVector, byte[] encrypted) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));
        return original;
    }

    public static String decrypt(String key, String initVector, String encrypted, int rounds) throws Exception {
        String str = HelperFunctions.decrypt(key, initVector, encrypted);
        int i = 1;
        while (i < rounds) {
            str = HelperFunctions.decrypt(key, initVector, str);
            ++i;
        }
        return str;
    }

    public static void printBlankLines(int n) {
        int i = 0;
        while (i < n) {
            System.out.println();
            ++i;
        }
    }

    public static HashMap<String, String> generateArgumentMap(String[] argv) throws NoArgumentValueProvided {
        LinkedList<String> queue = new LinkedList<String>(Arrays.asList(argv));
        HashMap<String, String> args2 = new HashMap<String, String>();
        String zac = "";
        if (queue.peek() != null && ((String)queue.peek()).startsWith("-")) {
            zac = (String)queue.poll();
            if (queue.peek() != null && !((String)queue.peek()).startsWith("--") && !((String)queue.peek()).startsWith("-")) {
                args2.put(zac, (String)queue.poll());
            }
        }
        while (queue.peek() != null && !((String)queue.peek()).equals("-args")) {
            String arg = (String)queue.poll();
            if (arg.startsWith("--")) {
                args2.put(arg, "true");
                continue;
            }
            if (!arg.startsWith("-") || arg.length() >= 2 && arg.charAt(1) >= '0' && arg.charAt(1) <= '9') continue;
            if (queue.peek() == null) {
                throw new NoArgumentValueProvided("No value provided for " + arg);
            }
            args2.put(arg, (String)queue.poll());
        }
        return args2;
    }

    public static void openWebsite(String path) throws URISyntaxException, IOException {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI(path));
        }
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static void concurrentDelay(Runnable r) {
        Duration timeout2 = Duration.ofMillis(500L);
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.schedule(r, timeout2.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static String makePOSTRequest(String path, Map<String, String> arguments) throws Exception {
        return HelperFunctions.makePOSTRequest(path, "", arguments);
    }

    public static String makePOSTRequest(String path, String body, Map<String, String> arguments) {
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            String v = "";
            try {
                v = String.valueOf(entry.getValue());
            }
            catch (Exception exception) {
                v = entry.getValue();
            }
            try {
                sj.add(String.valueOf(URLEncoder.encode(entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode(v, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        try {
            return HelperFunctions.makePOSTRequest(path, body, sj.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String makePOSTRequest(String path, String paramsString) throws Exception {
        return HelperFunctions.makePOSTRequest(path, "", paramsString);
    }

    public static String makePOSTRequest(String path, String body, String paramsString) throws Exception {
        if (!path.startsWith("http://") && !path.startsWith("https://")) {
            path = "http://" + path;
        }
        URL url = new URL(path);
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        try {
            String inputLine;
            byte[] out = paramsString.getBytes(StandardCharsets.UTF_8);
            http.setDoOutput(true);
            OutputStream os = http.getOutputStream();
            os.write(out);
            os.write(body.getBytes("UTF8"));
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            String string = response.toString();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            http.disconnect();
        }
    }

    public static Date stringToDate(String str, String str_format) throws Exception {
        if (str.length() != str_format.length()) {
            throw new Exception("Date and format must be of the same length.");
        }
        String day = "";
        String month = "";
        String year = "";
        String hour = "";
        String minute = "";
        String second = "";
        int i = 0;
        int yrL = 0;
        int yrR = yrL = str_format.indexOf("y");
        if (yrL > -1) {
            i = yrL;
            while (i < str_format.length() && str_format.charAt(i) == 'y') {
                ++i;
            }
            yrR = i;
            year = str.substring(yrL, yrR);
        }
        int moL = 0;
        int moR = moL = str_format.indexOf("M");
        if (moL > -1) {
            i = moL;
            while (i < str_format.length() && str_format.charAt(i) == 'M') {
                ++i;
            }
            moR = i;
            month = str.substring(moL, moR);
        }
        int dayL = 0;
        int dayR = dayL = str_format.indexOf("d");
        if (dayL > -1) {
            i = dayL;
            while (i < str_format.length() && str_format.charAt(i) == 'd') {
                ++i;
            }
            dayR = i;
            day = str.substring(dayL, dayR);
        }
        int hL = 0;
        int hR = hL = str_format.indexOf("h");
        if (hL > -1) {
            i = hL;
            while (i < str_format.length() && str_format.charAt(i) == 'h') {
                ++i;
            }
            hR = i;
            hour = str.substring(hL, hR);
        }
        int mL = 0;
        int mR = mL = str_format.indexOf("m");
        if (mL > -1) {
            i = mL;
            while (i < str_format.length() && str_format.charAt(i) == 'm') {
                ++i;
            }
            mR = i;
            minute = str.substring(mL, mR);
        }
        int sL = 0;
        int sR = sL = str_format.indexOf("s");
        if (sL > -1) {
            i = sL;
            while (i < str_format.length() && str_format.charAt(i) == 's') {
                ++i;
            }
            sR = i;
            second = str.substring(sL, sR);
        }
        StringBuilder yString = new StringBuilder();
        i = yrL;
        while (i < yrR) {
            yString.append('y');
            ++i;
        }
        StringBuilder mString = new StringBuilder();
        i = moL;
        while (i < moR) {
            mString.append('M');
            ++i;
        }
        StringBuilder dString = new StringBuilder();
        i = dayL;
        while (i < dayR) {
            dString.append('d');
            ++i;
        }
        StringBuilder hrString = new StringBuilder();
        i = hL;
        while (i < hR) {
            hrString.append('h');
            ++i;
        }
        StringBuilder minString = new StringBuilder();
        i = mL;
        while (i < mR) {
            minString.append('m');
            ++i;
        }
        StringBuilder secString = new StringBuilder();
        i = sL;
        while (i < sR) {
            secString.append('s');
            ++i;
        }
        SimpleDateFormat format = new SimpleDateFormat("" + yString + mString + dString + hrString + minString + secString, Locale.ENGLISH);
        try {
            Date date = format.parse(String.valueOf(year) + month + day + hour + minute + second);
            return date;
        }
        catch (ParseException parseException) {
            throw new Exception("");
        }
    }

    public static String GetIP() throws Exception {
        URL whatismyip = new URL("http://checkip.amazonaws.com");
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
        String ip = in.readLine();
        in.close();
        return ip;
    }

    public static String getResource(String r) throws IOException {
        return HelperFunctions.getResource(r, HelperFunctions.class);
    }

    public static String getResource(String r, Class c) throws IOException {
        int length;
        InputStream in = c.getResourceAsStream(r);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        in.close();
        return result.toString("UTF-8");
    }

    public static boolean isDarkMode() {
        try {
            String cmd;
            return HelperFunctions.isMac() && HelperFunctions.shellExec(cmd = "defaults read -g AppleInterfaceStyle").equals("Dark");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDarkModeEnabledMac() {
        try {
            Process process = Runtime.getRuntime().exec("defaults read -g AppleInterfaceStyle");
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDarkModeEnabledWindows() {
        try {
            String line;
            Process process = Runtime.getRuntime().exec("reg query HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize /v AppsUseLightTheme");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("AppsUseLightTheme")) continue;
                return line.trim().endsWith("0x0");
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean isDarkModeEnabledGnome() {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"gsettings", "get", "org.gnome.desktop.interface", "color-scheme"});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String output = reader.readLine();
            return output != null && output.toLowerCase().contains("dark");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDarkModeEnabled() {
        if (HelperFunctions.isMac()) {
            return HelperFunctions.isDarkModeEnabledMac();
        }
        if (HelperFunctions.isWindows()) {
            return HelperFunctions.isDarkModeEnabledWindows();
        }
        if (HelperFunctions.isUnix()) {
            return HelperFunctions.isDarkModeEnabledGnome();
        }
        return false;
    }

    public static void delay(long t) {
        try {
            TimeUnit.MILLISECONDS.sleep(t);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static byte[] toByteArray(Object obj) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return bytes;
    }

    public static List<String> readLastNLines(String filePath, int n) throws IOException {
        ArrayDeque<String> deque = new ArrayDeque<String>(n);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (deque.size() == n) {
                    deque.removeFirst();
                }
                deque.addLast(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new ArrayList<String>(deque);
    }

    public static String capitalize(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public static String capitalizeSentences(String str) {
        String[] split = str.split("\\. ");
        StringBuilder output = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            output.append(HelperFunctions.capitalize(s)).append(". ");
            ++n2;
        }
        return output.toString();
    }

    public static File getAppDataDirectory(String appName, String alternative) {
        File appDir;
        String userHome = System.getProperty("user.home");
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String appData = System.getenv("APPDATA");
            appDir = new File(appData, appName);
        } else {
            appDir = os.contains("mac") ? new File(String.valueOf(userHome) + "/Library/Application Support", appName) : new File(userHome, "." + appName.toLowerCase());
        }
        if (!appDir.exists() && !appDir.mkdirs()) {
            return new File(alternative);
        }
        return appDir;
    }

    public static File getClassFilePath(Class<?> c) throws URISyntaxException {
        return new File(c.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    public static Font loadFontFromJar(String resourcePath, float size) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = HelperFunctions.class.getResourceAsStream(resourcePath);){
                assert (is != null);
                Font font = Font.createFont(0, is);
                return font.deriveFont(size);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FontFormatException | IOException exception) {
            return new Font("SansSerif", 0, (int)size);
        }
    }

    public static class NoArgumentValueProvided
    extends Exception {
        String message;

        public NoArgumentValueProvided(String msg) {
            this.message = msg;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }
}

