/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;

public class FontUtils {
    public static Font loadSystemFontByName(String fontFileName, float size) throws IOException, FontFormatException {
        File fontFile = FontUtils.findSystemFontFile(fontFileName);
        if (fontFile != null && fontFile.exists()) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(fontFile);){
                Font font = Font.createFont(0, is).deriveFont(size);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                return font;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private static File findSystemFontFile(String fontFileName) {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("mac")) {
            return FontUtils.searchFolders(new String[]{"/System/Library/Fonts/", "/Library/Fonts/", String.valueOf(System.getProperty("user.home")) + "/Library/Fonts/"}, fontFileName);
        }
        if (os.contains("win")) {
            return new File("C:\\Windows\\Fonts\\" + fontFileName);
        }
        if (os.contains("nix") || os.contains("nux")) {
            return FontUtils.searchFolders(new String[]{"/usr/share/fonts/", "/usr/local/share/fonts/", String.valueOf(System.getProperty("user.home")) + "/.fonts/"}, fontFileName);
        }
        return null;
    }

    private static File searchFolders(String[] directories, String fileName) {
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            File f = new File(dir, fileName);
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        return null;
    }
}

