/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class FileHelperFunctions {
    public static Clip openAudioClip(String url) throws Exception {
        FileInputStream str = new FileInputStream(url);
        AudioInputStream audioIn = AudioSystem.getAudioInputStream(new BufferedInputStream(str));
        Clip clip = AudioSystem.getClip();
        clip.open(audioIn);
        return clip;
    }

    public static byte[] readFile(String fileName) throws IOException {
        try (InputStream is = new File(fileName).exists() ? new FileInputStream(fileName) : new BufferedInputStream(new URL(fileName).openStream());){
            FileInputStream inputStream2 = new FileInputStream(fileName);
            long fileSize = new File(fileName).length();
            byte[] allBytes = new byte[(int)fileSize];
            ((InputStream)inputStream2).read(allBytes);
            ((InputStream)inputStream2).close();
            byte[] byArray = allBytes;
            return byArray;
        }
    }

    public static String readFileAsString(String fileName) throws IOException {
        return FileHelperFunctions.readFileAsString(fileName, null);
    }

    public static String readFileAsString(String fileName, String charsetName) throws IOException {
        byte[] o = FileHelperFunctions.readFile(fileName);
        int used = o.length;
        return charsetName != null ? new String(o, 0, used, charsetName) : new String(o, 0, used);
    }

    public static void writeFile(String filename, String content, boolean append) throws IOException {
        String[] contents = new String[]{content};
        FileHelperFunctions.writeFile(filename, contents, append);
    }

    public static void writeFile(String filename, String[] content, boolean append) throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename, append)));
        int i = 0;
        while (i < content.length) {
            out.print(content[i]);
            ++i;
        }
        out.close();
    }

    public static void writeByteFile(String filename, byte[] content) throws IOException {
        FileOutputStream stream = new FileOutputStream(filename);
        stream.write(content);
        stream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFileUsingStream(File source2, File dest) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream is = new FileInputStream(source2);
            try {
                try (FileOutputStream os = new FileOutputStream(dest);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)is).read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, length);
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

