/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.Sort;

public class FloatList
implements Iterable<Float> {
    int count;
    float[] data;

    public FloatList() {
        this.data = new float[10];
    }

    public FloatList(int length) {
        this.data = new float[length];
    }

    public FloatList(float[] list) {
        this.count = list.length;
        this.data = new float[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public FloatList(Iterable<Object> iter) {
        this(10);
        for (Object o : iter) {
            if (o == null) {
                this.append(Float.NaN);
                continue;
            }
            if (o instanceof Number) {
                this.append(((Number)o).floatValue());
                continue;
            }
            this.append(PApplet.parseFloat(o.toString().trim()));
        }
        this.crop();
    }

    public FloatList(Object ... items) {
        this.count = items.length;
        this.data = new float[this.count];
        int index = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            float value = Float.NaN;
            if (o != null) {
                value = o instanceof Number ? ((Number)o).floatValue() : PApplet.parseFloat(o.toString().trim(), Float.NaN);
            }
            this.data[index++] = value;
            ++n2;
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            float[] temp = new float[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0.0f);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public float get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void set(int index, float what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            int i = this.count;
            while (i < index) {
                this.data[i] = 0.0f;
                ++i;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void push(float value) {
        this.append(value);
    }

    public float pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        float value = this.get(this.count - 1);
        --this.count;
        return value;
    }

    public float remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        float entry = this.data[index];
        int i = index;
        while (i < this.count - 1) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int i;
        int ii = 0;
        if (Float.isNaN(value)) {
            i = 0;
            while (i < this.count) {
                if (!Float.isNaN(this.data[i])) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.count) {
                if (this.data[i] != (float)value) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public boolean replaceValue(float value, float newValue) {
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    this.data[i] = newValue;
                    return true;
                }
                ++i;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.data[index] = newValue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceValues(float value, float newValue) {
        boolean changed = false;
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    this.data[i] = newValue;
                    changed = true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == value) {
                    this.data[i] = newValue;
                    changed = true;
                }
                ++i;
            }
        }
        return changed;
    }

    public void append(float value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(float[] values2) {
        float[] fArray = values2;
        int n = values2.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void append(FloatList list) {
        float[] fArray = list.values();
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void appendUnique(float value) {
        if (!this.hasValue(value)) {
            this.append(value);
        }
    }

    public void insert(int index, float value) {
        this.insert(index, new float[]{value});
    }

    public void insert(int index, float[] values2) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        float[] temp = new float[this.count + values2.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values2, 0, temp, index, values2.length);
        System.arraycopy(this.data, index, temp, index + values2.length, this.count - index);
        this.count += values2.length;
        this.data = temp;
    }

    public void insert(int index, FloatList list) {
        this.insert(index, list.values());
    }

    public int index(float what) {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == what) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasValue(float value) {
        if (Float.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Float.isNaN(this.data[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == value) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void boundsProblem(int index, String method) {
        String msg = String.format("The list size is %d. You cannot %s() to element %d.", this.count, method, index);
        throw new ArrayIndexOutOfBoundsException(msg);
    }

    public void add(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] + amount;
        } else {
            this.boundsProblem(index, "add");
        }
    }

    public void sub(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] - amount;
        } else {
            this.boundsProblem(index, "sub");
        }
    }

    public void mult(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] * amount;
        } else {
            this.boundsProblem(index, "mult");
        }
    }

    public void div(int index, float amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] / amount;
        } else {
            this.boundsProblem(index, "div");
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public float min() {
        this.checkMinMax("min");
        int index = this.minIndex();
        return index == -1 ? Float.NaN : this.data[index];
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        float m = Float.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    float d = this.data[j];
                    if (!Float.isNaN(d) && d < m) {
                        m = this.data[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public float max() {
        this.checkMinMax("max");
        int index = this.maxIndex();
        return index == -1 ? Float.NaN : this.data[index];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        float m = Float.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    float d = this.data[j];
                    if (!Float.isNaN(d) && d > m) {
                        m = this.data[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public float sum() {
        double amount = this.sumDouble();
        if (amount > 3.4028234663852886E38) {
            throw new RuntimeException("sum() exceeds 3.4028235E38, use sumDouble()");
        }
        if (amount < -3.4028234663852886E38) {
            throw new RuntimeException("sum() lower than -3.4028235E38, use sumDouble()");
        }
        return (float)amount;
    }

    public double sumDouble() {
        double sum = 0.0;
        int i = 0;
        while (i < this.count) {
            sum += (double)this.data[i];
            ++i;
        }
        return sum;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                if (FloatList.this.count == 0) {
                    return 0;
                }
                int right = FloatList.this.count - 1;
                while (FloatList.this.data[right] != FloatList.this.data[right]) {
                    if (--right != -1) continue;
                    return 0;
                }
                int i = right;
                while (i >= 0) {
                    float v = FloatList.this.data[i];
                    if (v != v) {
                        FloatList.this.data[i] = FloatList.this.data[right];
                        FloatList.this.data[right] = v;
                        --right;
                    }
                    --i;
                }
                return right + 1;
            }

            @Override
            public float compare(int a, int b) {
                return FloatList.this.data[b] - FloatList.this.data[a];
            }

            @Override
            public void swap(int a, int b) {
                float temp = FloatList.this.data[a];
                FloatList.this.data[a] = FloatList.this.data[b];
                FloatList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        int i = 0;
        while (i < this.count / 2) {
            float t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
            ++i;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            float temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public FloatList copy() {
        FloatList outgoing = new FloatList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public float[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int index = -1;

            @Override
            public void remove() {
                FloatList.this.remove(this.index);
                --this.index;
            }

            @Override
            public Float next() {
                return Float.valueOf(FloatList.this.data[++this.index]);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < FloatList.this.count;
            }
        };
    }

    public float[] array() {
        return this.array(null);
    }

    public float[] array(float[] array) {
        if (array == null || array.length != this.count) {
            array = new float[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public FloatList getPercent() {
        double sum = 0.0;
        float[] fArray = this.array();
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            sum += (double)value;
            ++n2;
        }
        FloatList outgoing = new FloatList(this.count);
        int i = 0;
        while (i < this.count) {
            double percent = (double)this.data[i] / sum;
            outgoing.set(i, (float)percent);
            ++i;
        }
        return outgoing;
    }

    public FloatList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public FloatList getSubset(int start, int num) {
        float[] subset = new float[num];
        System.arraycopy(this.data, start, subset, 0, num);
        return new FloatList(subset);
    }

    public String join(String separator) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.data[0]);
        int i = 1;
        while (i < this.count) {
            sb.append(separator);
            sb.append(this.data[i]);
            ++i;
        }
        return sb.toString();
    }

    public void print() {
        int i = 0;
        while (i < this.count) {
            System.out.format("[%d] %f%n", i, Float.valueOf(this.data[i]));
            ++i;
        }
    }

    public String toJSON() {
        return "[ " + this.join(", ") + " ]";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " " + this.toJSON();
    }
}

