/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.util;

import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.hawtdispatch.internal.util.StringSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionSupport {
    public static String toString(Object target) {
        return IntrospectionSupport.toString(target, Object.class, null, null);
    }

    public static String toString(Object target, Class<?> stopClass, Map<String, Object> overrideFields, String[] fields) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            IntrospectionSupport.addFields(target, target.getClass(), stopClass, map);
            if (overrideFields != null) {
                for (String key : overrideFields.keySet()) {
                    Object value = overrideFields.get(key);
                    map.put(key, value);
                }
            }
            if (fields != null) {
                map.keySet().retainAll(Arrays.asList(fields));
            }
            boolean useMultiLine = false;
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = null;
                if (entry.getValue() != null && (value = entry.getValue().toString()) != null && (value.indexOf(10) >= 0 || key.length() + value.length() > 70)) {
                    useMultiLine = true;
                }
                props.put(key, value);
            }
            StringBuffer buffer = new StringBuffer();
            if (useMultiLine) {
                buffer.append("{\n");
                boolean first = true;
                for (Map.Entry entry : props.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",\n");
                    }
                    buffer.append("  ");
                    buffer.append((String)entry.getKey());
                    buffer.append(": ");
                    buffer.append(StringSupport.indent((String)entry.getValue(), 2));
                }
                buffer.append("\n}");
            } else {
                buffer.append("{");
                boolean first = true;
                for (Map.Entry entry : props.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append((String)entry.getKey());
                    buffer.append(": ");
                    String value = (String)entry.getValue();
                    buffer.append(value);
                }
                buffer.append("}");
            }
            return buffer.toString();
        }
        catch (Throwable e) {
            Thread thread2 = Thread.currentThread();
            thread2.getUncaughtExceptionHandler().uncaughtException(thread2, e);
            return "Could not toString: " + e.toString();
        }
    }

    private static void addFields(Object target, Class<?> startClass, Class<?> stopClass, LinkedHashMap<String, Object> map) {
        if (startClass != stopClass) {
            IntrospectionSupport.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        Field[] fields = startClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
                continue;
            }
            catch (Throwable e) {
                Thread thread2 = Thread.currentThread();
                thread2.getUncaughtExceptionHandler().uncaughtException(thread2, e);
            }
        }
    }

    static {
        String[] additionalPath = new String[]{"org.springframework.beans.propertyeditors", "org.apache.activemq.util"};
        String[] searchPath = (String[])Array.newInstance(String.class, PropertyEditorManager.getEditorSearchPath().length + additionalPath.length);
        System.arraycopy(PropertyEditorManager.getEditorSearchPath(), 0, searchPath, 0, PropertyEditorManager.getEditorSearchPath().length);
        System.arraycopy(additionalPath, 0, searchPath, PropertyEditorManager.getEditorSearchPath().length, additionalPath.length);
        PropertyEditorManager.setEditorSearchPath(searchPath);
    }
}

