/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.WorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadDispatchQueue
implements HawtDispatchQueue {
    volatile String label;
    final LinkedList<Task> localTasks = new LinkedList();
    final ConcurrentLinkedQueue<Task> sharedTasks = new ConcurrentLinkedQueue();
    final WorkerThread thread;
    final GlobalDispatchQueue globalQueue;
    private final LinkedList<Task> sourceQueue = new LinkedList();

    public ThreadDispatchQueue(GlobalDispatchQueue globalQueue, WorkerThread thread2) {
        this.thread = thread2;
        this.globalQueue = globalQueue;
        this.label = thread2.getName() + " pritority: " + globalQueue.getLabel();
        this.getDispatcher().track(this);
    }

    @Override
    public LinkedList<Task> getSourceQueue() {
        return this.sourceQueue;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isExecuting() {
        return this.globalQueue.dispatcher.getCurrentThreadQueue() == this;
    }

    @Override
    public void assertExecuting() {
        assert (this.isExecuting()) : this.getDispatcher().assertMessage(this.getLabel());
    }

    @Override
    public HawtDispatcher getDispatcher() {
        return this.globalQueue.dispatcher;
    }

    @Override
    @Deprecated
    public void execute(Runnable runnable2) {
        this.execute(new TaskWrapper(runnable2));
    }

    @Override
    public void execute(Task task) {
        if (Thread.currentThread() != this.thread) {
            this.sharedTasks.add(task);
            this.thread.unpark();
        } else {
            this.localTasks.add(task);
        }
    }

    public Task poll() {
        Task rc = this.localTasks.poll();
        if (rc == null) {
            rc = this.sharedTasks.poll();
        }
        return rc;
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Task task) {
        this.getDispatcher().timerThread.addRelative(task, this, delay, unit);
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTargetQueue(DispatchQueue queue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HawtDispatchQueue getTargetQueue() {
        return null;
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.THREAD_QUEUE;
    }
}

