/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ZPEMacroInterfaceObjectViewer
extends JFrame {
    private final JList<String> functionList;
    private final DefaultListModel<String> listModel;
    private final JLabel functionNameLabel;
    private final JLabel parameterLabel;
    private final JTextArea descriptionArea;

    public ZPEMacroInterfaceObjectViewer(ZPEObject o) {
        super("Object Method Browser");
        this.setDefaultCloseOperation(2);
        this.setSize(500, 400);
        this.setLocationRelativeTo(null);
        this.listModel = new DefaultListModel();
        this.functionList = new JList<String>(this.listModel);
        this.functionList.setPreferredSize(new Dimension(150, 400));
        this.functionList.setMaximumSize(new Dimension(150, 400));
        this.functionList.setMinimumSize(new Dimension(150, 400));
        this.functionList.setSelectionMode(0);
        try {
            this.functionList.setFont(HelperFunctions.getSystemDisplayFont(14));
        }
        catch (Exception e2) {
            this.functionList.setFont(new Font(HelperFunctions.getBestAvailableFont(true), 0, 14));
        }
        JScrollPane listScrollPane = new JScrollPane(this.functionList);
        listScrollPane.setPreferredSize(new Dimension(150, 400));
        listScrollPane.setMaximumSize(new Dimension(150, 400));
        listScrollPane.setMinimumSize(new Dimension(150, 400));
        JPanel detailPanel = new JPanel(new GridLayout(3, 1));
        this.functionNameLabel = new JLabel("Function:");
        this.functionNameLabel.setFont(new Font("Segoe UI", 1, 14));
        this.parameterLabel = new JLabel("Parameters:");
        this.parameterLabel.setFont(new Font("Segoe UI", 0, 13));
        this.descriptionArea = new JTextArea("");
        this.descriptionArea.setFont(new Font("Segoe UI", 2, 12));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setOpaque(false);
        detailPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        detailPanel.add(this.functionNameLabel);
        detailPanel.add(this.parameterLabel);
        detailPanel.add(this.descriptionArea);
        detailPanel.setPreferredSize(new Dimension(250, 400));
        detailPanel.setMaximumSize(new Dimension(250, 400));
        detailPanel.setMinimumSize(new Dimension(250, 400));
        for (String m : o.getProperties()) {
            this.listModel.addElement(m);
        }
        this.functionList.addListSelectionListener(e -> {
            String selected;
            if (!e.getValueIsAdjusting() && (selected = this.functionList.getSelectedValue()) != null) {
                this.functionNameLabel.setText("<html><body><h2>Function</h2><div> " + selected + "</div></body></html>");
                if (o.getProperty(selected) instanceof ZPEObjectNativeMethod) {
                    ZPEObjectNativeMethod method = (ZPEObjectNativeMethod)o.getProperty(selected);
                    StringBuilder params = new StringBuilder();
                    for (int i = 0; i < method.getParameterNames().length; ++i) {
                        params.append("<i style=\"color:#f60;\">").append(method.getParameterTypes()[i]).append("</i> ").append(method.getParameterNames()[i]).append(", ");
                    }
                    if (params.length() > 0) {
                        params.delete(params.length() - 2, params.length());
                    }
                    this.parameterLabel.setText("<html><body><h2>Parameters</h2><div>" + String.valueOf(params) + "</div></body></html>");
                }
            }
        });
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        mainPanel.add((Component)listScrollPane, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.7;
        gbc.fill = 1;
        mainPanel.add((Component)detailPanel, gbc);
        this.add(mainPanel);
    }
}

