/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.components.BalfMenuBar;
import jamiebalfour.ui.components.BalfScrollbar;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.editor.ConsoleOutputTextArea;
import jamiebalfour.zpe.interfaces.GenericEditor;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ZPEConsole
extends JFrame {
    private static final long serialVersionUID = 4086525518278830649L;
    final ZPEConsole console;
    final GenericEditor parent;
    ConsoleOutputTextArea consoleOutput;
    PrintStream defaultOut;
    PrintStream defaultErr;
    InputStream defaultIn;
    String lastCode = "";
    ZPEString[] lastArgs;
    boolean lastWasCI;
    ZPERuntimeEnvironment yass;
    int permission_level = 3;
    Properties mainProperties;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("YASS files (*.yas)", "yas");
    static FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Text files (*.txt)", "txt");
    static FileNameExtensionFilter filter3 = new FileNameExtensionFilter("YASS executable files (*.yex)", "yex");
    private boolean caseInsensitive = false;
    private String file;
    boolean runAsProcess = false;

    public ZPEConsole(int permission_level) {
        this.parent = null;
        this.permission_level = permission_level;
        this.console = this;
        this.file = this.file;
        this.console.setSize(400, 400);
        URL imagePath = HelperFunctions.isMac() ? this.getClass().getResource("/files/ZPELogomacOS.png") : this.getClass().getResource("/files/ZPELogoLighter.png");
        assert (imagePath != null);
        ImageIcon lighterLogo = new ImageIcon(imagePath);
        Image newimg = lighterLogo.getImage().getScaledInstance(60, 60, 4);
        lighterLogo = new ImageIcon(newimg);
        try {
            this.setIconImage(lighterLogo.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String path = ZPEInstance.getInstallPath() + "gui.properties";
        File f = new File(path);
        if (f.exists()) {
            try {
                this.mainProperties = HelperFunctions.readProperties(path);
                if (this.mainProperties.containsKey("CONSOLE_HEIGHT")) {
                    this.console.setSize(this.console.getWidth(), HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_HEIGHT").toString()));
                }
                if (this.mainProperties.containsKey("CONSOLE_WIDTH")) {
                    this.console.setSize(HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_WIDTH").toString()), this.console.getHeight());
                }
                if (this.mainProperties.containsKey("CONSOLE_XPOS")) {
                    this.console.setLocation(new Point(HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_XPOS").toString()), this.console.getY()));
                }
                if (this.mainProperties.containsKey("CONSOLE_YPOS")) {
                    this.console.setLocation(new Point(this.console.getX(), HelperFunctions.stringToInteger(this.mainProperties.get("CONSOLE_YPOS").toString())));
                }
                if (this.mainProperties.containsKey("CONSOLE_MAXIMISED") && this.mainProperties.get("CONSOLE_MAXIMISED").toString().equals("true")) {
                    this.console.setExtendedState(6);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.startup(new Font("Monospaced", 0, 16));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ZPEConsole.this.mainProperties.put("CONSOLE_HEIGHT", "" + ZPEConsole.this.console.getHeight());
                ZPEConsole.this.mainProperties.put("CONSOLE_WIDTH", "" + ZPEConsole.this.console.getWidth());
                ZPEConsole.this.mainProperties.put("CONSOLE_XPOS", "" + ZPEConsole.this.console.getX());
                ZPEConsole.this.mainProperties.put("CONSOLE_YPOS", "" + ZPEConsole.this.console.getY());
                if (ZPEConsole.this.console.getExtendedState() == 6) {
                    ZPEConsole.this.mainProperties.put("CONSOLE_MAXIMISED", "true");
                } else {
                    ZPEConsole.this.mainProperties.put("CONSOLE_MAXIMISED", "false");
                }
                String path = ZPEInstance.getInstallPath() + "gui.properties";
                try {
                    FileOutputStream output = new FileOutputStream(path);
                    ZPEConsole.this.mainProperties.store(output, null);
                }
                catch (Exception ex) {
                    ZPECore.log("Error saving GUI settings. " + ex.getMessage());
                }
            }
        });
    }

    public ZPEConsole(GenericEditor owner, String title, Font font, int permission_level) {
        this.parent = owner;
        this.console = this;
        this.permission_level = permission_level;
        this.setSize(new Dimension(400, 350));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ZPEConsole.this.parent != null) {
                    ZPEConsole.this.parent.setProperty("CONSOLE_HEIGHT", "" + ZPEConsole.this.console.getHeight());
                    ZPEConsole.this.parent.setProperty("CONSOLE_WIDTH", "" + ZPEConsole.this.console.getWidth());
                    ZPEConsole.this.parent.setProperty("CONSOLE_XPOS", "" + ZPEConsole.this.console.getX());
                    ZPEConsole.this.parent.setProperty("CONSOLE_YPOS", "" + ZPEConsole.this.console.getY());
                    if (ZPEConsole.this.console.getExtendedState() == 6) {
                        ZPEConsole.this.parent.setProperty("CONSOLE_MAXIMISED", "true");
                    } else {
                        ZPEConsole.this.parent.setProperty("CONSOLE_MAXIMISED", "false");
                    }
                    ZPEConsole.this.parent.saveGUISettings(ZPEConsole.this.parent.getProperties());
                }
                assert (ZPEConsole.this.parent != null);
                ZPEConsole.this.parent.destroyConsole();
            }
        });
        this.setTitle(title);
        if (this.parent.getProperties().containsKey("CONSOLE_HEIGHT")) {
            this.console.setSize(this.console.getWidth(), HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_HEIGHT").toString()));
        }
        if (this.parent.getProperties().containsKey("CONSOLE_WIDTH")) {
            this.console.setSize(HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_WIDTH").toString()), this.console.getHeight());
        }
        if (this.parent.getProperties().containsKey("CONSOLE_XPOS")) {
            this.console.setLocation(new Point(HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_XPOS").toString()), this.console.getY()));
        }
        if (this.parent.getProperties().containsKey("CONSOLE_YPOS")) {
            this.console.setLocation(new Point(this.console.getX(), HelperFunctions.stringToInteger(this.parent.getProperties().get("CONSOLE_YPOS").toString())));
        }
        if (this.parent.getProperties().containsKey("CONSOLE_MAXIMISED") && this.parent.getProperties().get("CONSOLE_MAXIMISED").toString().equals("true")) {
            this.console.setExtendedState(6);
        }
        this.startup(font);
    }

    private void startup(Font font) {
        this.getContentPane().setLayout(new BorderLayout());
        BalfScrollbar scrollPane = new BalfScrollbar();
        scrollPane.setLightColour(Color.BLACK);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add((Component)scrollPane, "Center");
        this.consoleOutput = new ConsoleOutputTextArea("", Color.black);
        this.consoleOutput.setFont(font);
        scrollPane.setViewportView(this.consoleOutput);
        int modifier = 2;
        if (HelperFunctions.isMac()) {
            modifier = 4;
        }
        BalfMenuBar menuBar = new BalfMenuBar(new Color(31, 31, 31), Color.white);
        BalfMenuBar.Menu mnFileMenu = new BalfMenuBar.Menu("File", menuBar);
        menuBar.add(mnFileMenu);
        BalfMenuBar.MenuItem mntmSaveOutputMenuItem = new BalfMenuBar.MenuItem("Save output", menuBar);
        mntmSaveOutputMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.addChoosableFileFilter(filter2);
                fc.setAcceptAllFileFilterUsed(false);
                int returnVal = fc.showSaveDialog(ZPEConsole.this.console.getContentPane());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    String extension = ZPEConsole.getSaveExtension(fc.getFileFilter());
                    try {
                        FileHelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, ZPEConsole.this.consoleOutput.getText(), false);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(ZPEConsole.this.console, "The file could not be saved.", "Error", 0);
                    }
                }
            }
        });
        mnFileMenu.add(mntmSaveOutputMenuItem);
        BalfMenuBar.MenuItem mntmDebugThisCodeMenuItem = new BalfMenuBar.MenuItem("Debug this code", menuBar);
        mntmDebugThisCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 1));
        mntmDebugThisCodeMenuItem.addActionListener(e -> {
            ZPEKit.setDebugging(true);
            this.runCode(this.lastCode, this.lastArgs, this.lastWasCI);
        });
        mnFileMenu.add(mntmDebugThisCodeMenuItem);
        BalfMenuBar.Menu mnEditMenu = new BalfMenuBar.Menu("Edit", menuBar);
        mnEditMenu.setMnemonic('E');
        menuBar.add(mnEditMenu);
        BalfMenuBar.MenuItem mntmCopyMenuItem = new BalfMenuBar.MenuItem("Copy", menuBar);
        mntmCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, modifier));
        mntmCopyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEConsole.this.consoleOutput.copy();
            }
        });
        mnEditMenu.add(mntmCopyMenuItem);
        this.defaultOut = System.out;
        this.defaultErr = System.err;
        this.defaultIn = System.in;
        this.setVisible(true);
        this.setAutoRequestFocus(true);
        this.getContentPane().add((Component)menuBar, "North");
    }

    public Process getProcess() {
        return this.consoleOutput.getProcess();
    }

    public void destroyCurrentProcess() {
        this.consoleOutput.destroyCurrentProcess();
    }

    public void runCode(String code, ZPEString[] args2, boolean caseInsensitive) {
        StringBuilder argv = new StringBuilder();
        for (ZPEString s : args2) {
            argv.append(s.toString()).append(" ");
        }
        try {
            Path tempPath = Files.createTempFile(ZPEHelperFunctions.generateRandomWord(12), ".tmp", new FileAttribute[0]);
            FileHelperFunctions.writeFile(tempPath.toAbsolutePath().toString(), code, false);
            this.consoleOutput.runAsProcess(tempPath, false, argv.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void runCode(Path tempPath, ZPEString[] args2, boolean caseInsensitive) {
        StringBuilder argv = new StringBuilder();
        for (ZPEString s : args2) {
            argv.append(s.toString()).append(" ");
        }
        this.consoleOutput.runAsProcess(tempPath, false, argv.toString());
    }

    private static String getSaveExtension(FileFilter f) {
        if (f.equals(filter1)) {
            return "yas";
        }
        if (f.equals(filter2)) {
            return "txt";
        }
        if (f.equals(filter3)) {
            return "yex";
        }
        return null;
    }
}

