/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.gui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class CommandWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Dimension defaultDimension = new Dimension(500, 104);
    private static final Dimension resizeDimension = new Dimension(500, 400);
    private static Point defaultLocation;
    private static Point resizeLocation;
    private static final Color foregroundColor;
    private static final Color backgroundColor;
    private static final Color altBackgroundColor;
    private final JTextField txtCommand;
    private final JTextArea outputConsole;
    final JFrame me = this;
    boolean toShow = false;

    public CommandWindow() {
        Point loc;
        int newWidth;
        this.setLayout(new BorderLayout(0, 0));
        this.setUndecorated(true);
        this.setBackground(new Color(0, 0, 0, 0));
        JPanel container = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2.setColor(Color.white);
                g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 104, 104);
            }
        };
        container.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)container, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        CommandWindow.defaultDimension.width = newWidth = (int)(width - 200.0);
        CommandWindow.resizeDimension.width = newWidth;
        this.setAlwaysOnTop(true);
        this.setSize(defaultDimension);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 0));
        panel.setBorder(new EmptyBorder(15, 35, 25, 35));
        panel.setOpaque(false);
        container.add((Component)panel, "North");
        this.txtCommand = new JTextField();
        this.txtCommand.setForeground(foregroundColor);
        this.txtCommand.setBackground(new Color(0, 0, 0, 0));
        this.txtCommand.setOpaque(false);
        this.txtCommand.setBorder(null);
        this.txtCommand.setCaretColor(Color.BLACK);
        this.txtCommand.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommandWindow.this.collect();
                    e.consume();
                } else {
                    CommandWindow.this.hideContent();
                }
            }
        });
        this.setLocationRelativeTo(null);
        panel.add((Component)this.txtCommand, "Center");
        this.txtCommand.setToolTipText("Insert a command in here.");
        this.txtCommand.setFont(new Font("Monospaced", 0, 61));
        this.txtCommand.setColumns(10);
        JPanel outputPanel = new JPanel();
        outputPanel.setBorder(new EmptyBorder(10, 2, 0, 2));
        outputPanel.setLayout(new BorderLayout(0, 0));
        outputPanel.setOpaque(false);
        this.outputConsole = new JTextArea();
        this.outputConsole.setForeground(foregroundColor);
        this.outputConsole.setBackground(new Color(255, 255, 255, 0));
        this.outputConsole.setFont(new Font("Monospaced", 0, 22));
        this.outputConsole.setEditable(false);
        this.outputConsole.setOpaque(false);
        this.outputConsole.setMargin(new Insets(0, 25, 25, 0));
        outputPanel.add((Component)this.outputConsole, "Center");
        container.add((Component)outputPanel, "Center");
        this.setForeground(foregroundColor);
        defaultLocation = loc = new Point(this.getLocation().x, this.getLocation().y - 100);
        this.setLocation(defaultLocation);
        resizeLocation = new Point(loc.x, loc.y - 52);
        HelperFunctions.redirectSystemOutput(this.outputConsole);
        this.setShape(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 104.0, 104.0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int newWidth;
                CommandWindow.this.setShape(new RoundRectangle2D.Double(0.0, 0.0, CommandWindow.this.getWidth(), CommandWindow.this.getHeight(), 104.0, 104.0));
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                double width = screenSize.getWidth();
                CommandWindow.defaultDimension.width = newWidth = (int)(width - 200.0);
                CommandWindow.resizeDimension.width = newWidth;
            }
        });
        this.txtCommand.requestFocusInWindow();
    }

    private void collect() {
        this.showContent();
        String currentLine = this.txtCommand.getText();
        String code = "function main() {return " + currentLine + "}";
        try {
            ZPEType returnValue = ZPEKit.interpret(code, new ZPEType[0], ZPEInstance.getUserDefinedPermissionLevelProperty());
            this.outputConsole.setText(returnValue.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.txtCommand.setText("");
    }

    private void showContent() {
        this.outputConsole.setText("");
        this.setLocation(resizeLocation);
        int newHeight = 0;
        for (int i = 0; i < this.outputConsole.getLineCount(); ++i) {
            newHeight += 22;
        }
        CommandWindow.resizeDimension.height = CommandWindow.defaultDimension.height + newHeight + 60;
        this.setSize(resizeDimension);
        this.toShow = true;
    }

    private void hideContent() {
        if (this.toShow) {
            this.toShow = false;
        }
        this.setLocation(defaultLocation);
        this.setSize(defaultDimension);
    }

    static {
        foregroundColor = Color.black;
        backgroundColor = new Color(238, 238, 238);
        altBackgroundColor = new Color(221, 221, 221);
    }
}

