/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UIUtils;
import jamiebalfour.ui.components.BalfMenuBar;
import jamiebalfour.ui.components.BalfSeparator;
import jamiebalfour.ui.windows.BalfWindow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;

public class BalfTitleBar
extends JPanel {
    final int originalCornerRounding;
    JPanel leftPanel;
    JPanel rightPanel;
    JPanel rightButtons;
    private final Point dragOffset = new Point();
    private Color backgroundColour;
    private Color foregroundColour;
    private final Color orgBackgroundColour;
    private final Color orgForegroundColour;
    int roundedCorners;
    JPanel _this = this;
    JFrame _frame;
    JDialog _dialog;
    WindowsCloseButton windowsCloseButton = null;
    JLabel leftLabel;
    MaximiseButtonListener maximiseButtonListener;
    private boolean maximiseEnabled = true;
    private boolean minimiseEnabled = true;
    JButton minimiseButton;
    JButton maxButton;
    boolean useFullScreen = false;
    JLabel iconLabel;
    public boolean isMaximised = false;
    public Dimension cachedSize = null;
    public Point cachedLocation = null;
    boolean darkMode = false;
    private BalfMenuBar _menu;
    private TitleBarLabelListener titleBarLabelListener;
    private CloseListener closeListener;
    private Shape cachedClipShape = null;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private final boolean debug = true;
    private boolean hasFocus = true;

    public BalfTitleBar(JFrame frame, int roundedCornerArc, Color backgroundColour, Color foregroundColour) {
        JPanel buttonPanel;
        this._frame = frame;
        this.roundedCorners = roundedCornerArc;
        this.originalCornerRounding = roundedCornerArc;
        this.backgroundColour = backgroundColour;
        this.foregroundColour = foregroundColour;
        this.orgBackgroundColour = backgroundColour;
        this.orgForegroundColour = foregroundColour;
        this.setForeground(foregroundColour);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(this._frame.getWidth() + 1, 40));
        this.setBackground(new Color(0, 0, 0, 0));
        this._frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                BalfTitleBar.this.hasFocus = true;
                BalfTitleBar.this._frame.repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                BalfTitleBar.this.hasFocus = false;
                BalfTitleBar.this._frame.repaint();
            }
        });
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            Color c;
            if (enabled) {
                this.enableDarkMode();
                c = new Color(0, 0, 0, 255);
            } else {
                this.disableDarkMode();
                c = this.backgroundColour;
            }
            if (this.rightButtons != null) {
                this.rightButtons.setBackground(HelperFunctions.adjustColorForContrast(c, 1));
                this.rightButtons.repaint();
            }
            this.repaint();
        });
        BalfLafManager.getInstance().addThemeChangeListener(() -> {
            if (BalfLafManager.getInstance().getTheme() == null) {
                this.backgroundColour = this.orgBackgroundColour;
                this.foregroundColour = this.orgForegroundColour;
            } else {
                this.backgroundColour = BalfLafManager.getInstance().getTheme().getBackground();
                this.foregroundColour = BalfLafManager.getInstance().getTheme().getForeground();
            }
            this.repaint();
            if (this.rightButtons != null) {
                this.rightButtons.setBackground(HelperFunctions.adjustColorForContrast(this.backgroundColour, 1));
                this.rightButtons.repaint();
            }
        });
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 0));
        this.leftPanel.setAlignmentX(0.0f);
        if (!HelperFunctions.isMac() && this._frame instanceof BalfWindow && ((BalfWindow)this._frame).getIcon() != null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setIcon(new ImageIcon(((BalfWindow)this._frame).getIcon().getImage()));
            this.leftPanel.add(Box.createHorizontalStrut(10));
            this.leftPanel.add(this.iconLabel);
            this.leftPanel.add(Box.createHorizontalStrut(10));
        }
        this.leftLabel = new JLabel();
        this.leftLabel.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 14.0f));
        this.leftLabel.setForeground(foregroundColour);
        this.leftLabel.setAlignmentX(0.0f);
        this._frame.addPropertyChangeListener("title", evt -> this.repaint());
        this.leftLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BalfTitleBar.this.titleBarLabelListener != null) {
                    BalfTitleBar.this.titleBarLabelListener.onLabelClicked(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (BalfTitleBar.this.leftLabel.isVisible() && !BalfTitleBar.this.leftLabel.getText().isEmpty()) {
                    if (BalfTitleBar.this.titleBarLabelListener != null) {
                        BalfTitleBar.this.leftLabel.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        BalfTitleBar.this.leftLabel.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    BalfTitleBar.this.leftLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        if (!HelperFunctions.isMac()) {
            buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
            buttonPanel.setOpaque(false);
            buttonPanel.setBackground(new Color(0, 0, 0, 0));
            buttonPanel.setSize(new Dimension(130, 40));
            buttonPanel.setMaximumSize(new Dimension(130, 40));
            WindowControlButton minBtn = new WindowControlButton("min");
            this.minimiseButton = minBtn;
            minBtn.addActionListener(e -> this._frame.setState(1));
            buttonPanel.add(minBtn);
            this.maxButton = new WindowControlButton("max");
            buttonPanel.add(this.maxButton);
            JButton closeBtn = this.createCloseButton();
            buttonPanel.add(closeBtn);
        } else {
            buttonPanel = new JPanel(new FlowLayout(0, 6, 12));
            buttonPanel.setOpaque(false);
            buttonPanel.setBackground(new Color(0, 0, 0, 0));
            buttonPanel.setSize(new Dimension(60, 40));
            buttonPanel.setMaximumSize(new Dimension(60, 40));
            JButton closeBtn = this.createCloseButton();
            buttonPanel.add(closeBtn);
            MacButton minBtn = this.createMacWindowButton(new Color(249, 200, 0));
            minBtn.setToolTipText("Minimise");
            this.minimiseButton = minBtn;
            minBtn.addActionListener(e -> {
                if (this.minimiseEnabled) {
                    this._frame.setState(1);
                }
            });
            buttonPanel.add(minBtn);
            this.maxButton = this.createMacWindowButton(new Color(53, 199, 90));
            this.maxButton.setToolTipText("Zoom");
            buttonPanel.add(this.maxButton);
        }
        this.leftPanel.setOpaque(false);
        this.leftPanel.setBackground(new Color(0, 0, 0, 0));
        this.leftPanel.setPreferredSize(null);
        this.rightPanel = new JPanel(new FlowLayout(2));
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 0));
        this.rightPanel.setOpaque(false);
        this.rightPanel.setBackground(new Color(0, 0, 0, 0));
        if (HelperFunctions.isMac()) {
            this.leftPanel.add(buttonPanel);
        }
        this.leftLabel.setAlignmentX(0.5f);
        this.leftPanel.add(new BalfSeparator(10, 10));
        this.leftPanel.add(this.leftLabel);
        this.rightButtons = new rightPanelZone(new FlowLayout(0));
        Color color = this.backgroundColour;
        color = HelperFunctions.adjustColorForContrast(color, 1);
        this.rightButtons.setBackground(color);
        this.rightButtons.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.rightButtons.setVisible(false);
        this.rightButtons.setOpaque(false);
        this.rightPanel.add(this.rightButtons);
        if (!HelperFunctions.isMac()) {
            this.rightPanel.add(buttonPanel);
        }
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.rightPanel, "East");
        this.maxButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                if (e.getClickCount() == 1) {
                    if (BalfTitleBar.this.maximiseButtonListener != null) {
                        BalfTitleBar.this.maximiseButtonListener.onMaximiseButtonClicked(e);
                    }
                    if (BalfTitleBar.this.maxButton instanceof WindowControlButton) {
                        ((WindowControlButton)BalfTitleBar.this.maxButton).hovered = false;
                        BalfTitleBar.this.maxButton.repaint();
                    }
                    BalfTitleBar.this.activateMaximise();
                }
            }
        });
        this.enableDragging(this);
        this.enableDragging(this.leftPanel);
        this.enableDragging(this.rightPanel);
        this.enableDragging(this.leftLabel);
        this.enableMaximise(this, 2);
        this.enableMaximise(this.leftPanel, 2);
        this.enableMaximise(this.rightPanel, 2);
        this._frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (BalfTitleBar.this._frame.getWidth() < 800) {
                    BalfTitleBar.this.leftLabel.hide();
                } else {
                    BalfTitleBar.this.leftLabel.show();
                }
            }
        });
    }

    public BalfTitleBar(JDialog dialog, int roundedCorners, Color backgroundColour, Color foregroundColour) {
        this._dialog = dialog;
        this.roundedCorners = roundedCorners;
        this.originalCornerRounding = roundedCorners;
        this.backgroundColour = backgroundColour;
        this.foregroundColour = foregroundColour;
        this.orgBackgroundColour = backgroundColour;
        this.orgForegroundColour = foregroundColour;
        this.setForeground(foregroundColour);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(this._dialog.getWidth() + 1, 30));
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            Color c;
            if (enabled) {
                this.enableDarkMode();
                c = new Color(0, 0, 0, 255);
            } else {
                this.disableDarkMode();
                c = this.backgroundColour;
            }
            if (this.rightButtons != null) {
                this.rightButtons.setBackground(HelperFunctions.adjustColorForContrast(c, 1));
                this.rightButtons.repaint();
            }
            this.repaint();
        });
        BalfLafManager.getInstance().addThemeChangeListener(() -> {
            if (BalfLafManager.getInstance().getTheme() == null) {
                this.backgroundColour = this.orgBackgroundColour;
                this.foregroundColour = this.orgForegroundColour;
            } else {
                this.backgroundColour = BalfLafManager.getInstance().getTheme().getBackground();
                this.foregroundColour = BalfLafManager.getInstance().getTheme().getForeground();
            }
            this.repaint();
            if (this.rightButtons != null) {
                this.rightButtons.setBackground(HelperFunctions.adjustColorForContrast(this.backgroundColour, 1));
                this.rightButtons.repaint();
            }
        });
        this.enableDragging(this);
    }

    private JButton createCloseButton() {
        if (!HelperFunctions.isMac()) {
            this.windowsCloseButton = new WindowsCloseButton();
            this.windowsCloseButton.addActionListener(e -> {
                if (this.closeListener != null) {
                    this.closeListener.onCloseButtonClicked(e);
                }
            });
            this.windowsCloseButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    BalfTitleBar.this.windowsCloseButton.setBackground(new Color(128, 128, 128));
                    BalfTitleBar.this.windowsCloseButton.setForeground(BalfTitleBar.this.foregroundColour.darker().darker());
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    BalfTitleBar.this.windowsCloseButton.setBackground(new Color(51, 51, 51));
                    BalfTitleBar.this.windowsCloseButton.setForeground(BalfTitleBar.this.foregroundColour);
                }
            });
            this.windowsCloseButton.setCursor(Cursor.getPredefinedCursor(12));
            return this.windowsCloseButton;
        }
        MacButton closeBtn = this.createMacWindowButton(new Color(254, 92, 96));
        closeBtn.setToolTipText("Close");
        closeBtn.addActionListener(e -> {
            if (this.closeListener != null) {
                this.closeListener.onCloseButtonClicked(e);
            }
        });
        return closeBtn;
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColour = color;
        this.repaint();
    }

    @Override
    public void setForeground(Color fg) {
        this.foregroundColour = fg;
        this.repaint();
    }

    public static BalfTitleBar generateCustomTitleBar(JFrame frame, int roundedCorners) {
        return new BalfTitleBar(frame, roundedCorners, new Color(40, 75, 99), Color.black);
    }

    public void disableMinimise(boolean disable) {
        boolean bl = this.minimiseEnabled = !disable;
        if (this.minimiseButton != null) {
            if (HelperFunctions.isMac()) {
                this.minimiseButton.setEnabled(this.minimiseEnabled);
            } else {
                this.minimiseButton.setVisible(this.minimiseEnabled);
            }
        }
    }

    public void disableMaximise(boolean disable) {
        boolean bl = this.maximiseEnabled = !disable;
        if (this.maxButton != null) {
            if (HelperFunctions.isMac()) {
                this.maxButton.setEnabled(this.maximiseEnabled);
            } else {
                this.maxButton.setVisible(this.maximiseEnabled);
            }
        }
    }

    public boolean windowHasFocus() {
        return this.hasFocus;
    }

    public void setTitleBarLabelListener(TitleBarLabelListener listener) {
        this.titleBarLabelListener = listener;
    }

    public void setMaximiseButtonListener(MaximiseButtonListener maximiseButtonListener) {
        this.maximiseButtonListener = maximiseButtonListener;
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    public Dimension getFrameSize() {
        if (this.isMaximised) {
            return this.cachedSize;
        }
        return this._frame.getSize();
    }

    public Point getFrameLocation() {
        if (this.isMaximised) {
            return this.cachedLocation;
        }
        return this._frame.getLocation();
    }

    public void activateMaximise() {
        if (this.isMaximised) {
            this._frame.setExtendedState(0);
            this._frame.setSize(this.cachedSize);
            this._frame.setLocation(this.cachedLocation);
            if (!this._frame.isUndecorated()) {
                this._frame.setUndecorated(true);
            }
            this.roundedCorners = this.originalCornerRounding;
            if (this._frame instanceof BalfWindow) {
                ((BalfWindow)this._frame).setRounding(20);
            }
            if (this.originalCornerRounding > 0 && this.windowsCloseButton != null) {
                this.windowsCloseButton.setRounded(true);
            }
            this.cachedSize = this._frame.getSize();
            this.cachedLocation = this._frame.getLocation();
            this._frame.getContentPane().setPreferredSize(new Dimension(800, 600));
        } else {
            this.cachedSize = this._frame.getSize();
            this.cachedLocation = this._frame.getLocation();
            if (HelperFunctions.isMac() && this.useFullScreen) {
                if (this._frame instanceof BalfWindow) {
                    ((BalfWindow)this._frame).goFullScreen();
                } else {
                    this._frame.setExtendedState(6);
                }
            } else {
                this._frame.setExtendedState(6);
            }
            if (!HelperFunctions.isMac()) {
                this.roundedCorners = 0;
                if (this._frame instanceof BalfWindow) {
                    ((BalfWindow)this._frame).setRounding(0);
                }
            }
            if (this.windowsCloseButton != null) {
                this.windowsCloseButton.setRounded(false);
            }
            if (this._frame instanceof BalfWindow) {
                ((BalfWindow)this._frame).maximiseAction();
            }
        }
        this._frame.getContentPane().revalidate();
        this._frame.getContentPane().repaint();
        this.isMaximised = !this.isMaximised;
        this.paintComponent(this.getGraphics());
    }

    public void addRightButton(rightPanelButton button) {
        button.setPreferredSize(new Dimension(30, 30));
        button.setMaximumSize(new Dimension(30, 30));
        button.setHorizontalAlignment(0);
        button.setVerticalAlignment(0);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setCursor(new Cursor(12));
        button.setDoubleBuffered(true);
        this.rightButtons.setVisible(true);
        this.rightButtons.add(button);
    }

    private void enableMaximise(JComponent c, final int clicks) {
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BalfTitleBar.this.maximiseEnabled && e.getClickCount() == clicks) {
                    if (BalfTitleBar.this.maximiseButtonListener != null) {
                        BalfTitleBar.this.maximiseButtonListener.onMaximiseButtonClicked(e);
                    }
                    BalfTitleBar.this.activateMaximise();
                }
            }
        });
    }

    private void enableDragging(JComponent t) {
        t.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BalfTitleBar.this.dragOffset.setLocation(e.getPoint());
            }
        });
        t.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (BalfTitleBar.this._frame != null) {
                    Point framePos = BalfTitleBar.this._frame.getLocation();
                    BalfTitleBar.this._frame.setLocation(framePos.x + e.getX() - BalfTitleBar.this.dragOffset.x, framePos.y + e.getY() - BalfTitleBar.this.dragOffset.y);
                } else if (BalfTitleBar.this._dialog != null) {
                    Point framePos = BalfTitleBar.this._dialog.getLocation();
                    BalfTitleBar.this._dialog.setLocation(framePos.x + e.getX() - BalfTitleBar.this.dragOffset.x, framePos.y + e.getY() - BalfTitleBar.this.dragOffset.y);
                }
            }
        });
    }

    private void enableSnapToTop(final JFrame frame) {
        final Point dragOffset = new Point();
        int SNAP_THRESHOLD = 5;
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        final boolean[] wasMaximised = new boolean[]{false};
        JRootPane dragArea = frame.getRootPane();
        dragArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                dragOffset.setLocation(e.getPoint());
            }
        });
        dragArea.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if ((frame.getExtendedState() & 6) == 6) {
                    frame.setExtendedState(0);
                    dragOffset.setLocation(e.getPoint());
                }
                Point screenPoint = e.getLocationOnScreen();
                int newX = screenPoint.x - dragOffset.x;
                int newY = screenPoint.y - dragOffset.y;
                frame.setLocation(newX, newY);
                if (newY <= 5 && !wasMaximised[0]) {
                    frame.setExtendedState(6);
                    wasMaximised[0] = true;
                } else if (newY > 5 && wasMaximised[0]) {
                    frame.setExtendedState(0);
                    wasMaximised[0] = false;
                }
            }
        });
    }

    private void enableDarkMode() {
        this.darkMode = true;
    }

    private void disableDarkMode() {
        this.darkMode = false;
    }

    private MacButton createMacWindowButton(Color color) {
        MacButton button = new MacButton(color);
        button.setPreferredSize(new Dimension(13, 13));
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setDoubleBuffered(true);
        return button;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font titleFont;
        Graphics2D g2 = (Graphics2D)g.create();
        int arc = this.roundedCorners;
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        boolean isMaximised = false;
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            boolean bl = isMaximised = (this._frame.getExtendedState() & 6) == 6;
        }
        if (arc > 0) {
            if (this.cachedClipShape == null || width != this.cachedWidth || height != this.cachedHeight) {
                RoundRectangle2D.Double topRounded = new RoundRectangle2D.Double(0.0, 0.0, width, height + arc, arc, arc);
                Area clip = new Area(new Rectangle(0, 0, width, height));
                clip.intersect(new Area(topRounded));
                this.cachedClipShape = clip;
                this.cachedWidth = width;
                this.cachedHeight = height;
            }
            g2.setClip(this.cachedClipShape);
        }
        Color baseColor = this.backgroundColour;
        if (this.darkMode) {
            baseColor = BalfLafManager.getInstance().getDarkColorBackground();
        }
        if (!this.hasFocus) {
            baseColor = UIUtils.transformToGrayscaleColour(baseColor);
        }
        g2.setColor(baseColor);
        g2.fillRect(0, 0, width, height);
        g2.fillRect(width - 1, 0, 2, height);
        String title = "";
        if (this._frame != null) {
            title = this._frame.getTitle();
        } else if (this._dialog != null) {
            title = this._dialog.getTitle();
        }
        if (HelperFunctions.isMac()) {
            try {
                titleFont = HelperFunctions.getSystemUserFont(14);
            }
            catch (Exception ex) {
                titleFont = new Font(HelperFunctions.getBestAvailableFont(false), 0, 14);
            }
        } else {
            titleFont = new Font(HelperFunctions.getBestAvailableFont(false), 0, 14);
        }
        Color textColor = this.foregroundColour;
        if (!this.hasFocus) {
            textColor = UIUtils.transformToGrayscaleColour(textColor);
        }
        g2.setFont(titleFont);
        g2.setColor(textColor);
        if (this.darkMode) {
            g2.setColor(BalfLafManager.getInstance().getDarkColorForeground());
        }
        FontMetrics fm = g2.getFontMetrics();
        int textWidth = fm.stringWidth(title);
        int textHeight = fm.getAscent();
        int x = (width - textWidth) / 2;
        int y = (height + textHeight) / 2 - 4;
        g2.drawString(title, x, y);
        super.paintComponent(g);
        g2.dispose();
    }

    public void setThemeColours(Color bg, Color fg) {
        this.setBackground(bg);
        this.setForeground(fg);
        if (this._menu != null) {
            this._menu.setBackground(this.getBackground());
            this._menu.setForeground(this.getForeground());
        }
    }

    public void attachMenu(BalfMenuBar menu) {
        this._menu = menu;
        if (this._menu != null) {
            this._menu.attachTitleBar(this);
            this.enableDragging(this._menu);
        }
    }

    public void setRounding(int rounding) {
        this.roundedCorners = rounding;
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public String getLabelText() {
        return this.leftLabel.getText();
    }

    public void setLabelText(String text) {
        this.leftLabel.setVisible(true);
        this.leftLabel.setText(text);
    }

    class WindowsCloseButton
    extends JButton {
        private boolean rounded;
        private boolean hovered = false;
        private Shape cachedShape = null;
        private int cachedWidth = -1;
        private int cachedHeight = -1;
        private boolean cachedRounded = false;

        public WindowsCloseButton() {
            this.setText("<html><center>\u2715</center></html>");
            this.setFont(new Font("SansSerif", 1, 16));
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setUI(new BasicButtonUI());
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setPreferredSize(new Dimension(40, 40));
            this.setForeground(new Color(200, 200, 200));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setDoubleBuffered(true);
            if (BalfTitleBar.this.roundedCorners > 0) {
                this.setRounded(true);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowsCloseButton.this.hovered = true;
                    WindowsCloseButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowsCloseButton.this.hovered = false;
                    WindowsCloseButton.this.repaint();
                }
            });
        }

        public void setRounded(boolean rounded) {
            if (this.rounded != rounded) {
                this.rounded = rounded;
                this.cachedShape = null;
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            int arc = 10;
            if (this.cachedShape == null || width != this.cachedWidth || height != this.cachedHeight || this.rounded != this.cachedRounded) {
                if (this.rounded && BalfTitleBar.this.roundedCorners > 0) {
                    Path2D.Double path = new Path2D.Double();
                    ((Path2D)path).moveTo(0.0, 0.0);
                    ((Path2D)path).lineTo(width - arc, 0.0);
                    ((Path2D)path).quadTo(width, 0.0, width, arc);
                    ((Path2D)path).lineTo(width, height);
                    ((Path2D)path).lineTo(0.0, height);
                    path.closePath();
                    this.cachedShape = path;
                } else {
                    this.cachedShape = new Rectangle(0, 0, width, height);
                }
                this.cachedWidth = width;
                this.cachedHeight = height;
                this.cachedRounded = this.rounded;
            }
            if (this.hovered) {
                g2.setColor(new Color(100, 100, 100));
                g2.fill(this.cachedShape);
            }
            super.paintComponent(g2);
            g2.dispose();
        }
    }

    class rightPanelZone
    extends JPanel {
        private Shape fillShape = null;
        private Shape outerBorderShape = null;
        private Shape innerBorderShape = null;
        private int cachedWidth = -1;
        private int cachedHeight = -1;
        private Color fillColour = new Color(51, 51, 51);

        public rightPanelZone(LayoutManager layout) {
            this.setLayout(layout);
            this.setOpaque(false);
        }

        @Override
        public void setBackground(Color c) {
            this.fillColour = c;
            this.fillShape = null;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int width = this.getWidth() - 10;
            int height = this.getHeight() - 2;
            int arc = 8;
            int strokeThickness = 1;
            if (this.fillShape == null || this.cachedWidth != width || this.cachedHeight != height) {
                this.fillShape = new RoundRectangle2D.Float(3.0f, 3.0f, width - strokeThickness - 6, height - strokeThickness - 6, arc, arc);
                this.outerBorderShape = new RoundRectangle2D.Float(3.0f, 3.0f, width - strokeThickness - 6, height - strokeThickness - 6, arc, arc);
                this.innerBorderShape = new RoundRectangle2D.Float(2.0f, 2.0f, width - strokeThickness - 4, height - strokeThickness - 4, arc, arc);
                this.cachedWidth = width;
                this.cachedHeight = height;
            }
            g2.setColor(this.fillColour);
            g2.fill(this.fillShape);
            g2.setStroke(new BasicStroke(strokeThickness));
            g2.setColor(new Color(56, 58, 66));
            g2.draw(this.outerBorderShape);
            g2.setColor(new Color(106, 107, 112));
            g2.draw(this.innerBorderShape);
            g2.dispose();
        }
    }

    public class WindowControlButton
    extends JButton {
        private final String type;
        boolean hovered = false;

        public WindowControlButton(String type) {
            this.type = type;
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setPreferredSize(new Dimension(40, 40));
            this.setForeground(new Color(200, 200, 200));
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setDoubleBuffered(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    WindowControlButton.this.hovered = true;
                    WindowControlButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WindowControlButton.this.hovered = false;
                    WindowControlButton.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(BalfTitleBar.this.foregroundColour);
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.hovered) {
                g2.setColor(new Color(100, 100, 100));
                g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
            g2.setColor(BalfTitleBar.this.foregroundColour);
            switch (this.type) {
                case "min": {
                    g2.fillRect(w / 2 - 6, h / 2 + 3, 12, 1);
                    break;
                }
                case "max": {
                    g2.drawRoundRect(w / 2 - 6, h / 2 - 6, 12, 12, 4, 4);
                }
            }
            g2.dispose();
        }
    }

    private class MacButton
    extends JButton {
        private final Color c;
        private boolean mouseIn = false;
        private Shape cachedCircle = null;

        public MacButton(Color c) {
            this.c = c;
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MacButton.this.mouseIn = false;
                    MacButton.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    MacButton.this.mouseIn = true;
                    MacButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    MacButton.this.mouseIn = false;
                    MacButton.this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int width = this.getWidth();
            int height = this.getHeight();
            int diameter = 13;
            if (this.cachedCircle == null) {
                int x = (width - diameter) / 2;
                int y = (height - diameter) / 2;
                this.cachedCircle = new Ellipse2D.Float(x, y, diameter, diameter);
                BalfTitleBar.this.cachedWidth = width;
                BalfTitleBar.this.cachedHeight = height;
            }
            Color drawColor = this.mouseIn || !this.isEnabled() ? new Color(this.c.getRed(), this.c.getGreen(), this.c.getBlue(), 100) : this.c;
            g2.setColor(drawColor);
            g2.fill(this.cachedCircle);
            g2.dispose();
        }
    }

    public static class rightPanelButton
    extends JButton {
        private Image myImage;
        private int imageWidth;
        private int imageHeight;
        private boolean mouseIn = false;
        private int cachedWidth = -1;
        private int cachedHeight = -1;
        private int imageDrawX = 0;
        private int imageDrawY = 0;

        public rightPanelButton(ImageIcon image) {
            this.myImage = image.getImage();
            this.imageWidth = this.myImage.getWidth(null);
            this.imageHeight = this.myImage.getHeight(null);
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    mouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mouseIn = false;
                    this.repaint();
                }
            });
        }

        @Override
        public void setIcon(Icon icon) {
            if (icon instanceof ImageIcon) {
                this.myImage = ((ImageIcon)icon).getImage();
            } else {
                int w = icon.getIconWidth();
                int h = icon.getIconHeight();
                BufferedImage image = new BufferedImage(w, h, 2);
                Graphics2D g2 = image.createGraphics();
                icon.paintIcon(null, g2, 0, 0);
                g2.dispose();
                this.myImage = image;
            }
            this.imageWidth = this.myImage.getWidth(null);
            this.imageHeight = this.myImage.getHeight(null);
            this.cachedWidth = -1;
            this.cachedHeight = -1;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            if (w != this.cachedWidth || h != this.cachedHeight) {
                this.cachedWidth = w;
                this.cachedHeight = h;
                int drawW = this.imageWidth - 2;
                int drawH = this.imageHeight - 2;
                this.imageDrawX = (w - drawW) / 2 - 1;
                this.imageDrawY = (h - drawH) / 2 - 1;
            }
            if (this.myImage != null) {
                if (this.mouseIn) {
                    Composite originalComposite = g2d.getComposite();
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    g2d.drawImage(this.myImage, this.imageDrawX, this.imageDrawY, this.imageWidth - 2, this.imageHeight - 2, null);
                    g2d.setComposite(originalComposite);
                } else {
                    g2d.drawImage(this.myImage, this.imageDrawX, this.imageDrawY, this.imageWidth - 2, this.imageHeight - 2, null);
                }
            }
            g2d.dispose();
        }
    }

    public static interface CloseListener {
        public void onCloseButtonClicked(ActionEvent var1);
    }

    public static interface MaximiseButtonListener {
        public void onMaximiseButtonClicked(MouseEvent var1);
    }

    public static interface TitleBarLabelListener {
        public void onLabelClicked(MouseEvent var1);
    }
}

