/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ColourUtils {
    private static final Map<String, Color> NAMED_COLORS = new HashMap<String, Color>();

    static {
        NAMED_COLORS.put("black", Color.BLACK);
        NAMED_COLORS.put("white", Color.WHITE);
        NAMED_COLORS.put("red", Color.RED);
        NAMED_COLORS.put("green", Color.GREEN);
        NAMED_COLORS.put("blue", Color.BLUE);
        NAMED_COLORS.put("gray", Color.GRAY);
        NAMED_COLORS.put("darkgray", Color.DARK_GRAY);
        NAMED_COLORS.put("lightgray", Color.LIGHT_GRAY);
        NAMED_COLORS.put("cyan", Color.CYAN);
        NAMED_COLORS.put("magenta", Color.MAGENTA);
        NAMED_COLORS.put("yellow", Color.YELLOW);
        NAMED_COLORS.put("orange", Color.ORANGE);
    }

    public static Color parseColor(String input) {
        if ((input = input.trim().toLowerCase()).matches("^#?[0-9a-f]{6}$")) {
            if (input.startsWith("#")) {
                input = input.substring(1);
            }
            int rgb = Integer.parseInt(input, 16);
            return new Color(rgb);
        }
        if (input.matches("^\\s*\\d{1,3}\\s*,\\s*\\d{1,3}\\s*,\\s*\\d{1,3}\\s*$")) {
            String[] parts = input.split(",");
            int r = Integer.parseInt(parts[0].trim());
            int g = Integer.parseInt(parts[1].trim());
            int b = Integer.parseInt(parts[2].trim());
            if (r > 255 || g > 255 || b > 255) {
                throw new IllegalArgumentException("RGB values must be between 0 and 255");
            }
            return new Color(r, g, b);
        }
        if (NAMED_COLORS.containsKey(input)) {
            return NAMED_COLORS.get(input);
        }
        throw new IllegalArgumentException("Invalid colour input: " + input);
    }

    public static String toHex(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }
}

