/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import org.fusesource.hawtdispatch.internal.NioDispatchSource;

final class NioAttachment {
    final ArrayList<NioDispatchSource> sources = new ArrayList(2);
    SelectionKey key;

    public NioAttachment(SelectionKey key) {
        this.key = key;
    }

    public SelectionKey key() {
        return this.key;
    }

    public void selected(SelectionKey key) {
        int readyOps = key.readyOps();
        for (NioDispatchSource source2 : this.sources) {
            int ops = source2.interestOps & readyOps;
            if (ops == 0) continue;
            source2.fire(readyOps);
        }
    }

    public void cancel() {
        for (NioDispatchSource source2 : new ArrayList<NioDispatchSource>(this.sources)) {
            this.sources.remove(source2);
            if (!source2.canceled.compareAndSet(false, true)) continue;
            source2.internal_cancel();
        }
    }
}

