/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPECoreType;
import jamiebalfour.zpe.interfaces.ZPEIndexableElement;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPERecord;
import jamiebalfour.zpe.types.ZPEString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ZPETuple
implements Iterable<ZPEType>,
Serializable,
ZPEIndexableElement,
ZPECoreType {
    byte[] types;
    ValueWrapper[] values;
    private boolean hasBeenInstantiated = false;

    public ZPETuple(byte[] types) {
        this.types = new byte[types.length];
        this.values = new ValueWrapper[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.types[i] = types[i];
            this.values[i] = types[i] == 119 ? new StringWrapper() : (types[i] == 120 ? new NumberWrapper() : (types[i] == 121 ? new BooleanWrapper() : (types[i] == 122 ? new ListWrapper() : (types[i] == 123 ? new MapWrapper() : (types[i] == 125 ? new ObjectWrapper() : (types[i] == 110 ? new RecordWrapper() : new MixedWrapper()))))));
        }
    }

    public ZPETuple(byte[] types, ZPEType[] values2) {
        types = new byte[types.length];
        this.values = new ValueWrapper[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.types[i] = types[i];
            values2[i] = types[i] == 119 ? new StringWrapper() : (types[i] == 120 ? new NumberWrapper() : (types[i] == 121 ? new BooleanWrapper() : (types[i] == 122 ? new ListWrapper() : (types[i] == 123 ? new MapWrapper() : (types[i] == 125 ? new ObjectWrapper() : (types[i] == 110 ? new RecordWrapper() : new MixedWrapper()))))));
            this.values[i].setValue(values2[i]);
        }
        this.hasBeenInstantiated = true;
    }

    public void setValue(ZPEType data, int i) {
        if (i > this.types.length - 1) {
            throw new ZPERuntimeException("Tuple value instantiation is too large for tuple.");
        }
        try {
            this.values[i].setValue(data);
        }
        catch (ClassCastException e) {
            throw new ZPERuntimeException("Tuple value instantiation value of incorrect type.");
        }
        this.hasBeenInstantiated = true;
    }

    public void setValue(ZPEType data, ZPENumber i) {
        if (i.intValue() > this.types.length - 1) {
            throw new ZPERuntimeException("Tuple value instantiation is too large for tuple.");
        }
        try {
            this.values[i.intValue()].setValue(data);
        }
        catch (ClassCastException e) {
            throw new ZPERuntimeException("Tuple value instantiation value of incorrect type.");
        }
        this.hasBeenInstantiated = true;
    }

    @Override
    public Object getIndex(Object i) {
        return this.values[HelperFunctions.stringToInteger(i.toString())].getValue();
    }

    public Object getIndex(ZPENumber i) {
        return this.values[i.intValue()].getValue();
    }

    @Override
    public Iterator<ZPEType> iterator() {
        List<ValueWrapper> iterable = Arrays.asList(this.values);
        return iterable.iterator();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (!this.hasBeenInstantiated) {
            YASSByteCodes y = new YASSByteCodes();
            for (int i = 0; i < this.types.length - 1; ++i) {
                out.append(y.symbolToString(this.types[i])).append(", ");
            }
            if (this.types.length > 0) {
                out.append(y.symbolToString(this.types[this.types.length - 1]));
            }
        } else {
            for (int i = 0; i < this.types.length - 1; ++i) {
                out.append(this.values[i].getValue()).append(", ");
            }
            if (this.types.length > 0) {
                out.append(this.values[this.types.length - 1].getValue());
            }
        }
        return "(" + String.valueOf(out) + ")";
    }

    @Override
    public ZPEType copyOfMe() {
        return this;
    }

    static class RecordWrapper
    implements ValueWrapper {
        ZPERecord value;

        RecordWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPERecord)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class ObjectWrapper
    implements ValueWrapper {
        ZPEObject value;

        ObjectWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPEObject)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class MapWrapper
    implements ValueWrapper {
        ZPEMap value;

        MapWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPEMap)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class ListWrapper
    implements ValueWrapper {
        ZPEList value;

        ListWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPEList)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class BooleanWrapper
    implements ValueWrapper {
        ZPEBoolean value;

        BooleanWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPEBoolean)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class NumberWrapper
    implements ValueWrapper {
        ZPENumber value;

        NumberWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPENumber)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class StringWrapper
    implements ValueWrapper {
        ZPEString value;

        StringWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = (ZPEString)v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static class MixedWrapper
    implements ValueWrapper {
        ZPEType value;

        MixedWrapper() {
        }

        @Override
        public void setValue(ZPEType v) {
            this.value = v;
        }

        @Override
        public ZPEType getValue() {
            return this.value;
        }
    }

    static interface ValueWrapper
    extends ZPEType {
        public void setValue(ZPEType var1);

        public ZPEType getValue();
    }
}

