/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEIndexableElement;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class ZPEString
extends ZPEMemberType
implements Iterable,
Comparable,
Serializable,
ZPEIndexableElement {
    private static final long serialVersionUID = -3248684484655054377L;
    String value = "";
    private static final Map<String, ZPEMemberType.ZPEStaticRefMethod> methods = new HashMap<String, ZPEMemberType.ZPEStaticRefMethod>();

    @Override
    protected ZPEMemberType runNative(IAST node, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt, IncorrectDataTypeException, InternalException {
        if (node.type == 3) {
            ZPEMemberType.ZPEStaticRefMethod fn = methods.get(node.id);
            if (fn != null) {
                this.returnValue = fn.call(this, arguments);
            } else {
                ZPECore.printWarning("The reference function call to `" + node.id + "` led to an undefined path because it is disabled by the system properties.");
                this.returnValue = ZPECore.UNDEFINED;
            }
        }
        return this;
    }

    public ZPEString(char c) {
        this.value = "" + c;
    }

    public ZPEString(String s) {
        this.value = s;
    }

    public ZPEString(ZPEString s) {
        this.value = s.value;
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEString(this);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int length() {
        return this.value.length();
    }

    public char charAt(int index) {
        if (ZPEInstance.getOptionBase1Property()) {
            --index;
        }
        return this.value.charAt(index);
    }

    public char charAt(ZPENumber index) {
        int i = index.intValue();
        if (ZPEInstance.getOptionBase1Property()) {
            --i;
        }
        return this.value.charAt(i);
    }

    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public void set(String s) {
        this.value = s;
    }

    public String toString() {
        return this.value;
    }

    public Iterator iterator() {
        return new CharacterIterator(this.value);
    }

    @Override
    public ZPEString copy() {
        return new ZPEString(this.value);
    }

    public int compareNumerically(ZPEString str) {
        if (this.value.length() < str.length()) {
            return -1;
        }
        if (this.value.length() > str.length()) {
            return 1;
        }
        int len = Math.max(this.value.length(), str.length());
        for (int i = 0; i < len; ++i) {
            if (this.value.charAt(i) < str.charAt(i)) {
                return -1;
            }
            if (this.value.charAt(i) <= str.charAt(i)) continue;
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return o.toString().compareTo(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZPEString)) {
            return false;
        }
        return o.toString().equals(this.value);
    }

    public boolean equalsStr(String s) {
        return s.equals(this.value);
    }

    @Override
    public Object getIndex(Object pos) {
        return Character.valueOf(this.charAt(HelperFunctions.stringToInteger(pos.toString())));
    }

    public static ZPEString newStr(String str) {
        return new ZPEString(str);
    }

    public static ZPEString newStr(char ch) {
        return new ZPEString(ch);
    }

    static {
        methods.put("get", get_Command::MainMethod);
        methods.put("append", append_Command::MainMethod);
        methods.put("prepend", prepend_Command::MainMethod);
        methods.put("cut", cut_Command::MainMethod);
        methods.put("length", length_Command::MainMethod);
        methods.put("empty", empty_Command::MainMethod);
        methods.put("dump", dump_Command::MainMethod);
        methods.put("to_string", ZPEMemberType::toString_Command);
    }

    static class CharacterIterator
    implements Iterator<ZPEString> {
        private final String str;
        private int pos = 0;

        public CharacterIterator(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.str.length();
        }

        @Override
        public ZPEString next() {
            return new ZPEString(this.str.charAt(this.pos++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class dump_Command
    implements ZPEReferenceMethod {
        dump_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPECore.print(((ZPEString)owner).value);
            return null;
        }
    }

    static class empty_Command
    implements ZPEReferenceMethod {
        empty_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return new ZPEBoolean(((ZPEString)owner).value.isEmpty());
        }
    }

    static class length_Command
    implements ZPEReferenceMethod {
        length_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return new ZPENumber(((ZPEString)owner).value.length());
        }
    }

    static class cut_Command
    implements ZPEReferenceMethod {
        cut_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int index1 = HelperFunctions.stringToInteger(arguments[0].toString());
            int index2 = HelperFunctions.stringToInteger(arguments[1].toString());
            String nVal = ((ZPEString)owner).value.substring(0, index1) + ((ZPEString)owner).value.substring(index2);
            String output = ((ZPEString)owner).value.substring(index1, index2);
            ((ZPEString)owner).value = nVal;
            return new ZPEString(output);
        }
    }

    static class prepend_Command
    implements ZPEReferenceMethod {
        prepend_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            String prepend = arguments[0].toString();
            ((ZPEString)owner).value = prepend + ((ZPEString)owner).value;
            return owner;
        }
    }

    static class append_Command
    implements ZPEReferenceMethod {
        append_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            String append = arguments[0].toString();
            ((ZPEString)owner).value = ((ZPEString)owner).value + append;
            return owner;
        }
    }

    static class get_Command
    implements ZPEReferenceMethod {
        get_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int index = HelperFunctions.stringToInteger(arguments[0].toString());
            if (arguments[0].toString().equalsIgnoreCase("any")) {
                int maximum = ((ZPEString)owner).value.length() - 1;
                int minimum = 0;
                Random rand = new Random();
                index = rand.nextInt(maximum - minimum + 1) + minimum;
            }
            return new ZPEString("" + ((ZPEString)owner).value.charAt(index));
        }
    }
}

