/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEString;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ZPERecord
extends ZPEMemberType
implements Serializable {
    private static final long serialVersionUID = -7819831393461871698L;
    private static final Map<String, ZPEMemberType.ZPEStaticRefMethod> methods = new HashMap<String, ZPEMemberType.ZPEStaticRefMethod>();
    private final Map<ZPEString, Object> fields = new HashMap<ZPEString, Object>();
    private final ZPEList fieldNames = new ZPEList();
    String name;
    ZPEPropertyWrapper par;
    private boolean locked = false;

    public ZPERecord(ZPEPropertyWrapper parent, String name) {
        this.name = name;
        this.par = parent;
    }

    @Override
    protected ZPEMemberType runNative(IAST node, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        if (node.type == 3) {
            ZPEMemberType.ZPEStaticRefMethod fn = methods.get(node.id);
            if (fn != null) {
                this.returnValue = fn.call(this, arguments);
            } else {
                ZPECore.printWarning("The reference function call to `" + node.id + "` led to an undefined path because it is disabled by the system properties.");
                this.returnValue = ZPECore.UNDEFINED;
            }
        }
        return this;
    }

    public void lock() {
        this.locked = true;
    }

    public ZPEList getFieldNames() {
        return (ZPEList)this.fieldNames.copyOfMe();
    }

    public boolean hasField(String id) {
        return this.fields.containsKey(new ZPEString(id));
    }

    public void addField(String id, ZPEVariable value) {
        if (!this.locked) {
            this.fields.put(new ZPEString(id), value);
            this.fieldNames.add(new ZPEString(id));
        }
    }

    public void setField(String id, ZPEType value) throws ZPERuntimeException {
        if (this.fields.containsKey(new ZPEString(id))) {
            ZPEVariable var = (ZPEVariable)this.fields.get(new ZPEString(id));
            var.setValue(value);
        }
    }

    public ZPEType getField(String id) {
        if (!this.fields.containsKey(new ZPEString(id))) {
            return ZPECore.UNDEFINED;
        }
        ZPEVariable var = (ZPEVariable)this.fields.get(new ZPEString(id));
        return var.getValue();
    }

    public String toString() {
        StringBuilder out = new StringBuilder("record structure " + this.name + " {");
        int size = this.fields.size();
        int i = 0;
        for (ZPEString o : this.fields.keySet()) {
            ZPEVariable var = (ZPEVariable)this.fields.get(o);
            if (var.getValue() != null) {
                String valueStr = var.getValue().toString();
                out.append(ZPEHelperFunctions.typeByteToString(var.getAssignedType())).append(" ").append(o.toString()).append(" = ").append(valueStr);
            } else {
                out.append(ZPEHelperFunctions.typeByteToString(var.getAssignedType())).append(" ").append(o.toString());
            }
            if (i < size - 1) {
                out.append(", ");
            }
            ++i;
        }
        out.append("}");
        return out.toString();
    }

    @Override
    public ZPEType copyOfMe() {
        return this;
    }

    static {
        methods.put("get", get_Command::MainMethod);
        methods.put("set", set_Command::MainMethod);
        methods.put("get_id", get_id_Command::MainMethod);
        methods.put("set_id", set_id_Command::MainMethod);
        methods.put("to_string", ZPEMemberType::toString_Command);
    }

    static class set_Command
    implements ZPEReferenceMethod {
        set_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) throws ZPERuntimeException {
            String identifier = arguments[0].toString();
            ZPEType value = arguments[1];
            ((ZPERecord)owner).setField(identifier, value);
            return owner;
        }
    }

    static class get_Command
    implements ZPEReferenceMethod {
        get_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            String identifier = arguments[0].toString();
            return ((ZPERecord)owner).getField(identifier);
        }
    }

    static class set_id_Command
    implements ZPEReferenceMethod {
        static String id;

        set_id_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) throws ZPERuntimeException {
            if (arguments.length != 0) {
                ZPEType value = arguments[0];
                ((ZPERecord)owner).setField(id, value);
                return owner;
            }
            return ((ZPERecord)owner).getField(id);
        }
    }

    static class get_id_Command
    implements ZPEReferenceMethod {
        static String id;

        get_id_Command() {
        }

        public static ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return ((ZPERecord)owner).getField(id);
        }
    }
}

