/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.Manual;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class YASSInteractiveInterpreter {
    YASSCompiler.CompilerFunction interactiveGlobal = null;
    ZPERuntimeEnvironment RT = new ZPERuntimeEnvironment();
    IAST prependedFileLast;

    public YASSInteractiveInterpreter() {
        Terminal terminal = null;
        LineReader reader = null;
        if (ZPEInstance.INTERACTIVE_LINE_COMPLETION) {
            try {
                String cmd;
                int i = 0;
                String[] funcs = new String[ZPEKit.getAllCommands().size() + ZPEKit.getAllAliases().size()];
                Iterator<String> iterator2 = ZPEKit.getAllCommands().iterator();
                while (iterator2.hasNext()) {
                    funcs[i] = cmd = iterator2.next();
                    ++i;
                }
                iterator2 = ZPEKit.getAllAliases().iterator();
                while (iterator2.hasNext()) {
                    funcs[i] = cmd = iterator2.next();
                    ++i;
                }
                terminal = TerminalBuilder.terminal();
                reader = LineReaderBuilder.builder().terminal(terminal).completer(new StringsCompleter(funcs)).expander(null).build();
                try {
                    ZPEHelperFunctions.readHistory(reader, "history.txt");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String currentLine = "";
        InputStreamReader converter = new InputStreamReader(System.in);
        BufferedReader in = new BufferedReader(converter);
        if (ZPEInstance.AUTO_PREPEND != null) {
            this.prependedFileLast = IAST.getLast(ZPEInstance.AUTO_PREPEND);
        }
        ZPEInstance.INTERACTIVE = true;
        if (reader == null) {
            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "), true);
        }
        try {
            if (reader != null) {
                reader.readLine(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "));
                currentLine = reader.getParsedLine().line();
            } else {
                currentLine = in.readLine();
            }
            while (currentLine != null && !currentLine.equals("exit()")) {
                if (reader != null) {
                    reader.getHistory().add(currentLine);
                    ZPEHelperFunctions.saveHistory(reader, "history.txt");
                }
                switch (currentLine.trim()) {
                    case "-clear": {
                        ZPEHelperFunctions.clearScreen();
                        if (reader != null) break;
                        ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "), true);
                        break;
                    }
                    case "-flush": {
                        this.RT.globalFunction.variableMap.clear();
                        this.RT.addSystemVariable();
                        if (reader != null) break;
                        ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "), true);
                        break;
                    }
                    case "help()": {
                        this.openHelp(reader);
                        if (reader != null) break;
                        ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "), true);
                        break;
                    }
                    default: {
                        try {
                            this.runCodeInteractively(currentLine);
                            if (reader != null) break;
                            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "), true);
                            break;
                        }
                        catch (Exception e) {
                            if (e instanceof IndexOutOfBoundsException) {
                                ZPECore.printError("Unclosed expression. Check that strings have been properly closed.", reader);
                            } else {
                                ZPECore.printError(e.getMessage(), reader);
                            }
                            HelperFunctions.delay(200L);
                            if (reader != null) break;
                            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "), true);
                        }
                    }
                }
                if (reader != null) {
                    reader.readLine(ZPEHelperFunctions.setConsoleEffectToGreen("zpe > "));
                    currentLine = reader.getParsedLine().line();
                    continue;
                }
                currentLine = in.readLine();
            }
        }
        catch (UserInterruptException e) {
            System.err.println(ZPEHelperFunctions.setConsoleEffectToRed("Interrupt request fired."));
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ZPEInstance.INTERACTIVE = false;
    }

    void runCodeInteractively(String code) throws CompileException, ZPERuntimeException {
        IAST rootNode;
        YASSCompiler c = new YASSCompiler();
        if (this.interactiveGlobal != null) {
            c.global = this.interactiveGlobal;
        }
        this.RT.globalFunction.code = rootNode = c.compile(code);
        if (ZPEInstance.AUTO_PREPEND != null) {
            this.prependedFileLast.next = rootNode.next;
            rootNode.next = ZPEInstance.AUTO_PREPEND;
        }
        this.RT.addSystemVariable();
        try {
            this.RT.globalFunction.run();
        }
        catch (ExitHalt e) {
            System.exit(HelperFunctions.stringToInteger(e.getMessage()));
        }
        catch (BreakPointHalt e) {
            System.out.println("YASS Program Breakpoint: ");
            System.out.println();
            Map<String, ZPEHelperFunctions.VariableInformation> vars = ZPEHelperFunctions.listAllVariables(this.RT);
            for (String s : vars.keySet()) {
                System.out.println(s + " [" + vars.get((Object)s).func.name + "] -> " + String.valueOf(vars.get((Object)s).value));
            }
        }
        catch (IncorrectDataTypeException | InternalException e) {
            throw new RuntimeException(e);
        }
        this.interactiveGlobal = c.global;
    }

    void openHelp(LineReader reader) {
        ZPECore.print("Welcome to ZPE 1.13! This is the built-in help facility.");
        ZPECore.print("From here you can enter the name of any predefined function within this version of ZPE, or the name of any library function that has been imported. For a full list of all of these functions, type -commands.");
        ZPECore.print();
        ZPECore.print("It is fully recommended that you visit the online documentation on the Internet at https://www.jamiebalfour.scot/projects/zpe/documentation/ before using ZPE/YASS.");
        ZPECore.print();
        ZPECore.print("You may type 'exit()' at any time to leave this interactive help program and return to the main interactive interpreter.");
        String currentLine = "";
        InputStreamReader converter = new InputStreamReader(System.in);
        BufferedReader in = new BufferedReader(converter);
        while (!currentLine.equals("exit()")) {
            try {
                if (reader != null) {
                    currentLine = reader.readLine(ZPEHelperFunctions.setConsoleEffectToGreen("help > "));
                } else {
                    ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("help > "), true);
                    currentLine = in.readLine();
                }
                if (!currentLine.equals("exit()")) {
                    if (currentLine.trim().equals("-commands")) {
                        Manual.printCommands();
                    } else {
                        Manual.getManualEntry(this.RT, currentLine.trim());
                    }
                }
            }
            catch (IOException e) {
                ZPECore.log("Error in help in interactive intepreter. " + e.getMessage());
            }
            if (currentLine.equals("exit()") || reader != null) continue;
            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("help > "), true);
        }
        ZPECore.print("You are now leaving the interactive help program and will return to the main interactive interpreter.");
    }
}

