/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.YASSPredefinedFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEPluginManager;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPECustomFunction;
import jamiebalfour.zpe.interfaces.ZPEInternalFunction;
import java.util.HashMap;

class Manual {
    Manual() {
    }

    private static String translateReturnTypeToString(byte type) {
        switch (type) {
            case 120: {
                return "number";
            }
            case 119: {
                return "string";
            }
            case 121: {
                return "boolean";
            }
            case 124: {
                return "function";
            }
            case 122: {
                return "list";
            }
            case 123: {
                return "associative_array";
            }
            case -4: {
                return "null";
            }
        }
        return "mixed";
    }

    public static void getManualEntry(String entry) {
        Manual.getManualEntry(new ZPERuntimeEnvironment(5), entry);
    }

    public static void getManualEntry(ZPERuntimeEnvironment z, String entry) {
        Object f = z.getInternalFunction(entry);
        if (f != null) {
            if (f instanceof Class && ZPEInternalFunction.class.isAssignableFrom((Class)f)) {
                Class fn = (Class)f;
                String a = YASSPredefinedFunctions.internalAliases.get(entry);
                if (YASSPredefinedFunctions.internalAliases.containsKey(entry)) {
                    ZPECore.print(ZPEHelperFunctions.setConsoleEffectToCyan(entry + " is an internal alias for " + a + ": "));
                }
                ZPECore.print(ZPEHelperFunctions.setConsoleEffectToYellow(YASSPredefinedFunctions.getManualHeader(fn) + " => " + Manual.translateReturnTypeToString(YASSPredefinedFunctions.getReturnType(fn))));
                ZPECore.print(YASSPredefinedFunctions.getManualEntry(fn));
                ZPECore.print();
                int per = YASSPredefinedFunctions.requiredPermissionLevels(fn);
                if (per == 0) {
                    System.out.println(ZPEHelperFunctions.setConsoleEffectToGreen("Minimum permission level: none"));
                } else {
                    ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("Minimum permission level: " + per));
                }
                ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("Can be overwritten: " + (YASSPredefinedFunctions.getMode(fn) == 1 ? "No" : "Yes")));
                ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen("Function version " + YASSPredefinedFunctions.getVersion(fn)));
                ZPECore.print();
            } else if (f instanceof ZPECustomFunction) {
                ZPECustomFunction fn = (ZPECustomFunction)f;
                String q = YASSPredefinedFunctions.internalAliases.get(entry);
                if (YASSPredefinedFunctions.internalAliases.containsKey(entry)) {
                    ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen(entry + " is an internal aliase for " + q + ": "));
                }
                ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen(fn.getManualHeader() + " -> " + Manual.translateReturnTypeToString(fn.getReturnType())));
                ZPECore.print(fn.getManualEntry());
                int per = fn.getRequiredPermissionLevel();
                if (per == 0) {
                    ZPECore.print("Minimum permission level: none");
                } else {
                    ZPECore.print("Minimum permission level: " + per);
                }
            }
        } else if (z.globalFunction.functionMap.containsKey(entry)) {
            f = z.globalFunction.functionMap.get(entry);
            ZPEFunction fn = (ZPEFunction)f;
            StringBuilder params = new StringBuilder();
            for (int i = 0; i < fn.parameterNames.size(); ++i) {
                String param2 = fn.parameterNames.get(i);
                if (i == fn.parameterNames.size() - 1) {
                    params.append(param2);
                    continue;
                }
                params.append(param2).append(", ");
            }
            if (fn.documentation != null) {
                HashMap documentation = (HashMap)fn.documentation;
                for (String s : documentation.keySet()) {
                    String doc = (String)documentation.get(s);
                    ZPECore.print("@" + doc);
                    if (doc.startsWith("\"") && doc.endsWith("\"")) {
                        doc = doc.substring(1, doc.length() - 2);
                    }
                    ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen(entry + " (" + String.valueOf(params) + ")"));
                    ZPECore.print(ZPEHelperFunctions.setConsoleEffectToGreen(doc));
                }
            }
        } else {
            ZPECore.print("No manual entry found.");
        }
    }

    public static void printCommands() {
        ZPERuntimeEnvironment z = new ZPERuntimeEnvironment();
        try {
            z.runStartup();
        }
        catch (ZPERuntimeException e) {
            throw new RuntimeException(e);
        }
        ZPECore.print("");
        ZPECore.print("ZPE aliases");
        ZPECore.print("");
        for (String s : YASSPredefinedFunctions.internalAliases.keySet()) {
            ZPECore.print("  " + s + " => " + YASSPredefinedFunctions.internalAliases.get(s) + ";");
        }
        ZPECore.print("");
        ZPECore.print("");
        ZPECore.print("ZPE functions (" + ZPEInstance.BUILT_IN_COMMANDS.getCommandCount() + " available):");
        ZPECore.print("");
        String lastCategory = "";
        for (String s : YASSPredefinedFunctions.getCommands()) {
            Class<? extends ZPEInternalFunction> func = YASSPredefinedFunctions.getInternalMethod(s);
            String permission_level = "" + YASSPredefinedFunctions.requiredPermissionLevels(func);
            if (!lastCategory.equals(YASSPredefinedFunctions.getCategory(func))) {
                lastCategory = YASSPredefinedFunctions.getCategory(func);
                System.out.println();
                System.out.println("  " + lastCategory + " functions");
                System.out.println();
            }
            String h = YASSPredefinedFunctions.getManualHeader(func).replace(s + " ", "");
            ZPECore.print("    " + s + h);
        }
        ZPECore.print("");
        ZPECore.print("");
        ZPECore.print("Imported native functions");
        ZPECore.print("");
        for (String s : ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.keySet()) {
            ZPECore.print("  " + s);
        }
        ZPECore.print("");
        ZPECore.print("");
    }
}

