/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ChatGPT {
    private static ChatGPT instance;
    private final String API_URL = ZPEInstance.getChatGPTURL();
    private final String API_KEY = ZPEInstance.getChatGPTKey();
    private final String API_MODEL = ZPEInstance.getChatGPTModel();

    private ChatGPT() throws Exception {
        if (ZPEInstance.getChatGPTKey() == null || ZPEInstance.getChatGPTURL() == null || ZPEInstance.getChatGPTModel() == null) {
            throw new Exception("ChatGPT is not configured yet.");
        }
    }

    public static ChatGPT getInstance() throws Exception {
        return instance == null ? (instance = new ChatGPT()) : instance;
    }

    public static String parseResultsToMessage(String data) throws MalformedJSONException {
        ZenithJSONParser json = new ZenithJSONParser();
        ZPEType res = null;
        res = json.jsonDecode(data, false);
        ZPEMap choice = (ZPEMap)((ZPEList)((ZPEMap)res).get(new ZPEString("choices"))).get(0);
        ZPEMap message = (ZPEMap)choice.get(new ZPEString("message"));
        ZPEString results = (ZPEString)message.get(new ZPEString("content"));
        return results.toString();
    }

    public String sendMessage(String message) throws IOException {
        OkHttpClient client = new OkHttpClient();
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.API_MODEL);
        requestBody.put("messages", new Object[]{Map.of("role", "user", "content", message)});
        String jsonBody = mapper.writeValueAsString(requestBody);
        Request request = new Request.Builder().url(this.API_URL).post(RequestBody.create(jsonBody, MediaType.parse("application/json"))).addHeader("Authorization", "Bearer " + this.API_KEY).addHeader("Content-Type", "application/json").build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code: " + String.valueOf(response));
            }
            assert (response.body() != null);
            String string = response.body().string();
            return string;
        }
    }
}

