/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.dialogs;

import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class OutputViewer
extends JFrame {
    private final JTextArea textArea;
    private final List<String> outputLines;

    public OutputViewer(List<String> outputLines) {
        this.setTitle("Output Stream Viewer");
        this.setSize(600, 400);
        this.setLocationRelativeTo(null);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.add(scrollPane);
        this.outputLines = outputLines;
        if (outputLines == null) {
            outputLines = new ArrayList<String>();
        }
        this.updateLines(outputLines);
        OutputViewer.redirectSystemOut(this);
    }

    public void updateLines(List<String> lines) {
        this.outputLines.clear();
        this.outputLines.addAll(lines);
        SwingUtilities.invokeLater(() -> {
            this.textArea.setText("");
            for (String line : this.outputLines) {
                this.textArea.append(line + "\n");
            }
        });
    }

    private static void redirectSystemOut(final OutputViewer v) {
        OutputStream customOut = new OutputStream(){
            private final StringBuilder buffer = new StringBuilder();
            private final OutputStream orgOut = System.out;

            @Override
            public void write(int b) throws IOException {
                char c = (char)b;
                this.orgOut.write(c);
                this.buffer.append(c);
                if (c == '\n') {
                    this.flushBuffer();
                }
            }

            private void flushBuffer() {
                String line = this.buffer.toString().replaceAll("\\r?\\n$", "");
                if (!line.isEmpty()) {
                    v.addLine(line);
                }
                this.buffer.setLength(0);
            }

            @Override
            public void flush() {
                this.flushBuffer();
            }

            @Override
            public void close() {
                this.flush();
            }
        };
        PrintStream ps = new PrintStream(customOut, true);
        System.setOut(ps);
        System.setErr(ps);
    }

    public void addLine(String line) {
        this.outputLines.add(line);
        SwingUtilities.invokeLater(() -> this.textArea.append(line + "\n"));
    }
}

