/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.dialogs;

import jamiebalfour.ui.components.BalfScrollbar;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BalfPropertiesManager
extends JFrame {
    private final Properties properties;
    private final File sourceFile;
    private final Map<String, JComponent> fieldMap = new LinkedHashMap<String, JComponent>();
    BalfScrollbar scrollPane;

    public BalfPropertiesManager(Properties properties, File sourceFile) {
        super("Properties Editor");
        this.properties = properties;
        this.sourceFile = sourceFile;
        this.setDefaultCloseOperation(2);
        this.setSize(400, 600);
        this.setLocationRelativeTo(null);
        JPanel panel = new JPanel(new GridBagLayout());
        this.scrollPane = new BalfScrollbar(panel);
        this.scrollPane.disableDarkMode();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        for (String key : properties.stringPropertyNames()) {
            JComponent valueComponent;
            String value = properties.getProperty(key);
            JLabel nameLabel = new JLabel(key);
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
                JComboBox<String> comboBox = new JComboBox<String>(new String[]{"true", "false"});
                comboBox.setSelectedItem(value.toLowerCase());
                valueComponent = comboBox;
            } else {
                JTextField valueField;
                valueComponent = valueField = new JTextField(value, 20);
            }
            this.fieldMap.put(key, valueComponent);
            gbc.gridx = 0;
            panel.add((Component)nameLabel, gbc);
            gbc.gridx = 1;
            panel.add((Component)valueComponent, gbc);
            ++gbc.gridy;
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 3;
        panel.add(Box.createVerticalGlue(), gbc);
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(this::saveProperties);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(saveButton);
        this.add((Component)buttonPanel, "South");
    }

    private void saveProperties(ActionEvent e) {
        try (FileOutputStream out = new FileOutputStream(this.sourceFile);){
            for (Map.Entry<String, JComponent> entry : this.fieldMap.entrySet()) {
                String value;
                String key = entry.getKey();
                JComponent comp = entry.getValue();
                if (comp instanceof JTextField) {
                    value = ((JTextField)comp).getText();
                } else {
                    if (!(comp instanceof JComboBox)) continue;
                    value = Objects.toString(((JComboBox)comp).getSelectedItem(), "");
                }
                this.properties.setProperty(key, value);
            }
            this.properties.store(out, "Updated Properties");
            this.scrollPane.repaint();
            JOptionPane.showMessageDialog(this, "Properties saved successfully.");
            this.scrollPane.repaint();
            this.dispose();
        }
        catch (IOException ex) {
            this.scrollPane.repaint();
            JOptionPane.showMessageDialog(this, "Error saving properties: " + ex.getMessage(), "Error", 0);
            this.scrollPane.repaint();
        }
    }
}

