/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfLafManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BalfSplitPane
extends JSplitPane {
    Color orgBackground;
    Color darkColour = BalfLafManager.getInstance().getDarkColorBackground().brighter();

    public BalfSplitPane(int orientation) {
        super(orientation);
        this.setDoubleBuffered(true);
        this.orgBackground = this.getBackground();
        this.setUI(new BalfSplitPaneUI(this));
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
        });
    }

    public void setDarkColour(Color darkColour) {
        this.darkColour = darkColour;
        this.repaint();
    }

    private void enableDarkMode() {
        this.setBackground(this.darkColour);
        this.repaint();
    }

    private void disableDarkMode() {
        this.setBackground(this.orgBackground);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getBackground());
        g2.fill(clip);
        g2.dispose();
        super.paintComponent(g);
    }

    static class BalfSplitPaneUI
    extends BasicSplitPaneUI {
        private final BalfSplitPane parent;

        public BalfSplitPaneUI(BalfSplitPane parent) {
            this.parent = parent;
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(HelperFunctions.adjustColorForContrast(parent.getBackground(), 2));
                    if (parent.getDividerSize() > 0) {
                        float[] dash = new float[]{4.0f, 4.0f};
                        g2.setStroke(new BasicStroke(1.5f, 0, 2, 0.0f, dash, 0.0f));
                        if (this.getOrientation() == 1) {
                            int x = this.getWidth() / 2;
                            g2.drawLine(x, 0, x, this.getHeight());
                        } else {
                            int y = this.getHeight() / 2;
                            g2.drawLine(0, y, this.getWidth(), y);
                        }
                    }
                }
            };
        }
    }
}

