/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UITheme;
import jamiebalfour.ui.UIUtils;
import jamiebalfour.ui.components.BalfSearchBox;
import jamiebalfour.ui.components.BalfSeparator;
import jamiebalfour.ui.components.BalfTitleBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class BalfMenuBar
extends JMenuBar {
    Color backgroundColor;
    Color foregroundColor;
    Color menuItemBackgroundColor;
    Color menuItemForegroundColor;
    final Color orgBackgroundColor;
    final Color orgForegroundColor;
    final Color orgMenuItemBackgroundColor;
    final Color orgMenuItemForegroundColor;
    BalfSearchBox searchBox;
    Color hoverColor;
    Color paneColour = null;
    Color orgPaneColour;
    private BalfTitleBar titleBar;
    private Insets orgInsets;
    boolean hasFocus;
    static EmptyBorder borderStyle = new EmptyBorder(5, 0, 5, 7);
    boolean darkMode = false;
    private Shape cachedBackgroundShape = null;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private boolean cachedDarkMode = false;

    public BalfMenuBar(Color backgroundColor, Color foregroundColor) {
        UIManager.put("PopupMenu.opacity", false);
        if (!HelperFunctions.isMac()) {
            UIManager.put("Menu.font", new Font("SF Pro Text", 0, 14));
            UIManager.put("MenuItem.font", new Font("SF Pro Text", 0, 14));
            UIManager.put("MenuItem.margin", new Insets(6, 20, 6, 20));
            UIManager.put("MenuItem.selectionBackground", new Color(80, 120, 160));
            UIManager.put("MenuItem.selectionForeground", Color.WHITE);
            UIManager.put("MenuItem.acceleratorFont", new Font("SF Pro Text", 0, 13));
        }
        UIManager.put("MenuItem.forceDoubleBuffering", Boolean.TRUE);
        UIManager.put("PopupMenu.forceDoubleBuffering", Boolean.TRUE);
        if (!HelperFunctions.isMac()) {
            borderStyle = new EmptyBorder(3, 0, 3, 7);
        }
        this.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 14.0f));
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.menuItemBackgroundColor = backgroundColor;
        this.menuItemForegroundColor = foregroundColor;
        this.orgBackgroundColor = backgroundColor;
        this.orgForegroundColor = foregroundColor;
        this.orgMenuItemBackgroundColor = this.menuItemBackgroundColor;
        this.orgMenuItemForegroundColor = this.menuItemForegroundColor;
        this.orgInsets = this.getInsets();
        this.hoverColor = this.menuItemBackgroundColor.brighter().brighter();
        if (this.hoverColor.equals(this.menuItemBackgroundColor.brighter().brighter())) {
            this.hoverColor = this.menuItemBackgroundColor.darker().darker();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2 && BalfMenuBar.this.titleBar != null) {
                    BalfMenuBar.this.titleBar.activateMaximise();
                }
            }
        });
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setDoubleBuffered(true);
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
            this.repaint();
        });
        BalfLafManager.getInstance().addThemeChangeListener(() -> {
            UITheme theme = BalfLafManager.getInstance().getTheme();
            if (BalfLafManager.getInstance().getTheme() == null) {
                this.setBackground(this.orgBackgroundColor);
                this.setForeground(this.orgForegroundColor);
                this.setMenuItemBackground(this.orgMenuItemBackgroundColor);
                this.setMenuItemForeground(this.orgMenuItemForegroundColor);
                this.paneColour = this.orgPaneColour;
            } else {
                this.setBackground(theme.getBackground());
                this.setForeground(theme.getForeground());
                this.setMenuItemBackground(theme.getMenuItemBackground());
                this.setMenuItemForeground(theme.getMenuItemForeground());
                this.paneColour = theme.getBackground().brighter();
            }
        });
    }

    public void setPaneColour(Color c) {
        this.paneColour = c;
        this.orgPaneColour = c;
    }

    private JMenu convertCustomMenuToJMenu(Menu customMenu) {
        JMenu jMenu = new JMenu(customMenu.getText());
        jMenu.setMnemonic(customMenu.getMnemonic());
        customMenu.link = jMenu;
        for (Component comp : customMenu.getMenuComponents()) {
            if (comp instanceof Menu) {
                jMenu.add(this.convertCustomMenuToJMenu((Menu)comp));
                continue;
            }
            if (comp instanceof CheckBoxMenuItem) {
                JCheckBoxMenuItem jCheck;
                CheckBoxMenuItem customCheck = (CheckBoxMenuItem)comp;
                customCheck.link = jCheck = new JCheckBoxMenuItem(customCheck.getText(), customCheck.isSelected());
                jCheck.setAccelerator(customCheck.getAccelerator());
                for (ActionListener al : customCheck.getActionListeners()) {
                    jCheck.addActionListener(al);
                }
                jCheck.addActionListener(e -> customCheck.setSelected(jCheck.isSelected()));
                jMenu.add(jCheck);
                continue;
            }
            if (comp instanceof MenuItem) {
                JMenuItem jItem;
                MenuItem customItem = (MenuItem)comp;
                customItem.link = jItem = new JMenuItem(customItem.getText());
                jItem.setAccelerator(customItem.getAccelerator());
                for (ActionListener al : customItem.getActionListeners()) {
                    jItem.addActionListener(al);
                }
                jMenu.add(jItem);
                continue;
            }
            if (!(comp instanceof Separator)) continue;
            jMenu.addSeparator();
        }
        return jMenu;
    }

    public JMenuBar toJMenuBar() {
        JMenuBar swingMenuBar = new JMenuBar();
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof Menu)) continue;
            swingMenuBar.add(this.convertCustomMenuToJMenu((Menu)comp));
        }
        return swingMenuBar;
    }

    void attachTitleBar(BalfTitleBar titleBar) {
        this.titleBar = titleBar;
        final JFrame _frame = this.titleBar._frame;
        _frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                BalfMenuBar.this.hasFocus = true;
                _frame.repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                BalfMenuBar.this.hasFocus = false;
                _frame.repaint();
            }
        });
    }

    public BalfSearchBox addSearchBox() {
        this.add(Box.createHorizontalGlue());
        this.searchBox = new BalfSearchBox(10);
        this.add(this.searchBox);
        this.add(new BalfSeparator(10, 30));
        return this.searchBox;
    }

    private void enableDarkMode() {
        this.darkMode = true;
        this.menuItemForegroundColor = BalfLafManager.getInstance().getDarkColorForeground();
        this.foregroundColor = BalfLafManager.getInstance().getDarkColorForeground();
    }

    private void disableDarkMode() {
        this.darkMode = false;
        this.menuItemForegroundColor = this.orgMenuItemForegroundColor;
        this.foregroundColor = this.orgForegroundColor;
    }

    private void recurseItems(Component comp) {
        if (comp instanceof MenuItem) {
            MenuItem cmi = (MenuItem)comp;
            for (Component c : cmi.getComponents()) {
                c.setForeground(this.foregroundColor);
                c.setFont(this.getFont());
                c.repaint();
            }
        }
    }

    @Override
    public void setBackground(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setColours(backgroundColor, this.foregroundColor);
    }

    @Override
    public void setForeground(Color foregroundColor) {
        this.setColours(this.backgroundColor, foregroundColor);
    }

    public void setMenuItemBackground(Color backgroundColor) {
        this.menuItemBackgroundColor = backgroundColor;
    }

    public void setMenuItemForeground(Color foregroundColor) {
        this.menuItemForegroundColor = foregroundColor;
    }

    public void setColours(Color backgroundColor, Color foregroundColor) {
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        for (Component c : this.getComponents()) {
            this.recurseItems(c);
            c.setForeground(foregroundColor);
            c.repaint();
        }
    }

    @Override
    public JMenu add(JMenu menu) {
        super.add(menu);
        if (menu instanceof Menu) {
            menu.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 6));
            menu.setIcon(null);
            ((Menu)menu).owner = this;
        }
        menu.setForeground(this.foregroundColor);
        this.setForeground(this.foregroundColor);
        return menu;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean shouldRebuild;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        Color c1 = this.backgroundColor;
        if (this.darkMode) {
            c1 = BalfLafManager.getInstance().getDarkColorBackground();
        }
        boolean bl = shouldRebuild = this.cachedBackgroundShape == null || width != this.cachedWidth || height != this.cachedHeight || this.darkMode != this.cachedDarkMode;
        if (shouldRebuild) {
            this.cachedBackgroundShape = new Rectangle2D.Float(0.0f, 0.0f, width, height);
            this.cachedWidth = width;
            this.cachedHeight = height;
            this.cachedDarkMode = this.darkMode;
        }
        if (this.titleBar != null && !this.hasFocus) {
            c1 = UIUtils.transformToGrayscaleColour(c1);
        }
        g2d.setColor(c1);
        g2d.fill(this.cachedBackgroundShape);
        g2d.dispose();
    }

    private static String getAcceleratorText(KeyStroke keyStroke) {
        StringBuilder sb = new StringBuilder();
        int modifiers = keyStroke.getModifiers();
        if (HelperFunctions.isMac()) {
            if ((modifiers & 0x100) != 0) {
                sb.append("\u2318");
            }
            if ((modifiers & 0x40) != 0) {
                sb.append("\u21e7");
            }
            if ((modifiers & 0x200) != 0) {
                sb.append("\u2325");
            }
            if ((modifiers & 0x80) != 0) {
                sb.append("^");
            }
        } else {
            if ((modifiers & 0x80) != 0) {
                sb.append("Ctrl+");
            }
            if ((modifiers & 0x100) != 0) {
                sb.append("Cmd+");
            }
            if ((modifiers & 0x200) != 0) {
                sb.append("Alt+");
            }
            if ((modifiers & 0x40) != 0) {
                sb.append("Shift+");
            }
        }
        sb.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        return sb.toString();
    }

    public static class Separator
    extends JSeparator {
        BalfMenuBar menuBar;
        boolean dashed = true;
        private Shape cachedHoverShape = null;

        public Separator(BalfMenuBar menuBar) {
            this.menuBar = menuBar;
            this.setDoubleBuffered(true);
        }

        public void setDashed(boolean dashed) {
            this.dashed = dashed;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            int xPos = 10;
            xPos = MenuItem.drawPane(g2, xPos, this.menuBar);
            if (this.cachedHoverShape == null) {
                this.cachedHoverShape = new Rectangle2D.Float(xPos, 0.0f, this.getWidth(), this.getHeight());
            }
            g2.setColor(this.menuBar.menuItemBackgroundColor);
            if (this.menuBar.darkMode) {
                g2.setColor(new Color(20, 20, 20));
            }
            g2.fill(this.cachedHoverShape);
            g2.setColor(this.menuBar.foregroundColor.darker().darker());
            if (g2.getColor() == this.menuBar.foregroundColor) {
                g2.setColor(this.menuBar.foregroundColor.brighter().brighter());
            }
            if (this.menuBar.darkMode) {
                g2.setColor(new Color(70, 70, 70));
            }
            if (this.dashed) {
                Stroke originalStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f));
                int y = this.getHeight() / 2;
                g2.drawLine(xPos + 5, y, this.getWidth() - 10, y);
            } else {
                g2.fillRect(xPos + 5, this.getHeight() / 2 - 1, this.getWidth() - xPos - 10, 1);
            }
            g2.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, 6);
        }
    }

    static class EmptyIcon
    implements Icon {
        private final int size = 16;

        EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static class CheckBoxMenuItem
    extends MenuItem {
        boolean selected = false;
        JCheckBoxMenuItem link = null;

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean selected) {
            this.selected = selected;
            this.repaint();
        }

        public CheckBoxMenuItem(String text, BalfMenuBar menuBar) {
            super(text, menuBar);
            this.orgInsets = super.getInsets();
            this.setForeground(menuBar.foregroundColor);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.setSelected(!this.isSelected());
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.setSelected(!this.isSelected());
                    this.repaint();
                }
            });
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (this.link != null) {
                this.link.setText(text);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
            if (this.isSelected()) {
                g2.setColor(this.getForeground());
                int x = 12;
                int y = this.getHeight() / 2;
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawLine(x, y + 2, x + 3, y + 5);
                g2.drawLine(x + 3, y + 5, x + 8, y - 2);
            }
            g2.dispose();
        }
    }

    public static class MenuItem
    extends JMenuItem {
        private JMenuItem link = null;
        protected boolean hovered = false;
        protected BalfMenuBar menuBar;
        private MenuItem _this = this;
        private Icon ico;
        protected Insets orgInsets;
        private Shape cachedHoverShape = null;
        private int cachedWidth = -1;
        private int cachedHeight = -1;
        private boolean cachedHovered = false;

        public MenuItem(BalfMenuBar menuBar) {
            this.orgInsets = super.getInsets();
            if (HelperFunctions.isMac()) {
                new Insets(1, 5, 5, 5);
            } else {
                new Insets(1, 5, 4, 5);
            }
            this.setup(menuBar);
        }

        @Override
        public void setIcon(Icon icon) {
            this.ico = icon;
            if (this.link != null) {
                this.link.setIcon(icon);
            }
        }

        public MenuItem(String text, BalfMenuBar menuBar) {
            super(text);
            this.setup(menuBar);
        }

        public MenuItem(String text, Icon icon, BalfMenuBar menuBar) {
            super(text, icon);
            this.setup(menuBar);
        }

        private void setup(BalfMenuBar menuBar) {
            this.menuBar = menuBar;
            this.setFont(menuBar.getFont());
            this.setDoubleBuffered(true);
            this.setOpaque(false);
            this.setForeground(menuBar.menuItemForegroundColor);
            this.setBorder(borderStyle);
            super.setIcon(new EmptyIcon());
            this.mouseListener();
            if (!HelperFunctions.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
            BalfLafManager.getInstance().addDarkModeListener(enabled -> {
                if (enabled) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(menuBar.menuItemForegroundColor);
                }
                this.repaint();
            });
            this.getModel().addChangeListener(e -> {
                this.setForeground(menuBar.menuItemForegroundColor);
                this.repaint();
            });
        }

        public MenuItem(Action a, BalfMenuBar menuBar) {
            super(a);
            this.setup(menuBar);
        }

        void mouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    hovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }
            });
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (this.link != null) {
                this.link.setText(text);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            boolean rebuild;
            Graphics2D g2 = (Graphics2D)g.create();
            int width = this.getWidth();
            int height = this.getHeight();
            int xPos = 10;
            xPos = MenuItem.drawPane(g2, xPos, this.menuBar);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            boolean bl = rebuild = this.cachedHoverShape == null || this.cachedWidth != width || this.cachedHeight != height || this.cachedHovered != this.hovered;
            if (rebuild) {
                this.cachedHoverShape = new Rectangle2D.Float(xPos, 0.0f, width - xPos, height + 1);
                this.cachedWidth = width;
                this.cachedHeight = height;
                this.cachedHovered = this.hovered;
            }
            g2.setColor(this.hovered ? (this.menuBar.darkMode ? BalfLafManager.getInstance().getDarkColorMenuHoverBackground() : this.menuBar.hoverColor) : (this.menuBar.darkMode ? new Color(20, 20, 20) : this.menuBar.menuItemBackgroundColor));
            g2.fill(this.cachedHoverShape);
            g2.setColor(this.menuBar.foregroundColor);
            FontMetrics fm = g2.getFontMetrics();
            int textHeight = fm.getAscent() - fm.getDescent();
            int textY = (this.getHeight() + textHeight) / 2;
            if (!this.isEnabled()) {
                g2.setColor(new Color(this.menuBar.foregroundColor.getRed(), this.menuBar.foregroundColor.getGreen(), this.menuBar.foregroundColor.getBlue(), 100));
            }
            g2.drawString(this.getText(), xPos + 5, textY);
            KeyStroke ks = this.getAccelerator();
            FontMetrics fm2 = g2.getFontMetrics();
            if (ks != null) {
                String accelText = BalfMenuBar.getAcceleratorText(ks);
                int accelWidth = fm.stringWidth(accelText);
                int accelX = this.getWidth() - accelWidth - 10;
                g2.drawString(accelText, accelX, textY);
            }
            g2.dispose();
        }

        private static int drawPane(Graphics2D g2, int xPos, BalfMenuBar menuBar) {
            if (menuBar.paneColour != null) {
                g2.setColor(menuBar.paneColour);
                if (menuBar.darkMode) {
                    g2.setColor(new Color(51, 51, 51));
                }
                g2.fillRect(0, 0, 32, 32);
                xPos = 32;
            }
            return xPos;
        }
    }

    public static class Menu
    extends JMenu {
        private JComponent owner;
        private boolean hovered = false;
        private BalfMenuBar menuBar;
        private JMenu link = null;
        private Icon ico;
        private Insets orgInsets;
        private Shape cachedHoverShape = null;
        private int cachedWidth = -1;
        private int cachedHeight = -1;
        private boolean cachedPopup = false;

        public Menu(BalfMenuBar menuBar) {
            this.setup(menuBar);
        }

        public Menu(String title, BalfMenuBar menuBar) {
            super(title);
            this.setup(menuBar);
        }

        private void showPopupWithDelay(int delayMs) {
            this.getPopupMenu().setLocation(-1000, -1000);
            this.getPopupMenu().show(this, -1000, -1000);
            this.getPopupMenu().setVisible(false);
            Timer timer = new Timer(delayMs, e -> this.getPopupMenu().show(this, 0, this.getHeight()));
            timer.setRepeats(false);
            timer.start();
        }

        private void setup(BalfMenuBar menuBar) {
            this.orgInsets = super.getInsets();
            this.menuBar = menuBar;
            this.setFont(menuBar.getFont());
            this.setDoubleBuffered(true);
            if (!HelperFunctions.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
            this.getPopupMenu().setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.getPopupMenu().setBackground(menuBar.menuItemBackgroundColor);
            this.getPopupMenu().setDoubleBuffered(true);
            this.getPopupMenu().setOpaque(true);
            this.setOpaque(false);
            this.setForeground(menuBar.menuItemForegroundColor);
            this.setBorder(borderStyle);
            this.getModel().addChangeListener(e -> {
                ButtonModel model = this.getModel();
                if (model.isRollover() || model.isArmed()) {
                    if (this.owner != null && this.owner instanceof BalfMenuBar) {
                        this.setForeground(menuBar.foregroundColor);
                    } else {
                        this.setForeground(menuBar.menuItemForegroundColor);
                    }
                } else {
                    this.setForeground(menuBar.menuItemForegroundColor);
                }
                this.repaint();
            });
            this.setIcon(new EmptyIcon());
            BalfLafManager.getInstance().addDarkModeListener(enabled -> {
                if (enabled) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(menuBar.menuItemForegroundColor);
                }
                this.repaint();
            });
            this.mouseListener();
        }

        @Override
        public JMenuItem add(String text) {
            JMenuItem x = super.add(text);
            x.setForeground(Color.white);
            if (this.link != null) {
                this.link.add(text);
            }
            return x;
        }

        @Override
        public Component add(Component c) {
            Component x = super.add(c);
            x.setForeground(Color.white);
            if (this.link != null) {
                this.link.add(c);
            }
            return x;
        }

        @Override
        public JMenuItem add(JMenuItem m) {
            JMenuItem x = super.add(m);
            x.setForeground(Color.white);
            if (this.link != null) {
                this.link.add(m);
            }
            return x;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (this.link != null) {
                this.link.setText(text);
            }
        }

        void mouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    hovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            boolean rebuild;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            boolean isHover = this.hovered || this.isPopupMenuVisible();
            int xPos = 0;
            if (this.owner == null || !(this.owner instanceof BalfMenuBar)) {
                xPos = 10;
                xPos = MenuItem.drawPane(g2, xPos, this.menuBar);
            }
            boolean bl = rebuild = this.cachedHoverShape == null || this.cachedWidth != width || this.cachedHeight != height || this.cachedPopup != isHover;
            if (rebuild) {
                if (!(this.owner instanceof BalfMenuBar)) {
                    this.cachedHoverShape = new Rectangle2D.Float(xPos, 0.0f, width - xPos, height + 1);
                    this.cachedWidth = width;
                    this.cachedHeight = height;
                    this.cachedPopup = isHover;
                } else {
                    Path2D.Float path = new Path2D.Float();
                    float arc = 5.0f;
                    path.moveTo(0.0f, height + 1);
                    path.lineTo(0.0f, arc);
                    path.quadTo(0.0f, 0.0f, arc, 0.0f);
                    path.lineTo((float)width - arc, 0.0f);
                    path.quadTo(width, 0.0f, width, arc);
                    path.lineTo(width, height + 1);
                    path.lineTo(0.0f, height + 1);
                    path.closePath();
                    this.cachedHoverShape = path;
                    this.cachedWidth = width;
                    this.cachedHeight = height;
                    this.cachedPopup = isHover;
                }
            }
            if (!(this.owner instanceof BalfMenuBar)) {
                g2.setColor(isHover ? (this.menuBar.darkMode ? BalfLafManager.getInstance().getDarkColorMenuHoverBackground() : this.menuBar.hoverColor) : (this.menuBar.darkMode ? new Color(20, 20, 20) : this.menuBar.menuItemBackgroundColor));
                g2.fill(this.cachedHoverShape);
            } else {
                Color m = this.menuBar.darkMode ? BalfLafManager.getInstance().getDarkColorBackground().darker() : this.menuBar.backgroundColor.darker();
                g2.setColor(m);
                if (isHover) {
                    g2.fill(this.cachedHoverShape);
                }
            }
            if (this.ico != null) {
                int iconX = 8;
                int iconY = (this.getHeight() - this.ico.getIconHeight()) / 2;
                this.ico.paintIcon(this, g2, iconX, iconY);
            }
            if (!(this.owner instanceof BalfMenuBar)) {
                g2.setColor(this.menuBar.foregroundColor);
                FontMetrics fm = g2.getFontMetrics();
                int textHeight = fm.getAscent() - fm.getDescent();
                int textY = (this.getHeight() + textHeight) / 2;
                g2.drawString(this.getText(), xPos + 5, textY);
                Menu.drawChevron(g2, this.getWidth() - 12, this.getHeight() / 2, 6);
            } else {
                g2.setColor(this.menuBar.foregroundColor);
                FontMetrics fm = g2.getFontMetrics();
                int textHeight = fm.getAscent() - fm.getDescent();
                int textX = (this.getWidth() - fm.stringWidth(this.getText())) / 2;
                int textY = (this.getHeight() + textHeight) / 2;
                g2.drawString(this.getText(), textX, textY);
            }
            g2.dispose();
        }

        private static void drawChevron(Graphics2D g2, int x, int y, int size) {
            int half = size / 2;
            Path2D.Float chevron = new Path2D.Float();
            chevron.moveTo(x, y - half);
            chevron.lineTo(x + half, y);
            chevron.lineTo(x, y + half);
            g2.setStroke(new BasicStroke(2.0f));
            g2.draw(chevron);
        }
    }
}

