/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.windows.BalfWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;

public class UIUtils {
    public static JPanel roundFrame(JFrame frame, int rounding, Color backgroundColour) {
        return UIUtils.roundFrameInner(frame, rounding, backgroundColour);
    }

    public static JPanel roundFrame(JWindow window, int rounding, Color backgroundColour) {
        return UIUtils.roundFrameInner(window, rounding, backgroundColour);
    }

    public static JPanel roundFrame(JDialog dialog, int rounding, Color backgroundColour) {
        return UIUtils.roundFrameInner(dialog, rounding, backgroundColour);
    }

    private static JPanel roundFrameInner(final RootPaneContainer frame, final int rounding, final Color backgroundColour) {
        if (frame instanceof JFrame) {
            ((JFrame)frame).setUndecorated(true);
            if (!HelperFunctions.isWindows()) {
                ((JFrame)frame).setBackground(new Color(0, 0, 0, 0));
            }
        } else if (frame instanceof JWindow) {
            if (!HelperFunctions.isWindows()) {
                ((JWindow)frame).setBackground(new Color(0, 0, 0, 0));
            }
        } else if (frame instanceof JDialog && !HelperFunctions.isWindows()) {
            ((JDialog)frame).setUndecorated(true);
            ((JDialog)frame).setBackground(new Color(0, 0, 0, 0));
        }
        if (frame instanceof JFrame) {
            ((JFrame)frame).setUndecorated(true);
        }
        final JPanel container = new JPanel(){
            private Shape cachedOuterRectangle = null;
            private Shape cachedBorderNormal = null;
            private Shape cachedBorderMaximised = null;
            private Shape cachedInnerRectangle = null;
            private int lastWidth = -1;
            private int lastHeight = -1;
            int inset;
            Color background = backgroundColour;

            @Override
            public Insets getInsets() {
                return new Insets(this.inset, this.inset, this.inset, this.inset);
            }

            @Override
            public void invalidate() {
                super.invalidate();
                this.cachedOuterRectangle = null;
                this.cachedBorderNormal = null;
                this.cachedBorderMaximised = null;
                if (frame instanceof BalfWindow) {
                    this.inset = this.isMaximised() ? 3 : 3;
                }
            }

            @Override
            public void setBackground(Color c) {
                this.background = c;
                this.cachedOuterRectangle = null;
                this.repaint();
            }

            private boolean isMaximised() {
                if (frame instanceof BalfWindow) {
                    return ((BalfWindow)frame).getExtendedState() == 6;
                }
                return false;
            }

            @Override
            protected void paintComponent(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                if (this.cachedOuterRectangle == null || w != this.lastWidth || h != this.lastHeight) {
                    if (frame instanceof BalfWindow && this.isMaximised() && !HelperFunctions.isMac()) {
                        this.cachedOuterRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, w, h, 0.0f, 0.0f);
                        this.cachedInnerRectangle = new RoundRectangle2D.Float(this.inset, this.inset, w - this.inset * 2, h - this.inset * 2, 0.0f, 0.0f);
                    } else {
                        this.cachedOuterRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, w, h, rounding, rounding);
                        float adjustedRounding = rounding - this.inset;
                        this.cachedInnerRectangle = new RoundRectangle2D.Float(2.0f, 2.0f, w - 4, h - 4, adjustedRounding, adjustedRounding);
                    }
                    this.lastWidth = w;
                    this.lastHeight = h;
                }
                if (this.cachedBorderNormal == null && !this.isMaximised()) {
                    this.cachedBorderNormal = new RoundRectangle2D.Float(1.0f, 1.0f, w - 2, h - 2, rounding, rounding);
                }
                if (this.cachedBorderMaximised == null && this.isMaximised()) {
                    this.cachedBorderMaximised = HelperFunctions.isMac() ? new RoundRectangle2D.Float(1.0f, 1.0f, w - 2, h - 2, rounding, rounding) : new Rectangle2D.Float(1.0f, 1.0f, w - 2, h - 2);
                }
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setColor(Color.decode("#4F4F4F"));
                if (!this.isMaximised()) {
                    g2.fill(this.cachedBorderNormal);
                } else {
                    g2.fill(this.cachedBorderMaximised);
                }
                g2.setColor(this.background);
                if (frame instanceof BalfWindow && !((BalfWindow)frame).hasFocus()) {
                    g2.setColor(UIUtils.transformToGrayscaleColour(this.background));
                }
                g2.fill(this.cachedInnerRectangle);
                g2.dispose();
                if (frame instanceof BalfWindow) {
                    ((BalfWindow)frame).setShape(this.cachedOuterRectangle);
                } else if (frame instanceof JFrame) {
                    ((JFrame)frame).setShape(this.cachedOuterRectangle);
                } else if (frame instanceof JWindow) {
                    ((JWindow)frame).setShape(this.cachedOuterRectangle);
                }
                super.paintComponent(g);
            }
        };
        if (frame instanceof BalfWindow) {
            BalfWindow bw = (BalfWindow)frame;
            bw.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    container.repaint();
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    container.repaint();
                }
            });
        }
        container.setOpaque(false);
        container.setDoubleBuffered(true);
        if (frame instanceof JFrame) {
            ((JFrame)frame).addWindowListener(new WindowAdapter(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    container.invalidate();
                }
            });
        }
        return container;
    }

    public static boolean isOpenGLPipelineAvailable() {
        try {
            Class.forName("sun.java2d.opengl.OGLRenderQueue");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                String clsName = gc.getClass().getName();
                if (clsName.contains("OGLGraphicsConfig")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static BufferedImage getMultiStepScaledImage(BufferedImage img, int targetWidth, int targetHeight) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage scaled = img;
        while (w > targetWidth || h > targetHeight) {
            w = Math.max(w / 2, targetWidth);
            h = Math.max(h / 2, targetHeight);
            BufferedImage tmp = new BufferedImage(w, h, 2);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(scaled, 0, 0, w, h, null);
            g2.dispose();
            scaled = tmp;
        }
        return scaled;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static Color transformToGrayscaleColour(Color color) {
        int avg = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        return new Color(avg, avg, avg, color.getAlpha());
    }

    public class RoundedFrame
    extends JPanel {
        JPanel container;

        @Override
        public void setBackground(Color c) {
            this.container.setBackground(c);
        }
    }
}

