/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.parsers.xml;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.parsers.xml.MalformedXMLException;
import jamiebalfour.parsers.xml.ZenithXMLParserByteCodes;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v5.ZenithParsingEngine;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.io.IOException;
import java.util.Scanner;

public class ZenithXMLParser {
    ZenithParsingEngine parser;

    public static void main(String[] args2) {
        try {
            String s = FileHelperFunctions.readFileAsString("test.xml", "utf-8");
            ZenithXMLParser jbxml = new ZenithXMLParser();
            Object xml = jbxml.ParseXMLString(s);
            System.out.println(xml);
            System.out.println("Done");
        }
        catch (IOException e) {
            ZPECore.printError("File not found!");
        }
        catch (MalformedXMLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object ParseXMLString(String xml) throws MalformedXMLException {
        ZenithXMLParserByteCodes bytecodes = new ZenithXMLParserByteCodes();
        this.parser = new ZenithParsingEngine(this.line_trimmer(xml), false, bytecodes);
        this.parser.getNextSymbol();
        return this.ParseElement();
    }

    private ZPEType ParseElement() throws MalformedXMLException {
        if (this.parser.getCurrentSymbol() == 10) {
            this.parser.getNextSymbol();
            ZPEMap element = new ZPEMap();
            String name = this.parser.getCurrentWord();
            element.put(new ZPEString("name"), new ZPEString(name));
            ZPEMap attributes = new ZPEMap();
            while (this.parser.getNextSymbol() == 5) {
                String attr_name = this.parser.getCurrentWord();
                if (this.parser.getNextSymbol() != 12) {
                    throw new MalformedXMLException("EQUALS EXPECTED");
                }
                this.parser.getNextSymbol();
                String value = this.parser.getCurrentWord();
                attributes.put(new ZPEString(attr_name), new ZPEString(value));
            }
            element.put(new ZPEString("attributes"), attributes);
            if (this.parser.getCurrentSymbol() == 14) {
                this.parser.getNextSymbol();
            }
            if (this.parser.getCurrentSymbol() != 11) {
                throw new MalformedXMLException("GT EXPECTED");
            }
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 10) {
                StringBuilder w = new StringBuilder(this.parser.getCurrentWord());
                while (this.parser.getNextSymbol() != 10) {
                    w.append(this.parser.getCurrentWord());
                }
                element.put(new ZPEString("value"), new ZPEString(w.toString()));
            } else {
                ZPEList children = new ZPEList();
                while (this.parser.getCurrentSymbol() == 10 && this.parser.peekAhead() != 14) {
                    children.add(this.ParseElement());
                    this.parser.getNextSymbol();
                }
                element.put(new ZPEString("children"), children);
            }
            if (this.parser.getCurrentSymbol() == 10 && this.parser.peekAhead() == 14) {
                this.parser.getNextSymbol();
                this.parser.getNextSymbol();
                if (this.parser.getCurrentWord().equals(name)) {
                    this.parser.getNextSymbol();
                }
            }
            return element;
        }
        return null;
    }

    public String ZPEList_To_XML(ZPEList l) {
        StringBuilder out;
        block5: {
            out = new StringBuilder();
            if (l.isEmpty()) break block5;
            if (l.get(0) instanceof ZPEMap) {
                for (ZPEType c : l) {
                    ZPEList current = (ZPEList)c;
                    for (ZPEType s : current) {
                        out.append("\"").append(s.toString()).append("\",");
                    }
                    out = new StringBuilder(out.substring(0, out.length() - 1));
                    out.append(System.lineSeparator());
                }
            } else {
                for (ZPEType c : l) {
                    out.append("\"").append(c.toString()).append("\",");
                }
            }
        }
        return out.toString();
    }

    private String line_trimmer(String s) {
        StringBuilder out = new StringBuilder();
        Scanner scanner = new Scanner(s);
        while (scanner.hasNextLine()) {
            String ln = scanner.nextLine();
            if ((ln = ln.trim()).isEmpty()) continue;
            out.append(ln).append(" ");
        }
        scanner.close();
        return out.toString();
    }
}

